/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Frequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.PreDefinedFrequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UnaryClauseModel;

public class IntervalClause
extends AbstractRepeatIntervalClause<Integer, UnaryClauseModel<Integer>> {
    protected int minValue = 1;
    protected int maxValue = 7999;

    public IntervalClause(RepeatIntervalModel repeatIntervalModel) {
        this(Integer.class, repeatIntervalModel);
    }

    protected IntervalClause(UnaryClauseModel<Integer> unaryClauseModel) {
        super(unaryClauseModel);
        ((UnaryClauseModel)this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
    }

    protected IntervalClause(Class<Integer> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new UnaryClauseModel<Integer>(clazz, ClauseType.INTERVAL, repeatIntervalModel, 1));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class RepeatIntervalChangeListener
    implements RepeatIntervalModelListener {
        protected RepeatIntervalChangeListener() {
        }

        @Override
        public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
            block0 : switch (repeatIntervalModelEvent.getClauseType()) {
                case FREQ: {
                    if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                    Frequency frequency = (Frequency)repeatIntervalModelEvent.getNewValue();
                    if (frequency instanceof PreDefinedFrequency) {
                        switch ((PreDefinedFrequency)frequency) {
                            case YEARLY: {
                                IntervalClause.this.maxValue = 99;
                                break block0;
                            }
                            case MONTHLY: {
                                IntervalClause.this.maxValue = 99;
                                break block0;
                            }
                            case WEEKLY: {
                                IntervalClause.this.maxValue = 49;
                                break block0;
                            }
                            case DAILY: {
                                IntervalClause.this.maxValue = 199;
                                break block0;
                            }
                            case HOURLY: {
                                IntervalClause.this.maxValue = 1999;
                                break block0;
                            }
                            case MINUTELY: {
                                IntervalClause.this.maxValue = 2999;
                                break block0;
                            }
                            case SECONDLY: {
                                IntervalClause.this.maxValue = 7999;
                                break block0;
                            }
                        }
                        IntervalClause.this.maxValue = 999;
                        break;
                    }
                    IntervalClause.this.maxValue = 999;
                }
            }
        }
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                try {
                    ((UnaryClauseModel)IntervalClause.this.clauseModel).set(Integer.valueOf(string));
                }
                catch (Throwable throwable) {
                    ((UnaryClauseModel)IntervalClause.this.clauseModel).set(1);
                }
            }
        }

        @Override
        public StringBuilder buildClause(StringBuilder stringBuilder, String string) {
            Integer n = (Integer)((UnaryClauseModel)IntervalClause.this.clauseModel).get();
            if (n > 1) {
                return super.buildClause(stringBuilder, string);
            }
            return stringBuilder;
        }
    }

    protected class Panel
    extends PropertyBasedPanel {
        protected GridBagLayout gridBagLayout1;
        protected JLabel intervalLabel;
        protected JSpinner intervalSpinner;
        protected SpinnerNumberModel intervalModel;

        public Panel(Properties properties) {
            super(properties);
            this.gridBagLayout1 = new GridBagLayout();
            this.intervalLabel = new JLabel();
            this.intervalSpinner = new JSpinner();
            this.intervalModel = new SpinnerNumberModel(1, 1, 7999, 1);
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((UnaryClauseModel)IntervalClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.intervalSpinner.setModel(this.intervalModel);
            this.intervalModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = Panel.this.intervalModel.getNumber().intValue();
                    if (n > IntervalClause.this.maxValue) {
                        Panel.this.intervalModel.setValue(IntervalClause.this.maxValue);
                    } else if (n < IntervalClause.this.minValue) {
                        Panel.this.intervalModel.setValue(IntervalClause.this.minValue);
                    } else {
                        Panel.this.intervalModel_changed(changeEvent);
                    }
                }
            });
            this.add((Component)this.intervalSpinner, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        }

        protected void intervalModel_changed(ChangeEvent changeEvent) {
            ((UnaryClauseModel)IntervalClause.this.clauseModel).set(this.intervalModel.getNumber().intValue());
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case INTERVAL: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Panel.this.intervalModel.setValue(repeatIntervalModelEvent.getNewValue());
                    }
                }
            }
        }
    }
}

