/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalEditPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalParseException;
import oracle.ide.help.HelpSystem;
import oracle.sql.DATE;

public class RepeatIntervalEditorDialog
extends JEWTDialog {
    private RepeatIntervalEditPanel panel;
    private OraDATEFormat format = null;
    private OraTIMESTAMPFormat tsFormat = null;

    public RepeatIntervalEditorDialog(Frame frame, String string, String string2, Image image, Connection connection, String string3) throws RepeatIntervalParseException {
        super(frame, string2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.panel = new RepeatIntervalEditPanel(string3, connection);
        jPanel.add((Component)new JLabel(SchedulerArb.getString("REPEAT_INTERVAL_NEWPOPUP_NAME_TEXT")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)this.panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.setContent(jPanel);
        this.setIconImage(image);
        this.setModal(true);
        this.setResizable(true);
        this.setButtonMask(7);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.panel, string);
    }

    private Timestamp calculateTimestamp(Object object, Connection connection) {
        Timestamp timestamp = null;
        if (object == null || object.toString().equals("")) {
            timestamp = new Timestamp(new Date().getTime());
        } else if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
            timestamp = new Timestamp(((Date)object).getTime());
        } else {
            try {
                this.format = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat();
                this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat();
                object = this.format.parseDATE(object.toString(), new ParsePosition(0)).dateValue();
                timestamp = new Timestamp(((Date)object).getTime());
            }
            catch (Exception exception) {
                timestamp = new Timestamp(new Date().getTime());
            }
        }
        return timestamp;
    }

    public String getRepeatInterval() {
        return this.panel.getRepeatInterval();
    }
}

