/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.plsqlpkg;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlArguments;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;

public class PlSqlPkgSpecParser {
    private List<Member> members = new LinkedList<Member>();
    private StringBuffer buf = new StringBuffer();

    public void reset() {
        this.buf.setLength(0);
        this.members.clear();
    }

    public void addLine(CharSequence charSequence) {
        this.add(charSequence);
        this.add("\n");
    }

    public void add(CharSequence charSequence) {
        this.buf.append(charSequence);
    }

    public List<Member> parseMembers() {
        String string = this.buf.substring(0, this.buf.length());
        List list = LexerToken.parse((String)string, (boolean)false);
        this.members.clear();
        this.members.addAll(this.parseMembers(list));
        return this.members;
    }

    public List<Member> parseMembers(List<LexerToken> list) {
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        plsqlStructureParser.parse(list, PlSqlArguments.sort);
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(plsqlStructureParser.children);
        return Collections.unmodifiableList(linkedList);
    }

    public static void main(String[] stringArray) {
        PlSqlPkgSpecParser plSqlPkgSpecParser = new PlSqlPkgSpecParser();
        plSqlPkgSpecParser.addLine("create or replace");
        plSqlPkgSpecParser.addLine("PACKAGE sybase_utilities AS");
        plSqlPkgSpecParser.addLine("identity NUMBER(10);");
        plSqlPkgSpecParser.addLine("trancount NUMBER(10):=0;");
        plSqlPkgSpecParser.addLine("var_number NUMBER(10):=0;");
        plSqlPkgSpecParser.addLine("");
        plSqlPkgSpecParser.addLine("");
        plSqlPkgSpecParser.addLine("FUNCTION bit_xor(p_raw1 RAW,p_raw2 RAW) RETURN RAW;");
        plSqlPkgSpecParser.addLine("FUNCTION str(p_expr IN NUMBER, p_len IN NUMBER DEFAULT 10, p_scale IN NUMBER DEFAULT 0)  RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION pi RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION bit_xor(p_num1 NUMBER,p_num2 NUMBER) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("PROCEDURE decrementTrancount;");
        plSqlPkgSpecParser.addLine("FUNCTION hex(p_num VARCHAR2) RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION isdate(p_expr IN VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION radians(p_degree IN NUMBER) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION str_to_date(p_date_expr IN VARCHAR2, p_dateformat IN VARCHAR2 := NULL) RETURN DATE;");
        plSqlPkgSpecParser.addLine("FUNCTION ident_incr(p_sequence IN VARCHAR2) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION day_(p_date_str IN VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION stuff(p_expr VARCHAR2, p_startIdx NUMBER, p_len NUMBER, p_replace_expr VARCHAR2)  RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("PROCEDURE commit_transaction;");
        plSqlPkgSpecParser.addLine("FUNCTION round_(p_expr NUMBER, p_len NUMBER, p_function NUMBER DEFAULT 0)  RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION patindex(p_pattern IN VARCHAR2, p_expr IN VARCHAR2, p_format IN VARCHAR2 DEFAULT 'using chars') RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("PROCEDURE incrementTrancount;");
        plSqlPkgSpecParser.addLine("FUNCTION convert_(p_dataType IN VARCHAR2, p_expr IN VARCHAR2, p_style IN VARCHAR2 DEFAULT NULL) RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION convert_to_date(p_expr IN VARCHAR2, p_style IN VARCHAR2 DEFAULT NULL) RETURN DATE;");
        plSqlPkgSpecParser.addLine("FUNCTION datename(p_part_expr IN VARCHAR2, p_date_str IN VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL)  RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION reverse_(p_expr IN VARCHAR2) RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION datepart(p_part_expr IN VARCHAR2, p_date_str IN VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL)  RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION dateadd(p_interval IN VARCHAR2, p_interval_val IN NUMBER, p_date_str IN VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL) RETURN DATE;");
        plSqlPkgSpecParser.addLine("FUNCTION degrees(p_angle_radians IN NUMBER)  RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION year_(p_date_str IN VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION to_base(p_dec NUMBER, p_base NUMBER)  RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION biginttohex(p_number NUMBER) RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION difference(p_expr1 IN VARCHAR2, p_expr2 IN VARCHAR2) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION datediff(p_datepart VARCHAR2, p_start_date_str VARCHAR2, p_end_date_str VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION fetch_status(p_cursorfound IN BOOLEAN) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION sqlstatus(p_cursorfound IN BOOLEAN,p_cursoropen IN BOOLEAN) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION ident_seed(p_sequence IN VARCHAR2) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION month_(p_date_str IN VARCHAR2, p_dateformat IN VARCHAR2 DEFAULT NULL) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("FUNCTION biginttohex(p_raw RAW) RETURN VARCHAR2;");
        plSqlPkgSpecParser.addLine("FUNCTION rand(p_seed NUMBER DEFAULT NULL) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("PROCEDURE resetTrancount;");
        plSqlPkgSpecParser.addLine("FUNCTION isnumeric(p_expr IN VARCHAR2) RETURN NUMBER;");
        plSqlPkgSpecParser.addLine("PROCEDURE buildDateFormat(p_date_exp in out VARCHAR2, p_date_fmt out VARCHAR);");
        plSqlPkgSpecParser.addLine("END sybase_utilities;");
        List<Member> list = plSqlPkgSpecParser.parseMembers();
        for (Member member : list) {
            System.out.println(member.name + " " + member.type + " " + (member.isPrivate ? "private " : "") + (member.isData() ? "data " : "") + "[" + member.toString() + "]");
        }
    }
}

