/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Date;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.scheduler.panels.DateTimeEditPanel;
import oracle.ide.help.HelpSystem;
import oracle.sql.DATE;

public class TimestampEditorDialog
extends JEWTDialog {
    private DateTimeEditPanel panel;
    private OraDATEFormat format = null;
    private OraTIMESTAMPFormat tsFormat = null;

    public TimestampEditorDialog(Frame frame, String string, String string2, Image image, Connection connection, Object object) {
        super(frame, string2);
        String string3 = null;
        this.panel = new DateTimeEditPanel(object, string3, true, connection);
        this.setContent((Component)((Object)this.panel));
        this.setIconImage(image);
        this.setModal(true);
        this.setButtonMask(7);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this.panel), string);
    }

    private Timestamp calculateTimestamp(Object object, Connection connection) {
        Timestamp timestamp = null;
        if (object == null || object.toString().equals("")) {
            timestamp = new Timestamp(new Date().getTime());
        } else if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
            timestamp = new Timestamp(((Date)object).getTime());
        } else {
            try {
                this.format = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat();
                this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat();
                object = this.format.parseDATE(object.toString(), new ParsePosition(0)).dateValue();
                timestamp = new Timestamp(((Date)object).getTime());
            }
            catch (Exception exception) {
                timestamp = new Timestamp(new Date().getTime());
            }
        }
        return timestamp;
    }

    public Timestamp getTimestamp() {
        return this.panel.getTimestamp();
    }

    public String getTimestampString() {
        return this.panel.getTimestampStr();
    }
}

