/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;
import oracle.sql.DATE;

public class DateTimeEditPanel
extends AbstractPopupCellEditor {
    public static final String TIMESTAMP_STRING_PREFIX = "TO_TIMESTAMP(";
    public static final String TIMESTAMP_STRING_SUFFIX = ")";
    protected DateTimeEditor dateEditor = null;
    protected JButton setTodayButton = new JButton();
    protected JButton setNullButton = new JButton();
    protected JButton setSysdateButton = new JButton();
    protected CalendarPopupButton calendarPopupButton = new CalendarPopupButton();
    protected CalendarPanel calendarPopup;
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JComboBox timezoneCB = new JComboBox<String>(TimeZone.getAvailableIDs());
    protected boolean _canChange = false;
    protected String sqlDateFormat = null;

    public DateTimeEditPanel() {
    }

    public DateTimeEditPanel(Object object, boolean bl, Connection connection) {
        this._canChange = bl;
        this._con = connection;
        this.createDateTimeEditPanel(this.decodeDate(object));
    }

    public DateTimeEditPanel(Object object, String string, boolean bl, Connection connection) {
        this._canChange = bl;
        this._con = connection;
        this.sqlDateFormat = string;
        this.createDateTimeEditPanel(this.decodeDate(object));
    }

    private Timestamp decodeDate(Object object) {
        Timestamp timestamp = null;
        if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
        }
        if (object instanceof java.util.Date) {
            timestamp = new Timestamp(((java.util.Date)object).getTime());
        } else if (object instanceof Timestamp) {
            timestamp = (Timestamp)object;
        } else {
            try {
                timestamp = this.evalTimestampText(object.toString());
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        if (timestamp == null) {
            timestamp = new Timestamp(new java.util.Date().getTime());
        }
        return timestamp;
    }

    private void createDateTimeEditPanel(Timestamp timestamp) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.createDateEditor(timestamp);
        this.getCalendarPopup();
        this.add((Component)this.dateEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 4, 4), 0, 0));
        this.add((Component)this.calendarPopupButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 4, 0), 0, 0));
        this.add(this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 4, 4), 0, 0));
    }

    private void createDateEditor(Timestamp timestamp) {
        OraSimpleDateFormat oraSimpleDateFormat = null;
        try {
            oraSimpleDateFormat = this.getOraSimpleDateFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (oraSimpleDateFormat == null) {
            return;
        }
        String string = oraSimpleDateFormat.toPattern();
        String string2 = this.convertToSimplifiedDateFormat(string, true);
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string2, oraSimpleDateFormat.getLocale());
        }
        catch (Exception exception) {
            simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, oraSimpleDateFormat.getLocale());
        }
        this.dateEditor = new DateTimeEditor((java.util.Date)timestamp);
    }

    public JComponent getDefaultComponent() {
        return this.dateEditor;
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getSetTodayButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected JButton getSetTodayButton() {
        ResourceUtils.resButton((AbstractButton)this.setTodayButton, (String)Messages.getString((String)"DateTimeEditPanel.1"));
        this.setTodayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditPanel.this.dateEditor.setCalendar(Calendar.getInstance());
            }
        });
        this.setTodayButton.setEnabled(this._canChange);
        return this.setTodayButton;
    }

    protected JButton getSetNullButton() {
        ResourceUtils.resButton((AbstractButton)this.setNullButton, (String)Messages.getString((String)"DateTimeEditPanel.2"));
        this.setNullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditPanel.this.dateEditor.setDate(null);
            }
        });
        return this.setNullButton;
    }

    private void getCalendarPopup() {
        this.calendarPopup = this.calendarPopupButton.getCalendarPanel();
        this.calendarPopupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditPanel.this.calendarPopup.setSelectedDate(DateTimeEditPanel.this.dateEditor.getDate());
                DateTimeEditPanel.this.calendarPopup.makeDateVisible(DateTimeEditPanel.this.dateEditor.getDate());
            }
        });
        this.calendarPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                java.util.Date[] dateArray;
                if (actionEvent.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dateArray = DateTimeEditPanel.this.calendarPopup.getSelectedDates()).length > 0) {
                    DateTimeEditPanel.this.dateEditor.setDate(dateArray[0]);
                }
            }
        });
    }

    public Date getDate() {
        return new Date(this.dateEditor.getDate().getTime());
    }

    public Timestamp getTimestamp() {
        long l = this.dateEditor.getCalendar().getTimeInMillis();
        return new Timestamp(l);
    }

    public String getTimestampStr() {
        return this.getTimestampExpr();
    }

    public String getTimestampExpr() {
        String string = null;
        Calendar calendar = this.dateEditor.getCalendar();
        try {
            OraSimpleDateFormat oraSimpleDateFormat = this.getOraSimpleDateFormat();
            string = this.genTimestampExpression(calendar, oraSimpleDateFormat);
            try {
                this.evalTimestampExpression(string);
            }
            catch (Exception exception) {
                String string2 = oraSimpleDateFormat.toPattern();
                String string3 = this.convertToNumericOnlyFormat(string2);
                string = this.genTimestampExpression(calendar, oraSimpleDateFormat, string3);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public String getTimestampLit() {
        String string = null;
        Calendar calendar = this.dateEditor.getCalendar();
        try {
            String string2;
            OraSimpleDateFormat oraSimpleDateFormat = null;
            OraSimpleDateFormat oraSimpleDateFormat2 = this.getOraSimpleDateFormat();
            try {
                string2 = this.genTimestampExpression(calendar, oraSimpleDateFormat2);
                if (string2 != null) {
                    this.evalTimestampExpression(string2);
                    oraSimpleDateFormat = oraSimpleDateFormat2;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            if (oraSimpleDateFormat == null) {
                try {
                    string2 = oraSimpleDateFormat2.toPattern();
                    String string3 = this.convertToNumericOnlyFormat(string2);
                    String string4 = this.genTimestampExpression(calendar, oraSimpleDateFormat2, string3);
                    if (string4 != null) {
                        this.evalTimestampExpression(string4);
                        oraSimpleDateFormat = oraSimpleDateFormat2;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            if (oraSimpleDateFormat != null) {
                string = oraSimpleDateFormat.format((java.util.Date)new Timestamp(calendar.getTimeInMillis()));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public Calendar getCalendar() {
        return this.dateEditor.getCalendar();
    }

    public void dismissPopupEditor() {
    }

    public JComponent getComponent() {
        return this;
    }

    public String getHelpTopicId() {
        return "f1_extendeddataedit_html";
    }

    public Object getValue() {
        return this.getTimestampLit();
    }

    public boolean isEditable() {
        return this._canChange;
    }

    public boolean isNULL() {
        return false;
    }

    public void setEditable(boolean bl) {
        this._canChange = bl;
    }

    public void setValue(Object object) {
        this.createDateTimeEditPanel(this.decodeDate(object));
    }

    public String validateValue() {
        return null;
    }

    private String convertToSimplifiedDateFormat(String string, boolean bl) {
        String string2 = string.toLowerCase();
        if (string2.contains("month")) {
            string2 = string2.replace("month", "MMMMM");
        }
        if (string2.contains("mon")) {
            string2 = string2.replace("mon", "MMM");
        }
        if (string2.contains("mm")) {
            string2 = string2.replace("mm", "MM");
        }
        if (string2.contains("dy")) {
            string2 = string2.replace("dy", "EEE");
        }
        if (string2.contains("day")) {
            string2 = string2.replace("day", "EEE");
        }
        if (string2.contains("ddd")) {
            string2 = string2.replace("ddd", "D");
        }
        if (string2.contains("rr")) {
            string2 = string2.replace("rr", "yy");
        }
        if (string2.contains("syyyy")) {
            string2 = string2.replace("syyyy", "-yyyy");
        }
        if (string2.contains("hh12")) {
            string2 = string2.replace("hh12", "hh");
        }
        if (string2.contains("hh24")) {
            string2 = string2.replace("hh24", "HH");
        }
        if (string2.contains("mi")) {
            string2 = string2.replace("mi", "mm");
        }
        if (string2.contains("a.m.") || string2.contains("am")) {
            string2 = string2.contains("a.m.") ? string2.replace("a.m.", "a") : string2.replace("am", "a");
        }
        if (string2.contains("p.m.") || string2.contains("pm")) {
            string2 = string2.contains("p.m.") ? string2.replace("p.m.", "a") : string2.replace("pm", "a");
        }
        if (string2.contains("ff")) {
            string2 = string2.replace("ff", "S");
        }
        if (string2.contains("tzr")) {
            string2 = string2.replace("tzr", bl ? "z" : "Z");
        }
        if (string2.contains("tzhtzm")) {
            string2 = string2.replace("tzhtzm", "Z");
        }
        if (string2.contains("x")) {
            string2 = string2.replace("x", ".");
        }
        return string2;
    }

    private String convertToNumericOnlyFormat(String string) {
        String string2 = string.toUpperCase();
        if (string2.contains("MONTH")) {
            string2 = string2.replace("MONTH", "MM");
        }
        if (string2.contains("MON")) {
            string2 = string2.replace("MON", "MM");
        }
        if (string2.contains("DY")) {
            string2 = string2.replace("DY", "DD");
        }
        if (string2.contains("DAY")) {
            string2 = string2.replace("DAY", "DD");
        }
        if (string2.contains("HH12")) {
            string2 = string2.replace("HH12", "HH24");
        }
        if (string2.contains("HH")) {
            string2 = string2.replace("HH", "HH24");
        }
        if (string2.contains("A.M.") || string2.contains("AM")) {
            string2 = string2.contains("A.M.") ? string2.replace("A.M.", "") : string2.replace("AM", "");
        }
        if (string2.contains("P.M.") || string2.contains("PM")) {
            string2 = string2.contains("P.M.") ? string2.replace("P.M.", "") : string2.replace("PM", "");
        }
        if (string2.contains("TZR")) {
            string2 = string2.replace("TZR", "");
        }
        return string2;
    }

    public void setPopupDialog(JEWTDialog jEWTDialog) {
    }

    private Timestamp evalTimestampText(String string) throws SQLException, ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return this.evalTimestampExpression(string);
        }
        catch (SQLException sQLException) {
            OraSimpleDateFormat oraSimpleDateFormat = this.getOraSimpleDateFormat();
            try {
                String string2 = this.genTimestampExpression(string, oraSimpleDateFormat);
                return this.evalTimestampExpression(string2);
            }
            catch (Exception exception) {
                try {
                    String string3 = this.genTimestampExpression(string, oraSimpleDateFormat, this.convertToNumericOnlyFormat(oraSimpleDateFormat.toPattern()));
                    return this.evalTimestampExpression(string3);
                }
                catch (SQLException sQLException2) {
                    throw sQLException;
                }
                catch (ParseException parseException) {
                    throw sQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp evalTimestampExpression(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = "BEGIN ? := CAST(CAST((" + string + ") AS TIMESTAMP WITH LOCAL TIME ZONE) AS TIMESTAMP); END;";
        CallableStatement callableStatement = this.getConnection().prepareCall(string2);
        try {
            callableStatement.registerOutParameter(1, 93);
            callableStatement.execute();
            Timestamp timestamp = callableStatement.getTimestamp(1);
            return timestamp;
        }
        finally {
            try {
                callableStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private String genTimestampExpression(Calendar calendar, OraSimpleDateFormat oraSimpleDateFormat, String string) throws ParseException {
        OraSimpleDateFormat oraSimpleDateFormat2 = oraSimpleDateFormat;
        if (string != null && (oraSimpleDateFormat2 = oraSimpleDateFormat2 == null ? this.getOraSimpleDateFormat() : (OraSimpleDateFormat)oraSimpleDateFormat2.clone()) != null) {
            oraSimpleDateFormat2.applyPattern(string);
        }
        return this.genTimestampExpression(calendar, oraSimpleDateFormat2);
    }

    private String genTimestampExpression(Calendar calendar, OraSimpleDateFormat oraSimpleDateFormat) throws ParseException {
        if (calendar == null) {
            return "NULL";
        }
        if (oraSimpleDateFormat != null) {
            Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
            String string = oraSimpleDateFormat.format((java.util.Date)timestamp);
            return this.genTimestampExpression(string, oraSimpleDateFormat);
        }
        return null;
    }

    private String genTimestampExpression(String string, OraSimpleDateFormat oraSimpleDateFormat, String string2) throws ParseException {
        OraSimpleDateFormat oraSimpleDateFormat2 = oraSimpleDateFormat;
        if (string2 != null && (oraSimpleDateFormat2 = oraSimpleDateFormat2 == null ? this.getOraSimpleDateFormat() : (OraSimpleDateFormat)oraSimpleDateFormat2.clone()) != null) {
            oraSimpleDateFormat2.applyPattern(string2);
        }
        return this.genTimestampExpression(string, oraSimpleDateFormat2);
    }

    private String genTimestampExpression(String string, OraSimpleDateFormat oraSimpleDateFormat) throws ParseException {
        if (string == null) {
            return "NULL";
        }
        if (oraSimpleDateFormat != null) {
            return this.genTimestampExpression(string, oraSimpleDateFormat.toPattern());
        }
        return null;
    }

    private String genTimestampExpression(Calendar calendar, SimpleDateFormat simpleDateFormat, String string) {
        String string2 = simpleDateFormat.format(calendar.getTime());
        return this.genTimestampExpression(string2, string);
    }

    private String genTimestampExpression(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "NULL";
        }
        if (string2 == null || string2.length() == 0) {
            return TIMESTAMP_STRING_PREFIX + this.wrapWithQuotes(string) + TIMESTAMP_STRING_SUFFIX;
        }
        return TIMESTAMP_STRING_PREFIX + this.wrapWithQuotes(string) + ", " + this.wrapWithQuotes(string2) + TIMESTAMP_STRING_SUFFIX;
    }

    private String wrapWithQuotes(String string) {
        if (string != null) {
            return "'" + string.replace("'", "''") + "'";
        }
        return "''";
    }

    private OraSimpleDateFormat getOraSimpleDateFormat() throws ParseException {
        OraTIMESTAMPFormat oraTIMESTAMPFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.getConnection())).getOraTIMESTAMPFormat();
        if (oraTIMESTAMPFormat != null && this.sqlDateFormat != null) {
            oraTIMESTAMPFormat.applyPattern(this.sqlDateFormat);
        }
        return oraTIMESTAMPFormat;
    }
}

