/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.oviewer.jobclass;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.ide.Ide;
import oracle.ide.view.View;

public class JobClassCellEditor
implements ICellEditor {
    JComponent renderer = null;
    Map<String, String> localToLogLevelMap = new Hashtable<String, String>(){
        {
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"), "FULL");
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"), "RUNS");
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FAILED_RUNS"), "FAILED_RUNS");
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF"), "OFF");
        }
    };
    Map<String, String> LogLevelTolocalMap = new Hashtable<String, String>(){
        {
            this.put("FULL", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"));
            this.put("RUNS", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"));
            this.put("FAILED_RUNS", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FAILED_RUNS"));
            this.put("OFF", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF"));
        }
    };
    boolean popup = false;

    public JobClassCellEditor(boolean bl) {
        this.popup = bl;
    }

    public JobClassCellEditor() {
        this(false);
    }

    public JComponent getComponent(JTable jTable, Object object, int n, int n2) {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string = null;
        XMLBasedEditor xMLBasedEditor = null;
        boolean bl = false;
        switch (n) {
            case 0: {
                string = SchedulerArb.get("JOBCLASSUPDATE_NAME_TOOLTIP");
                break;
            }
            case 1: {
                string = SchedulerArb.get("JOBCLASSUPDATE_LOGGING_LEVEL_TOOLTIP");
                break;
            }
            case 2: {
                string = SchedulerArb.get("JOBCLASSUPDATE_LOG_HISTORY_TOOLTIP");
                break;
            }
            case 3: {
                string = SchedulerArb.get("JOBCLASSUPDATE_RESOURCE_CONSUMER_GROUP_TOOLTIP");
                break;
            }
            case 4: {
                string = SchedulerArb.get("JOBCLASSUPDATE_SERVICE_TOOLTIP");
                break;
            }
            case 5: {
                string = SchedulerArb.get("JOBCLASSUPDATE_COMMENTS_TOOLTIP");
            }
        }
        switch (n) {
            case 0: {
                this.renderer = new JTextField(object == null ? null : object.toString());
                ((JTextField)this.renderer).setEditable(false);
                break;
            }
            case 1: {
                View view = Ide.getMainWindow().getLastActiveView();
                if (view instanceof XMLBasedEditor) {
                    xMLBasedEditor = (XMLBasedEditor)view;
                    int[] nArray = DBUtil.getDbVersion((Connection)xMLBasedEditor.getConnection()).toIntArray();
                    bl = nArray[0] >= 11;
                }
                String[] stringArray = bl ? new String[]{SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FAILED_RUNS"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF")} : new String[]{SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF")};
                this.renderer = this.getListBox(jTable, this.getLocalLoggingLevel(object), true, stringArray);
                break;
            }
            case 2: {
                int n3 = 0;
                if (object instanceof Number) {
                    n3 = ((Number)object).intValue();
                } else if (object != null) {
                    try {
                        n3 = Integer.valueOf(object.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                }
                this.renderer = new JSpinner(new SpinnerNumberModel(n3, 0, 1000000, 1));
                break;
            }
            case 3: {
                View view = Ide.getMainWindow().getLastActiveView();
                if (view instanceof XMLBasedEditor) {
                    xMLBasedEditor = (XMLBasedEditor)view;
                    SQLComboxModel sQLComboxModel = new SQLComboxModel(xMLBasedEditor.getConnection(), dBMSSchedulerCodeGenerator.generate(DBUtil.getDbVersion((Connection)xMLBasedEditor.getConnection()).toCanonicalString(), "RESOURCE_CONSUMER_GROUP_LIST_WITH_NULL", null), null, object == null ? "null" : object.toString());
                    this.renderer = this.popup ? new JComboBox() : this.getListBox(jTable, "", false, "");
                    ((JComboBox)this.renderer).setModel(sQLComboxModel);
                    break;
                }
                this.renderer = new JTextField(object == null ? null : object.toString());
                break;
            }
            case 4: {
                View view = Ide.getMainWindow().getLastActiveView();
                if (view instanceof XMLBasedEditor) {
                    xMLBasedEditor = (XMLBasedEditor)view;
                    SQLComboxModel sQLComboxModel = new SQLComboxModel(xMLBasedEditor.getConnection(), dBMSSchedulerCodeGenerator.generate(DBUtil.getDbVersion((Connection)xMLBasedEditor.getConnection()).toCanonicalString(), "SERVICE_LIST_WITH_NULL", null), null, object == null ? "null" : object.toString());
                    this.renderer = this.popup ? new JComboBox() : this.getListBox(jTable, "", false, "");
                    ((JComboBox)this.renderer).setModel(sQLComboxModel);
                    break;
                }
                this.renderer = new JTextField(object == null ? null : object.toString());
                break;
            }
            case 5: {
                this.renderer = new JTextField(object == null ? null : object.toString());
            }
        }
        this.renderer.setToolTipText(string);
        return this.renderer;
    }

    private JComponent getListBox(final JTable jTable, Object object, boolean bl, String ... stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        if (object != null) {
            jComboBox.setSelectedItem(object.toString().toUpperCase());
        }
        jComboBox.setEditable(bl);
        if (!this.popup) {
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        jTable.editingStopped(null);
                    }
                }
            });
        }
        return jComboBox;
    }

    public Object getValue() {
        if (this.renderer instanceof JTextField) {
            return ((JTextField)this.renderer).getText();
        }
        if (this.renderer instanceof JComboBox) {
            Object object = ((JComboBox)this.renderer).getSelectedItem();
            if (object != null && object.equals("null")) {
                object = null;
            }
            return object;
        }
        if (this.renderer instanceof JSpinner) {
            try {
                ((JSpinner)this.renderer).commitEdit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ((JSpinner)this.renderer).getValue();
        }
        return null;
    }

    private String getLocalLoggingLevel(Object object) {
        String string = null;
        if (object != null && (string = this.LogLevelTolocalMap.get(object.toString())) == null) {
            string = object.toString();
        }
        return string;
    }
}

