/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.oviewer.filewatcher;

import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridCellUpdated;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdate;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.oviewer.RowModel;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;

public class FileWatcherActionUpdate
implements IRaptorGridCellUpdated,
IRaptorGridUpdate {
    public static final int ROW_OWNER = 0;
    public static final int ROW_FILE_WATCHER_NAME = 1;
    public static final int ROW_ENABLED = 2;
    public static final int ROW_DESTINATION = 3;
    public static final int ROW_DIRECTORY_PATH = 4;
    public static final int ROW_FILE_NAME = 5;
    public static final int ROW_CREDENTIAL_NAME = 6;
    public static final int ROW_MIN_FILE_SIZE = 7;
    public static final int ROW_LAST_MODIFIED_TIME = 8;
    public static final int ROW_STEADY_STATE_DURATION = 9;
    public static final int ROW_COMMENTS = 10;
    static final String[] PROPERTIES = new String[]{"owner", "name", "enabled", "destination", "directory_path", "file_name", "credential_name", "min_file_size", "last_row_modified", "steady_state_duration", "comments"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        Connection connection = Connections.getInstance().getConnection(string);
        String string2 = DBUtil.getDbVersion((Connection)Connections.getInstance().getConnection(string)).toCanonicalString();
        DBUtil.getConnectionResolver().lock(connection);
        try {
            RowModel rowModel = new RowModel(list, 0, 1, PROPERTIES);
            Object v = rowModel.get("enabled");
            rowModel.put("enabled", Boolean.valueOf(v == null ? null : v.toString()));
            Map<String, Boolean> map = rowModel.getChanges();
            Map<String, Boolean> map2 = rowModel.getIsNull();
            rowModel.put("schema", ((RaptorGridCell)list.get(0).getRow().get(2)).getCellData());
            rowModel.put("name", ((RaptorGridCell)list.get(0).getRow().get(3)).getCellData());
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            treeMap.put("model", rowModel);
            treeMap.put("changes", map);
            treeMap.put("isnull", map2);
            String string3 = dBMSSchedulerCodeGenerator.generate(string2, "FILE_WATCHER_UPDATE", treeMap);
            iRaptorTaskProgressUpdater.checkCanProceed();
            if (string3 == null) return 0;
            CallableStatement callableStatement = null;
            try {
                callableStatement = connection.prepareCall(string3);
                callableStatement.execute();
                if (callableStatement == null) return 0;
            }
            catch (SQLException sQLException) {
                int n;
                block9: {
                    try {
                        SQLErrorDialog.showErrorDialog((String)string, (Component)Ide.getMainWindow(), (String)SchedulerArb.getString("CREDENTIALUPDATEDIALOG_TITLE"), (SQLException)sQLException);
                        n = 1;
                        if (callableStatement == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (callableStatement == null) throw throwable;
                        callableStatement.close();
                        throw throwable;
                    }
                    callableStatement.close();
                }
                DBUtil.getConnectionResolver().unlock(connection);
                return n;
            }
            callableStatement.close();
            return 0;
        }
        finally {
            DBUtil.getConnectionResolver().unlock(connection);
        }
    }

    public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
        return null;
    }

    public void setGridInfo(EditableGridInfo editableGridInfo) {
    }
}

