/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.oviewer.chain;

import java.sql.Connection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.celleditor.AbstractCustomCellEditor;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.oviewer.chain.ChainStepCellRenderer;
import oracle.ide.Ide;
import oracle.ide.view.View;

public abstract class ChainStepCellEditor
extends AbstractCustomCellEditor {
    public static final int COL_PROGRAM_NAME = 5;
    public static final int COL_EVENT_SCHEDULE_OWNER = 6;
    public static final int COL_EVENT_SCHEDULE_NAME = 7;
    public static final int COL_EVENT_QUEUE_OWNER = 8;
    public static final int COL_EVENT_QUEUE_NAME = 9;
    public static final int COL_EVENT_QUEUE_AGENT = 10;
    public static final int COL_EVENT_CONDITION = 11;
    public static final int COL_SKIP = 12;
    public static final int COL_PAUSE = 13;
    public static final int COL_RESTART_ON_RECOVERY = 14;
    public static final int COL_CREDENTIAL_OWNER = 15;
    public static final int COL_CREDENTIAL_NAME = 16;
    public static final int COL_DESTINATION = 17;
    public static final int COL_RESTART_ON_FAILURE = 18;
    JComponent renderer = null;
    boolean popup = false;
    ChainStepCellRenderer.Version version = ChainStepCellRenderer.Version.V11_2;

    public ChainStepCellEditor(boolean bl) {
        this.popup = bl;
    }

    public ChainStepCellEditor() {
        this(false);
    }

    public JComponent getComponent(JTable jTable, Object object, int n, int n2) {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        XMLBasedEditor xMLBasedEditor = null;
        this.renderer = null;
        boolean bl = false;
        this.renderer = new JTextField(object == null ? "NULL" : object.toString());
        ((JTextField)this.renderer).setEditable(false);
        switch (this.version) {
            case V10_2: {
                bl = n2 == 13 || n2 == 12 || n2 == 14;
                break;
            }
            case V11_1: {
                bl = n2 == 13 || n2 == 12 || n2 == 14 || n2 == 17 || n2 == 15 || n2 == 16;
                break;
            }
            case V11_2: {
                bl = n2 == 13 || n2 == 12 || n2 == 14 || n2 == 18 || n2 == 17 || n2 == 15 || n2 == 16;
            }
        }
        switch (n2) {
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                if (this.popup) {
                    this.renderer = ChainStepCellEditor.getBoolean(object, false);
                    break;
                }
                this.renderer = this.getBooleanJComboBox(jTable, Boolean.valueOf(object.toString()), false, false);
                break;
            }
            case 16: 
            case 17: {
                this.renderer = new JTextField(object == null ? "NULL" : object.toString());
                ((JTextField)this.renderer).setEditable(bl);
                break;
            }
            case 15: {
                View view = Ide.getMainWindow().getLastActiveView();
                if (view instanceof XMLBasedEditor) {
                    xMLBasedEditor = (XMLBasedEditor)view;
                    SQLComboxModel sQLComboxModel = new SQLComboxModel(xMLBasedEditor.getConnection(), dBMSSchedulerCodeGenerator.generate(DBUtil.getDbVersion((Connection)xMLBasedEditor.getConnection()).toCanonicalString(), "SCHEMAS_LIST", null), null, object == null ? "NULL" : object.toString());
                    this.renderer = this.popup ? new JComboBox() : this.getJComboBox(jTable, new Object[0], false, false);
                    ((JComboBox)this.renderer).setModel(sQLComboxModel);
                    break;
                }
                this.renderer = new JTextField(object == null ? null : object.toString());
                break;
            }
            default: {
                this.renderer = new JTextField(object == null ? "NULL" : object.toString());
                ((JTextField)this.renderer).setEditable(bl);
            }
        }
        return this.renderer;
    }

    public Object getValue() {
        if (this.renderer instanceof JTextField) {
            return ((JTextField)this.renderer).getText();
        }
        if (this.renderer instanceof JComboBox) {
            Object object = ((JComboBox)this.renderer).getSelectedItem();
            if (object != null && object.equals("NULL")) {
                object = null;
            }
            return object;
        }
        if (this.renderer instanceof JSpinner) {
            return ((JSpinner)this.renderer).getValue();
        }
        return null;
    }

    protected static JComponent getBoolean(Object object, boolean bl) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{Boolean.TRUE, Boolean.FALSE});
        if (object != null) {
            if (object instanceof Boolean) {
                jComboBox.setSelectedItem(object);
            } else {
                jComboBox.setSelectedItem(Boolean.valueOf(object.toString().toUpperCase()));
            }
        }
        jComboBox.setEditable(bl);
        return jComboBox;
    }
}

