/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.util.HashMap;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineAction;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineUtils;

public class XMLGraphEngineEdgeType
extends XMLGraphEngineType
implements GraphEngineEdgeType {
    private String style = "edgeStyle=endArrow=block;strokeColor=#000000;strokeWidth=2";
    private String sourceType;
    private String targetType;
    private boolean directed;
    private boolean loadSource;
    private boolean loadTarget;
    private boolean createReversed;

    public XMLGraphEngineEdgeType(GraphEngineDefinitions graphEngineDefinitions) {
        super(graphEngineDefinitions);
    }

    public void setStyle(String string) {
        String string2 = this.style;
        this.style = string;
        this.propertyChangeSupport.firePropertyChange("style", string2, string);
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    public void setSourceType(String string) {
        String string2 = this.sourceType;
        this.sourceType = string;
        this.propertyChangeSupport.firePropertyChange("sourcetype", string2, string);
    }

    @Override
    public String getSourceType() {
        return this.sourceType;
    }

    public void setTargetType(String string) {
        String string2 = this.targetType;
        this.targetType = string;
        this.propertyChangeSupport.firePropertyChange("targettype", string2, string);
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    public void setDirected(boolean bl) {
        boolean bl2 = this.directed;
        this.directed = bl;
        this.propertyChangeSupport.firePropertyChange("directed", bl2, bl);
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public String canMoveEdgeSource(GraphEngineNodeType graphEngineNodeType, GraphEngineNodeType graphEngineNodeType2) {
        if (this.getAction("MOVE_SOURCE") != null && this.getSourceType().equals(graphEngineNodeType.getTypeId()) && this.getTargetType().equals(graphEngineNodeType2.getTypeId())) {
            return null;
        }
        return "";
    }

    @Override
    public String canMoveEdgeTarget(GraphEngineNodeType graphEngineNodeType, GraphEngineNodeType graphEngineNodeType2) {
        if (this.getAction("MOVE_TARGET") != null && this.getSourceType().equals(graphEngineNodeType.getTypeId()) && this.getTargetType().equals(graphEngineNodeType2.getTypeId())) {
            return null;
        }
        return "";
    }

    @Override
    public GraphEngineEdge moveEdgeSource(GraphEngineEdge graphEngineEdge, GraphEngineNode graphEngineNode) {
        GraphEngineEdge graphEngineEdge2 = null;
        GraphEngineAction graphEngineAction = this.getAction("MOVE_SOURCE");
        if (graphEngineAction != null) {
            GraphEngineNode graphEngineNode2 = graphEngineEdge.getSource();
            GraphEngineNode graphEngineNode3 = graphEngineEdge.getTarget();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("SOURCE", graphEngineNode2);
            hashMap.put("TARGET", graphEngineNode3);
            hashMap.put("NEWSOURCE", graphEngineNode);
            String string = graphEngineAction.execute(hashMap);
            if (string == null) {
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode2.getGraph(), graphEngineNode);
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode2.getGraph(), graphEngineNode2);
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode2.getGraph(), graphEngineNode3);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode2.getGraph().getModel().getDefinitions(), graphEngineNode);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode2.getGraph().getModel().getDefinitions(), graphEngineNode2);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode2.getGraph().getModel().getDefinitions(), graphEngineNode3);
            }
        }
        return graphEngineEdge2;
    }

    @Override
    public GraphEngineEdge moveEdgeTarget(GraphEngineEdge graphEngineEdge, GraphEngineNode graphEngineNode) {
        GraphEngineEdge graphEngineEdge2 = null;
        GraphEngineAction graphEngineAction = this.getAction("MOVE_TARGET");
        if (graphEngineAction != null) {
            GraphEngineNode graphEngineNode2 = graphEngineEdge.getSource();
            GraphEngineNode graphEngineNode3 = graphEngineEdge.getTarget();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("SOURCE", graphEngineNode2);
            hashMap.put("TARGET", graphEngineNode3);
            hashMap.put("NEWTARGET", graphEngineNode);
            String string = graphEngineAction.execute(hashMap);
            if (string == null) {
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode2.getGraph(), graphEngineNode);
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode2.getGraph(), graphEngineNode2);
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode2.getGraph(), graphEngineNode3);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode2.getGraph().getModel().getDefinitions(), graphEngineNode);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode2.getGraph().getModel().getDefinitions(), graphEngineNode2);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode2.getGraph().getModel().getDefinitions(), graphEngineNode3);
            }
        }
        return graphEngineEdge2;
    }

    @Override
    public GraphEngineEdge create(GraphEngineNode graphEngineNode, GraphEngineNode graphEngineNode2) {
        GraphEngineEdge graphEngineEdge = null;
        GraphEngineAction graphEngineAction = this.getAction("CREATE");
        GraphEngineNode graphEngineNode3 = graphEngineNode;
        GraphEngineNode graphEngineNode4 = graphEngineNode2;
        if (graphEngineAction != null) {
            if (this.getSourceType().equals(graphEngineNode.getType().getTypeId()) && this.getTargetType().equals(graphEngineNode2.getType().getTypeId())) {
                graphEngineNode3 = graphEngineNode;
                graphEngineNode4 = graphEngineNode2;
            } else if (this.isCreateReversed() && this.getSourceType().equals(graphEngineNode2.getType().getTypeId()) && this.getTargetType().equals(graphEngineNode.getType().getTypeId())) {
                graphEngineNode3 = graphEngineNode2;
                graphEngineNode4 = graphEngineNode;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("SOURCE", graphEngineNode3);
            hashMap.put("TARGET", graphEngineNode4);
            String string = graphEngineAction.execute(hashMap);
            if (string == null) {
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode3.getGraph(), graphEngineNode3);
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineNode3.getGraph(), graphEngineNode4);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode3.getGraph().getModel().getDefinitions(), graphEngineNode3);
                XMLGraphEngineUtils.generateEdgesFor(graphEngineNode3.getGraph().getModel().getDefinitions(), graphEngineNode4);
            }
        }
        return graphEngineEdge;
    }

    public void setLoadSource(boolean bl) {
        this.loadSource = bl;
    }

    @Override
    public boolean isLoadSource() {
        return this.loadSource;
    }

    public void setLoadTarget(boolean bl) {
        this.loadTarget = bl;
    }

    @Override
    public boolean isLoadTarget() {
        return this.loadTarget;
    }

    public void setCreateReversed(boolean bl) {
        this.createReversed = bl;
    }

    @Override
    public boolean isCreateReversed() {
        return this.createReversed;
    }
}

