/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.controller;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.editors.graphical.GraphicalEditor;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorActionController;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorArb;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorGraphComponent;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorModelMxEventListener;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorMouseHandler;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorMxGraph;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorObjectActionListener;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorReadOnlyModeActionController;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorSelectionMxEventListener;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorTransferHandler;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineAction;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModelObserver;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineType;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class GraphicalEditorController {
    public static final String GRAPHICAL_EDITOR_CONTROLLER = "GraphicalEditorController";
    public static final String GE_DBOBJECT = "GraphicalEditorController.dbObject";
    public static final String GE_TYPE = "GraphicalEditorController.type";
    public static final String GE_ADDED = "GraphicalEditorController.added";
    public static final String GE_DELETED = "GraphicalEditorController.deleted";
    public static final String GE_SRC_OBJECT = "GraphicalEditorController.srcObject";
    public static final String GE_TGT_OBJECT = "GraphicalEditorController.tgtObject";
    public static final String GE_OBJECT = "GraphicalEditorController.object";
    public static final Float GRAPHICAL_EDITOR_MENU_SECTION_ID = Float.valueOf(11.0f);
    public static final Float GRAPHICAL_EDITOR_TOOLBAR_SECTION_ID = Float.valueOf(10.0f);
    GraphicalEditorObjectActionListener graphicalEditorObjectActionListener = new GraphicalEditorObjectActionListener(this);
    GraphicalEditorReadOnlyModeActionController readOnlyModeActionController = new GraphicalEditorReadOnlyModeActionController();
    Map<GraphEngineAction, IdeAction> actionIdeActionMap = new HashMap<GraphEngineAction, IdeAction>();
    static IDEContextMenuListener contextMenuListener = new IDEContextMenuListener();
    private mxGraph jGraphXModel;
    private mxGraphComponent jGraphXComponent;
    private mxIGraphLayout jGraphXLayout;
    private mxEventSource.mxIEventListener jGraphModelXListener = new GraphicalEditorModelMxEventListener(this);
    private mxEventSource.mxIEventListener jGraphSelectionXListener = new GraphicalEditorSelectionMxEventListener(this);
    private GraphEngineModel graphEngineModel;
    private GraphEngineModelObserver graphEngineObserver = new GraphEngineObserver();
    private GraphicalEditorTransferHandler graphEngineTransferHandler = new GraphicalEditorTransferHandler(this);
    private GraphicalEditorMouseHandler graphicalEditorMouseHandler = new GraphicalEditorMouseHandler(this);
    private Map<Element, List<GraphEngineObject>> elementToLocalMap = new HashMap<Element, List<GraphEngineObject>>();
    private Map<GraphEngineObject, Element> localToElementMap = new HashMap<GraphEngineObject, Element>();
    private Map<Object, GraphEngineObject> jGraphXToLocalMap = new HashMap<Object, GraphEngineObject>();
    private Map<GraphEngineObject, Object> localToJGraphXMap = new HashMap<GraphEngineObject, Object>();
    private List<GraphEngineObject> graphEngineSelection = new Vector<GraphEngineObject>();
    private List<Object> jGraphXSelection = new Vector<Object>();
    private GraphicalEditor editor;
    private DBObject rootDBObject;
    private boolean panning = false;
    private boolean readOnly = true;
    private MouseEvent lastPopupEvent = null;

    public GraphicalEditorController(GraphicalEditor graphicalEditor) {
        this.editor = graphicalEditor;
        if (graphicalEditor.getContext() != null && graphicalEditor.getContext().getNode() != null) {
            Node node = graphicalEditor.getContext().getNode();
            this.rootDBObject = node instanceof IViewerNode ? ((IViewerNode)node).getDBObject() : new DBObject((Element)graphicalEditor.getContext().getNode());
            graphicalEditor.getContext().setProperty("ObjectAction.DBOBJECT", (Object)this.rootDBObject);
        }
        graphicalEditor.getContext().setProperty(GRAPHICAL_EDITOR_CONTROLLER, (Object)this);
        mxConstants.DEFAULT_HOTSPOT = 0.5;
        mxConstants.MIN_HOTSPOT_SIZE = 16;
        this.jGraphXModel = new GraphicalEditorMxGraph(this);
        this.jGraphXComponent = new GraphicalEditorGraphComponent(this, this.jGraphXModel);
        this.jGraphXComponent.setCenterZoom(true);
        this.jGraphXModel.addListener(null, this.jGraphModelXListener);
        this.jGraphXModel.getSelectionModel().addListener(null, this.jGraphSelectionXListener);
        this.jGraphXComponent.getGraphControl().addMouseListener((MouseListener)this.graphicalEditorMouseHandler);
        this.jGraphXComponent.addMouseWheelListener((MouseWheelListener)this.graphicalEditorMouseHandler);
        this.jGraphXLayout = new mxHierarchicalLayout(this.jGraphXModel);
        ObjectActionController.addListener((IObjectActionListener)this.graphicalEditorObjectActionListener);
    }

    public void close() {
        this.jGraphXModel.removeListener(this.jGraphModelXListener);
        this.jGraphXModel.getSelectionModel().removeListener(this.jGraphSelectionXListener);
        this.jGraphXComponent.getGraphControl().removeMouseListener((MouseListener)this.graphicalEditorMouseHandler);
        this.jGraphXComponent.removeMouseWheelListener((MouseWheelListener)this.graphicalEditorMouseHandler);
        ObjectActionController.removeListener((IObjectActionListener)this.graphicalEditorObjectActionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(GraphEngineModel graphEngineModel) {
        if (this.graphEngineModel != null) {
            this.graphEngineModel.removeObserver(this.graphEngineObserver);
            this.graphEngineModel = null;
        }
        this.jGraphXModel.removeListener(this.jGraphModelXListener);
        try {
            this.jGraphXModel.removeCells(this.jGraphXModel.getChildCells(this.jGraphXModel.getDefaultParent()));
            this.jGraphXToLocalMap.clear();
            this.localToJGraphXMap.clear();
            this.jGraphXComponent.putClientProperty((Object)"ToolTipText", null);
            this.jGraphXComponent.getGraphControl().putClientProperty((Object)"ToolTipText", null);
        }
        finally {
            this.jGraphXModel.addListener(null, this.jGraphModelXListener);
        }
        this.graphEngineModel = graphEngineModel;
        if (this.graphEngineModel != null) {
            this.jGraphXToLocalMap.put(this.jGraphXModel.getDefaultParent(), graphEngineModel.getGraph());
            this.localToJGraphXMap.put(graphEngineModel.getGraph(), this.jGraphXModel.getDefaultParent());
            this.loadModel(graphEngineModel.getGraph());
            graphEngineModel.addObserver(this.graphEngineObserver);
            this.jGraphXComponent.putClientProperty((Object)"ToolTipText", (Object)graphEngineModel.getDefinitions().getRootDefinition().getToolTip());
            this.jGraphXComponent.getGraphControl().putClientProperty((Object)"ToolTipText", (Object)graphEngineModel.getDefinitions().getRootDefinition().getToolTip());
        }
    }

    public boolean importElement(Element element, Object object, Point2D point2D) {
        Object object2;
        GraphEngineObject graphEngineObject = null;
        boolean bl = true;
        if (object != null) {
            graphEngineObject = this.jGraphXToLocalMap.get(object);
        }
        List<GraphEngineObject> list = null;
        if (graphEngineObject != null) {
            if (this.isReadOnly()) {
                return false;
            }
            if (graphEngineObject.getType().getExternalDropAction() == null) {
                object2 = new Point2D.Double(point2D.getX() + 64.0, point2D.getY() + 64.0);
                while (this.getJGraphXComponent().getCellAt((int)((Point2D)object2).getX(), (int)((Point2D)object2).getY()) != null) {
                    ((Point2D)object2).setLocation(((Point2D)object2).getX() + 32.0, ((Point2D)object2).getY() + 32.0);
                }
                list = this.graphEngineModel.importElement(element, (Point2D)object2);
                if (list != null && list.size() > 0) {
                    bl = this.graphEngineModel.drop(graphEngineObject, list.toArray(new GraphEngineObject[list.size()]));
                }
            }
        } else {
            object2 = new Point2D.Double(point2D.getX(), point2D.getY());
            while (this.getJGraphXComponent().getCellAt((int)((Point2D)object2).getX(), (int)((Point2D)object2).getY()) != null) {
                ((Point2D)object2).setLocation(((Point2D)object2).getX() + 32.0, ((Point2D)object2).getY() + 32.0);
            }
            list = this.graphEngineModel.importElement(element, (Point2D)object2);
        }
        object2 = this.elementToLocalMap.get(element);
        if (object2 == null) {
            this.elementToLocalMap.put(element, list);
        } else if (list != null) {
            object2.addAll(list);
        }
        return list != null && list.size() > 0 && bl;
    }

    public boolean addNode(String string, String string2) {
        boolean bl = false;
        String string3 = this.rootDBObject.getConnectionName();
        if (string != null && string2 != null) {
            String string4 = null;
            if (string2 != null) {
                Point2D point2D;
                if (string2.contains(".")) {
                    string4 = string2.substring(0, string2.indexOf(46));
                    string2 = string2.substring(string2.indexOf(46) + 1);
                } else {
                    string4 = this.rootDBObject.getSchemaName();
                }
                URL uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string3, null, (String)string4, (String)string), (String)string2);
                DatabaseNode databaseNode = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                if (databaseNode == null) {
                    uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string3, null, (String)string4, (String)string), (String)string2);
                    databaseNode = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                }
                Point2D point2D2 = point2D = this.lastPopupEvent == null ? new Point2D.Double(10.0, 10.0) : this.lastPopupEvent.getPoint();
                if (databaseNode != null) {
                    bl = this.importElement((Element)databaseNode, null, point2D);
                }
            }
        }
        return bl;
    }

    public boolean importContext(Context context, Object object, Point2D point2D) {
        Element[] elementArray;
        boolean bl = true;
        if (point2D != null) {
            point2D = new Point2D.Double(point2D.getX(), point2D.getY());
        }
        for (Element element : elementArray = context.getSelection()) {
            bl &= this.importElement(element, object, point2D);
            if (point2D == null) continue;
            point2D.setLocation(point2D.getX() + 32.0, point2D.getY() + 32.0);
        }
        return bl;
    }

    public mxGraph getJGraphXModel() {
        return this.jGraphXModel;
    }

    public mxGraphComponent getJGraphXComponent() {
        return this.jGraphXComponent;
    }

    public String isValidEdge(Object object, Object object2, Object object3) {
        GraphEngineObject graphEngineObject;
        GraphEngineEdge graphEngineEdge = null;
        GraphEngineNode graphEngineNode = null;
        GraphEngineNode graphEngineNode2 = null;
        if (this.isReadOnly()) {
            return "";
        }
        if (object != null && (graphEngineObject = this.jGraphXToLocalMap.get(object)) instanceof GraphEngineEdge) {
            graphEngineEdge = (GraphEngineEdge)graphEngineObject;
        }
        if (object2 != null && (graphEngineObject = this.jGraphXToLocalMap.get(object2)) instanceof GraphEngineNode) {
            graphEngineNode = (GraphEngineNode)graphEngineObject;
        }
        if (object3 != null && (graphEngineObject = this.jGraphXToLocalMap.get(object3)) instanceof GraphEngineNode) {
            graphEngineNode2 = (GraphEngineNode)graphEngineObject;
        }
        if (graphEngineNode != null && graphEngineNode2 != null) {
            if (graphEngineEdge != null) {
                return this.graphEngineModel.canMoveEdge(graphEngineEdge, graphEngineNode, graphEngineNode2);
            }
            return this.graphEngineModel.canCreateEdge(graphEngineNode, graphEngineNode2);
        }
        return "";
    }

    public String moveEdge(Object object, Object object2, Object object3) {
        try {
            GraphEngineObject graphEngineObject;
            GraphEngineEdge graphEngineEdge = null;
            GraphEngineNode graphEngineNode = null;
            GraphEngineNode graphEngineNode2 = null;
            if (object != null && (graphEngineObject = this.jGraphXToLocalMap.get(object)) instanceof GraphEngineEdge) {
                graphEngineEdge = (GraphEngineEdge)graphEngineObject;
            }
            if (object2 != null && (graphEngineObject = this.jGraphXToLocalMap.get(object2)) instanceof GraphEngineNode) {
                graphEngineNode = (GraphEngineNode)graphEngineObject;
            }
            if (object3 != null && (graphEngineObject = this.jGraphXToLocalMap.get(object3)) instanceof GraphEngineNode) {
                graphEngineNode2 = (GraphEngineNode)graphEngineObject;
            }
            if (graphEngineNode != null && graphEngineNode2 != null) {
                this.graphEngineModel.moveEdge(graphEngineEdge, graphEngineNode, graphEngineNode2);
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public void createEdge(Object object, Object object2, MouseEvent mouseEvent) {
        try {
            GraphEngineObject graphEngineObject;
            GraphEngineNode graphEngineNode = null;
            GraphEngineNode graphEngineNode2 = null;
            if (object != null && (graphEngineObject = this.jGraphXToLocalMap.get(object)) instanceof GraphEngineNode) {
                graphEngineNode = (GraphEngineNode)graphEngineObject;
            }
            if (object2 != null && (graphEngineObject = this.jGraphXToLocalMap.get(object2)) instanceof GraphEngineNode) {
                graphEngineNode2 = (GraphEngineNode)graphEngineObject;
            }
            if (!this.isReadOnly() && this.graphEngineModel.canCreateEdge(graphEngineNode, graphEngineNode2) == null) {
                this.graphEngineModel.createEdge(graphEngineNode, graphEngineNode2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadModel(GraphEngineGraph graphEngineGraph) {
        for (GraphEngineNode graphEngineObject : graphEngineGraph.getNodes()) {
            this.addNodeToJGraphX(graphEngineObject);
        }
        for (GraphEngineEdge graphEngineEdge : graphEngineGraph.getEdges()) {
            this.addEdgeToJGraphX(graphEngineEdge);
        }
    }

    private void addNodeToJGraphX(GraphEngineNode graphEngineNode) {
        GraphEngineNodeType graphEngineNodeType = graphEngineNode.getType();
        Point2D point2D = graphEngineNode.getLocation();
        Object object = this.jGraphXModel.getDefaultParent();
        if (graphEngineNode.getParent() != null) {
            object = this.localToJGraphXMap.get(graphEngineNode.getParent());
        }
        if (point2D == null) {
            point2D = this.lastPopupEvent != null ? this.lastPopupEvent.getPoint() : new Point2D.Double(64.0, 64.0);
        }
        if (graphEngineNodeType != null) {
            Object object2 = this.jGraphXModel.insertVertex(object, graphEngineNode.getId(), (Object)graphEngineNode.getLabel(), point2D.getX(), point2D.getY(), graphEngineNodeType.getSize().getWidth(), graphEngineNodeType.getSize().getHeight(), graphEngineNodeType.getStyle());
            this.localToJGraphXMap.put(graphEngineNode, object2);
            this.jGraphXToLocalMap.put(object2, graphEngineNode);
        }
    }

    private void removeNodeFromJGraphX(GraphEngineNode graphEngineNode) {
        Object object = this.localToJGraphXMap.get(graphEngineNode);
        if (object != null) {
            Object[] objectArray = this.jGraphXModel.removeCells(new Object[]{object});
        }
    }

    private void addEdgeToJGraphX(GraphEngineEdge graphEngineEdge) {
        GraphEngineEdgeType graphEngineEdgeType = graphEngineEdge.getType();
        Object object = this.jGraphXModel.getDefaultParent();
        Object object2 = this.localToJGraphXMap.get(graphEngineEdge.getSource());
        Object object3 = this.localToJGraphXMap.get(graphEngineEdge.getTarget());
        if (graphEngineEdge.getParent() != null) {
            object = this.localToJGraphXMap.get(graphEngineEdge.getParent());
        }
        if (graphEngineEdgeType != null && object != null && object2 != null && object3 != null) {
            Object object4 = this.jGraphXModel.insertEdge(object, graphEngineEdge.getId(), (Object)graphEngineEdge.getLabel(), object2, object3, graphEngineEdge.getStyle() != null ? graphEngineEdge.getStyle() : graphEngineEdgeType.getStyle());
            this.localToJGraphXMap.put(graphEngineEdge, object4);
            this.jGraphXToLocalMap.put(object4, graphEngineEdge);
        }
    }

    private void removeEdgeFromJGraphX(GraphEngineEdge graphEngineEdge) {
        Object object = this.localToJGraphXMap.get(graphEngineEdge);
        if (object != null) {
            this.jGraphXModel.removeCells(new Object[]{object});
        }
    }

    public void moved(Object object, Point2D point2D) {
        GraphEngineObject graphEngineObject = this.jGraphXToLocalMap.get(object);
        if (graphEngineObject != null) {
            graphEngineObject.setLocation(point2D);
        }
    }

    public void jGraphXObjectRemoved(Object object) {
        GraphEngineObject graphEngineObject = this.jGraphXToLocalMap.get(object);
        if (graphEngineObject != null) {
            this.localToJGraphXMap.remove(graphEngineObject);
            if (graphEngineObject instanceof GraphEngineNode) {
                this.graphEngineModel.getGraph().remove((GraphEngineNode)graphEngineObject);
            } else if (graphEngineObject instanceof GraphEngineEdge) {
                this.graphEngineModel.getGraph().remove((GraphEngineEdge)graphEngineObject);
            }
        }
    }

    public void ideObjectRemoved(Element element) {
        List<GraphEngineObject> list = this.elementToLocalMap.get(element);
        if (list != null) {
            for (GraphEngineObject graphEngineObject : list) {
                if (graphEngineObject instanceof GraphEngineNode) {
                    this.graphEngineModel.getGraph().remove((GraphEngineNode)graphEngineObject);
                    continue;
                }
                if (!(graphEngineObject instanceof GraphEngineEdge)) continue;
                this.graphEngineModel.getGraph().remove((GraphEngineEdge)graphEngineObject);
            }
        }
    }

    public void ideObjectReload(Element element) {
        List<GraphEngineObject> list;
        if (element != null && (list = this.elementToLocalMap.get(element)) != null) {
            for (GraphEngineObject object : list) {
                if (!(object instanceof GraphEngineEdge)) continue;
                this.graphEngineModel.getGraph().remove((GraphEngineEdge)object);
            }
            Object object = null;
            for (GraphEngineObject graphEngineObject : list) {
                if (!(graphEngineObject instanceof GraphEngineNode)) continue;
                if (object == null) {
                    object = graphEngineObject.getLocation();
                }
                this.graphEngineModel.getGraph().remove((GraphEngineNode)graphEngineObject);
            }
            this.importElement(element, null, (Point2D)object);
        }
    }

    public void ideObjectReloadParent(Element element) {
        this.ideObjectReload(element);
    }

    void selectionChanged(List<Object> list, List<Object> list2) {
        GraphEngineObject graphEngineObject2;
        if (list2 != null) {
            for (Object object : list2) {
                if (object == null) continue;
                graphEngineObject2 = this.jGraphXToLocalMap.get(object);
                this.jGraphXSelection.remove(object);
                this.graphEngineSelection.remove(graphEngineObject2);
            }
        }
        if (list != null) {
            for (Object e : list) {
                if (e == null) continue;
                graphEngineObject2 = this.jGraphXToLocalMap.get(e);
                this.jGraphXSelection.add(e);
                this.graphEngineSelection.add(graphEngineObject2);
            }
        }
        Vector vector = new Vector();
        for (GraphEngineObject graphEngineObject2 : this.graphEngineSelection) {
            Element element;
            if (graphEngineObject2 == null || (element = graphEngineObject2.getElement()) == null || vector.contains(element)) continue;
            vector.add(element);
        }
        this.editor.getToolbar();
        this.editor.scheduleUpdateSelection();
    }

    public Element[] getSelection() {
        Vector<Element> vector = new Vector<Element>();
        for (GraphEngineObject graphEngineObject : this.graphEngineSelection) {
            Element element = graphEngineObject.getElement();
            if (element == null || vector.contains(element)) continue;
            vector.add(element);
        }
        Element[] elementArray = vector.toArray(new Element[vector.size()]);
        return elementArray;
    }

    public Object[] getSelectedCells() {
        Vector<Object> vector = new Vector<Object>();
        for (GraphEngineObject graphEngineObject : this.graphEngineSelection) {
            Object object = this.localToJGraphXMap.get(graphEngineObject);
            if (object == null || vector.contains(object)) continue;
            vector.add(object);
        }
        Object[] objectArray = vector.toArray(new Object[vector.size()]);
        return objectArray;
    }

    public JPopupMenu getContextMenu() {
        JPopupMenu jPopupMenu = null;
        if (this.editor.getContext().getNode() instanceof IViewerNode) {
            jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(((IViewerNode)this.editor.getContext().getNode()).getDBObject());
        }
        return jPopupMenu;
    }

    public List<Action> getPopupActions(Object object) {
        Vector<Action> vector = new Vector<Action>();
        try {
            IdeAction missingResourceException;
            Object object2;
            Object object3;
            Object object4;
            GraphEngineObject graphEngineObject = object != null ? this.jGraphXToLocalMap.get(object) : this.graphEngineModel.getGraph();
            Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
            if (graphEngineObject instanceof GraphEngineEdge) {
                context.setProperty(GE_SRC_OBJECT, (Object)((GraphEngineEdge)graphEngineObject).getSource());
                context.setProperty(GE_TGT_OBJECT, (Object)((GraphEngineEdge)graphEngineObject).getTarget());
            }
            context.setProperty(GE_OBJECT, (Object)graphEngineObject);
            if (graphEngineObject != null && graphEngineObject.getElement() instanceof IViewerNode) {
                context.setProperty(GE_DBOBJECT, (Object)((IViewerNode)graphEngineObject.getElement()).getDBObject());
            } else {
                context.setProperty(GE_DBOBJECT, (Object)this.rootDBObject);
            }
            GraphEngineType graphEngineType = graphEngineObject.getType();
            if (graphEngineType != null) {
                List<GraphEngineAction> list = graphEngineType.getPopupActions();
                object4 = this.graphEngineModel.getResourceBundle();
                context.setProperty(GE_TYPE, (Object)graphEngineType.getTypeId());
                for (GraphEngineAction object5 : list) {
                    if (this.isReadOnly() && !object5.isAllowedWhenReadOnly()) continue;
                    object3 = object5.getTitle();
                    object2 = null;
                    if (object3 != null) {
                        if (object4 != null) {
                            try {
                                object2 = ((ResourceBundle)object4).getString(object5.getTitle());
                            }
                            catch (MissingResourceException missingResourceException2) {
                                object2 = null;
                            }
                        }
                        if (object2 == null) {
                            try {
                                object2 = GraphicalEditorArb.get((String)object3);
                            }
                            catch (MissingResourceException missingResourceException3) {
                                object2 = null;
                            }
                            if (object2 == null) {
                                object2 = object3;
                            }
                        }
                    }
                    missingResourceException = null;
                    missingResourceException = this.actionIdeActionMap.get(object5);
                    if (missingResourceException == null) {
                        GraphicalEditorActionController graphicalEditorActionController;
                        ImageIcon imageIcon;
                        try {
                            imageIcon = new ImageIcon(this.getClass().getResource(object5.getIcon()));
                        }
                        catch (Throwable throwable) {
                            imageIcon = null;
                        }
                        missingResourceException = IdeAction.get((int)object5.getActionID(), null, (String)StringUtils.stripMnemonic((String)object2), null, (Integer)StringUtils.getMnemonicKeyCode((String)object2), (Icon)imageIcon, (Object)object4, (boolean)true).newLocalAction((View)this.editor);
                        if (object5.getControllerClassName() == null) {
                            graphicalEditorActionController = new GraphicalEditorActionController(object5);
                        } else {
                            try {
                                Object[] objectArray;
                                Constructor<?> constructor;
                                Class<?> clazz = Class.forName(object5.getControllerClassName());
                                try {
                                    constructor = clazz.getConstructor(GraphEngineAction.class);
                                    objectArray = new Object[]{object5};
                                }
                                catch (Exception exception) {
                                    constructor = clazz.getConstructor(new Class[0]);
                                    objectArray = null;
                                }
                                graphicalEditorActionController = (Controller)constructor.newInstance(objectArray);
                            }
                            catch (Exception exception) {
                                graphicalEditorActionController = new GraphicalEditorActionController(object5);
                            }
                        }
                        missingResourceException.addController((Controller)graphicalEditorActionController);
                    }
                    vector.add((Action)missingResourceException);
                    missingResourceException.updateAction(this.editor.getContext());
                }
            }
            if (object == null) {
                boolean bl = false;
                if (vector.size() > 0) {
                    bl = true;
                }
                if ((object4 = this.getContextMenu()) != null && ((Container)object4).getComponentCount() > 0) {
                    for (int i = 0; i < ((Container)object4).getComponentCount(); ++i) {
                        Component component = ((Container)object4).getComponent(i);
                        if (!(component instanceof JMenuItem)) continue;
                        object3 = (JMenuItem)component;
                        object2 = ((AbstractButton)object3).getAction();
                        if (object2 instanceof IdeAction) {
                            missingResourceException = (IdeAction)object2;
                            if (missingResourceException.getValue("Name").equals("Scheduler Design Editor")) continue;
                            if (object2.isEnabled()) {
                                missingResourceException.updateAction(this.editor.getContext());
                            }
                        }
                        if (!object2.isEnabled()) continue;
                        if (bl) {
                            bl = false;
                            vector.add(null);
                        }
                        vector.add((Action)object2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public void mousePopup(Object object, MouseEvent mouseEvent) {
        this.lastPopupEvent = mouseEvent;
        try {
            List<Action> list = this.getPopupActions(object);
            if (list.size() > 0) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                boolean bl = false;
                for (Action action : list) {
                    if (action == null) {
                        if (!bl) continue;
                        jPopupMenu.addSeparator();
                        bl = false;
                        continue;
                    }
                    jPopupMenu.add(action);
                    bl = true;
                }
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() < 0) {
            this.getJGraphXComponent().zoomIn();
        } else {
            this.getJGraphXComponent().zoomOut();
        }
    }

    public void setJGraphXLayout(mxIGraphLayout mxIGraphLayout2) {
        this.jGraphXLayout = mxIGraphLayout2;
    }

    public mxIGraphLayout getJGraphXLayout() {
        return this.jGraphXLayout;
    }

    public boolean isValidExternalDropTarget(Object object) {
        try {
            GraphEngineObject graphEngineObject;
            if (!this.isReadOnly() && (graphEngineObject = this.jGraphXToLocalMap.get(object)) != null) {
                GraphEngineType graphEngineType = graphEngineObject.getType();
                return graphEngineType.isExternalDropAllowed();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public boolean isValidDropTarget(Object object, Object[] objectArray) {
        try {
            if (this.isReadOnly()) {
                return false;
            }
            GraphEngineObject graphEngineObject = this.jGraphXToLocalMap.get(object);
            if (graphEngineObject != null) {
                GraphEngineType[] graphEngineTypeArray = new GraphEngineType[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (object2 == null) {
                        return false;
                    }
                    GraphEngineObject graphEngineObject2 = this.jGraphXToLocalMap.get(object2);
                    if (graphEngineObject2 == null) {
                        return false;
                    }
                    graphEngineTypeArray[i] = graphEngineObject2.getType();
                }
                GraphEngineType graphEngineType = graphEngineObject.getType();
                return graphEngineType == null ? false : graphEngineType.canAcceptDrop(graphEngineTypeArray);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public boolean dropCellsOnTarget(Object object, Object[] objectArray) {
        try {
            GraphEngineObject graphEngineObject = this.jGraphXToLocalMap.get(object);
            if (graphEngineObject != null) {
                GraphEngineObject[] graphEngineObjectArray = new GraphEngineObject[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (object2 == null) {
                        return false;
                    }
                    GraphEngineObject graphEngineObject2 = this.jGraphXToLocalMap.get(object2);
                    if (graphEngineObject2 == null) {
                        return false;
                    }
                    graphEngineObjectArray[i] = graphEngineObject2;
                }
                return this.graphEngineModel.drop(graphEngineObject, graphEngineObjectArray);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    void openEditor(Object object) {
        try {
            GraphEngineObject graphEngineObject = this.jGraphXToLocalMap.get(object);
            if (graphEngineObject != null) {
                this.graphEngineModel.edit(graphEngineObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPanning(boolean bl) {
        this.panning = bl;
    }

    public boolean isPanning() {
        return this.panning;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getToolTipFor(Object object) {
        String string = null;
        GraphEngineObject graphEngineObject = this.jGraphXToLocalMap.get(object);
        if (graphEngineObject != null) {
            string = graphEngineObject.getToolTip();
        }
        return string;
    }

    public void layout() {
        this.getJGraphXLayout().execute(this.getJGraphXModel().getDefaultParent());
    }

    public void refresh() {
        if (this.graphEngineModel != null && this.graphEngineModel.getGraph() != null) {
            this.graphEngineModel.getGraph().refresh();
        }
    }

    public Controller getReadOnlyModeActionController() {
        return this.readOnlyModeActionController;
    }

    static {
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)contextMenuListener);
    }

    private static class IDEContextMenuListener
    implements ContextMenuListener {
        private IDEContextMenuListener() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Object object = contextMenu.getContext().getProperty(GraphicalEditorController.GRAPHICAL_EDITOR_CONTROLLER);
            if (object != null && object instanceof GraphicalEditorController) {
                Object object2;
                Object[] objectArray;
                GraphicalEditorController graphicalEditorController = (GraphicalEditorController)object;
                Float f = GRAPHICAL_EDITOR_TOOLBAR_SECTION_ID;
                try {
                    objectArray = graphicalEditorController.editor.getToolbar();
                    if (objectArray != null && objectArray.getActions() != null && objectArray.getActions().length > 0) {
                        object2 = objectArray.getActions();
                        for (int i = ((Action[])object2).length - 1; i >= 0; --i) {
                            Action action = object2[i];
                            JMenuItem jMenuItem = new JMenuItem(action);
                            jMenuItem.putClientProperty("menu-section-id", f);
                            contextMenu.add((Component)jMenuItem);
                        }
                        contextMenu.addSeparator();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    List<Action> list;
                    f = GRAPHICAL_EDITOR_MENU_SECTION_ID;
                    objectArray = graphicalEditorController.getSelectedCells();
                    object2 = null;
                    if (objectArray != null && objectArray.length == 1) {
                        object2 = objectArray[0];
                        GraphEngineObject graphEngineObject = (GraphEngineObject)graphicalEditorController.jGraphXToLocalMap.get(object2);
                        if (graphEngineObject != null) {
                            contextMenu.getContext().setProperty(GraphicalEditorController.GE_OBJECT, (Object)graphEngineObject);
                            contextMenu.getContext().setProperty(GraphicalEditorController.GE_TYPE, (Object)graphEngineObject.getType().getTypeId());
                        }
                    }
                    if ((list = graphicalEditorController.getPopupActions(object2)).size() > 0) {
                        boolean bl = false;
                        for (Action action : list) {
                            if (action == null) {
                                if (!bl) continue;
                                contextMenu.addSeparator();
                                f = Float.valueOf(f.floatValue() + 1.0f);
                                bl = false;
                                continue;
                            }
                            JMenuItem jMenuItem = new JMenuItem(action);
                            jMenuItem.putClientProperty("menu-section-id", f);
                            contextMenu.add((Component)jMenuItem);
                            bl = true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class GraphEngineObserver
    implements GraphEngineModelObserver {
        private GraphEngineObserver() {
        }

        @Override
        public void nodeAdded(GraphEngineNode graphEngineNode) {
            GraphicalEditorController.this.addNodeToJGraphX(graphEngineNode);
        }

        @Override
        public void nodeUpdated(GraphEngineNode graphEngineNode) {
        }

        @Override
        public void nodeRemoved(GraphEngineNode graphEngineNode) {
            GraphicalEditorController.this.removeNodeFromJGraphX(graphEngineNode);
        }

        @Override
        public void edgeAdded(GraphEngineEdge graphEngineEdge) {
            GraphicalEditorController.this.addEdgeToJGraphX(graphEngineEdge);
        }

        @Override
        public void edgeUpdated(GraphEngineEdge graphEngineEdge) {
        }

        @Override
        public void edgeRemoved(GraphEngineEdge graphEngineEdge) {
            GraphicalEditorController.this.removeEdgeFromJGraphX(graphEngineEdge);
        }
    }
}

