/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;

public abstract class NameValidationPropertyChangeListener
implements PropertyChangeListener {
    private Timer timer;
    private final String property;
    private boolean currentlyInvalid = false;

    public NameValidationPropertyChangeListener(String string) {
        this.property = string;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(this.property)) {
            if (this.currentlyInvalid) {
                this.validate();
            }
            this.getTimer().restart();
        }
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NameValidationPropertyChangeListener.this.validate();
                }
            };
            this.timer = new Timer(1000, actionListener);
            this.timer.setRepeats(false);
        }
        return this.timer;
    }

    protected void validate() {
        this.getTimer().stop();
        this.currentlyInvalid = this.validateImpl();
    }

    protected abstract boolean validateImpl();
}

