/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.editors.chain.Messages;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;

public class ChainNodeDeleteAction
extends ActionDialog {
    private static final String SCHEMA = "schema";
    private static final String OBJECT_NAME = "Object Name";
    private static final String CHAIN_NAME = "Chain Name";
    private static final String FORCE_CHECK = "Force";
    private String chain_name;
    private boolean isRule;
    private String object_name;
    private String owner;

    public ChainNodeDeleteAction() {
        ObjectAction objectAction = new ObjectAction();
        objectAction.setReloadParent(false);
        objectAction.setReload(true);
        this.setObjectAction(objectAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        ResultSet resultSet;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        TextBoxActionControl textBoxActionControl2;
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl2 = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("OBJECT_NAME", this.object_name);
                textBoxActionControl.put("CHAIN_NAME", this.chain_name);
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                textBoxActionControl2 = dBUtil.executeOracleQuery(this.getQuery(connection, this.isRule ? "getRuleOwner" : "getStepOwner"), (Map)textBoxActionControl);
                if (textBoxActionControl2 != null && (resultSet = textBoxActionControl2.getResultSet()).next()) {
                    this.owner = resultSet.getString("OWNER");
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (textBoxActionControl2 != null) {
                    textBoxActionControl2.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl2 = new TextBoxActionControl(SCHEMA, Messages.getString("ChainStepCreateAction.4"), this.owner);
        textBoxActionControl2.setEditable(false);
        textBoxActionControl = new TextBoxActionControl(CHAIN_NAME, Messages.getString("ChainStepCreateAction.6"), this.chain_name);
        textBoxActionControl.setEditable(false);
        dBUtil = new TextBoxActionControl(OBJECT_NAME, this.isRule ? Messages.getString("ChainNodeDeleteAction.Rule_Name") : Messages.getString("ChainNodeDeleteAction.Step_Name"), this.object_name);
        dBUtil.setEditable(false);
        resultSet = new BooleanCheckBoxActionControl(FORCE_CHECK, Messages.getString("ChainNodeDeleteAction.Force"), false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)resultSet);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(SCHEMA);
        String string3 = values.get(OBJECT_NAME);
        String string4 = values.get(CHAIN_NAME);
        String string5 = values.get(FORCE_CHECK);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(SCHEMA, string2);
        treeMap.put("object_name", string3);
        treeMap.put("force", string5);
        treeMap.put("chain_name", string4);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string6 = null;
        string6 = this.isRule ? dBMSSchedulerCodeGenerator.generate(string, "CHAIN_RULE_DELETE", treeMap2) : dBMSSchedulerCodeGenerator.generate(string, "CHAIN_STEP_DELETE", treeMap2);
        return string6;
    }

    protected String getTitle() {
        return Messages.getString("ChainEditorDelete");
    }

    public void setIsRule(boolean bl) {
        this.isRule = bl;
    }

    public void setChainName(String string) {
        this.chain_name = string;
    }

    public void setObjectName(String string) {
        this.object_name = string;
    }
}

