/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraphView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.chain.ChainEditorController;
import oracle.dbtools.scheduler.editors.chain.ChainEditorReadOnlyModeActionController;
import oracle.dbtools.scheduler.editors.chain.ChainGraphModel;
import oracle.dbtools.scheduler.editors.chain.ChainGraphViewer;
import oracle.dbtools.scheduler.editors.chain.ChainRuleCreateAction;
import oracle.dbtools.scheduler.editors.chain.ChainStepCreateAction;
import oracle.dbtools.scheduler.editors.chain.Messages;
import oracle.dbtools.scheduler.editors.graphical.GraphicalEditorToolbarActions;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorArb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class ChainEditor
extends ViewerEditor {
    private JSlider xSlider = null;
    private JSlider ySlider = null;
    private ChainGraphViewer m_Jgraph = null;
    private ChainGraphModel m_JModel = null;
    private String STEP_QUERY = "select \"STEP_NAME\", \"PROGRAM_NAME\", \"EVENT_SCHEDULE_NAME\", \"STEP_TYPE\", \"OWNER\", \"CHAIN_NAME\", \"PROGRAM_OWNER\", \"SKIP\", \"PAUSE\" from \"SYS\".\"ALL_SCHEDULER_CHAIN_STEPS\" where \"CHAIN_NAME\" = ? AND \"OWNER\" = ?";
    private String RULE_QUERY = "select \"RULE_NAME\", \"CONDITION\", \"ACTION\", \"COMMENTS\" from \"SYS\".\"ALL_SCHEDULER_CHAIN_RULES\" where \"CHAIN_NAME\" = ? AND \"OWNER\" = ?";
    private ViewerNode m_ViewerNode;
    private IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Chain_Editor.Refresh_Editor");
    protected IdeAction _editAction;
    protected ChainEditorReadOnlyModeActionController editController;
    private boolean isEditable = false;
    protected boolean ignoreZoomChange = false;
    static final int STEP_CREATE_CMD_ID = Ide.findOrCreateCmdID((String)"STEP_CREATE_CMD_ID");
    private static final int RULE_CREATE_CMD_ID = Ide.findOrCreateCmdID((String)"RULE_CREATE_CMD_ID");
    static final int EDIT_EDITOR_CMD_ID = Ide.createCmdID((String)"Chain_Editor.Edit_Editor");
    public static final int ZOOM_CMD_ID = Ide.findOrCreateCmdID((String)"ZOOM_GE_ACTION_ID");
    public static final int ZOOM_IN_CMD_ID = Ide.findOrCreateCmdID((String)"ZOOM_IN_GE_ACTION_ID");
    public static final int ZOOM_OUT_CMD_ID = Ide.findOrCreateCmdID((String)"ZOOM__OUT_GE_ACTION_ID");

    public ChainEditor() {
        String string = ConnectionArb.getString((String)"DB_MENU_ACTION_CATEGORY");
        ChainEditorController chainEditorController = new ChainEditorController();
        this.editController = new ChainEditorReadOnlyModeActionController();
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)SchedulerArb.getString("PROGRAMPANEL.REFRESH"), (String)string, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true).newLocalAction((View)this);
        this._refreshAction.addController((Controller)chainEditorController);
        this._editAction = IdeAction.get((int)EDIT_EDITOR_CMD_ID, null, (String)GraphicalEditorArb.getString("GRAPHICALEDITOR_TOOLBAR_SWITCH_TO_WRITE"), null, null, (Icon)RaptorImagesArb.getIcon((String)"EDIT_CODE_BROKEN"), null, (boolean)true).newLocalAction((View)this);
        this._editAction.addController((Controller)this.editController);
        this._editAction.putValue("Check", (Object)Boolean.TRUE);
        this._editAction.setState(false);
    }

    protected void cleanUp() {
    }

    protected JComponent createViewerUI() {
        if (this.m_Jgraph == null) {
            Node node = this.getContext().getNode();
            if (!(node instanceof ViewerNode)) {
                return null;
            }
            this.m_ViewerNode = (ViewerNode)node;
            if (this.m_ViewerNode.getDBObject().getObjectName() == null) {
                return null;
            }
            this.m_JModel = new ChainGraphModel(this.m_ViewerNode.getDBObject().getObjectName());
            this.m_Jgraph = new ChainGraphViewer(this.m_JModel, this.m_ViewerNode.getDBObject(), this.getContext().getView(), this);
            Toolbar toolbar = this.getToolbar();
            toolbar.add((ToggleAction)this._refreshAction).setName("Refresh");
            final ToggleToolButton toggleToolButton = new ToggleToolButton((ToggleAction)this._editAction);
            toggleToolButton.setSelectedIcon(RaptorImagesArb.getIcon((String)"EDIT_CODE_BROKEN"));
            toggleToolButton.setIcon(RaptorImagesArb.getIcon((String)"EDIT_CODE_WRITE"));
            toggleToolButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (toggleToolButton.isSelected()) {
                        toggleToolButton.setToolTipText(GraphicalEditorArb.getString("GRAPHICALEDITOR_TOOLBAR_SWITCH_TO_WRITE"));
                    } else {
                        toggleToolButton.setToolTipText(GraphicalEditorArb.getString("GRAPHICALEDITOR_TOOLBAR_SWITCH_TO_READ_ONLY"));
                    }
                }
            });
            toolbar.add((Component)toggleToolButton).setName("Edit");
            ToolbarActionController toolbarActionController = new ToolbarActionController();
            this.addToolbarZooms(toolbarActionController);
            this.addStepButtons(toolbarActionController);
            toolbar.addSeparator();
        }
        return this.m_Jgraph.getGui();
    }

    private void addStepButtons(ToolbarActionController toolbarActionController) {
        Toolbar toolbar = this.getToolbar();
        toolbar.addSeparator();
        IdeAction ideAction = IdeAction.get((int)STEP_CREATE_CMD_ID, null, (String)Messages.getString("ChainStepCreateAction.15"), null, null, (Icon)new ImageIcon(ChainEditor.class.getResource("/oracle/dbtools/scheduler/images/createchainstep.png"), "Rule Start Icon"), null, (boolean)true);
        ideAction.addController((Controller)toolbarActionController);
        toolbar.add((ToggleAction)ideAction).setName("StepCreate");
        IdeAction ideAction2 = IdeAction.get((int)RULE_CREATE_CMD_ID, null, (String)Messages.getString("ChainRuleCreateAction.28"), null, null, (Icon)new ImageIcon(ChainEditor.class.getResource("/oracle/dbtools/scheduler/images/createchainrule.png"), "Rule Start Icon"), null, (boolean)true);
        ideAction2.addController((Controller)toolbarActionController);
        toolbar.add((ToggleAction)ideAction2).setName("StepCreate");
    }

    private void addToolbarZooms(ToolbarActionController toolbarActionController) {
        Toolbar toolbar = this.getToolbar();
        this.xSlider = new JSlider(0, 50, 150, 100);
        this.xSlider.setMaximumSize(new Dimension(128, 200));
        this.xSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ChainEditor.this.m_Jgraph.setTopology(ChainEditor.this.xSlider.getValue(), ChainEditor.this.ySlider.getValue());
            }
        });
        this.xSlider.setOpaque(false);
        this.xSlider.setBackground(toolbar.getBackground());
        this.ySlider = new JSlider(0, 10, 100, 50);
        this.ySlider.setMaximumSize(new Dimension(128, 200));
        this.ySlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ChainEditor.this.m_Jgraph.setTopology(ChainEditor.this.xSlider.getValue(), ChainEditor.this.ySlider.getValue());
            }
        });
        this.ySlider.setOpaque(false);
        this.ySlider.setBackground(toolbar.getBackground());
        this.xSlider.setToolTipText(Messages.getString("ChainEditor.1"));
        this.ySlider.setToolTipText(Messages.getString("ChainEditor.2"));
        toolbar.addSeparator();
        IdeAction ideAction = IdeAction.get((int)ZOOM_CMD_ID, null, (String)SchedulerArb.getString("GRAPHICALEDITOR_ZOOM_BUTTON_NAME"), null, null, null, null, (boolean)true);
        IdeAction ideAction2 = IdeAction.get((int)ZOOM_IN_CMD_ID, null, (String)SchedulerArb.getString("GRAPHICALEDITOR_ZOOM_IN_BUTTON_NAME"), null, null, (Icon)OracleIcons.getIcon((String)"zoomin.png"), null, (boolean)true);
        IdeAction ideAction3 = IdeAction.get((int)ZOOM_OUT_CMD_ID, null, (String)SchedulerArb.getString("GRAPHICALEDITOR_ZOOM_OUT_BUTTON_NAME"), null, null, (Icon)OracleIcons.getIcon((String)"zoomout.png"), null, (boolean)true);
        final JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"400%", "200%", "150%", "100%", "75%", "50%", SchedulerArb.getString("GRAPHICALEDITOR_ZOOM_PAGE_LABEL")});
        jComboBox.setEditable(true);
        jComboBox.setMinimumSize(new Dimension(75, 0));
        jComboBox.setPreferredSize(new Dimension(75, 0));
        jComboBox.setMaximumSize(new Dimension(75, 100));
        jComboBox.setMaximumRowCount(9);
        jComboBox.setAction((Action)ideAction);
        jComboBox.setName("ZoomCombo");
        ideAction.addController((Controller)toolbarActionController);
        toolbar.add(jComboBox);
        final mxGraphView mxGraphView2 = this.m_Jgraph.getGraphComponent().getGraph().getView();
        mxEventSource.mxIEventListener mxIEventListener2 = new mxEventSource.mxIEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(Object object, mxEventObject mxEventObject2) {
                ChainEditor.this.ignoreZoomChange = true;
                try {
                    jComboBox.setSelectedItem((int)Math.round(100.0 * mxGraphView2.getScale()) + "%");
                }
                finally {
                    ChainEditor.this.ignoreZoomChange = false;
                }
            }
        };
        mxGraphView2.getGraph().getView().addListener("scale", mxIEventListener2);
        mxGraphView2.getGraph().getView().addListener("scaleAndTranslate", mxIEventListener2);
        mxIEventListener2.invoke(null, null);
        ideAction2.addController((Controller)toolbarActionController);
        toolbar.add((ToggleAction)ideAction2).setName("ZoomIn");
        ideAction3.addController((Controller)toolbarActionController);
        toolbar.add((ToggleAction)ideAction3).setName("ZoomOut");
    }

    public Object getPrintable() {
        return null;
    }

    protected void updateContent(boolean bl) {
        Boolean bl2;
        final String string = this.STEP_QUERY;
        final String string2 = this.RULE_QUERY;
        Node node = this.getContext().getNode();
        Map map = this.getContext().getNode().getTransientProperties();
        if (map.get("CHAIN_EDITOR_IS_EDITABLE") == null) {
            bl2 = Boolean.FALSE;
            map.put("CHAIN_EDITOR_IS_EDITABLE", bl2);
        }
        bl2 = (Boolean)map.get("CHAIN_EDITOR_IS_EDITABLE");
        this.setEditable(bl2);
        if (node instanceof ViewerNode) {
            this.m_ViewerNode = (ViewerNode)node;
            if (!this.m_JModel.getStepDataMap().isEmpty()) {
                this.m_JModel.clear();
                this.m_Jgraph.clear();
            }
            DatabaseQueryTask<Boolean> databaseQueryTask = new DatabaseQueryTask<Boolean>(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, false, true){

                public String getConnectionName() {
                    return ChainEditor.this.m_ViewerNode.getDBObject().getConnectionName();
                }

                public String getQuery() {
                    return string + " UNION " + string2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Boolean doWork() throws TaskException {
                    Connection connection = ChainEditor.this.m_ViewerNode.getDBObject().getConnection();
                    if (ChainEditor.this.m_ViewerNode.getDBObject().getObjectName() == null) {
                        return false;
                    }
                    DBUtil.getConnectionResolver().lock(connection);
                    try {
                        ChainEditor.this.m_JModel.clear();
                        PreparedStatement preparedStatement = connection.prepareStatement(string);
                        preparedStatement.setString(1, ChainEditor.this.m_ViewerNode.getDBObject().getObjectName());
                        preparedStatement.setString(2, ChainEditor.this.m_ViewerNode.getDBObject().getSchemaName());
                        ResultSet resultSet = preparedStatement.executeQuery();
                        this.fillChainModelSteps(resultSet);
                        PreparedStatement preparedStatement2 = connection.prepareStatement(string2);
                        preparedStatement2.setString(1, ChainEditor.this.m_ViewerNode.getDBObject().getObjectName());
                        preparedStatement2.setString(2, ChainEditor.this.m_ViewerNode.getDBObject().getSchemaName());
                        ResultSet resultSet2 = preparedStatement2.executeQuery();
                        ChainEditor.this.m_JModel.fillRuleDataList(resultSet2);
                        ChainEditor.this.m_JModel.setGraphModel();
                        resultSet.close();
                        preparedStatement.close();
                        resultSet2.close();
                        preparedStatement2.close();
                        this.updateGui();
                    }
                    catch (SQLException sQLException) {
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        DBUtil.getConnectionResolver().unlock(connection);
                    }
                    return true;
                }

                private void fillChainModelSteps(ResultSet resultSet) {
                    String string10 = null;
                    String string22 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    try {
                        while (resultSet.next()) {
                            string10 = resultSet.getString(1);
                            string22 = resultSet.getString(2);
                            string3 = resultSet.getString(3);
                            string4 = resultSet.getString(4);
                            string5 = resultSet.getString(5);
                            string6 = resultSet.getString(6);
                            string7 = resultSet.getString(7);
                            string8 = resultSet.getString(8);
                            string9 = resultSet.getString(9);
                            ChainEditor.this.m_JModel.addStep(string10, string22, string3, string4, string5, string6, string7, string8, string9, "FALSE");
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }

                private void updateGui() {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ChainEditor.this.m_Jgraph.setTopology(ChainEditor.this.m_ViewerNode.getDBObject());
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        }
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public ChainGraphViewer getChainGraphViewer() {
        return this.m_Jgraph;
    }

    public Object getEditorAttribute(String string) {
        if (string.equals("scrollable")) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    private class ToolbarActionController
    implements Controller {
        private ToolbarActionController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            block15: {
                if (ideAction.getCommandId() == GraphicalEditorToolbarActions.ZOOM_IN_CMD_ID) {
                    ChainEditor.this.m_Jgraph.getGraphComponent().zoomIn();
                } else if (ideAction.getCommandId() == GraphicalEditorToolbarActions.ZOOM_OUT_CMD_ID) {
                    ChainEditor.this.m_Jgraph.getGraphComponent().zoomOut();
                } else if (ideAction.getCommandId() == GraphicalEditorToolbarActions.ZOOM_CMD_ID) {
                    EventObject eventObject = context.getEvent();
                    if (eventObject != null && eventObject.getSource() instanceof JComboBox) {
                        JComboBox jComboBox = (JComboBox)eventObject.getSource();
                        String string = (String)jComboBox.getSelectedItem();
                        try {
                            if (string.equals(SchedulerArb.getString("GRAPHICALEDITOR_ZOOM_PAGE_LABEL"))) {
                                mxGraphComponent mxGraphComponent2 = ChainEditor.this.m_Jgraph.getGraphComponent();
                                mxRectangle mxRectangle2 = mxGraphComponent2.getGraph().getGraphBounds();
                                mxPoint mxPoint2 = mxGraphComponent2.getGraph().getView().getTranslate();
                                Dimension dimension = mxGraphComponent2.getSize();
                                double d = mxGraphComponent2.getGraph().getView().getScale();
                                double d2 = dimension.getWidth() / dimension.getHeight();
                                double d3 = mxRectangle2.getWidth() / mxRectangle2.getHeight();
                                double d4 = 1.0;
                                if (d2 > d3) {
                                    d4 = dimension.getHeight() / (mxRectangle2.getHeight() / d);
                                    mxPoint2.setY(mxPoint2.getY() - mxRectangle2.getY() / d);
                                } else {
                                    d4 = dimension.getWidth() / (mxRectangle2.getWidth() / d);
                                    mxPoint2.setX(mxPoint2.getX() - mxRectangle2.getX() / d);
                                }
                                mxGraphComponent2.getGraph().getView().scaleAndTranslate(d4, mxPoint2.getX(), mxPoint2.getY());
                                break block15;
                            }
                            string = string.replace("%", "");
                            ChainEditor.this.m_Jgraph.getGraphComponent().zoomTo(Double.parseDouble(string) / 100.0, ChainEditor.this.m_Jgraph.getGraphComponent().isCenterZoom());
                        }
                        catch (Exception exception) {}
                    }
                } else if (ideAction.getCommandId() == STEP_CREATE_CMD_ID) {
                    DBObject dBObject = ChainEditor.this.m_ViewerNode.getDBObject();
                    String string = dBObject.getObjectName();
                    ChainStepCreateAction chainStepCreateAction = new ChainStepCreateAction();
                    chainStepCreateAction.setDBObject(dBObject);
                    chainStepCreateAction.setChainName(string);
                    chainStepCreateAction.launch();
                    ChainEditor.this.updateContent(true);
                } else if (ideAction.getCommandId() == RULE_CREATE_CMD_ID) {
                    DBObject dBObject = ChainEditor.this.m_ViewerNode.getDBObject();
                    String string = dBObject.getObjectName();
                    ChainRuleCreateAction chainRuleCreateAction = new ChainRuleCreateAction();
                    chainRuleCreateAction.setDBObject(dBObject);
                    chainRuleCreateAction.setChainName(string);
                    chainRuleCreateAction.launch();
                    ChainEditor.this.updateContent(true);
                }
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(true);
            return true;
        }
    }
}

