/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.schedule;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenActionControl;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleResultSet;

public class SchedulerCreateAction
extends ActionDialogBase {
    private static final String SCHEDULE_NAME = "schedule_name";
    private static final String COMMENTS = "comments";
    private static final String SCHEDULE_WHEN = "schedule_when";
    private String scheduleOwner;
    private String scheduleName;
    private String comments;
    private String oldComments;
    private ScheduleWhenModel whenModel;
    private ScheduleWhenActionControl whenCtrl;

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public SchedulerCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected List<ActionControl> createControls(Connection var1_1) {
        this.whenModel = new ScheduleWhenModel();
        var2_2 = this.getOperation();
        try {
            var3_3 = this.getObjectName();
        }
        catch (Exception var5_4) {
            var3_3 = "null";
        }
        try {
            var4_8 = this.getDBObjectSchemaName();
        }
        catch (Exception var5_5) {
            var4_8 = "null";
        }
        if (var2_2 != Operation.CREATE_NEW) {
            if (Connections.getInstance().lock(var1_1)) {
                var5_6 = null;
                try {
                    var6_9 = new HashMap();
                    var6_9.put("OBJECT_NAME", var3_3);
                    var6_9.put("OBJECT_OWNER", var4_8);
                    var7_11 = DBUtil.getInstance((Connection)var1_1);
                    var7_11.setRaiseError(true);
                    var5_6 = var7_11.executeOracleQuery(this.getQuery(var1_1, "getScheduleData"), (Map)var6_9);
                    if (var5_6 == null || !(var8_12 = (OracleResultSet)var5_6.getResultSet()).next()) ** GOTO lbl42
                    if (var2_2 == Operation.EDIT) {
                        this.scheduleName = var8_12.getString("SCHEDULE_NAME");
                    }
                    this.comments = this.oldComments = var8_12.getString("COMMENTS");
                    this.whenModel.initPropertiesFromRS(var8_12, var1_1);
                }
                catch (Exception var6_10) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var6_10.getStackTrace()[0].toString(), var6_10);
                }
                finally {
                    if (var5_6 != null) {
                        var5_6.close();
                    }
                    Connections.getInstance().unlock(var1_1);
                }
            }
        } else {
            this.whenModel.initProperty(ScheduleWhenModel.Property.EVENT_TYPE, (Object)ScheduleWhenModel.EventType.REPEATING);
        }
lbl42:
        // 5 sources

        this.whenModel.doInitialize();
        try {
            this.scheduleOwner = this.getDBObjectSchemaName();
            if (this.scheduleOwner == null) {
                this.scheduleOwner = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception var5_7) {
            this.scheduleOwner = "null";
        }
        var5_6 = new TextBoxActionControl("schedule_name", SchedulerArb.getString("SCHEDULEUPDATE_NAME_LABEL"), this.scheduleName);
        var6_9 = new TextBoxActionControl("comments", SchedulerArb.getString("SCHEDULEUPDATE_COMMENTS_LABEL"), this.comments);
        this.whenCtrl = new ScheduleWhenActionControl("schedule_when", null, CardLayoutPanel.Type.TITLE_BORDER, SchedulerArb.getString("SCHEDULEWHEN_CARD_TITLE_BORDER"), ScheduleWhenActionControl.FCOTarget.SCHEDULE, var1_1);
        this.whenCtrl.setModel(this.whenModel);
        var5_6.setEditable(var2_2 != Operation.EDIT);
        var7_11 = new ArrayList<E>();
        var7_11.add(var5_6);
        var7_11.add(var6_9);
        var7_11.add(this.whenCtrl);
        return var7_11;
    }

    protected String getScript(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        ScheduleWhenModel.EventType eventType = this.whenModel.getEventType();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(SCHEDULE_NAME);
        String string3 = values.get(COMMENTS);
        String string4 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.REPEAT_INTERVAL.getValueName());
        String string5 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.START_DATE.getValueName());
        String string6 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.END_DATE.getValueName());
        String string7 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.EVENT_CONDITION.getValueName());
        String string8 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.QUEUE_SPEC);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("owner", this.wrapQuotes(this.scheduleOwner));
        treeMap.put("name", this.wrapQuotes(string2));
        treeMap.put("event_condition", this.wrapQuotes(string7));
        treeMap.put("end_date", string6);
        treeMap.put("start_date", string5);
        treeMap.put("queue_spec", string8);
        treeMap.put(COMMENTS, this.wrapQuotes(string3));
        treeMap.put("repeat_interval", this.wrapQuotes(string4));
        Map<String, Boolean> map = this.whenModel.getChanges();
        Map<String, Boolean> map2 = this.whenModel.getIsNull();
        map.put(COMMENTS, !SchedulerCreateAction.areEqual(this.oldComments, string3));
        if (!SchedulerCreateAction.areEqual(this.oldComments, string3)) {
            map.put("has_changes", true);
        }
        map2.put(COMMENTS, string3 == null);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("schema", this.scheduleOwner);
        treeMap2.put("model", treeMap);
        treeMap2.put("changes", map);
        treeMap2.put("isnull", map2);
        String string9 = null;
        string9 = operation == Operation.EDIT ? dBMSSchedulerCodeGenerator.generate(string, "SCHEDULE_UPDATE", treeMap2) : (eventType != null && eventType.getScheduleType() == ScheduleWhenModel.ScheduleType.EVENT ? dBMSSchedulerCodeGenerator.generate(string, "CREATE_EVENT_SCHEDULE", treeMap2) : dBMSSchedulerCodeGenerator.generate(string, "CREATE_SCHEDULE", treeMap2));
        return string9;
    }

    protected String getTitle() {
        Operation operation = this.getOperation();
        if (operation == Operation.EDIT) {
            return SchedulerArb.getString("SCHEDULEUPDATEDIALOG_TITLE");
        }
        return SchedulerArb.getString("SCHEDULECREATEDIALOG_TITLE");
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHSCHEDULE";
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_createScheduleDialog_html");
    }

    protected boolean isCloseOnError() {
        return false;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    private String wrapQuotes(String string) {
        return string != null ? string.replaceAll("'", "''") : string;
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return SchedulerCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(SchedulerCreateAction.this.getDBObject().getDBVersion(), "SCHEDULE_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = SchedulerCreateAction.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("SCHEDULE_NAME");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    resultSetWrapper.close();
                }
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

