/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleResultSet;

public class NewJobModel {
    private Hashtable<String, String> attributesDefaults = new Hashtable();
    private DBObject dbObject = null;
    private HashMap<String, Object> previousJobDataMap;
    private HashMap<String, String> notificationDataMap;
    private HashMap<Integer, String> jobArgDataMap;
    private HashMap<String, String> previousJobDestinationMap;
    private ScheduleWhenModel whenModel;
    private String[] queryRaiseEvents = new String[]{"job_started", "job_succeeded", "job_failed", "job_broken", "job_completed", "job_stopped", "job_sch_lim_reached", "job_disabled", "job_chain_stalled"};
    private Connection connection = null;
    private Operation operation;
    private String schemaForStoreProcedure = null;

    public NewJobModel(DBObject dBObject, Operation operation) {
        this.previousJobDataMap = new HashMap();
        this.notificationDataMap = new HashMap();
        this.jobArgDataMap = new HashMap();
        this.previousJobDestinationMap = new HashMap();
        this.operation = operation;
        this.whenModel = new ScheduleWhenModel();
        this.setDBObject(dBObject);
    }

    public void setDBObject(DBObject dBObject) {
        this.dbObject = dBObject;
        this.connection = dBObject != null ? dBObject.getConnection() : null;
    }

    public DBObject getDBObject() {
        return this.dbObject;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean getDelayLoadingChoice() {
        return this.getOperation() == Operation.CREATE_NEW;
    }

    public ScheduleWhenModel getWhenModel() {
        return this.whenModel;
    }

    public Object setPreviousJobData(String string, Object object) {
        return this.previousJobDataMap.put(string, object);
    }

    public Object getPreviousJobData(String string) {
        return this.previousJobDataMap.get(string);
    }

    public void setPreviousJobJobArgData(Integer n, String string) {
        this.jobArgDataMap.put(n, string);
    }

    public String[] getPreviousJobJobArgData() {
        String[] stringArray = null;
        Set<Integer> set = this.jobArgDataMap.keySet();
        if (set.size() > 0) {
            stringArray = new String[set.size()];
            Iterator<Integer> iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = this.jobArgDataMap.get(iterator.next());
                ++n;
            }
        }
        return stringArray;
    }

    public String getLoggingLevelPreviousJobData() {
        String string = (String)this.getPreviousJobData("oldLoggingLevel");
        if (string.equals("OFF")) {
            string = "DBMS_SCHEDULER.LOGGING_OFF";
        } else if (string.equals("RUNS")) {
            string = "DBMS_SCHEDULER.LOGGING_RUNS";
        } else if (string.equals("FAILED RUNS")) {
            string = "DBMS_SCHEDULER.LOGGING_FAILED_RUNS";
        } else if (string.equals("FULL")) {
            string = "DBMS_SCHEDULER.LOGGING_FULL";
        }
        return string;
    }

    private String[] getEventsFromString(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i <= 8; ++i) {
            if (string.indexOf(this.queryRaiseEvents[i].toUpperCase()) < 0) continue;
            hashSet.add(this.queryRaiseEvents[i]);
        }
        String[] stringArray = new String[hashSet.size()];
        return hashSet.toArray(stringArray);
    }

    private int getEventTotalFromString(String string) {
        int n = 0;
        for (int i = 0; i <= 8; ++i) {
            if (string.indexOf(this.queryRaiseEvents[i].toUpperCase()) < 0) continue;
            n += (int)Math.pow(2.0, i);
        }
        return n;
    }

    public String[] getRaisedEventsPreviousJobDataEnums() {
        String string = (String)this.getPreviousJobData("oldRaiseEvent");
        if (string != null) {
            return this.getEventsFromString(string);
        }
        return new String[0];
    }

    public int getRaisedEventsPreviousJobData() {
        String string = (String)this.getPreviousJobData("oldRaiseEvent");
        if (string != null) {
            return this.getEventTotalFromString(string);
        }
        return 0;
    }

    public void setJobNotificationData(String string, String string2, boolean bl) {
        String string3 = string2;
        if (bl) {
            String string4 = this.notificationDataMap.get(string);
            if (string4 == null) {
                string4 = "";
            }
            string3 = !string4.contains(string2) ? (string4.trim().length() == 0 ? string2 : string4 + " , " + string2) : string4;
        }
        this.notificationDataMap.put(string, string3);
    }

    public String getJobNotificationData(String string) {
        return this.notificationDataMap.get(string);
    }

    public Object setPreviousJobDestinationData(String string, String string2) {
        return this.previousJobDestinationMap.put(string, string2);
    }

    public String getPreviousJobDestinationData(String string) {
        return this.previousJobDestinationMap.get(string);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean Feature112() {
        return DBUtil.checkVersion((Connection)this.getConnection(), null, (Version)new Version("11.2"));
    }

    public boolean Feature111() {
        return DBUtil.checkVersion((Connection)this.getConnection(), null, (Version)new Version("11.1"));
    }

    public boolean Feature102() {
        return DBUtil.checkVersion((Connection)this.getConnection(), null, (Version)new Version("10.2"));
    }

    public boolean supportsExternalDBJobs() {
        return this.Feature112();
    }

    public String getSchema() {
        return this.dbObject != null ? this.dbObject.getSchemaName() : null;
    }

    public String getJobObjectName() {
        return this.dbObject != null ? this.dbObject.getObjectName() : null;
    }

    public String getDBObjectSchemaName() {
        return DBURLFormatHelper.getSchema((URL)this.dbObject.getURL());
    }

    public String getDBObjectChildName() {
        return DBURLFormatHelper.getChildName((URL)this.dbObject.getURL());
    }

    public String getDBObjectName() {
        return DBURLFormatHelper.getName((URL)this.dbObject.getURL());
    }

    protected String getObjectName() {
        String string = this.getDBObjectChildName();
        if (string == null) {
            string = this.getDBObjectName();
        }
        return string;
    }

    public void setSchemaForStoredProcedure(String string) {
        this.schemaForStoreProcedure = string;
    }

    public String getSchemaForStoredProcedure() {
        return this.schemaForStoreProcedure;
    }

    public String getDBVersion() {
        return this.dbObject != null ? this.dbObject.getDBVersion() : null;
    }

    public String getQuery() {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string = dBMSSchedulerCodeGenerator.generate(this.getDBVersion(), "JOB_LIST", null);
        return string;
    }

    protected String getQuery(Connection connection, String string) {
        return Utils.getQuery(this.getClass(), (Connection)connection, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobInformation() {
        String string = this.getJobObjectName();
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OBJECT_NAME", string);
                String string2 = this.getQuery(connection, "getJobData");
                resultSetWrapper = dBUtil.executeOracleQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setJobDataFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobParallelInstanceData() {
        String string = this.getJobObjectName();
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OBJECT_NAME", string);
                String string2 = this.getQuery(connection, "getParallelInstanceData");
                resultSetWrapper = dBUtil.executeOracleQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setParallelInstancesFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobJobArgsData() {
        String string = this.getJobObjectName();
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OBJECT_NAME", string);
                String string2 = this.getQuery(connection, "getJobArgsData");
                resultSetWrapper = dBUtil.executeOracleQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setJobArgsFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public void setNewJobInformation() {
        this.whenModel.initProperty(ScheduleWhenModel.Property.EVENT_TYPE, (Object)ScheduleWhenModel.EventType.IMMEDIATE);
    }

    protected void setJobDataFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                this.setPreviousJobData("oldOwner", this.getSchema());
                this.setPreviousJobData("oldObjectName", this.getObjectName());
                this.setPreviousJobData("oldJobclass", "\"SYS\".\"" + this.getStringFromRS(resultSet, "JOB_CLASS") + "\"");
                this.setPreviousJobData("oldEnabled", this.getStringFromRS(resultSet, "ENABLED"));
                this.setPreviousJobData("oldComments", this.getStringFromRS(resultSet, "COMMENTS"));
                this.setPreviousJobData("oldJobType", this.getStringFromRS(resultSet, "JOB_TYPE"));
                this.setPreviousJobData("oldJobAction", this.getStringFromRS(resultSet, "JOB_ACTION"));
                this.setPreviousJobData("oldNumArgs", new Integer(this.getIntFromRS(resultSet, "NUMBER_OF_ARGUMENTS")));
                this.setPreviousJobData("oldProgramName", this.getStringFromRS(resultSet, "PROGRAM_NAME"));
                this.setPreviousJobData("oldProgramOwner", this.getStringFromRS(resultSet, "PROGRAM_OWNER"));
                this.setPreviousJobData("oldJobStyle", this.getStringFromRS(resultSet, "JOB_STYLE"));
                this.setPreviousJobData("oldCredentialOwner", this.getStringFromRS(resultSet, "CREDENTIAL_OWNER"));
                this.setPreviousJobData("oldCredentialName", this.getStringFromRS(resultSet, "CREDENTIAL_NAME"));
                this.setPreviousJobData("oldDestinationOwner", this.getStringFromRS(resultSet, "DESTINATION_OWNER"));
                this.setPreviousJobData("oldDestinationName", this.getStringFromRS(resultSet, "DESTINATION"));
                this.setPreviousJobData("oldNumberOfDestination", new Integer(this.getIntFromRS(resultSet, "NUMBER_OF_DESTINATIONS")));
                this.setPreviousJobData("oldSource", this.getStringFromRS(resultSet, "SOURCE"));
                this.setPreviousJobData("oldAutoDrop", this.getStringFromRS(resultSet, "AUTO_DROP"));
                this.setPreviousJobData("oldRestartable", this.getStringFromRS(resultSet, "RESTARTABLE"));
                this.setPreviousJobData("oldJobPriority", this.getStringFromRS(resultSet, "JOB_PRIORITY"));
                this.setPreviousJobData("oldMaxRuns", this.getStringFromRS(resultSet, "MAX_RUNS"));
                this.setPreviousJobData("oldMaxFailures", this.getStringFromRS(resultSet, "MAX_FAILURES"));
                this.setPreviousJobData("oldJobWeight", this.getStringFromRS(resultSet, "JOB_WEIGHT"));
                this.setPreviousJobData("oldStopOnWindowClose", this.getStringFromRS(resultSet, "STOP_ON_WINDOW_CLOSE"));
                this.setPreviousJobData("oldFollowDefaultTimeZone", this.getStringFromRS(resultSet, "STOP_ON_WINDOW_CLOSE"));
                this.setPreviousJobData("oldLoggingLevel", this.getStringFromRS(resultSet, "LOGGING_LEVEL"));
                this.setPreviousJobData("oldInstanceId", this.getStringFromRS(resultSet, "INSTANCE_ID"));
                this.setPreviousJobData("oldMaxRunDuration", this.getStringFromRS(resultSet, "MAX_RUN_DURATION"));
                this.setPreviousJobData("oldScheduleLimit", this.getStringFromRS(resultSet, "SCHEDULE_LIMIT"));
                this.setPreviousJobData("oldRaiseEvent", this.getStringFromRS(resultSet, "RAISE_EVENTS"));
                this.getWhenModel().initPropertiesFromRS((OracleResultSet)resultSet, this.connection);
            }
        }
    }

    protected void setParallelInstancesFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                this.setPreviousJobData("oldParallelInstances", this.getStringFromRS(resultSet, "PARALLEL_INSTANCES"));
            }
        }
    }

    protected void setJobArgsFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "JOB_NAME");
                String string2 = this.getStringFromRS(resultSet, "ARGUMENT_NAME");
                int n = this.getIntFromRS(resultSet, "ARGUMENT_POSITION");
                String string3 = this.getStringFromRS(resultSet, "ARGUMENT_TYPE");
                String string4 = this.getStringFromRS(resultSet, "VALUE");
                this.setPreviousJobJobArgData(new Integer(n), string4);
            }
        }
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getIntFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private long getLongFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getLong(string);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    private boolean getBooleanFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getBoolean(string);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobNotificationInformation() {
        if (!this.Feature112()) {
            return;
        }
        String string = this.getJobObjectName();
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OBJECT_NAME", string);
                String string2 = this.getQuery(connection, "getNotificationData");
                if (string2 != null && (resultSetWrapper = dBUtil.executeOracleQuery(string2, hashMap)) != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setNotificationDataFromResultSet(resultSet);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void setNotificationDataFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            if (resultSet.next()) {
                do {
                    this.setJobNotificationData("oldJobNotificationRecipient", this.getStringFromRS(resultSet, "RECIPIENT"), true);
                    this.setJobNotificationData("oldJobNotificationSender", this.getStringFromRS(resultSet, "SENDER"), false);
                    this.setJobNotificationData("oldJobNotificationBody", this.getStringFromRS(resultSet, "BODY"), false);
                    this.setJobNotificationData("oldJobNotificationSubject", this.getStringFromRS(resultSet, "SUBJECT"), false);
                    this.setJobNotificationData("oldJobNotificationFilterCondition", this.getStringFromRS(resultSet, "FILTER_CONDITION"), false);
                    this.setJobNotificationData("oldJobNotificationSelectedEvents", this.getStringFromRS(resultSet, "EVENT"), true);
                } while (resultSet.next());
            } else {
                this.setJobNotificationData("oldJobNotificationSubject", NewJobPropertyPanelModel.notificationDefaultSubject, false);
                this.setJobNotificationData("oldJobNotificationBody", NewJobPropertyPanelModel.notificationDefaultBody, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobDestinationInformation() {
        if (!this.Feature112()) {
            return;
        }
        String string = (String)this.getPreviousJobData("oldDestinationOwner");
        String string2 = (String)this.getPreviousJobData("oldDestinationName");
        if (string2 == null) {
            this.setPreviousJobDestinationData("oldJobDestinationType", "");
        } else {
            Connection connection = this.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSetWrapper resultSetWrapper = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_OWNER", string);
                    hashMap.put("OBJECT_DEST_OR_GROUP_NAME", string2);
                    String string3 = this.getQuery(connection, "getDestinationTypeData");
                    if (string3 != null && (resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap)) != null) {
                        ResultSet resultSet = resultSetWrapper.getResultSet();
                        this.setDestinationDataFromResultSet(resultSet);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    protected void setDestinationDataFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null && resultSet.next()) {
            this.setPreviousJobDestinationData("oldJobDestinationType", this.getStringFromRS(resultSet, "DEST_TYPE"));
        }
    }

    public void printHashMapJobModel() {
        this.printHashMap(this.previousJobDataMap, "PreviousJobDataMap");
        this.printHashMap(this.notificationDataMap, "NotificationDataMap");
        this.printHashMap(this.jobArgDataMap, "jobArgDataMap");
        this.printHashMap(this.previousJobDestinationMap, "previousJobDestinationMap");
    }

    private void printHashMap(HashMap hashMap, String string) {
        System.out.println("*********************************************");
        System.out.println("  \t\t" + string);
        System.out.println("*********************************************");
        Set set = hashMap.keySet();
        for (Object k : set) {
            String string2 = null;
            Object v = hashMap.get(k);
            if (v instanceof String) {
                string2 = (String)v;
            } else if (v instanceof Integer) {
                string2 = new String() + (Integer)v;
            }
            System.out.println("  <key=" + k + ">, value=" + (string2 == null ? "(null)" : string2));
        }
        System.out.println("*********************************************");
    }

    public static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

