/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateBase;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobAdvancedPropertiesPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobDestinationCommonPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobEmailNotificationPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobProgramArgumentCommonPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobProgramArgumentExecutablePanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobProgramArgumentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelDBTask;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;

public class NewJobCreateAction
extends NewJobCreateBase {
    private static boolean DEBUG = false;
    NewJobPropertyPanel basicEditPanel;
    NewJobAdvancedPropertiesPanel advancedPropertiesEditPanel;
    NewJobProgramArgumentPanel programArgumentsEditPanel;
    NewJobProgramArgumentExecutablePanel programArgumentsExecutableEditPanel;
    NewJobDestinationCommonPanel destinationEditPanel;
    NewJobEmailNotificationPanel emailNotificationEditPanel;

    private void initiateRaptorTask_JobDetails(Connection connection) {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string = this.getQuery(connection, "jobCreateGetUsers");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.SCHEMA_LIST_UPDATE_METHOD);
        string = this.getQuery(connection, "jobCreateGetCurrentUser");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask2 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.SCHEMA_UPDATE_METHOD);
        string = dBMSSchedulerCodeGenerator.generate(this.version, "JOB_CLASS_NAMES", null);
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask3 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOBCLASS_LIST_UPDATE_METHOD);
        string = this.getQuery(connection, "getPrograms");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask4 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHAT_NAMED_PROGRAMS_METHOD);
        string = this.getQuery(connection, "getSchedules_NewJob");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask5 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHEN_NAMED_SCHEDULES_METHOD);
        string = this.getQuery(connection, "getChains");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask6 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHAT_CHAINS_METHOD);
        string = this.getQuery(connection, "getStoredProcedures");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask7 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHAT_STORED_PROCEDURES_METHOD);
        string = this.getQuery(connection, "getAdvancedQueues_NewJob");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask8 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHEN_EVENT_ADVANCED_QUEUE_METHOD);
        string = this.getQuery(connection, "getAgents_NewJob");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask9 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHEN_EVENT_AGENT_METHOD);
        string = this.getQuery(connection, "getFileWatchers_NewJob");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask10 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHEN_FILE_WATCHER_METHOD);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask2);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask3);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask4);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask6);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask7);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask5);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask8);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask9);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask10);
        this.model.addPropertyChangeListener(this.modelChanges);
    }

    private void initiateRaptorTask_Destination(Connection connection) {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string = this.getQuery(connection, "jobCreateGetLocalCredentials");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string, NewJobPropertyPanelModel.JOB_WHERE_TO_EXECUTE_JOBS_LOCAL_CREDENTIAL_METHOD);
        String string2 = this.getQuery(connection, "jobCreateGetRemoteCredentials");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask2 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string2, NewJobPropertyPanelModel.JOB_WHERE_TO_EXECUTE_JOBS_REMOTE_CREDENTIAL_METHOD);
        String string3 = this.getQuery(connection, "jobCreateGetRemoteDBDestinations");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask3 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string3, NewJobPropertyPanelModel.JOB_WHERE_TO_EXECUTE_JOBS_REMOTE_DESTINATION_METHOD);
        String string4 = this.getQuery(connection, "jobCreateGetRemoteExternalDestinations");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask4 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string4, NewJobPropertyPanelModel.JOB_WHERE_TO_EXECUTE_JOBS_REMOTE_EXTERNAL_DESTINATION_METHOD);
        String string5 = this.getQuery(connection, "jobCreateGetMultipleCredentials");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask5 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string5, NewJobPropertyPanelModel.JOB_WHERE_TO_EXECUTE_JOBS_MULTIPLE_CREDENTIAL_METHOD);
        String string6 = this.getQuery(connection, "jobCreateGetMultipleDBDestinations");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask6 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string6, NewJobPropertyPanelModel.JOB_WHERE_TO_EXECUTE_JOBS_MULTIPLE_DESTINATION_METHOD);
        String string7 = this.getQuery(connection, "jobCreateGetMultipleExternalDestinations");
        NewJobPropertyPanelDBTask newJobPropertyPanelDBTask7 = new NewJobPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string7, NewJobPropertyPanelModel.JOB_WHERE_TO_EXECUTE_JOBS_MULTIPLE_EXTERNAL_DESTINATION_METHOD);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask2);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask3);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask4);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask5);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask6);
        RaptorTaskManager.getInstance().addTask((RaptorTask)newJobPropertyPanelDBTask7);
        this.model.addPropertyChangeListener(this.modelChanges);
    }

    @Override
    protected JComponent initEditPane(Connection connection, CustomTabbedPane customTabbedPane) {
        this.initiateRaptorTask_JobDetails(connection);
        NewJobPropertyPanel newJobPropertyPanel = new NewJobPropertyPanel(PanelType.CREATE, this.model, this.controller, connection, customTabbedPane);
        return newJobPropertyPanel;
    }

    @Override
    protected JComponent initEditPane_ProgramArguments(String string, String string2) {
        NewJobProgramArgumentCommonPanel newJobProgramArgumentCommonPanel = new NewJobProgramArgumentCommonPanel(PanelType.CREATE, this.model, this.controller, string, string2);
        return newJobProgramArgumentCommonPanel;
    }

    @Override
    protected JComponent initEditPane_AdvancedProperties() {
        NewJobAdvancedPropertiesPanel newJobAdvancedPropertiesPanel = new NewJobAdvancedPropertiesPanel(PanelType.CREATE, this.model, this.controller);
        return newJobAdvancedPropertiesPanel;
    }

    @Override
    protected JComponent initEditPane_Destination(Connection connection) {
        this.initiateRaptorTask_Destination(connection);
        NewJobDestinationCommonPanel newJobDestinationCommonPanel = new NewJobDestinationCommonPanel(PanelType.CREATE, this.model, this.controller);
        return newJobDestinationCommonPanel;
    }

    @Override
    protected JComponent initEditPane_EmailNotification() {
        NewJobEmailNotificationPanel newJobEmailNotificationPanel = new NewJobEmailNotificationPanel(PanelType.CREATE, this.model, this.controller);
        return newJobEmailNotificationPanel;
    }

    public void setArgs(String string) {
    }

    protected String getEditPaneTitle() {
        return SchedulerArb.getString("JOB_CREATE_TAB_JOB_DETAILS");
    }

    protected String getTitle() {
        return SchedulerArb.getString("JOBCREATEDIALOG_TITLE");
    }

    protected String getScript() {
        String string;
        block16: {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("changes", this.modelChanges);
            hashtable.put("model", this.templateModel);
            try {
                String string2;
                String string3;
                String string4;
                String string5 = this.getDBMSSchedulerCreateJobCodeGeneratorOption();
                if (string5 == null) {
                    throw new Throwable("There is not code option; please check the configuration of the params.");
                }
                String string6 = dBMSSchedulerCodeGenerator.generate(this.version, string5, hashtable);
                string = string6.trim();
                if (string.endsWith("END;")) {
                    string = string.substring(0, string.length() - 4);
                } else if (string.endsWith("END")) {
                    string = string.substring(0, string.length() - 3);
                }
                List<NewJobPropertyPanelModel.JobArgument> list = this.model.getJobArguments();
                if (list.size() > 0) {
                    string4 = null;
                    if (this.model.getJobArgSelectionChoice() == 1) {
                        string4 = "JOB_CREATE_SET_ARGUMENT_BY_POSITION";
                        for (NewJobPropertyPanelModel.JobArgument jobArgument : list) {
                            string3 = this.model.getSchema();
                            string2 = this.model.getJobName();
                            String string7 = jobArgument.getArgumentNewValue();
                            Integer n = jobArgument.getArgumentPosition();
                            if (string7 == null || string7.length() <= 0) continue;
                            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                            hashtable2.put("argument_value", string7);
                            hashtable2.put("argument_position", n);
                            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                            treeMap.put("args", hashtable2);
                            treeMap.put("model", this.templateModel);
                            String string8 = dBMSSchedulerCodeGenerator.generate(this.version, string4, treeMap);
                            string = string + "\n\n" + string8;
                        }
                    } else {
                        string4 = "JOB_CREATE_SET_ARGUMENT_BY_NAME";
                        for (NewJobPropertyPanelModel.JobArgument jobArgument : list) {
                            string3 = this.model.getSchema();
                            string2 = this.model.getJobName();
                            String string9 = jobArgument.getArgumentNewValue();
                            String string10 = jobArgument.getArgumentName();
                            if (string9 == null || string9.length() <= 0) continue;
                            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                            hashtable3.put("argument_value", string9);
                            hashtable3.put("argument_name", string10);
                            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                            treeMap.put("args", hashtable3);
                            treeMap.put("model", this.templateModel);
                            String string11 = dBMSSchedulerCodeGenerator.generate(this.version, string4, treeMap);
                            string = string + "\n\n" + string11;
                        }
                    }
                }
                if ((string4 = this.getDBMSSchedulerCreateJobAttributeCodeGenertorOption()) == null) {
                    throw new Throwable("There is not code option; please check the configuration of the params (Set Attribute).");
                }
                String string12 = dBMSSchedulerCodeGenerator.generate(this.version, string4, hashtable);
                string = string + "\n\n" + (String)string12;
                boolean bl = this.controller.isEmailActive();
                if (bl) {
                    string3 = this.getDBMSSchedulerCreateJobEmailNotificationCodeGenertorOption();
                    if (string3 == null) {
                        throw new Throwable("There is not code option; please check the configuration of the params (Explicit Enable).");
                    }
                    string2 = dBMSSchedulerCodeGenerator.generate(this.version, string3, hashtable);
                    string = string + "\n\n" + string2;
                }
                if (this.model.getEnabled().booleanValue()) {
                    string3 = this.getDBMSSchedulerCreateJobExplicitEnableCodeGenertorOption();
                    string2 = dBMSSchedulerCodeGenerator.generate(this.version, string3, hashtable);
                    string = string + "\n\n" + string2;
                }
                string = string + "\nEND; \n/";
            }
            catch (Throwable throwable) {
                string = "";
                if (!DEBUG) break block16;
                throwable.printStackTrace();
            }
        }
        if (DEBUG) {
            System.out.println("code = " + string);
        }
        return string;
    }

    private String getDBMSSchedulerCreateJobCodeGeneratorOption() {
        if (this.model == null) {
            return null;
        }
        if (this.model.getJobTypeSelection() == null) {
            // empty if block
        }
        if (this.model.getExecuteJobSelection() == null) {
            // empty if block
        }
        if (this.model.getJobTypeSelection() == null || this.model.getExecuteJobSelection() == null) {
            return null;
        }
        String string = this.model.getJobTypeSelection().trim();
        String string2 = this.model.getExecuteJobSelection().trim();
        if (string.equals("NAMED_PROGRAM") && string2.equals("NAMED_SCHEDULE")) {
            return "CREATE_JOB_PROG_AND_SCHEDULE";
        }
        if (string.equals("NAMED_PROGRAM") && string2.equals("IMMEDIATE")) {
            return "CREATE_JOB_PROG_AND_INLINE_SCHEDULE";
        }
        if (string.equals("NAMED_PROGRAM") && string2.equals("ONCE")) {
            return "CREATE_JOB_PROG_AND_INLINE_SCHEDULE";
        }
        if (string.equals("NAMED_PROGRAM") && string2.equals("EVENT")) {
            return "CREATE_JOB_PROG_AND_EVENT";
        }
        if (string.equals("NAMED_PROGRAM") && string2.equals("CALENDAR_EXPRESSION")) {
            return "CREATE_JOB_PROG_AND_INLINE_SCHEDULE";
        }
        if (string.equals("NAMED_PROGRAM") && string2.equals("FILE_WATCHER")) {
            return "CREATE_JOB_PROG_AND_EVENT";
        }
        if (string.equals("CHAIN") && string2.equals("NAMED_SCHEDULE")) {
            return "CREATE_JOB_INLINE_PROG_AND_SCHEDULE";
        }
        if (string.equals("CHAIN") && string2.equals("IMMEDIATE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("CHAIN") && string2.equals("ONCE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("CHAIN") && string2.equals("EVENT")) {
            return "CREATE_JOB_INLINE_PROG_AND_EVENT";
        }
        if (string.equals("CHAIN") && string2.equals("CALENDAR_EXPRESSION")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("PLSQL_BLOCK") && string2.equals("NAMED_SCHEDULE")) {
            return "CREATE_JOB_INLINE_PROG_AND_SCHEDULE";
        }
        if (string.equals("PLSQL_BLOCK") && string2.equals("IMMEDIATE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("PLSQL_BLOCK") && string2.equals("ONCE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("PLSQL_BLOCK") && string2.equals("EVENT")) {
            return "CREATE_JOB_INLINE_PROG_AND_EVENT";
        }
        if (string.equals("PLSQL_BLOCK") && string2.equals("CALENDAR_EXPRESSION")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("STORED_PROCEDURE") && string2.equals("NAMED_SCHEDULE")) {
            return "CREATE_JOB_INLINE_PROG_AND_SCHEDULE";
        }
        if (string.equals("STORED_PROCEDURE") && string2.equals("IMMEDIATE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("STORED_PROCEDURE") && string2.equals("ONCE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("STORED_PROCEDURE") && string2.equals("EVENT")) {
            return "CREATE_JOB_INLINE_PROG_AND_EVENT";
        }
        if (string.equals("STORED_PROCEDURE") && string2.equals("CALENDAR_EXPRESSION")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("STORED_PROCEDURE") && string2.equals("FILE_WATCHER")) {
            return "CREATE_JOB_PROG_AND_EVENT";
        }
        if (string.equals("EXECUTABLE") && string2.equals("NAMED_SCHEDULE")) {
            return "CREATE_JOB_INLINE_PROG_AND_SCHEDULE";
        }
        if (string.equals("EXECUTABLE") && string2.equals("IMMEDIATE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("EXECUTABLE") && string2.equals("ONCE")) {
            return "CREATE_JOB_BASIC";
        }
        if (string.equals("EXECUTABLE") && string2.equals("EVENT")) {
            return "CREATE_JOB_INLINE_PROG_AND_EVENT";
        }
        if (string.equals("EXECUTABLE") && string2.equals("CALENDAR_EXPRESSION")) {
            return "CREATE_JOB_BASIC";
        }
        return null;
    }

    private String getDBMSSchedulerCreateJobAttributeCodeGenertorOption() {
        if (!this.isReadyforCodeGen()) {
            return null;
        }
        return "JOB_CREATE_SET_ATTRIBUTES";
    }

    private String getDBMSSchedulerCreateJobExplicitEnableCodeGenertorOption() {
        if (!this.isReadyforCodeGen()) {
            return null;
        }
        return "JOB_CREATE_SET_ATTRIBUTES_EXPLICIT_ENABLE";
    }

    private String getDBMSSchedulerCreateJobEmailNotificationCodeGenertorOption() {
        if (!this.isReadyforCodeGen()) {
            return null;
        }
        return "JOB_CREATE_ADD_EMAIL_NOTIFICATION";
    }

    private boolean isReadyforCodeGen() {
        if (this.model == null) {
            return false;
        }
        if (this.model.getJobTypeSelection() == null || this.model.getExecuteJobSelection() == null) {
            return false;
        }
        String string = this.model.getJobTypeSelection().trim();
        String string2 = this.model.getExecuteJobSelection().trim();
        return string != null && string2 != null;
    }

    private String getDBMSSchedulerDestinationCodeGeneratorOption() {
        if (this.model == null) {
            return null;
        }
        String string = this.model.getJobTypeSelection().trim();
        String string2 = this.model.getExecuteJobSelection().trim();
        String string3 = this.model.getDestinationSelection().trim();
        if (string3.equals("LOCAL") ? !string.equals("EXECUTABLE") : string3.equals("REMOTE") || string3.equals("MULTIPLE")) {
            return null;
        }
        return null;
    }
}

