/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.resource.UtilBundle;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.CharacterMap;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLObjectReader
extends Reader {
    private XMLDocument m_doc;
    private DTD m_dtd;
    private Reader m_reader;
    private boolean m_isValidate = false;
    private String m_xml;
    private DOMParser m_parser;
    public static ThreadLocal s_tls;
    protected ResourceBundle m_Resources = null;

    public XMLObjectReader(String xml) {
        this.m_xml = xml;
        this.initialize();
    }

    public XMLObjectReader(Reader reader) {
        this.m_reader = reader;
        this.initialize();
    }

    public XMLObjectReader(InputStream inputStream) {
        try {
            this.m_reader = new InputStreamReader(inputStream, "UTF8");
        }
        catch (Exception e) {
            this.m_reader = new InputStreamReader(inputStream);
        }
        this.initialize();
    }

    private void initialize() {
        if (s_tls != null) {
            Object _obj = s_tls.get();
            try {
                if (_obj != null && _obj instanceof DOMParser) {
                    this.m_parser = (DOMParser)_obj;
                }
            }
            catch (Exception ex) {
                this.m_parser = null;
            }
        }
        if (this.m_parser == null) {
            this.m_parser = new DOMParser();
            this.m_parser.setPreserveWhitespace(false);
            this.m_parser.showWarnings(false);
        }
        if (this.m_Resources == null) {
            try {
                this.m_Resources = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
            }
            catch (MissingResourceException mre) {
                mre.printStackTrace();
                this.m_Resources = null;
            }
        }
    }

    public void setValidationMode(boolean validate) {
        this.m_isValidate = validate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDTD(String dtdName, String componentName) throws BIIOException, BIParseException, BISAXException {
        InputStream _in = this.getClass().getResourceAsStream(dtdName);
        if (_in == null) {
            throw new BIIOException(UtilBundle.getResourceString("DTD cannot be found", this.m_Resources), null);
        }
        try {
            XMLObjectReader xMLObjectReader = this;
            synchronized (xMLObjectReader) {
                this.m_parser.setValidationMode(false);
                this.m_parser.parseDTD(_in, componentName);
                this.m_dtd = this.m_parser.getDoctype();
            }
        }
        catch (IOException ioe) {
            throw new BIIOException(ioe.getLocalizedMessage(), null);
        }
        catch (XMLParseException xpe) {
            throw new BIParseException(xpe.getMessage(0), xpe.getPublicId(), xpe.getSystemId(), xpe.getLineNumber(0), xpe.getColumnNumber(0), xpe.getMessageType(0), null);
        }
        catch (SAXException se) {
            throw new BISAXException(se.getLocalizedMessage(), null);
        }
    }

    public ObjectNode readObjectNode() throws BIIOException, BIParseException, BISAXException {
        return this.readObjectNode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode readObjectNode(CharacterMap map) throws BIIOException, BIParseException, BISAXException {
        if (this.m_xml != null) {
            this.m_reader = new StringReader(this.convertCharacters(this.m_xml, map));
        }
        try {
            XMLObjectReader xMLObjectReader = this;
            synchronized (xMLObjectReader) {
                this.m_parser.setValidationMode(this.m_isValidate);
                if (this.m_isValidate && this.m_dtd != null) {
                    this.m_parser.setDoctype(this.m_dtd);
                }
                this.m_parser.parse(this.m_reader);
                this.m_doc = this.m_parser.getDocument();
            }
            Element elem = (Element)this.m_doc.removeChild((Node)this.m_doc.getDocumentElement());
            ObjectNode node = new ObjectNode(new ObjectScope(), elem);
            this.close();
            return node;
        }
        catch (IOException ioe) {
            throw new BIIOException(ioe.getLocalizedMessage(), null);
        }
        catch (XMLParseException xpe) {
            throw new BIParseException(xpe.getLocalizedMessage(), xpe.getPublicId(), xpe.getSystemId(), xpe.getLineNumber(), xpe.getColumnNumber(), xpe.getMessageType(0), null);
        }
        catch (SAXException se) {
            throw new BISAXException(se.getLocalizedMessage(), null);
        }
    }

    public ContainerNode readContainerNode() throws BIIOException, BIParseException, BISAXException {
        return this.readContainerNode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerNode readContainerNode(CharacterMap map) throws BIIOException, BIParseException, BISAXException {
        if (this.m_xml != null) {
            this.m_reader = new StringReader(this.convertCharacters(this.m_xml, map));
        }
        try {
            XMLObjectReader xMLObjectReader = this;
            synchronized (xMLObjectReader) {
                this.m_parser.setValidationMode(this.m_isValidate);
                if (this.m_isValidate && this.m_dtd != null) {
                    this.m_parser.setDoctype(this.m_dtd);
                }
                this.m_parser.parse(this.m_reader);
            }
            this.m_doc = this.m_parser.getDocument();
            Element elem = (Element)this.m_doc.removeChild((Node)this.m_doc.getDocumentElement());
            ContainerNode node = new ContainerNode(new ObjectScope(), elem);
            this.close();
            return node;
        }
        catch (IOException ioe) {
            throw new BIIOException(ioe.getLocalizedMessage(), null);
        }
        catch (XMLParseException xpe) {
            throw new BIParseException(xpe.getLocalizedMessage(), xpe.getPublicId(), xpe.getSystemId(), xpe.getLineNumber(), xpe.getColumnNumber(), xpe.getMessageType(0), null);
        }
        catch (SAXException se) {
            throw new BISAXException(se.getLocalizedMessage(), null);
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.m_reader.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.m_reader.close();
    }

    private String convertCharacters(String xml, CharacterMap map) {
        if (map != null) {
            Vector _maps = map.getMappings();
            if (_maps != null) {
                for (int j = _maps.size() - 1; j > -1; --j) {
                    Object _holder;
                    Object _elem = _maps.elementAt(j);
                    if (_elem instanceof CharacterMap.CharHolder) {
                        _holder = (CharacterMap.CharHolder)_maps.elementAt(j);
                        xml = xml.replace(((CharacterMap.CharHolder)_holder).getValue(), ((CharacterMap.CharHolder)_holder).getKey());
                        continue;
                    }
                    if (!(_elem instanceof CharacterMap.StringHolder)) continue;
                    _holder = (CharacterMap.StringHolder)_maps.elementAt(j);
                    xml = this.replace(xml, 0, ((CharacterMap.StringHolder)_holder).getValue(), ((CharacterMap.StringHolder)_holder).getKey());
                }
            }
            return xml;
        }
        return xml;
    }

    private String replace(String xml, int index, String key, String value) {
        int _index = xml.indexOf(key, index);
        if (_index > -1) {
            String _newStr = xml.substring(0, _index) + value + xml.substring(_index + key.length(), xml.length());
            return this.replace(_newStr, _index, key, value);
        }
        return xml;
    }
}

