/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.io;

import java.io.IOException;
import java.io.RandomAccessFile;

public class LE {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/io/LE.java /st_jdevadf_patchset_ias/1 2009/09/28 08:30:31 kmchorto Exp $";

    public static int readInt8(byte[] b, int offset) {
        byte b1 = b[offset];
        return b1;
    }

    public static int readUInt8(byte[] b, int offset) {
        byte b1 = b[offset];
        return b1 & 0xFF;
    }

    public static int readInt8(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[1];
        raf.readFully(b);
        return LE.readInt8(b, 0);
    }

    public static int readUInt8(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[1];
        raf.readFully(b);
        return LE.readUInt8(b, 0);
    }

    public static int readInt16(byte[] b, int offset) {
        byte b1 = b[offset];
        byte b2 = b[offset + 1];
        return (b2 << 8) + (b1 & 0xFF);
    }

    public static int readUInt16(byte[] b, int offset) {
        byte b1 = b[offset];
        byte b2 = b[offset + 1];
        return ((b2 & 0xFF) << 8) + (b1 & 0xFF);
    }

    public static int readInt16(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[2];
        raf.readFully(b);
        return LE.readInt16(b, 0);
    }

    public static int readUInt16(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[2];
        raf.readFully(b);
        return LE.readUInt16(b, 0);
    }

    public static int readInt32(byte[] b, int offset) {
        byte b1 = b[offset];
        byte b2 = b[offset + 1];
        byte b3 = b[offset + 2];
        byte b4 = b[offset + 3];
        return (b4 << 24) + ((b3 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + (b1 & 0xFF);
    }

    public static long readUInt32(byte[] b, int offset) {
        byte b1 = b[offset];
        byte b2 = b[offset + 1];
        byte b3 = b[offset + 2];
        byte b4 = b[offset + 3];
        return (((long)b4 & 0xFFL) << 24) + (((long)b3 & 0xFFL) << 16) + (((long)b2 & 0xFFL) << 8) + ((long)b1 & 0xFFL);
    }

    public static int readInt32(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[4];
        raf.readFully(b);
        return LE.readInt32(b, 0);
    }

    public static long readUInt32(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[4];
        raf.readFully(b);
        return LE.readUInt32(b, 0);
    }

    public static long readInt64(byte[] b, int offset) {
        byte b1 = b[offset];
        byte b2 = b[offset + 1];
        byte b3 = b[offset + 2];
        byte b4 = b[offset + 3];
        byte b5 = b[offset + 4];
        byte b6 = b[offset + 5];
        byte b7 = b[offset + 6];
        byte b8 = b[offset + 7];
        return ((long)b8 << 56) + (((long)b7 & 0xFFL) << 48) + (((long)b6 & 0xFFL) << 40) + (((long)b5 & 0xFFL) << 32) + (((long)b4 & 0xFFL) << 24) + (((long)b3 & 0xFFL) << 16) + (((long)b2 & 0xFFL) << 8) + ((long)b1 & 0xFFL);
    }

    public static long readInt64(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[8];
        raf.readFully(b);
        return LE.readInt64(b, 0);
    }

    public static double readIEEEDouble(byte[] b, int offset) {
        long l = LE.readInt64(b, offset);
        return Double.longBitsToDouble(l);
    }

    public static void memset(int val, byte[] b, int start, int end) {
        for (int i = start; i <= end; ++i) {
            b[i] = (byte)val;
        }
    }

    public static void memset(int val, byte[] b) {
        LE.memset(val, b, 0, b.length - 1);
    }

    public static void writeInt8(int val, byte[] b, int offset) {
        b[offset] = (byte)val;
    }

    public static void writeUInt8(int val, byte[] b, int offset) {
        b[offset] = (byte)val;
    }

    public static void writeInt8(int val, RandomAccessFile raf) throws IOException {
        raf.write(val);
    }

    public static void writeUInt8(int val, RandomAccessFile raf) throws IOException {
        raf.write(val);
    }

    public static void writeInt16(int val, byte[] b, int offset) {
        b[offset] = (byte)val;
        b[offset + 1] = (byte)(val >> 8);
    }

    public static void writeUInt16(int val, byte[] b, int offset) {
        b[offset] = (byte)val;
        b[offset + 1] = (byte)(val >> 8);
    }

    public static void writeInt16(int val, RandomAccessFile raf) throws IOException {
        byte[] b = new byte[2];
        LE.writeInt16(val, b, 0);
        raf.write(b);
    }

    public static void writeUInt16(int val, RandomAccessFile raf) throws IOException {
        byte[] b = new byte[2];
        LE.writeUInt16(val, b, 0);
        raf.write(b);
    }

    public static void writeInt32(int val, byte[] b, int offset) {
        b[offset] = (byte)val;
        b[offset + 1] = (byte)(val >> 8);
        b[offset + 2] = (byte)(val >> 16);
        b[offset + 3] = (byte)(val >> 24);
    }

    public static void writeUInt32(long val, byte[] b, int offset) {
        b[offset] = (byte)val;
        b[offset + 1] = (byte)(val >> 8);
        b[offset + 2] = (byte)(val >> 16);
        b[offset + 3] = (byte)(val >> 24);
    }

    public static void writeInt32(int val, RandomAccessFile raf) throws IOException {
        byte[] b = new byte[4];
        LE.writeInt32(val, b, 0);
        raf.write(b);
    }

    public static void writeUInt32(long val, RandomAccessFile raf) throws IOException {
        byte[] b = new byte[4];
        LE.writeUInt32(val, b, 0);
        raf.write(b);
    }

    public static void writeInt64(long val, byte[] b, int offset) {
        b[offset] = (byte)val;
        b[offset + 1] = (byte)(val >> 8);
        b[offset + 2] = (byte)(val >> 16);
        b[offset + 3] = (byte)(val >> 24);
        b[offset + 4] = (byte)(val >> 32);
        b[offset + 5] = (byte)(val >> 40);
        b[offset + 6] = (byte)(val >> 48);
        b[offset + 7] = (byte)(val >> 56);
    }

    public static void writeUInt64(long val, byte[] b, int offset) {
        b[offset] = (byte)val;
        b[offset + 1] = (byte)(val >> 8);
        b[offset + 2] = (byte)(val >> 16);
        b[offset + 3] = (byte)(val >> 24);
        b[offset + 4] = (byte)(val >> 32);
        b[offset + 5] = (byte)(val >> 40);
        b[offset + 6] = (byte)(val >> 48);
        b[offset + 7] = (byte)(val >> 56);
    }

    public static void writeIEEEDouble(double val, byte[] b, int offset) {
        long bits = Double.doubleToLongBits(val);
        LE.writeUInt64(bits, b, offset);
    }

    public static String UTF16LEToString(byte[] data, int offset, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = (char)LE.readUInt16(data, offset + i * 2);
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String UTF16LEToString(byte[] data, int offset) {
        char ch;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while ((ch = (char)LE.readUInt16(data, offset + i * 2)) != '\u0000') {
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public static byte[] StringToUTF16LE(String str, boolean zeroTerminate) {
        int len = str.length();
        byte[] data = zeroTerminate ? new byte[(len + 1) * 2] : new byte[len * 2];
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            LE.writeUInt16(ch, data, i * 2);
        }
        if (zeroTerminate) {
            LE.writeUInt16(0, data, len * 2);
        }
        return data;
    }
}

