/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dss.util.Utility;
import oracle.dss.util.transform.GetMemberInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;

public class Filter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<OperVal> m_filters = new ArrayList<OperVal>();

    public Filter() {
    }

    public Filter(String column, Operator oper, Object value) {
        ArrayList<Object> vals = null;
        if (value instanceof List) {
            vals = (ArrayList<Object>)value;
        } else {
            vals = new ArrayList<Object>();
            vals.add(value);
        }
        this.addFilter(column, oper, vals);
    }

    public Filter(String column, Operator oper, List<Object> values) {
        this.addFilter(column, oper, values);
    }

    private void addFilter(String column, Operator oper, List<Object> values) {
        this.m_filters.add(new OperVal(column, this.getDefaultBooleanOperator(), oper, values));
    }

    private BooleanOperator getDefaultBooleanOperator() {
        return this.m_filters.size() == 0 ? BooleanOperator.NOT_APPLICABLE : BooleanOperator.AND;
    }

    public void add(BooleanOperator boolOper, String column, Operator oper, List<Object> values) {
        this.m_filters.add(new OperVal(column, boolOper, oper, values));
    }

    public void add(BooleanOperator boolOper, String column, Operator oper, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        this.add(boolOper, column, oper, values);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter filter = (Filter)obj;
        if (this.m_filters == null && filter.m_filters == null) {
            return true;
        }
        if (this.m_filters == null || filter.m_filters == null) {
            return false;
        }
        return ((Object)this.m_filters).equals(filter.m_filters);
    }

    public Set<String> getAttributes() {
        HashSet<String> attributes = new HashSet<String>();
        for (OperVal operVal : this.m_filters) {
            attributes.addAll(operVal.getAttributes());
        }
        return attributes;
    }

    protected boolean filter(GetMemberInterface row, String dataLayer, Object dataLayerVal) throws TransformException {
        Iterator<OperVal> cols = this.m_filters.iterator();
        OperVal operVal = null;
        BooleanOperator boolOper = null;
        boolean failed = false;
        while (cols.hasNext()) {
            operVal = cols.next();
            boolOper = operVal.getBooleanOperator();
            if (boolOper == BooleanOperator.AND) {
                if (failed) {
                    return false;
                }
                boolean bl = failed = !this.test(operVal, row, dataLayer, dataLayerVal);
                if (failed) {
                    return false;
                }
            }
            if (boolOper == BooleanOperator.OR) {
                if (!failed) {
                    return true;
                }
                boolean bl = failed = !this.test(operVal, row, dataLayer, dataLayerVal);
                if (!failed) {
                    return true;
                }
            }
            if (boolOper != BooleanOperator.NOT_APPLICABLE) continue;
            failed = !this.test(operVal, row, dataLayer, dataLayerVal);
        }
        if (boolOper == BooleanOperator.NOT_APPLICABLE) {
            return !failed;
        }
        return boolOper == BooleanOperator.AND;
    }

    private boolean test(OperVal operVal, GetMemberInterface row, String dataLayer, Object dataLayerVal) throws TransformException {
        MemberInterface mi = row.getMember(operVal.getColumn());
        String val = null;
        if (mi != null) {
            val = mi.getValue();
        } else if (dataLayer != null && operVal.getColumn().equals(dataLayer)) {
            return operVal.filter(dataLayerVal);
        }
        return operVal.filter(val);
    }

    private class OperVal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected String m_column = null;
        protected BooleanOperator m_boolOper = null;
        protected Operator m_oper = null;
        protected List<Object> m_values = null;

        public OperVal(String column, BooleanOperator boolOper, Operator oper, List<Object> values) {
            this.m_column = column;
            this.m_boolOper = boolOper;
            this.m_oper = oper;
            this.m_values = values;
        }

        public String getColumn() {
            return this.m_column;
        }

        public BooleanOperator getBooleanOperator() {
            return this.m_boolOper;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OperVal)) {
                return false;
            }
            OperVal operVal = (OperVal)obj;
            return operVal.m_boolOper == this.m_boolOper && operVal.m_oper == this.m_oper && Utility.compareObj(operVal.m_column, this.m_column) && Utility.compareLists(operVal.m_values, this.m_values);
        }

        public boolean filter(Object value) {
            if (this.m_oper == Operator.EQUALS) {
                Object iterVal2 = null;
                for (Object iterVal2 : this.m_values) {
                    if (iterVal2 == null && value == null) {
                        return true;
                    }
                    if (iterVal2 == null || !iterVal2.equals(value)) continue;
                    return true;
                }
                return false;
            }
            if (this.m_oper == Operator.NOT_EQUALS) {
                Iterator<Object> iter = this.m_values.iterator();
                Object iterVal = null;
                while (iter.hasNext()) {
                    iterVal = iter.next();
                    if (iterVal == null && value == null) {
                        return false;
                    }
                    if (iterVal == null || !iterVal.equals(value)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public Set<String> getAttributes() {
            HashSet<String> attributes = new HashSet<String>();
            if (this.m_column != null) {
                attributes.add(this.m_column);
            }
            return attributes;
        }
    }

    public static enum BooleanOperator {
        AND,
        OR,
        NOT_APPLICABLE;

    }

    public static enum Operator {
        EQUALS,
        NOT_EQUALS;

    }
}

