/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.transform.Cache;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.InsertInfo;
import oracle.dss.util.transform.MemberCacheKey;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MemberWrapper;
import oracle.dss.util.transform.Page;
import oracle.dss.util.transform.PageInfo;
import oracle.dss.util.transform.PagedEdgeTreeMap;
import oracle.dss.util.transform.QDRLite;
import oracle.dss.util.transform.ResultTable;
import oracle.dss.util.transform.ResultTableInsert;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.SliceInsertInfo;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.total.TotalRow;

public class Cube
implements Cloneable {
    protected static final TransformUtils.NullMarker m_nullMarker = new TransformUtils.NullMarker();
    private Hashtable<Integer, Boolean> m_isOutline = new Hashtable();
    private boolean m_outlineChecked = false;
    protected PagedEdgeTreeMap m_mainCube = null;
    protected List<EdgeTree> m_pages = new ArrayList<EdgeTree>();
    protected boolean[] m_hasEdge = null;

    public Cube() {
        this(new PageInfo());
    }

    public Cube(PageInfo pageInfo) {
        this.m_mainCube = new PagedEdgeTreeMap(pageInfo.isConstantCube());
    }

    public Object clone() throws CloneNotSupportedException {
        Cube newCube = null;
        try {
            newCube = (Cube)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        newCube.m_isOutline = (Hashtable)this.m_isOutline.clone();
        newCube.m_outlineChecked = this.m_outlineChecked;
        newCube.m_mainCube = (PagedEdgeTreeMap)this.m_mainCube.clone();
        newCube.m_pages = (List)((ArrayList)this.m_pages).clone();
        if (this.m_hasEdge != null) {
            newCube.m_hasEdge = (boolean[])this.m_hasEdge.clone();
        }
        return newCube;
    }

    public void clear() {
        this.m_mainCube.clear();
        this.m_pages.clear();
    }

    public Object clone(boolean caching) throws CloneNotSupportedException {
        Cube cube = null;
        try {
            cube = (Cube)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        cube.m_mainCube = (PagedEdgeTreeMap)this.m_mainCube.clone(caching);
        for (EdgeTree tree : this.m_pages) {
            try {
                cube.m_pages.add((EdgeTree)tree.clone(caching));
            }
            catch (CloneNotSupportedException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        cube.m_isOutline = (Hashtable)this.m_isOutline.clone();
        if (this.m_hasEdge != null) {
            cube.m_hasEdge = (boolean[])this.m_hasEdge.clone();
        }
        return cube;
    }

    public void release() {
        this.m_isOutline.clear();
        this.m_isOutline = null;
        for (EdgeTree tree : this.m_pages) {
            if (tree == null) continue;
            tree.release();
        }
        List cubeVal = null;
        Page key = null;
        for (Map.Entry entry : this.m_mainCube.entrySet()) {
            key = (Page)entry.getKey();
            cubeVal = (List)entry.getValue();
            for (EdgeTree tree : cubeVal) {
                if (tree == null) continue;
                tree.release();
            }
        }
    }

    protected boolean isOutline(int edge) {
        if (this.m_outlineChecked) {
            return this.m_isOutline.get(edge);
        }
        this.m_isOutline = new Hashtable();
        boolean anyOutline = false;
        for (EdgeTree tree : this.m_pages) {
            if (tree == null) continue;
            boolean outline = tree.isOutline();
            if (outline) {
                anyOutline = true;
            }
            this.m_isOutline.put(tree.getEdge(), outline);
        }
        List cubeVal = null;
        Page key = null;
        Object newCubeVal = null;
        for (Map.Entry entry : this.m_mainCube.entrySet()) {
            key = (Page)entry.getKey();
            cubeVal = (List)entry.getValue();
            for (EdgeTree tree : cubeVal) {
                if (tree == null) continue;
                boolean outline = tree.isOutline();
                if (outline) {
                    anyOutline = true;
                }
                this.m_isOutline.put(tree.getEdge(), outline);
            }
        }
        this.m_outlineChecked = true;
        this.m_isOutline.put(-1, anyOutline);
        return this.m_isOutline.get(edge);
    }

    public EdgeTree getEdgeTree(int edge, Page page) {
        if (edge < this.getEdgeCount()) {
            if (edge >= 2) {
                return this.m_pages.get(edge - 2);
            }
            List<EdgeTree> edgeList = this.m_mainCube.get(page);
            if (edgeList != null && edge < edgeList.size()) {
                return edgeList.get(edge);
            }
        }
        return null;
    }

    protected void walkData(ResultTable rt, Cache cache, Page page, boolean[] alwaysAdd, boolean keepNulls, LayerSortInfo[] sortInfo) throws TransformException {
        this.walkData(new ResultTableInsert(rt, null), cache, page, alwaysAdd, keepNulls, sortInfo);
    }

    private boolean _notPaged(String[][] layout, Page sortPage) {
        boolean pages = false;
        if (layout.length > 2 && !this.m_mainCube.isNotPaged()) {
            for (int e = 2; e < layout.length; ++e) {
                if (layout[e] == null || layout[e].length <= 0) continue;
                pages = true;
                break;
            }
        }
        return sortPage != null && (this.m_mainCube.isNotPaged() || !pages);
    }

    protected void walkData(ResultTableInsert rti, Cache cache, Page sortPage, boolean[] alwaysAdd, boolean keepNulls, LayerSortInfo[] sortInfo) throws TransformException {
        EdgeTree.RowInfo[] column = null;
        EdgeTree.RowInfo[] row = null;
        ResultTable rt = rti.getResultTable();
        String[] measList = TransformUtils.getMeasList(rt.getProjection());
        DataTable dt = rt.getDataTable();
        String[][] layout = rt.getProjection().getLayout();
        long rowCount = dt.getRowCount();
        Row rowData = null;
        MemberWrapper[][][] pageVals = null;
        InsertInfo[] edgeInserts = rti.getEdgeInserts(true);
        InsertInfo colInsert = null;
        InsertInfo rowInsert = null;
        QDRLite[] qdrs = null;
        PageRowInfo pri = null;
        EdgeTree colEdgeTree = null;
        EdgeTree rowEdgeTree = null;
        boolean notPaged = this._notPaged(layout, sortPage);
        if (notPaged) {
            colEdgeTree = this._getOrCreateEdgeTree(0, sortPage);
            rowEdgeTree = this._getOrCreateEdgeTree(1, sortPage);
            colInsert = colEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 0) : null;
            rowInsert = rowEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 1) : null;
        }
        if (!notPaged & rowCount == 0L) {
            pri = this.addPageRows(rowData, layout, edgeInserts, alwaysAdd, keepNulls, sortInfo);
            pageVals = pri.m_wrapper;
            for (Page page : pri.m_pages) {
                if (notPaged) continue;
                colEdgeTree = this._getOrCreateEdgeTree(0, page);
                rowEdgeTree = this._getOrCreateEdgeTree(1, page);
            }
        }
        int r = 0;
        while ((long)r < rowCount) {
            rowData = dt.getRow(r);
            pri = this.addPageRows(rowData, layout, edgeInserts, alwaysAdd, keepNulls, sortInfo);
            pageVals = pri.m_wrapper;
            for (Page page : pri.m_pages) {
                if (!notPaged) {
                    colEdgeTree = this._getOrCreateEdgeTree(0, page);
                    rowEdgeTree = this._getOrCreateEdgeTree(1, page);
                    if (colInsert == null) {
                        InsertInfo insertInfo = colInsert = colEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 0) : null;
                    }
                    if (rowInsert == null) {
                        InsertInfo insertInfo = rowInsert = rowEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 1) : null;
                    }
                }
                if (colEdgeTree != null && layout.length > 0) {
                    column = colEdgeTree.addRow(rowData, layout[0], colInsert, TransformUtils.alwaysAdd(alwaysAdd, 0), keepNulls, sortInfo);
                }
                if (rowEdgeTree != null && layout.length > 1) {
                    row = rowEdgeTree.addRow(rowData, layout[1], rowInsert, TransformUtils.alwaysAdd(alwaysAdd, 1), keepNulls, sortInfo);
                }
                if (cache.m_caching && (qdrs = this._getQDRs(rt.getProjection().getLayout(), pageVals, column, row)) != null && this.getRealQDRs() != null) {
                    for (int i = 0; i < qdrs.length; ++i) {
                        this.getRealQDRs().add(qdrs[i]);
                    }
                }
                if (rowData instanceof TotalRow) {
                    ((TotalRow)rowData).setLocation(column, row, pri);
                }
                if (!rt.isLocalStorage() && !rowData.isCalculatedValue()) continue;
                MemberCacheKey cacheKey = null;
                DataCellInterface value = null;
                if (measList == null) continue;
                for (int m = 0; m < measList.length; ++m) {
                    cacheKey = row != null && row[0].hasMeasure() ? cache.m_memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, 0), row[m].getValues(), column != null ? column[0].getValues() : null) : (column != null && column[0].hasMeasure() ? cache.m_memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, 0), row != null ? row[0].getValues() : null, column != null ? column[m].getValues() : null) : cache.m_memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, m), row != null ? row[0].getValues() : null, column != null ? column[0].getValues() : null));
                    value = rowData.getCell(measList[m]).getDataCellInterface();
                    this.storeData(value, cacheKey, cache.m_dataCache);
                    cache.m_memberKeyPool.returnCacheKeyToPool(cacheKey);
                }
            }
            ++r;
        }
    }

    protected PageRowInfo addPageRows(Row rowData, String[][] layout, InsertInfo[] edgeInserts, boolean[] alwaysAdd, boolean keepNulls, LayerSortInfo[] sortInfo) throws TransformException {
        int edgeCount = this.getEdgeCount();
        int edgeCountBeyondRow = edgeCount < 2 ? 0 : edgeCount - 2;
        MemberWrapper[][][] retVal = new MemberWrapper[edgeCountBeyondRow][][];
        if (edgeCountBeyondRow == 0) {
            return new PageRowInfo();
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        pages.add(new Page());
        String[] measList = null;
        for (int i = 0; i < retVal.length; ++i) {
            EdgeTree.RowInfo[] ri;
            if (layout.length <= 1 + i + 1 || (ri = this.getEdgeTree(i + 1 + 1, null).addRow(rowData, layout[1 + i + 1], InsertInfo.getEdgeInsert(edgeInserts, 2 + i), TransformUtils.alwaysAdd(alwaysAdd, 1 + i + 1), keepNulls, sortInfo)) == null) continue;
            retVal[i] = new MemberWrapper[ri.length][];
            if (ri.length > 1) {
                measList = new String[ri.length];
                try {
                    pages.add((Page)((Page)pages.get(0)).clone());
                }
                catch (CloneNotSupportedException e) {
                    throw new TransformException(e.getMessage(), e);
                }
            }
            for (int m = 0; m < ri.length; ++m) {
                ((Page)pages.get(m)).setPage(i + 1 + 1, ri[m].getStringValues());
                retVal[i][m] = ri[m].getValues();
                if (ri.length <= 1) continue;
                measList[m] = ri[m].getMeasure();
            }
        }
        return new PageRowInfo(retVal, measList, pages);
    }

    private EdgeTree _getOrCreateEdgeTree(int edge, Page page) throws TransformException {
        if (edge < this.getEdgeCount()) {
            if (edge >= 2) {
                return this.m_pages.get(edge - 2);
            }
            List<EdgeTree> edgeList = this.m_mainCube.get(page);
            if (edgeList != null && edge < edgeList.size()) {
                return edgeList.get(edge);
            }
        }
        if (this.m_hasEdge != null && edge < this.m_hasEdge.length && this.m_hasEdge[edge]) {
            return this.setEdgeTree(edge, page);
        }
        return null;
    }

    protected EdgeTree setEdgeTree(int edge, Page page) throws TransformException {
        return null;
    }

    private QDRLite[] _getQDRs(String[][] layout, MemberWrapper[][][] pageVals, EdgeTree.RowInfo[] column, EdgeTree.RowInfo[] row) throws TransformException {
        if (row != null && row.length > 0 && row[0].hasMeasure()) {
            QDRLite[] qdrs = new QDRLite[row.length];
            for (int m = 0; m < row.length; ++m) {
                qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, 0), row[m].getValues(), column != null ? column[0].getValues() : null);
            }
            return qdrs;
        }
        if (column != null && column[0].hasMeasure()) {
            QDRLite[] qdrs = new QDRLite[column.length];
            for (int m = 0; m < column.length; ++m) {
                qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, 0), row != null ? row[0].getValues() : null, column != null ? column[m].getValues() : null);
            }
            return qdrs;
        }
        QDRLite[] qdrs = new QDRLite[pageVals != null && pageVals.length > 0 && pageVals[0] != null ? pageVals[0].length : 0];
        for (int m = 0; m < qdrs.length; ++m) {
            qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, m), row != null ? row[0].getValues() : null, column != null ? column[0].getValues() : null);
        }
        return qdrs;
    }

    private MemberWrapper[][] getNthMeasureTuple(MemberWrapper[][][] pageVals, int m) {
        if (pageVals == null) {
            return null;
        }
        MemberWrapper[][] retVal = new MemberWrapper[pageVals.length][];
        for (int e = 0; e < retVal.length; ++e) {
            retVal[e] = pageVals[e] != null && pageVals[e].length > m ? pageVals[e][m] : new MemberWrapper[0];
        }
        return retVal;
    }

    private QDRLite _getQDR(String[][] layout, MemberWrapper[][] pages, MemberWrapper[] row, MemberWrapper[] col) throws TransformException {
        int l;
        QDRLite qdr = new QDRLite();
        if (pages != null) {
            for (int e = 2; e < pages.length + 2; ++e) {
                if (pages[e - 2] == null) continue;
                for (int l2 = 0; l2 < pages[e - 2].length; ++l2) {
                    qdr.addDimMemberPair(layout[e][l2], pages[e - 2][l2].getValue());
                }
            }
        }
        if (row != null) {
            for (l = 0; l < row.length; ++l) {
                qdr.addDimMemberPair(layout[1][l], row[l].getValue());
            }
        }
        if (col != null) {
            for (l = 0; l < col.length; ++l) {
                qdr.addDimMemberPair(layout[0][l], col[l].getValue());
            }
        }
        return qdr;
    }

    public int getEdgeCount() {
        return this.m_pages.size() + this.m_mainCube.getEdgeCount();
    }

    protected void setEdgeTree(int edge, EdgeTree et, Page page) throws TransformException {
        if (edge >= 2) {
            this._setEdge(edge - 2, this.m_pages, et);
        } else {
            Page myPage = null;
            try {
                myPage = (Page)page.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new TransformException(e.getMessage(), e);
            }
            List<EdgeTree> currMain = this.m_mainCube.get(myPage);
            if (currMain == null) {
                currMain = new ArrayList<EdgeTree>();
            }
            this._setEdge(edge, currMain, et);
            this.m_mainCube.put(myPage, currMain);
        }
    }

    private void _setEdge(int edge, List<EdgeTree> edgeList, EdgeTree et) {
        int currEdgeCount = edgeList.size();
        if (edge < currEdgeCount) {
            edgeList.set(edge, et);
        } else {
            for (int i = currEdgeCount; i < edge; ++i) {
                edgeList.add(null);
            }
            edgeList.add(et);
        }
    }

    public EdgeTree getColumnEdgeTree(Page page) {
        return this.getEdgeTree(0, page);
    }

    public EdgeTree getRowEdgeTree(Page page) {
        return this.getEdgeTree(1, page);
    }

    public void lockTrees() {
        for (EdgeTree et : this.m_pages) {
            if (et == null) continue;
            et.lock();
        }
        List cubeVal = null;
        Page key = null;
        Object newCubeVal = null;
        for (Map.Entry entry : this.m_mainCube.entrySet()) {
            key = (Page)entry.getKey();
            cubeVal = (List)entry.getValue();
            for (EdgeTree et : cubeVal) {
                if (et == null) continue;
                et.lock();
            }
        }
    }

    public void invalidate(QDRLite[] qdr, Page page) throws TransformException {
        EdgeTree et = null;
        int edgeCount = this.getEdgeCount();
        for (int i = 0; i < qdr.length; ++i) {
            for (int e = 0; e < edgeCount; ++e) {
                et = this.getEdgeTree(e, page);
                if (et == null) continue;
                et.invalidate(qdr[i]);
            }
        }
    }

    public boolean insert(SliceInsertInfo sliceToInsert, String dataLayer, MemberInterface[] dataMemberInterfaces, Page page) throws TransformException {
        EdgeTree et = null;
        int edgeCount = this.getEdgeCount();
        boolean inserted = false;
        for (int e = 0; e < edgeCount; ++e) {
            et = this.getEdgeTree(e, page);
            if (et == null || !et.insert(sliceToInsert, dataLayer, dataMemberInterfaces)) continue;
            inserted = true;
        }
        return inserted;
    }

    public void delete(QDRLite[] qdr, Page page) throws TransformException {
        EdgeTree et = null;
        int edgeCount = this.getEdgeCount();
        for (int i = 0; i < qdr.length; ++i) {
            for (int e = 0; e < edgeCount; ++e) {
                et = this.getEdgeTree(e, page);
                if (et == null) continue;
                et.delete(qdr[i]);
            }
        }
    }

    public ArrayList<QDRLite> getRealQDRs() {
        return null;
    }

    protected void storeData(DataCellInterface data, MemberCacheKey cacheKey, Hashtable<MemberCacheKey, Object> memberCache) {
        if (data == null) {
            memberCache.put((MemberCacheKey)cacheKey.clone(), m_nullMarker);
        } else {
            memberCache.put((MemberCacheKey)cacheKey.clone(), data);
        }
    }

    private EdgeTreeNode _convertMemberToNode(MemberWrapper[] members) {
        EdgeTreeNode[] nodes = this._convertMemberToNode(new MemberWrapper[][]{members});
        if (nodes == null) {
            return null;
        }
        if (nodes.length == 0) {
            return null;
        }
        return nodes[0];
    }

    private EdgeTreeNode[] _convertMemberToNode(MemberWrapper[][] members) {
        if (members == null) {
            return null;
        }
        EdgeTreeNode[] retVal = new EdgeTreeNode[members.length];
        MemberWrapper[] edgeList = null;
        MemberWrapper member = null;
        for (int i = 0; i < retVal.length; ++i) {
            edgeList = members[i];
            if (edgeList == null || members[i].length <= 0) continue;
            member = members[i][members[i].length - 1];
            retVal[i] = member != null ? member.getEdgeTreeNode() : null;
        }
        return retVal;
    }

    protected void unlockPageTree(InsertInfo[] edgeInserts) {
    }

    protected String getColumn(InsertInfo[] edgeInserts, int edge) {
        InsertInfo info = InsertInfo.getEdgeInsert(edgeInserts, edge);
        if (info != null) {
            return info.getColumn();
        }
        return null;
    }

    public class PageRowInfo {
        protected MemberWrapper[][][] m_wrapper = null;
        protected String[] m_measList = null;
        protected List<Page> m_pages = null;

        public PageRowInfo() {
            this(null, null, null);
        }

        public MemberWrapper[][][] getMembers() {
            return this.m_wrapper;
        }

        public String[] getMeasures() {
            return this.m_measList;
        }

        public PageRowInfo(MemberWrapper[][][] wrapper, String[] measList, List<Page> pages) {
            this.m_wrapper = wrapper;
            this.m_measList = measList;
            if (pages != null) {
                this.m_pages = pages;
            } else {
                this.m_pages = new ArrayList<Page>();
                this.m_pages.add(new Page(null));
            }
        }
    }
}

