/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.parameters;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.dss.util.Utility;
import oracle.dss.util.parameters.Parameter;
import oracle.dss.util.parameters.ParameterManager;
import oracle.dss.util.parameters.ParameterUser;
import oracle.dss.util.parameters.ParameterValueManager;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.persistence.XMLizable;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ParameterUserHelper
implements XMLizable {
    protected static final String XML_NAME = "ParameterMap";
    protected HashMap<String, String> m_paramNames = new HashMap();
    protected HashMap<String, Parameter> m_parameters = new HashMap();

    public void parameterize(ParameterUser pu, ParameterManager pm) {
        Set<String> keySet = this.m_paramNames.keySet();
        Iterator<String> params = keySet.iterator();
        String paramName = null;
        String paramKey = null;
        while (params.hasNext()) {
            Parameter param;
            paramKey = params.next();
            paramName = this.getAssociatedParameterName(paramKey);
            if (paramName == null || (param = paramName != null ? pm.getParameter(paramName) : null) == null) continue;
            ParameterValueManager pvm = pm.getParameterValueManager();
            Object value = null;
            while (pvm != null) {
                value = pvm.getValue(param);
                if (value != null) {
                    pvm = null;
                    continue;
                }
                pvm = pvm.getParentParameterValueManager();
            }
            if (value == null) {
                value = param.getDefaultValue();
            }
            if (value instanceof StringBuffer) {
                value = value.toString();
            }
            if (value == null) continue;
            this._callMethod(pu, paramKey, value);
        }
    }

    private void _callMethod(ParameterUser pu, String paramKey, Object value) {
        try {
            Method m = pu.getClass().getMethod(paramKey, value.getClass());
            if (m != null) {
                m.invoke((Object)pu, value);
            }
        }
        catch (Exception e) {
            Method m2 = null;
            try {
                if (value instanceof Integer) {
                    m2 = pu.getClass().getMethod(paramKey, Integer.TYPE);
                } else if (value instanceof Long) {
                    m2 = pu.getClass().getMethod(paramKey, Long.TYPE);
                } else if (value instanceof Double) {
                    m2 = pu.getClass().getMethod(paramKey, Double.TYPE);
                } else if (value instanceof Float) {
                    m2 = pu.getClass().getMethod(paramKey, Float.TYPE);
                }
                if (m2 != null) {
                    m2.invoke((Object)pu, value);
                }
            }
            catch (Exception e2) {
                try {
                    Method m = pu.getClass().getMethod(paramKey, Object.class);
                    if (m != null) {
                        m.invoke((Object)pu, value);
                    }
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ParameterUserHelper)) {
            return false;
        }
        ParameterUserHelper puh = (ParameterUserHelper)obj;
        return Utility.compareHashMap(this.m_paramNames, puh.m_paramNames);
    }

    public Object clone() throws CloneNotSupportedException {
        ParameterUserHelper newHelper = new ParameterUserHelper();
        newHelper.m_paramNames = (HashMap)this.m_paramNames.clone();
        newHelper.m_parameters = (HashMap)this.m_parameters.clone();
        return newHelper;
    }

    public String getAssociatedParameterName(Object field) {
        return this.m_paramNames.get(field);
    }

    public void associateParameter(Object field, Parameter parameter) {
        if (parameter == null) {
            this.m_paramNames.remove(field);
            this.m_parameters.remove(field);
        } else {
            this.m_paramNames.put((String)field, parameter.getName());
            this.m_parameters.put((String)field, parameter);
        }
    }

    public boolean usesParameter(Parameter parameter) {
        return this.m_paramNames.containsValue(parameter.getName());
    }

    public Parameter[] getParameters() {
        Collection<Parameter> c = this.m_parameters.values();
        if (c == null || c.size() == 0) {
            return null;
        }
        return c.toArray(new Parameter[c.size()]);
    }

    public String[] getParameterFields() {
        Set<String> c = this.m_paramNames.keySet();
        if (c == null || c.size() == 0) {
            return null;
        }
        return c.toArray(new String[c.size()]);
    }

    public String[] getParameterNames() {
        Collection<String> c = this.m_paramNames.values();
        if (c == null || c.size() == 0) {
            return null;
        }
        return c.toArray(new String[c.size()]);
    }

    @Override
    public Object getXML(XMLContext controls) {
        if (this.m_paramNames != null && !this.m_paramNames.isEmpty()) {
            ContainerNode params = new ContainerNode("dvt-cube:" + this.getTagName());
            params.addProperty("name", "parametermap");
            Set<String> keySet = this.m_paramNames.keySet();
            Iterator<String> keys = keySet.iterator();
            String value = null;
            String name = null;
            PropertyNode pn = null;
            while (keys.hasNext()) {
                name = keys.next();
                value = this.m_paramNames.get(name);
                pn = new PropertyNode(name, value);
                params.addContainedObject(pn);
            }
            return params;
        }
        return null;
    }

    @Override
    public void setXML(XMLContext context, Object node) {
        ObjectNode objNode = (ObjectNode)node;
        ContainerNode params = objNode.getContainer("dvt-cube:" + this.getTagName());
        if (params != null) {
            Enumeration objs = params.getContainedObject();
            ObjectNode value = null;
            this.m_paramNames = new HashMap();
            while (objs.hasMoreElements()) {
                value = (ObjectNode)objs.nextElement();
                this.m_paramNames.put(value.getName(), value.getValueAsString());
            }
        }
    }

    @Override
    public String getTagName() {
        return XML_NAME;
    }
}

