/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.beans.PropertyVetoException;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dss.util.gui.layout.AbstractCrosstabHeader;
import oracle.dss.util.gui.layout.Crosstab;

public class ColumnHeader
extends AbstractCrosstabHeader {
    private static final long serialVersionUID = 1L;

    public ColumnHeader(Crosstab crosstab, int edge) {
        super(crosstab, 0, edge);
        this.getRowHeader().setCanResizeItems(false);
        this.setRowHeaderWidth(10);
        this.getGrid().setGridSelectionManager(GeneralGridSelectionManager.createSingleRowSelectionManager());
    }

    @Override
    public int getSelectedIndex() {
        OneDSelection sel = this.getGrid().getSelection().getRowSelection();
        if (sel.isEmpty()) {
            return -1;
        }
        return sel.getSingleItem();
    }

    @Override
    public void setItems(String[] items) {
        super.setItems(items);
        int max = 0;
        int count = items == null ? 0 : items.length;
        for (int i = 0; i < count; ++i) {
            int size = this.getElementWidth(this.getItem(i));
            if (size <= max) continue;
            max = size;
        }
        this.setDefaultColumnWidth(max);
    }

    public void setColumnWidth(int width) {
        this.setDefaultColumnWidth(width - this.getRowHeaderWidth() - 2);
    }

    @Override
    protected AbstractCrosstabHeader.CrosstabModel createModel() {
        return new ColumnModel();
    }

    @Override
    protected void selectionChanged() {
        this.getCrosstab().columnSelectionChanged();
    }

    @Override
    protected TwoDSelection getNewFocusSelection() {
        return new TwoDSelection(0, true);
    }

    @Override
    protected void focusLost() {
        try {
            this.getRowHeader().deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private class ColumnModel
    extends AbstractCrosstabHeader.CrosstabModel {
        private int _columnCount;

        private ColumnModel() {
        }

        @Override
        public int getColumnCount() {
            return this._columnCount;
        }

        @Override
        protected AbstractPivotHeaderCell createCell(int index, int count) {
            return new AbstractCrosstabHeader.ExtendedCell(0, 1, index, 1, this.getElement(index));
        }

        @Override
        protected void fireEvents(int oldCount, int newCount) {
            int diff = newCount - oldCount;
            if (diff > 0) {
                this.fireModelEvent(2004, 0, diff);
            } else if (diff < 0) {
                this.fireModelEvent(2005, 0, -diff);
            }
            if (newCount != 0 && this._columnCount == 0) {
                this._columnCount = 1;
                this.fireModelEvent(2001, 0, 1);
            } else if (newCount == 0 && this._columnCount != 0) {
                this._columnCount = 0;
                this.fireModelEvent(2002, 0, 1);
            }
        }
    }
}

