/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.tree;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dss.util.gui.component.ComponentNode;
import oracle.dss.util.gui.component.tree.ArrowButton;

public class VirtualTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private JTree m_jTree = null;

    public VirtualTreeCellRenderer(JTree jTree) {
        this.m_jTree = jTree;
    }

    public boolean isArrowButton(Object objValue) {
        return this.getArrowButton(objValue) != null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object objValue, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int nRow, boolean bHasFocus) {
        Component component = this.getArrowButton(objValue);
        if (component != null && jTree != null) {
            component.setBackground(jTree.getBackground());
            component.setForeground(jTree.getForeground());
            return component;
        }
        component = super.getTreeCellRendererComponent(jTree, objValue, bIsSelected, bIsExpanded, bIsLeaf, nRow, this.hasFocus);
        if (component != null) {
            component.setEnabled(this.isEnabled(objValue));
        }
        return component;
    }

    public boolean isEnabled(Object objValue) {
        Object object;
        boolean bEnabled = true;
        if (objValue instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)objValue).getUserObject()) instanceof ComponentNode) {
            bEnabled = ((ComponentNode)object).isEnabled();
        }
        return bEnabled;
    }

    private Component getArrowButton(Object objValue) {
        Object object;
        if (objValue instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)objValue).getUserObject()) instanceof ArrowButton) {
            return (Component)object;
        }
        return null;
    }
}

