/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.tree;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dss.util.gui.component.tree.DeferredTreeNode;

public class DeferredTreeNodeImpl
extends DefaultMutableTreeNode
implements DeferredTreeNode {
    private static final long serialVersionUID = 1L;
    private JTree m_jTree = null;
    private boolean m_bLoaded = false;
    private boolean m_bLeaf = false;

    public DeferredTreeNodeImpl(JTree jTree, Object objUser) {
        super(objUser);
        this.setTree(jTree);
    }

    @Override
    public void setLeaf(boolean bLeaf) {
        this.m_bLeaf = bLeaf;
    }

    @Override
    public boolean isLeaf() {
        return this.m_bLeaf;
    }

    @Override
    public int getChildCount() {
        if (!this.isLoaded()) {
            this.load();
        }
        return super.getChildCount();
    }

    public JTree getTree() {
        return this.m_jTree;
    }

    @Override
    public int getIndex() {
        return -1;
    }

    @Override
    public int getPageSize() {
        return -1;
    }

    @Override
    public boolean isLoaded() {
        return this.m_bLoaded;
    }

    @Override
    public void refresh() {
        this.removeAllChildren();
        this.load();
    }

    public static void setParentWindowCursor(Component component, int predefCursor) {
        if (component != null) {
            component.setCursor(Cursor.getPredefinedCursor(predefCursor));
            Window parentWindow = SwingUtilities.windowForComponent(component);
            if (parentWindow != null) {
                parentWindow.setCursor(Cursor.getPredefinedCursor(predefCursor));
            }
        }
    }

    protected Vector getChildren() {
        return null;
    }

    void load() {
        DeferredTreeNodeImpl.setParentWindowCursor(this.getTree(), 3);
        this.setLoaded(true);
        this.setChildren(this.getChildren());
        DeferredTreeNodeImpl.setParentWindowCursor(this.getTree(), 0);
    }

    void setChildren(Vector vChildren) {
        this.children = vChildren;
    }

    private void setTree(JTree jTree) {
        this.m_jTree = jTree;
    }

    private void setLoaded(boolean bLoaded) {
        this.m_bLoaded = bLoaded;
    }
}

