/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.radioList;

import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.dss.util.gui.component.radioList.RadioListActionListener;

public class RadioList
extends JPanel
implements ListDataListener {
    private static final long serialVersionUID = 1L;
    ComboBoxModel m_cbModel;
    ButtonGroup m_group;
    RadioListActionListener m_actionListener;

    public RadioList(ComboBoxModel model) {
        this.m_cbModel = model;
        this.init();
        this.m_cbModel.addListDataListener(this);
    }

    protected void init() {
        this.setLayout(new GridLayout(0, 1));
        this.m_group = new ButtonGroup();
        Object selectedItem = this.m_cbModel.getSelectedItem();
        for (int i = 0; i < this.m_cbModel.getSize(); ++i) {
            Object curModelObj = this.m_cbModel.getElementAt(i);
            JRadioButton button = new JRadioButton();
            button.setText(curModelObj.toString());
            button.setActionCommand(new Integer(i).toString());
            this.m_group.add(button);
            if (curModelObj.equals(selectedItem)) {
                button.setSelected(true);
            }
            button.addActionListener(this.getActionListener());
            this.add(button);
        }
    }

    protected RadioListActionListener getActionListener() {
        if (this.m_actionListener == null) {
            this.m_actionListener = new RadioListActionListener(this.m_cbModel);
        }
        return this.m_actionListener;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        Object selectedItem = this.m_cbModel.getSelectedItem();
        Enumeration<AbstractButton> buttons = this.m_group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton curButton = buttons.nextElement();
            if (!curButton.getText().equals(selectedItem.toString())) continue;
            curButton.setSelected(true);
            break;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"Option 1", "Option 2", "Option 3"};
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(options);
        RadioList rl = new RadioList(model);
        JFrame frame = new JFrame();
        frame.setTitle("Radio List Test");
        frame.addWindowListener(new RadioListWindowAdapter(model));
        frame.add(rl);
        frame.pack();
        frame.setVisible(true);
        model.setSelectedItem(model.getElementAt(2));
    }

    private static class RadioListWindowAdapter
    extends WindowAdapter {
        private ComboBoxModel _model;

        public RadioListWindowAdapter(ComboBoxModel model) {
            this._model = model;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.out.println("Final Selection: " + this._model.getSelectedItem());
            System.exit(0);
        }
    }
}

