/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dss.util.help.HelpContext;

public class BIFontPane
extends FontPane
implements ItemListener,
HelpContext {
    private static final long serialVersionUID = 1L;
    protected JToggleButton auto = null;
    protected JToggleButton rotate_0 = null;
    protected JToggleButton rotate_90 = null;
    protected JToggleButton rotate_270 = null;
    protected JPanel textRotationBar = null;
    protected JLabel rotationlabel;
    protected TitledPane pane = null;
    protected int oldValue;
    protected String m_strHelpContextID;
    protected int m_rotateMask = 0;
    private ResourceBundle rBundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    private boolean m_bSuperCalled = true;
    public static final String TEXT_ROTATION = "textRotation";
    public static final int BUTTON_ROTATE_AUTO = 1;
    public static final int BUTTON_ROTATE_0 = 2;
    public static final int BUTTON_ROTATE_90 = 4;
    public static final int BUTTON_ROTATE_270 = 8;
    public static final int ROTATE_AUTO = 0;
    public static final int ROTATE_0 = 1;
    public static final int ROTATE_90 = 2;
    public static final int ROTATE_270 = 3;

    public BIFontPane() {
        this.getFontBackgroundColorChoice().setColorPalette(ColorGrid.getColorPalette((int)2));
        this.getFontColorChoice().setColorPalette(ColorGrid.getColorPalette((int)2));
        Component c = this._createTextRotationComponent();
        this.setExtraComponent(c);
        if (c.getParent() instanceof Container) {
            Container cm = c.getParent();
            cm.remove(c);
            cm.add("Center", c);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            int newValue = e.getSource() == this.rotate_0 ? 1 : (e.getSource() == this.rotate_90 ? 2 : (e.getSource() == this.rotate_270 ? 3 : 0));
            this.firePropertyChange(TEXT_ROTATION, this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setRotationButtonMask(int buttonMask) {
        this.m_rotateMask = buttonMask;
        this.textRotationBar.removeAll();
        if ((buttonMask & 1) != 0) {
            this.textRotationBar.add(this.auto);
            this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        }
        if ((buttonMask & 2) != 0) {
            this.textRotationBar.add(this.rotate_0);
            this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        }
        if ((buttonMask & 4) != 0) {
            this.textRotationBar.add(this.rotate_90);
            this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        }
        if ((buttonMask & 8) != 0) {
            this.textRotationBar.add(this.rotate_270);
        }
        this.pane.setVisible(buttonMask != 0);
        this.revalidate();
    }

    public int getTextRotation() {
        if (this.rotate_0.isSelected()) {
            return 1;
        }
        if (this.rotate_90.isSelected()) {
            return 2;
        }
        if (this.rotate_270.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void setTextRotation(int rotation) {
        if (rotation == 1) {
            this.rotate_0.setSelected(true);
            this.oldValue = 1;
        }
        if (rotation == 2) {
            this.rotate_90.setSelected(true);
            this.oldValue = 2;
        }
        if (rotation == 3) {
            this.rotate_270.setSelected(true);
            this.oldValue = 3;
        }
        if (rotation == 0) {
            this.auto.setSelected(true);
            this.oldValue = 0;
        }
    }

    @Override
    public String getHelpContextID() {
        String strID = "oracle.dss.util.gui.BiFontPane";
        int styleMask = this.getStyleButtonMask();
        int alignmentMask = this.getAlignmentButtonMask();
        int colorMask = this.getColorComponentMask();
        if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) == 0 && (styleMask & 8) == 0 && (alignmentMask & 2) != 0 && (alignmentMask & 4) != 0 && (alignmentMask & 8) != 0 && (alignmentMask & 0x10) == 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) == 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            strID = "oracle.dss.util.gui.BiFontPane_A";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) == 0 && (alignmentMask & 2) != 0 && (alignmentMask & 4) != 0 && (alignmentMask & 8) != 0 && (alignmentMask & 0x10) != 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) != 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            strID = "oracle.dss.util.gui.BiFontPane_B";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) != 0 && (alignmentMask & 2) != 0 && (alignmentMask & 4) != 0 && (alignmentMask & 8) != 0 && (alignmentMask & 0x10) != 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            strID = "oracle.dss.util.gui.BiFontPane_C";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) == 0 && (alignmentMask & 2) != 0 && (alignmentMask & 4) != 0 && (alignmentMask & 8) != 0 && (alignmentMask & 0x10) == 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            strID = "oracle.dss.util.gui.BiFontPane_D";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) == 0 && (alignmentMask & 2) != 0 && (alignmentMask & 4) != 0 && (alignmentMask & 8) != 0 && (alignmentMask & 0x10) == 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) != 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            strID = "oracle.dss.util.gui.BiFontPane_E";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) == 0 && (alignmentMask & 2) == 0 && (alignmentMask & 4) == 0 && (alignmentMask & 8) == 0 && (alignmentMask & 0x10) == 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            strID = "oracle.dss.util.gui.BiFontPane_F";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) == 0 && (alignmentMask & 2) == 0 && (alignmentMask & 4) == 0 && (alignmentMask & 8) == 0 && (alignmentMask & 0x10) == 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) != 0 && (this.m_rotateMask & 2) != 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            strID = "oracle.dss.util.gui.BiFontPane_G";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) == 0 && (alignmentMask & 2) != 0 && (alignmentMask & 4) != 0 && (alignmentMask & 8) != 0 && (alignmentMask & 0x10) == 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            strID = "oracle.dss.util.gui.BiFontPane_H";
        } else if ((styleMask & 1) != 0 && (styleMask & 2) != 0 && (styleMask & 4) != 0 && (styleMask & 8) == 0 && (alignmentMask & 2) == 0 && (alignmentMask & 4) == 0 && (alignmentMask & 8) == 0 && (alignmentMask & 0x10) == 0 && (alignmentMask & 0x40) == 0 && (alignmentMask & 0x80) == 0 && (alignmentMask & 0x100) == 0 && (colorMask & 1) != 0 && (colorMask & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) != 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            strID = "oracle.dss.util.gui.BiFontPane_I";
        }
        return strID;
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.auto.setText(this.rBundle.getString("Automatic"));
        this.rotationlabel.setText(this.rBundle.getString("Orientation"));
        this.rotate_0.getAccessibleContext().setAccessibleName(this.rBundle.getString("0 degree"));
        this.rotate_90.getAccessibleContext().setAccessibleName(this.rBundle.getString("90 degree"));
        this.rotate_270.getAccessibleContext().setAccessibleName(this.rBundle.getString("270 degree"));
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    }

    private ImageIcon _getImageIcon(String imageName) {
        return new ImageIcon(ImageUtils.getImageResource(BIFontPane.class, (String)imageName));
    }

    private Component _createTextRotationComponent() {
        this.textRotationBar = new JPanel();
        this.textRotationBar.setLayout(new BoxLayout(this.textRotationBar, 0));
        this.textRotationBar.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.auto = new JToggleButton(this.rBundle.getString("Automatic"));
        this.auto.setName("FontAutomaticToggleButton");
        this.rotate_0 = new JToggleButton();
        this.rotate_0.setName("FontRotate0ToggleButton");
        this.rotate_0.getAccessibleContext().setAccessibleName(this.rBundle.getString("0 degree"));
        this.rotate_90 = new JToggleButton();
        this.rotate_90.setName("FontRotate90ToggleButton");
        this.rotate_90.getAccessibleContext().setAccessibleName(this.rBundle.getString("90 degree"));
        this.rotate_270 = new JToggleButton();
        this.rotate_270.setName("FontRotate270ToggleButton");
        this.rotate_270.getAccessibleContext().setAccessibleName(this.rBundle.getString("270 degree"));
        this.auto.addItemListener(this);
        this.rotate_0.addItemListener(this);
        this.rotate_90.addItemListener(this);
        this.rotate_270.addItemListener(this);
        this.rotate_0.setIcon(this._getImageIcon("images/0_degrees.gif"));
        this.rotate_90.setIcon(this._getImageIcon("images/90_degrees.gif"));
        this.rotate_270.setIcon(this._getImageIcon("images/270_degrees.gif"));
        this.textRotationBar.add(this.auto);
        this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.textRotationBar.add(this.rotate_0);
        this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.textRotationBar.add(this.rotate_90);
        this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.textRotationBar.add(this.rotate_270);
        ButtonGroup group = new ButtonGroup();
        group.add(this.auto);
        group.add(this.rotate_0);
        group.add(this.rotate_90);
        group.add(this.rotate_270);
        this.rotationlabel = new JLabel(this.rBundle.getString("Orientation"));
        this.pane = new TitledPane((Component)this.rotationlabel, (Component)this.textRotationBar);
        return this.pane;
    }

    public void setCustomColorsEnabled(boolean enabled) {
        if (enabled) {
            this.getFontBackgroundColorChoice().setEditAllowed(true);
            this.getFontBackgroundColorChoice().setCustomColorPalette(this._createCustomPalette(this.getFontBackgroundColorChoice()));
            this.getFontBackgroundColorChoice().getColorPalettePane().setCustomColorsVisible(true);
            this.getFontBackgroundColorChoice().getColorPalettePane().setEditVisible(true);
            this.getFontColorChoice().setEditAllowed(true);
            this.getFontColorChoice().setCustomColorPalette(this._createCustomPalette(this.getFontColorChoice()));
            this.getFontColorChoice().getColorPalettePane().setCustomColorsVisible(true);
            this.getFontColorChoice().getColorPalettePane().setEditVisible(true);
        } else {
            this.getFontBackgroundColorChoice().setEditAllowed(false);
            this.getFontBackgroundColorChoice().setCustomColorPalette(null);
            this.getFontBackgroundColorChoice().getColorPalettePane().setCustomColorsVisible(false);
            this.getFontBackgroundColorChoice().getColorPalettePane().setEditVisible(false);
            this.getFontColorChoice().setEditAllowed(false);
            this.getFontColorChoice().setCustomColorPalette(null);
            this.getFontColorChoice().getColorPalettePane().setCustomColorsVisible(false);
            this.getFontColorChoice().getColorPalettePane().setEditVisible(false);
        }
    }

    private TwoDModel _createCustomPalette(ColorChoice color) {
        TwoDModel regularModel = color.getColorPalette();
        ArrayTwoDModel customModel = new ArrayTwoDModel(regularModel.getColumnCount(), 2);
        return customModel;
    }
}

