/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format;

import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.share.nls.LocaleUtils;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.MergeableXML;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.Utility;
import oracle.dss.util.format.BaseViewFormatCallback;
import oracle.dss.util.format.DvtNumberConverter;
import oracle.dss.util.format.NumberConverter;
import oracle.dss.util.format.dateFormat.OracleDateFormat;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class BaseViewFormat
implements MergeableXML {
    private static final long serialVersionUID = 1L;
    protected static final boolean DEBUG = false;
    public static final int DEFAULT_NUM_TYPE = 0;
    public static final String DEFAULT_CURRENCY_SYMBOL = "$";
    public static final boolean DEFAULT_LEADING_ZERO = true;
    public static final int DEFAULT_POS_NUM_FMT = 0;
    public static final int DEFAULT_NEG_NUM_FMT = 1;
    public static final int DEFAULT_POS_CUR_FMT = 0;
    public static final int DEFAULT_NEG_CUR_FMT = 0;
    public static final int DEFAULT_SCALE_FACTOR = 0;
    public static final int DEFAULT_SCALE_FACTOR_EXPONENT = 0;
    private static final String m_UtilBundle = "oracle.dss.util.resource.UtilBundle";
    private HashMap m_jsfHashMap;
    public static final String DEFAULT_SCALE_DOWN_THOUSANDS_STRING = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("K");
    public static final String DEFAULT_SCALE_DOWN_MILLIONS_STRING = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("M");
    public static final String DEFAULT_SCALE_DOWN_BILLIONS_STRING = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("B");
    public static final String DEFAULT_SCALE_DOWN_TRILLIONS_STRING = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("T");
    public static final String DEFAULT_SCALE_DOWN_QUADRILLIONS_STRING = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("Q");
    public static final String SCALE_DOWN_SYMBOL_BY_LOCALE = "__sym_locale__";
    public static final char THOU_SEP_BY_LOCALE = '0';
    public static final char DEC_SEP_BY_LOCALE = '0';
    public static final String DEFAULT_NULL_STRING = "";
    private static final String DEFAULT_TRUE_STRING = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("true");
    private static final String DEFAULT_FALSE_STRING = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("false");
    public static final int MIN_DATATYPE = 1;
    public static final int DATATYPE_BOOLEAN = 1;
    public static final int DATATYPE_SHORT = 2;
    public static final int DATATYPE_INT = 3;
    public static final int DATATYPE_LONG = 4;
    public static final int DATATYPE_DOUBLE = 5;
    public static final int DATATYPE_FLOAT = 6;
    public static final int DATATYPE_STRING = 7;
    public static final int DATATYPE_DATE = 8;
    public static final int DATATYPE_TIME = 10;
    public static final int DATATYPE_TIMESTAMP = 11;
    public static final int MAX_DATATYPE = 11;
    public static final int MIN_NUMTYPE = 0;
    public static final int NUMTYPE_GENERAL = 0;
    public static final int NUMTYPE_CURRENCY = 1;
    public static final int NUMTYPE_PERCENT = 2;
    public static final int NUMTYPE_PERCENT_SYMBOL = 3;
    public static final int MAX_NUMTYPE = 3;
    public static final int MIN_POS_NUMFMT = 0;
    public static final int POS_NUMFMT_NUM = 0;
    public static final int POS_NUMFMT_POS_NUM = 1;
    public static final int POS_NUMFMT_NUM_POS = 2;
    public static final int ORACLE_POS_NUM_CONST = 3;
    public static final int POS_NUMFMT_BY_LOCALE = 4;
    public static final int MAX_POS_NUMFMT = 4;
    public static final int MIN_NEG_NUMFMT = 0;
    public static final int NEG_NUMFMT_OP_NUM_CP = 0;
    public static final int NEG_NUMFMT_NEG_NUM = 1;
    public static final int NEG_NUMFMT_NUM_NEG = 2;
    public static final int NEG_NUMFMT_NUM = 3;
    public static final int ORACLE_NEG_NUM_CONST = 4;
    public static final int NEG_NUMFMT_BY_LOCALE = 5;
    public static final int MAX_NEG_NUMFMT = 5;
    public static final int MIN_POS_CURFMT = 0;
    public static final int POS_CURFMT_CUR_NUM = 0;
    public static final int POS_CURFMT_NUM_CUR = 1;
    public static final int POS_CURFMT_CUR_SPAC_NUM = 2;
    public static final int POS_CURFMT_NUM_SPAC_CUR = 3;
    public static final int POS_CURFMT_POS_CUR_NUM = 4;
    public static final int POS_CURFMT_CUR_NUM_POS = 5;
    public static final int POS_CURFMT_POS_NUM_CUR = 6;
    public static final int POS_CURFMT_NUM_POS_CUR = 7;
    public static final int POS_CURFMT_NUM_CUR_POS = 8;
    public static final int POS_CURFMT_POS_NUM_SPAC_CUR = 9;
    public static final int POS_CURFMT_POS_CUR_SPAC_NUM = 10;
    public static final int POS_CURFMT_NUM_SPAC_CUR_POS = 11;
    public static final int ORACLE_POS_CUR_CONST = 12;
    public static final int POS_CURFMT_BY_LOCALE = 13;
    public static final int MAX_POS_CURFMT = 13;
    public static final int MIN_NEG_CURFMT = 0;
    public static final int NEG_CURFMT_OP_CUR_NUM_CP = 0;
    public static final int NEG_CURFMT_NEG_CUR_NUM = 1;
    public static final int NEG_CURFMT_CUR_NEG_NUM = 2;
    public static final int NEG_CURFMT_CUR_NUM_NEG = 3;
    public static final int NEG_CURFMT_OP_NUM_CUR_CP = 4;
    public static final int NEG_CURFMT_NEG_NUM_CUR = 5;
    public static final int NEG_CURFMT_NUM_NEG_CUR = 6;
    public static final int NEG_CURFMT_NUM_CUR_NEG = 7;
    public static final int NEG_CURFMT_NEG_NUM_SPAC_CUR = 8;
    public static final int NEG_CURFMT_NEG_CUR_SPAC_NUM = 9;
    public static final int NEG_CURFMT_NUM_SPAC_CUR_NEG = 10;
    public static final int ORACLE_NEG_CUR_CONST = 11;
    public static final int NEG_CURFMT_CUR_SPAC_NUM_NEG = 12;
    public static final int NEG_CURFMT_CUR_SPAC_NEG_NUM = 13;
    public static final int NEG_CURFMT_BY_LOCALE = 14;
    public static final int MAX_NEG_CURFMT = 14;
    public static final int MIN_NEG_PCTFMT = 0;
    public static final int NEG_PCTFMT_NEG_NUM_PCT = 0;
    public static final int NEG_PCTFMT_OP_NUM_PCT_CP = 1;
    public static final int MAX_NEG_PCTFMT = 1;
    public static final int MIN_SCALEFACTOR = 0;
    public static final int SCALEFACTOR_NONE = 0;
    public static final int SCALEFACTOR_THOUSANDS = 1;
    public static final int SCALEFACTOR_MILLIONS = 2;
    public static final int SCALEFACTOR_BILLIONS = 3;
    public static final int SCALEFACTOR_TRILLIONS = 4;
    public static final int SCALEFACTOR_QUADRILLIONS = 5;
    public static final int SCALEFACTOR_BASE_10 = 6;
    public static final int MAX_SCALEFACTOR = 6;
    public static final int UNKNOWN_PATTERN_STR = -1;
    public static final int OEO_PATTERN_STR = 0;
    public static final int ORACLE_PATTERN_STR = 1;
    public static final int BIBEANS_PATTERN_STR = 2;
    public static final String VIEW_FORMAT_NAME = "ViewFormat";
    public static final int CURRENCYSYMBOL = 0;
    public static final int DATEFORMAT = 1;
    public static final int DECIMALDIGIT = 2;
    public static final int DECIMALSEPARATOR = 3;
    public static final int LEADINGZERO = 4;
    public static final int NEGCURFMT = 5;
    public static final int NEGNUMFMT = 6;
    public static final int NUMBERTYPE = 7;
    public static final int POSCURFMT = 8;
    public static final int POSNUMFMT = 9;
    public static final int SCALEDOWNBILLIONS = 10;
    public static final int SCALEDOWNMILLIONS = 11;
    public static final int SCALEDOWNQUADRILLIONS = 12;
    public static final int SCALEDOWNTHOUSANDS = 13;
    public static final int SCALEDOWNTRILLIONS = 14;
    public static final int SCALEFACTOR = 15;
    public static final int THOUSANDSEPARATOR = 16;
    public static final int ORACLEDATEFORMAT = 17;
    public static final int SCALEFACTOR_EXPONENT = 18;
    protected static final int VIEWFORMAT_END = 19;
    protected static final String numtype_general = "NUMTYPE_GENERAL";
    protected static final String numtype_currency = "NUMTYPE_CURRENCY";
    protected static final String numtype_percent = "NUMTYPE_PERCENT";
    protected static final String numtype_percent_s = "N_P_S";
    private static String VIEWFORMAT = "ViewFormat";
    private static final char EMPTY_CHARACTER = '\u0000';
    private static final int NUMBER_TYPE_BIT = 0;
    private static final int THOUSAND_SEPARATOR_BIT = 1;
    private static final int DECIMAL_SEPARATOR_BIT = 2;
    private static final int CURRENCY_SYMBOL_BIT = 3;
    private static final int LEADING_ZERO_BIT = 4;
    private static final int DECIMAL_DIGIT_BIT = 5;
    private static final int POS_NUMFMT_BIT = 6;
    private static final int NEG_NUMFMT_BIT = 7;
    private static final int POS_CURFMT_BIT = 8;
    private static final int NEG_CURFMT_BIT = 9;
    private static final int SCALEFACTOR_BIT = 10;
    private static final int SCALEDOWN_THOUSANDS_BIT = 11;
    private static final int SCALEDOWN_MILLIONS_BIT = 12;
    private static final int SCALEDOWN_BILLIONS_BIT = 13;
    private static final int SCALEDOWN_TRILLIONS_BIT = 14;
    private static final int SCALEDOWN_QUADRILLIONS_BIT = 15;
    protected static final int DATE_FORMAT_BIT = 16;
    private static final int ORACLE_DATE_FORMAT_BIT = 17;
    private static final int SCALEFACTOR_EXPONENT_BIT = 18;
    private static final int NEG_PCTFMT_BIT = 19;
    private static final int NUMBER_OF_FORMAT_BITS = 20;
    protected static final String m_version_2_4_0_6 = "2.4.0.6";
    protected static final String m_version_2_4_0_16 = "2.4.0.16";
    protected BaseViewFormatCallback m_vfCallback = null;
    protected boolean m_bUseCallback = true;
    protected static final String pos_numfmt_num = "POS_NUMFMT_NUM";
    protected static final String pos_numfmt_pos_num = "POS_NUMFMT_POS_NUM";
    protected static final String pos_numfmt_num_pos = "POS_NUMFMT_NUM_POS";
    protected static final String oracle_pos_num_const = "ORACLE_POS_NUM_CONST";
    protected static final String pos_numfmt_loc = "POS_NUMFMT_BY_LOCALE";
    protected static final String neg_numfmt_op_num_cp = "NEG_NUMFMT_OP_NUM_CP";
    protected static final String neg_numfmt_neg_num = "NEG_NUMFMT_NEG_NUM";
    protected static final String neg_numfmt_num_neg = "NEG_NUMFMT_NUM_NEG";
    protected static final String neg_numfmt_num = "NEG_NUMFMT_NUM";
    protected static final String oracle_neg_num_const = "ORACLE_NEG_NUM_CONST";
    protected static final String neg_numfmt_loc = "NEG_NUMFMT_BY_LOCALE";
    protected static final String pos_curfmt_cur_num = "POS_CURFMT_CUR_NUM";
    protected static final String pos_curfmt_num_cur = "POS_CURFMT_NUM_CUR";
    protected static final String pos_curfmt_cur_spac_num = "POS_CURFMT_CUR_SPAC_NUM";
    protected static final String pos_curfmt_num_spac_cur = "POS_CURFMT_NUM_SPAC_CUR";
    protected static final String pos_curfmt_cur_num_pos = "POS_CURFMT_CUR_NUM_POS";
    protected static final String pos_curfmt_pos_num_cur = "POS_CURFMT_POS_NUM_CUR";
    protected static final String pos_curfmt_num_pos_cur = "POS_CURFMT_NUM_POS_CUR";
    protected static final String pos_curfmt_pos_cur_num = "POS_CURFMT_POS_CUR_NUM";
    protected static final String pos_curfmt_num_cur_pos = "POS_CURFMT_NUM_CUR_POS";
    protected static final String pos_curfmt_pos_num_spac_cur = "POS_CURFMT_POS_NUM_SPAC_CUR";
    protected static final String pos_curfmt_pos_cur_spac_num = "POS_CURFMT_POS_CUR_SPAC_NUM";
    protected static final String pos_curfmt_num_spac_cur_pos = "POS_CURFMT_NUM_SPAC_CUR_POS";
    protected static final String pos_curfmt_loc = "POS_CURFMT_BY_LOCALE";
    protected static final String neg_curfmt_op_cur_num_cp = "NEG_CURFMT_OP_CUR_NUM_CP";
    protected static final String neg_curfmt_neg_cur_num = "NEG_CURFMT_NEG_CUR_NUM";
    protected static final String neg_curfmt_cur_neg_num = "NEG_CURFMT_CUR_NEG_NUM";
    protected static final String neg_curfmt_cur_num_neg = "NEG_CURFMT_CUR_NUM_NEG";
    protected static final String neg_curfmt_op_num_cur_cp = "NEG_CURFMT_OP_NUM_CUR_CP";
    protected static final String neg_curfmt_neg_num_cur = "NEG_CURFMT_NEG_NUM_CUR";
    protected static final String neg_curfmt_num_neg_cur = "NEG_CURFMT_NUM_NEG_CUR";
    protected static final String neg_curfmt_num_cur_neg = "NEG_CURFMT_NUM_CUR_NEG";
    protected static final String neg_curfmt_neg_num_spac_cur = "NEG_CURFMT_NEG_NUM_SPAC_CUR";
    protected static final String neg_curfmt_neg_cur_spac_num = "NEG_CURFMT_NEG_CUR_SPAC_NUM";
    protected static final String neg_curfmt_num_spac_cur_neg = "NEG_CURFMT_NUM_SPAC_CUR_NEG";
    protected static final String oracle_neg_cur_const = "ORACLE_NEG_CUR_CONST";
    protected static final String neg_curfmt_cur_spac_num_neg = "NEG_CURFMT_CUR_SPAC_NUM_NEG";
    protected static final String neg_curfmt_cur_spac_neg_num = "NEG_CURFMT_CUR_SPAC_NEG_NUM";
    protected static final String neg_curfmt_loc = "NEG_CURFMT_BY_LOCALE";
    protected static final String neg_pctfmt_neg_num_pct = "NEG_PCTFMT_NEG_NUM_PCT";
    protected static final String neg_pctfmt_op_num_pct_cp = "NEG_PCTFMT_OP_NUM_PCT_CP";
    private static final String oracle_fmt_str = "ORACLE_PATTERN_STR";
    private static final String oeo_fmt_str = "OEO_PATTERN_STR";
    private static final String bibeans_fmt_str = "BIBEANS_PATTERN_STR";
    protected static final String thou_sep_by_locale = "THOU_SEP_BY_LOCALE";
    protected static final String dec_sep_by_locale = "DEC_SEP_BY_LOCALE";
    protected static final String scalefactor_none = "SCALEFACTOR_NONE";
    protected static final String scalefactor_thousands = "SCALEFACTOR_THOUSANDS";
    protected static final String scalefactor_millions = "SCALEFACTOR_MILLIONS";
    protected static final String scalefactor_billions = "SCALEFACTOR_BILLIONS";
    protected static final String scalefactor_trillions = "SCALEFACTOR_TRILLIONS";
    protected static final String scalefactor_quadrillions = "SCALEFACTOR_QUADRILLIONS";
    protected static final String scale_down_sym_loc = "SCALE_DOWN_SYMBOL_BY_LOCALE";
    public static final String a_numberType = "numberType";
    public static final String a_thousandSeparator = "thousandSeparator";
    public static final String a_decimalSeparator = "decimalSeparator";
    public static final String a_currencySymbol = "currencySymbol";
    public static final String a_leadingZero = "leadingZero";
    public static final String a_decimalDigit = "decimalDigit";
    public static final String a_posNumFmt = "posNumFmt";
    public static final String a_negNumFmt = "negNumFmt";
    public static final String a_posCurFmt = "posCurFmt";
    public static final String a_negCurFmt = "negCurFmt";
    public static final String a_scaleFactor = "scaleFactor";
    public static final String a_nfs = "nfs";
    public static final String a_nft = "nft";
    public static final String a_scaleDownThousands = "scaleDownThousands";
    public static final String a_scaleDownMillions = "scaleDownMillions";
    public static final String a_scaleDownBillions = "scaleDownBillions";
    public static final String a_scaleDownTrillions = "scaleDownTrillions";
    public static final String a_scaleDownQuadrillions = "scaleDownQuadrillions";
    public static final String a_javaDateFormat = "javaDateFormat";
    public static final String a_oracleDateFormat = "oracleDateFormat";
    public static final String a_negPctFmt = "negPctFmt";
    protected static final String a_numberTypeUsed = "numberTypeUsed";
    protected static final String a_thousandSeparatorUsed = "thousandSeparatorUsed";
    protected static final String a_decimalSeparatorUsed = "decimalSeparatorUsed";
    protected static final String a_currencySymbolUsed = "currencySymbolUsed";
    protected static final String a_leadingZeroUsed = "leadingZeroUsed";
    protected static final String a_decimalDigitUsed = "decimalDigitUsed";
    protected static final String a_posNumFmtUsed = "posNumFmtUsed";
    protected static final String a_negNumFmtUsed = "negNumFmtUsed";
    protected static final String a_posCurFmtUsed = "posCurFmtUsed";
    protected static final String a_negCurFmtUsed = "negCurFmtUsed";
    protected static final String a_scaleFactorUsed = "scaleFactorUsed";
    protected static final String a_scaleDownThousandsUsed = "scaleDownThousandsUsed";
    protected static final String a_scaleDownMillionsUsed = "scaleDownMillionsUsed";
    protected static final String a_scaleDownBillionsUsed = "scaleDownBillionsUsed";
    protected static final String a_scaleDownTrillionsUsed = "scaleDownTrillionsUsed";
    protected static final String a_scaleDownQuadrillionsUsed = "scaleDownQuadrillionsUsed";
    protected static final String a_javaDateFormatUsed = "javaDateFormatUsed";
    protected static final String a_oracleDateFormatUsed = "oracleDateFormatUsed";
    protected static final String a_negPctFmtUsed = "negPctFmtUsed";
    public static final String a_ISOC = "ISOC";
    protected static final int numberType = 0;
    protected static final char thousandSeparator = '0';
    protected static final char decimalSeparator = '0';
    protected static final boolean leadingZero = true;
    protected static final String currencySymbol = "$";
    protected static final int decimalDigit = 0;
    protected static final int posNumFmt = 4;
    protected static final int negNumFmt = 5;
    protected static final int posCurFmt = 13;
    protected static final int negCurFmt = 14;
    protected static final int scaleFactor = 0;
    protected static final String scaleDownThousands = "__sym_locale__";
    protected static final String scaleDownMillions = "__sym_locale__";
    protected static final String scaleDownBillions = "__sym_locale__";
    protected static final String scaleDownTrillions = "__sym_locale__";
    protected static final String scaleDownQuadrillions = "__sym_locale__";
    protected static final String dateFormat = "";
    protected static final boolean ISOC = false;
    protected static final int negPctFmt = 0;
    protected static final boolean numberTypeUsed = false;
    protected static final boolean thousandSeparatorUsed = false;
    protected static final boolean decimalSeparatorUsed = false;
    protected static final boolean currencySymbolUsed = false;
    protected static final boolean leadingZeroUsed = false;
    protected static final boolean decimalDigitUsed = false;
    protected static final boolean posNumFmtUsed = false;
    protected static final boolean negNumFmtUsed = false;
    protected static final boolean posCurFmtUsed = false;
    protected static final boolean negCurFmtUsed = false;
    protected static final boolean scaleFactorUsed = false;
    protected static final boolean scaleDownThousandsUsed = false;
    protected static final boolean scaleDownMillionsUsed = false;
    protected static final boolean scaleDownBillionsUsed = false;
    protected static final boolean scaleDownTrillionsUsed = false;
    protected static final boolean scaleDownQuadrillionsUsed = false;
    protected static final boolean dateFormatUsed = false;
    protected static final boolean negPctFmtUsed = false;
    private static final String numberFormatString = null;
    private static final int numberFormatType = 0;
    private char d_thousandSeparator = (char)48;
    private char d_decimalSeparator = (char)48;
    private String d_currencySymbol = "$";
    private String m_sJavaDateFormat = "";
    private String m_sOracleDateFormat = "";
    private int m_iNumberType = 0;
    private char m_cThousandSeparator = (char)48;
    private char m_cDecimalSeparator = (char)48;
    private String m_sCurrencySymbol = "$";
    private boolean m_bLeadingZero = true;
    private int m_iDecimalDigit;
    private int m_iPosNumFmt = 4;
    private int m_iNegNumFmt = 5;
    private int m_iPosCurFmt = 13;
    private int m_iNegCurFmt = 14;
    private int m_iScaleFactor = 0;
    private int m_nScaleFactorExponent = 0;
    private String m_sScaleDownThousands = "__sym_locale__";
    private String m_sScaleDownMillions = "__sym_locale__";
    private String m_sScaleDownBillions = "__sym_locale__";
    private String m_sScaleDownTrillions = "__sym_locale__";
    private String m_sScaleDownQuadrillions = "__sym_locale__";
    private String m_sSDThousandsLoc = DEFAULT_SCALE_DOWN_THOUSANDS_STRING;
    private String m_sSDMillionsLoc = DEFAULT_SCALE_DOWN_MILLIONS_STRING;
    private String m_sSDBillionsLoc = DEFAULT_SCALE_DOWN_BILLIONS_STRING;
    private String m_sSDTrillionsLoc = DEFAULT_SCALE_DOWN_TRILLIONS_STRING;
    private String m_sSDQuadrillionsLoc = DEFAULT_SCALE_DOWN_QUADRILLIONS_STRING;
    private String m_true_str = DEFAULT_TRUE_STRING;
    private String m_false_str = DEFAULT_FALSE_STRING;
    public static final String on = "on";
    public static final String off = "off";
    private int m_defNegCurFmt = -1;
    private int m_defPosCurFmt = -1;
    private char m_cThouSepLoc;
    private char m_cDecSepLoc;
    private int m_iPosNumFmtLoc;
    private int m_iNegNumFmtLoc;
    private int m_iPosCurFmtLoc;
    private int m_iNegCurFmtLoc;
    protected BitSet m_formatUsedFlags;
    private NumberFormat m_oNumberInstance = null;
    private NumberFormat m_oCurrencyInstance = null;
    private NumberFormat m_oPercentInstance = null;
    private SimpleDateFormat m_oJavaDateInstance = null;
    private OracleDateFormat m_oOracleDateInstance = null;
    private String m_oCurrencySymbol = null;
    private static ConcurrentHashMap m_hDefNumberInstances = new ConcurrentHashMap();
    private static ConcurrentHashMap m_hDefCurrencyInstances = new ConcurrentHashMap();
    private static ConcurrentHashMap m_hDefPercentInstances = new ConcurrentHashMap();
    private static ConcurrentHashMap m_hDefJavaDateInstances = new ConcurrentHashMap();
    private static ConcurrentHashMap m_hDefOracleDateInstances = new ConcurrentHashMap();
    private Locale m_locale = null;
    private TimeZone m_timeZone = null;
    private ErrorHandler m_eh = null;
    private boolean m_initOracle = false;
    private static final String m_method_dateToString = "DateToString";
    private static final String m_method_timeToString = "TimeToString";
    private static final String m_method_timestampToString = "TimestampToString";
    private static final String m_method_stringToDate = "StringToDate";
    private static final String m_method_stringToTime = "StringToTime";
    private static final String m_method_stringToTimestamp = "StringToTimestamp";
    private static final String m_method_stringToObject = "StringToObject";
    private static final String m_method_setScaleFactor = "setScaleFactor";
    private static final String m_method_setCurrencySymbol = "setCurrencySymbol";
    private static final String m_method_setJavaDateFormat = "setJavaDateFormat";
    private static final String m_method_setOracleDateFormat = "setOracleDateFormat";
    private static final String m_method_setScaleDownBillions = "setScaleDownBillions";
    private static final String m_method_setScaleDownMillions = "setScaleDownMillions";
    private static final String m_method_setScaleDownQuadrillions = "setScaleDownQuadrillions";
    private static final String m_method_setScaleDownThousands = "setScaleDownThousands";
    private static final String m_method_setScaleDownTrillions = "setScaleDownTrillions";
    private int m_nNumberFormatType = 0;
    private String m_strNumberFormatString = null;
    private boolean m_bLeadingTrailingBlanksUsed = false;
    private boolean m_bNegativeAngleBracketsUsed = false;
    private boolean m_bNegativeMinusSpaceUsed = false;
    private boolean m_bISOCurrency = false;
    private boolean m_bISOCurrencyUsed = false;
    private NumberConverter m_numberConverter = null;
    private boolean m_nfsUsed = false;
    private int m_negPctFmt = 0;
    private static BitSet NoBitsSet = new BitSet(20);

    public BaseViewFormat() {
        this.init();
    }

    public BaseViewFormat(int numberType, char thousandSeparator, char decimalSeparator, String currencySymbol, boolean leadingZero, int decimalDigit, int posNumFmt, int negNumFmt, int posCurFmt, int negCurFmt, int scaleFactor, String scaleDownThousands, String scaleDownMillions, String scaleDownBillions, String scaleDownTrillions, String scaleDownQuadrillions, String dateFormat) {
        this.init(numberType, thousandSeparator, decimalSeparator, currencySymbol, leadingZero, decimalDigit, posNumFmt, negNumFmt, posCurFmt, negCurFmt, scaleFactor, scaleDownThousands, scaleDownMillions, scaleDownBillions, scaleDownTrillions, scaleDownQuadrillions, dateFormat);
    }

    public BaseViewFormat(String strNumberFormatString, int nNumberFormatType) {
        this();
        this.initWithString(strNumberFormatString, nNumberFormatType);
    }

    public void init() {
        this.init(0, '0', '0', "$", true, 0, 4, 5, 13, 14, 0, "__sym_locale__", "__sym_locale__", "__sym_locale__", "__sym_locale__", "__sym_locale__", "");
        this.m_iPosNumFmtLoc = this._getDefPosNumFmt();
        this.m_iNegNumFmtLoc = this._getDefNegNumFmt();
        this.m_iPosCurFmtLoc = this._getDefPosCurFmt();
        this.m_iNegCurFmtLoc = this._getDefNegCurFmt();
    }

    public void init(int numberType, char thousandSeparator, char decimalSeparator, String currencySymbol, boolean leadingZero, int decimalDigit, int posNumFmt, int negNumFmt, int posCurFmt, int negCurFmt, int scaleFactor, String scaleDownThousands, String scaleDownMillions, String scaleDownBillions, String scaleDownTrillions, String scaleDownQuadrillions, String dateFormat) {
        this.m_formatUsedFlags = new BitSet(20);
        this.m_formatUsedFlags.and(NoBitsSet);
        this.m_iNumberType = numberType;
        this.m_cThousandSeparator = thousandSeparator;
        this.m_cDecimalSeparator = decimalSeparator;
        this.setCurrencySymbol(currencySymbol);
        this.setCurrencySymbolUsed(false);
        this.setISOCurrencyUsed(false);
        this.m_bLeadingZero = leadingZero;
        this.m_iDecimalDigit = decimalDigit;
        this.m_iPosNumFmt = posNumFmt;
        this.m_iNegNumFmt = negNumFmt;
        this.m_iPosCurFmt = posCurFmt;
        this.m_iNegCurFmt = negCurFmt;
        this.m_iScaleFactor = scaleFactor;
        this.setScaleDownThousands(scaleDownThousands);
        this.setScaleDownThousandsUsed(false);
        this.setScaleDownMillions(scaleDownMillions);
        this.setScaleDownMillionsUsed(false);
        this.setScaleDownBillions(scaleDownBillions);
        this.setScaleDownBillionsUsed(false);
        this.setScaleDownTrillions(scaleDownTrillions);
        this.setScaleDownTrillionsUsed(false);
        this.setScaleDownQuadrillions(scaleDownQuadrillions);
        this.setScaleDownQuadrillionsUsed(false);
        this.setOracleDateFormat(dateFormat);
        this.setOracleDateFormatUsed(false);
        this.m_numberConverter = null;
        this.m_oNumberInstance = this.getDefNumberInstance();
        this.m_oCurrencyInstance = this.getDefCurrencyInstance();
        this.m_oPercentInstance = this.getDefPercentInstance();
        this.m_nNumberFormatType = 0;
        this.m_strNumberFormatString = null;
        this.m_nfsUsed = false;
        this.updateDefaultSymbols();
        this.updateDefaultCurrencySymbol();
    }

    public ObjectNode getXML(boolean allProperties) {
        return this.getXML(allProperties, false);
    }

    @Override
    public ObjectNode getXML(boolean allProperties, boolean emptyElement) {
        int tmp;
        ObjectNode node = new ObjectNode(VIEW_FORMAT_NAME);
        boolean nodeExists = false;
        if (this.isNumberFormatStringUsed()) {
            if (allProperties || this.getNumberFormatString() != numberFormatString) {
                node.addProperty(a_nfs, this.getNumberFormatString());
                nodeExists = true;
            }
            if (allProperties || this.getNumberFormatType() != 0) {
                if (this.getNumberFormatType() == 1) {
                    node.addProperty(a_nft, oracle_fmt_str);
                } else if (this.getNumberFormatType() == 0) {
                    node.addProperty(a_nft, oeo_fmt_str);
                } else if (this.getNumberFormatType() == 2) {
                    node.addProperty(a_nft, bibeans_fmt_str);
                }
                nodeExists = true;
            }
            if (nodeExists) {
                return node;
            }
            return null;
        }
        if (allProperties || this.isNumberTypeUsed() || 0 != this.getNumberType()) {
            tmp = this.getNumberType();
            if (tmp == 0) {
                node.addProperty(a_numberType, numtype_general);
            } else if (tmp == 1) {
                node.addProperty(a_numberType, numtype_currency);
            } else if (tmp == 2) {
                node.addProperty(a_numberType, numtype_percent);
            } else if (tmp == 3) {
                node.addProperty(a_numberType, numtype_percent_s);
            }
            nodeExists = true;
        }
        if (allProperties || this.isThousandSeparatorUsed() || '0' != this.getThousandSeparator()) {
            if (this.getThousandSeparator() == this.d_thousandSeparator) {
                node.addProperty(a_thousandSeparator, thou_sep_by_locale);
            } else {
                node.addProperty(a_thousandSeparator, this.getThousandSeparator());
            }
            nodeExists = true;
        }
        if (allProperties || this.isDecimalSeparatorUsed() || this.d_decimalSeparator != this.getDecimalSeparator()) {
            if (this.getDecimalSeparator() == '0') {
                node.addProperty(a_decimalSeparator, dec_sep_by_locale);
            } else {
                node.addProperty(a_decimalSeparator, this.getDecimalSeparator());
            }
            nodeExists = true;
        }
        if (allProperties || this.isCurrencySymbolUsed() || !this.d_currencySymbol.equals(this.getCurrencySymbol()) && this.m_locale == null) {
            node.addProperty(a_currencySymbol, this.getCurrencySymbol());
            nodeExists = true;
        }
        if (allProperties || !this.isLeadingZero()) {
            node.addProperty(a_leadingZero, this.isLeadingZero());
            nodeExists = true;
        }
        if (allProperties || this.isDecimalDigitUsed() || 0 != this.getDecimalDigit()) {
            node.addProperty(a_decimalDigit, this.getDecimalDigit());
            nodeExists = true;
        }
        if (allProperties || this.isPosNumFmtUsed() || 4 != this.getPosNumFmt()) {
            tmp = this.getPosNumFmt();
            if (tmp == 0) {
                node.addProperty(a_posNumFmt, pos_numfmt_num);
            } else if (tmp == 1) {
                node.addProperty(a_posNumFmt, pos_numfmt_pos_num);
            } else if (tmp == 2) {
                node.addProperty(a_posNumFmt, pos_numfmt_num_pos);
            } else if (tmp == 4) {
                node.addProperty(a_posNumFmt, pos_numfmt_loc);
            }
            nodeExists = true;
        }
        if (allProperties || this.isNegNumFmtUsed() || 5 != this.getNegNumFmt()) {
            tmp = this.getNegNumFmt();
            if (tmp == 0) {
                node.addProperty(a_negNumFmt, neg_numfmt_op_num_cp);
            } else if (tmp == 1) {
                node.addProperty(a_negNumFmt, neg_numfmt_neg_num);
            } else if (tmp == 2) {
                node.addProperty(a_negNumFmt, neg_numfmt_num_neg);
            } else if (tmp == 3) {
                node.addProperty(a_negNumFmt, neg_numfmt_num);
            } else if (tmp == 5) {
                node.addProperty(a_negNumFmt, neg_numfmt_loc);
            }
            nodeExists = true;
        }
        if (allProperties || this.isPosCurFmtUsed() || 13 != this.getPosCurFmt()) {
            tmp = this.getPosCurFmt();
            if (tmp == 0) {
                node.addProperty(a_posCurFmt, pos_curfmt_cur_num);
            } else if (tmp == 1) {
                node.addProperty(a_posCurFmt, pos_curfmt_num_cur);
            } else if (tmp == 2) {
                node.addProperty(a_posCurFmt, pos_curfmt_cur_spac_num);
            } else if (tmp == 3) {
                node.addProperty(a_posCurFmt, pos_curfmt_num_spac_cur);
            } else if (tmp == 5) {
                node.addProperty(a_posCurFmt, pos_curfmt_cur_num_pos);
            } else if (tmp == 4) {
                node.addProperty(a_posCurFmt, pos_curfmt_pos_cur_num);
            } else if (tmp == 7) {
                node.addProperty(a_posCurFmt, pos_curfmt_num_pos_cur);
            } else if (tmp == 6) {
                node.addProperty(a_posCurFmt, pos_curfmt_pos_num_cur);
            } else if (tmp == 9) {
                node.addProperty(a_posCurFmt, pos_curfmt_pos_num_spac_cur);
            } else if (tmp == 8) {
                node.addProperty(a_posCurFmt, pos_curfmt_num_cur_pos);
            } else if (tmp == 11) {
                node.addProperty(a_posCurFmt, pos_curfmt_num_spac_cur_pos);
            } else if (tmp == 10) {
                node.addProperty(a_posCurFmt, pos_curfmt_pos_cur_spac_num);
            } else if (tmp == 13) {
                node.addProperty(a_posCurFmt, pos_curfmt_loc);
            }
            nodeExists = true;
        }
        if (allProperties || this.isNegCurFmtUsed() || 14 != this.getNegCurFmt()) {
            tmp = this.getNegCurFmt();
            if (tmp == 0) {
                node.addProperty(a_negCurFmt, neg_curfmt_op_cur_num_cp);
            } else if (tmp == 1) {
                node.addProperty(a_negCurFmt, neg_curfmt_neg_cur_num);
            } else if (tmp == 2) {
                node.addProperty(a_negCurFmt, neg_curfmt_cur_neg_num);
            } else if (tmp == 3) {
                node.addProperty(a_negCurFmt, neg_curfmt_cur_num_neg);
            } else if (tmp == 2) {
                node.addProperty(a_negCurFmt, neg_curfmt_cur_neg_num);
            } else if (tmp == 5) {
                node.addProperty(a_negCurFmt, neg_curfmt_neg_num_cur);
            } else if (tmp == 6) {
                node.addProperty(a_negCurFmt, neg_curfmt_num_neg_cur);
            } else if (tmp == 7) {
                node.addProperty(a_negCurFmt, neg_curfmt_num_cur_neg);
            } else if (tmp == 8) {
                node.addProperty(a_negCurFmt, neg_curfmt_neg_num_spac_cur);
            } else if (tmp == 9) {
                node.addProperty(a_negCurFmt, neg_curfmt_neg_cur_spac_num);
            } else if (tmp == 10) {
                node.addProperty(a_negCurFmt, neg_curfmt_num_spac_cur_neg);
            } else if (tmp == 12) {
                node.addProperty(a_negCurFmt, neg_curfmt_cur_spac_num_neg);
            } else if (tmp == 13) {
                node.addProperty(a_negCurFmt, neg_curfmt_cur_spac_neg_num);
            } else if (tmp == 14) {
                node.addProperty(a_negCurFmt, neg_curfmt_loc);
            }
            nodeExists = true;
        }
        if (allProperties || this.isScaleFactorUsed() || 0 != this.getScaleFactor()) {
            tmp = this.getScaleFactor();
            if (tmp == 0) {
                node.addProperty(a_scaleFactor, scalefactor_none);
            } else if (tmp == 1) {
                node.addProperty(a_scaleFactor, scalefactor_thousands);
            } else if (tmp == 2) {
                node.addProperty(a_scaleFactor, scalefactor_millions);
            } else if (tmp == 3) {
                node.addProperty(a_scaleFactor, scalefactor_billions);
            } else if (tmp == 4) {
                node.addProperty(a_scaleFactor, scalefactor_trillions);
            } else if (tmp == 5) {
                node.addProperty(a_scaleFactor, scalefactor_quadrillions);
            }
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownThousandsUsed() || !"__sym_locale__".equals(this.getScaleDownThousands())) {
            if (this.getScaleDownThousands().equals("__sym_locale__")) {
                node.addProperty(a_scaleDownThousands, scale_down_sym_loc);
            } else {
                node.addProperty(a_scaleDownThousands, this.getScaleDownThousands());
            }
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownMillionsUsed() || !"__sym_locale__".equals(this.getScaleDownMillions())) {
            if (this.getScaleDownMillions().equals("__sym_locale__")) {
                node.addProperty(a_scaleDownMillions, scale_down_sym_loc);
            } else {
                node.addProperty(a_scaleDownMillions, this.getScaleDownMillions());
            }
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownBillionsUsed() || !"__sym_locale__".equals(this.getScaleDownBillions())) {
            if (this.getScaleDownBillions().equals("__sym_locale__")) {
                node.addProperty(a_scaleDownBillions, scale_down_sym_loc);
            } else {
                node.addProperty(a_scaleDownBillions, this.getScaleDownBillions());
            }
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownTrillionsUsed() || !"__sym_locale__".equals(this.getScaleDownTrillions())) {
            if (this.getScaleDownTrillions().equals("__sym_locale__")) {
                node.addProperty(a_scaleDownTrillions, scale_down_sym_loc);
            } else {
                node.addProperty(a_scaleDownTrillions, this.getScaleDownTrillions());
            }
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownQuadrillionsUsed() || !"__sym_locale__".equals(this.getScaleDownQuadrillions())) {
            if (this.getScaleDownQuadrillions().equals("__sym_locale__")) {
                node.addProperty(a_scaleDownQuadrillions, scale_down_sym_loc);
            } else {
                node.addProperty(a_scaleDownQuadrillions, this.getScaleDownQuadrillions());
            }
            nodeExists = true;
        }
        String temp = this.getJavaDateFormat();
        if (allProperties || this.isJavaDateFormatUsed() || !"".equals(temp)) {
            node.addProperty(a_javaDateFormat, this.getJavaDateFormat());
            nodeExists = true;
        }
        temp = this.getOracleDateFormat();
        if (allProperties || this.isOracleDateFormatUsed() || !"".equals(temp)) {
            node.addProperty(a_oracleDateFormat, this.getOracleDateFormat());
            nodeExists = true;
        }
        if (allProperties || this.isISOCurrency()) {
            node.addProperty(a_ISOC, this.isISOCurrency());
            nodeExists = true;
        }
        if (allProperties || this.isNegPctFmtUsed() || 0 != this.getNegPctFmt()) {
            switch (this.getNegPctFmt()) {
                case 1: {
                    node.addProperty(a_negPctFmt, neg_pctfmt_op_num_pct_cp);
                    nodeExists = true;
                    break;
                }
                case 0: {
                    node.addProperty(a_negPctFmt, neg_pctfmt_neg_num_pct);
                    nodeExists = true;
                }
            }
        }
        if (allProperties || this.isNumberTypeUsed()) {
            node.addProperty(a_numberTypeUsed, this.isNumberTypeUsed());
            nodeExists = true;
        }
        if (allProperties || this.isThousandSeparatorUsed()) {
            node.addProperty(a_thousandSeparatorUsed, this.isThousandSeparatorUsed());
            nodeExists = true;
        }
        if (allProperties || this.isDecimalSeparatorUsed()) {
            node.addProperty(a_decimalSeparatorUsed, this.isDecimalSeparatorUsed());
            nodeExists = true;
        }
        if (allProperties || this.isCurrencySymbolUsed()) {
            node.addProperty(a_currencySymbolUsed, this.isCurrencySymbolUsed());
            nodeExists = true;
        }
        if (allProperties || this.isLeadingZeroUsed()) {
            node.addProperty(a_leadingZeroUsed, this.isLeadingZeroUsed());
            nodeExists = true;
        }
        if (allProperties || this.isDecimalDigitUsed()) {
            node.addProperty(a_decimalDigitUsed, this.isDecimalDigitUsed());
            nodeExists = true;
        }
        if (allProperties || this.isPosNumFmtUsed()) {
            node.addProperty(a_posNumFmtUsed, this.isPosNumFmtUsed());
            nodeExists = true;
        }
        if (allProperties || this.isNegNumFmtUsed()) {
            node.addProperty(a_negNumFmtUsed, this.isNegNumFmtUsed());
            nodeExists = true;
        }
        if (allProperties || this.isPosCurFmtUsed()) {
            node.addProperty(a_posCurFmtUsed, this.isPosCurFmtUsed());
            nodeExists = true;
        }
        if (allProperties || this.isNegCurFmtUsed()) {
            node.addProperty(a_negCurFmtUsed, this.isNegCurFmtUsed());
            nodeExists = true;
        }
        if (allProperties || this.isScaleFactorUsed()) {
            node.addProperty(a_scaleFactorUsed, this.isScaleFactorUsed());
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownThousandsUsed()) {
            node.addProperty(a_scaleDownThousandsUsed, this.isScaleDownThousandsUsed());
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownMillionsUsed()) {
            node.addProperty(a_scaleDownMillionsUsed, this.isScaleDownMillionsUsed());
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownBillionsUsed()) {
            node.addProperty(a_scaleDownBillionsUsed, this.isScaleDownBillionsUsed());
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownTrillionsUsed()) {
            node.addProperty(a_scaleDownTrillionsUsed, this.isScaleDownTrillionsUsed());
            nodeExists = true;
        }
        if (allProperties || this.isScaleDownQuadrillionsUsed()) {
            node.addProperty(a_scaleDownQuadrillionsUsed, this.isScaleDownQuadrillionsUsed());
            nodeExists = true;
        }
        if (allProperties || this.isJavaDateFormatUsed()) {
            node.addProperty(a_javaDateFormatUsed, this.isJavaDateFormatUsed());
            nodeExists = true;
        }
        if (allProperties || this.isOracleDateFormatUsed()) {
            node.addProperty(a_oracleDateFormatUsed, this.isOracleDateFormatUsed());
            nodeExists = true;
        }
        if (allProperties || this.isNegPctFmtUsed()) {
            node.addProperty(a_negPctFmtUsed, this.isNegPctFmtUsed());
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setXML(ObjectNode node, String version, int reset, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            boolean bl = this.setXML(node, version, reset);
            return bl;
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Override
    public boolean setXML(ObjectNode node, String version, int reset) {
        String scaleD;
        boolean bVersionBefore_2_4_0_16;
        boolean bVersionBefore_2_4_0_6;
        if (version == null || version.equals("")) {
            bVersionBefore_2_4_0_6 = false;
            bVersionBefore_2_4_0_16 = false;
        } else {
            bVersionBefore_2_4_0_6 = Utility.compareXMLVersions(version, m_version_2_4_0_6) < 0;
            bVersionBefore_2_4_0_16 = Utility.compareXMLVersions(version, m_version_2_4_0_16) < 0;
        }
        PropertyNode pNode = node.getProperty(a_nfs);
        if (pNode != null) {
            String nfs = pNode.getValueAsString();
            int numType = 0;
            pNode = node.getProperty(a_nft);
            if (pNode != null) {
                String tmp = pNode.getValueAsString();
                numType = tmp.equals(oracle_fmt_str) ? 1 : (tmp.equals(bibeans_fmt_str) ? 2 : 0);
            }
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_nfs, nfs);
                this.m_jsfHashMap.put(a_nft, new Integer(numType));
            } else {
                this.initWithString(nfs, numType);
            }
            return true;
        }
        pNode = node.getProperty(a_numberType);
        boolean bUsed = false;
        if (pNode != null) {
            bUsed = this.isNumberTypeUsed();
            this.setNumberType(BaseViewFormat.convertNumberTypeToInt(pNode.getValueAsString()));
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isNumberTypeUsed()) {
                this.setNumberTypeUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_thousandSeparator)) != null) {
            String thouSepStr;
            bUsed = this.isThousandSeparatorUsed();
            int thouSep = bVersionBefore_2_4_0_6 ? (int)pNode.getValueAsInteger() : ((thouSepStr = pNode.getValueAsString()).equals(thou_sep_by_locale) ? 48 : (int)pNode.getValueAsCharacter());
            this.setThousandSeparator((char)thouSep);
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isThousandSeparatorUsed()) {
                this.setThousandSeparatorUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_decimalSeparator)) != null) {
            String decSepStr;
            bUsed = this.isDecimalSeparatorUsed();
            int decSep = bVersionBefore_2_4_0_6 ? (int)pNode.getValueAsInteger() : ((decSepStr = pNode.getValueAsString()).equals(dec_sep_by_locale) ? 48 : (int)pNode.getValueAsCharacter());
            this.setDecimalSeparator((char)decSep);
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isDecimalSeparatorUsed()) {
                this.setDecimalSeparatorUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_currencySymbol)) != null) {
            bUsed = this.isCurrencySymbolUsed();
            this.setCurrencySymbol(pNode.getValueAsString());
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isCurrencySymbolUsed()) {
                this.setCurrencySymbolUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_leadingZero)) != null) {
            bUsed = this.isLeadingZeroUsed();
            this.setLeadingZero(pNode.getValueAsBoolean());
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isLeadingZeroUsed()) {
                this.setLeadingZeroUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_decimalDigit)) != null) {
            bUsed = this.isDecimalDigitUsed();
            this.setDecimalDigit(pNode.getValueAsInteger());
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isDecimalDigitUsed()) {
                this.setDecimalDigitUsed(bUsed);
            }
        }
        pNode = node.getProperty(a_posNumFmt);
        boolean bOldPosNumFmtUsed = this.isPosNumFmtUsed();
        boolean bResetPosNumFmtUsed = false;
        if (pNode != null) {
            bUsed = this.isPosNumFmtUsed();
            this.setPosNumFmt(BaseViewFormat.convertPosNumFmtToInt(pNode.getValueAsString()));
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isPosNumFmtUsed()) {
                bResetPosNumFmtUsed = true;
            }
        }
        pNode = node.getProperty(a_negNumFmt);
        boolean bOldNegNumFmtUsed = this.isNegNumFmtUsed();
        boolean bResetNegNumFmtUsed = false;
        boolean bNegNumFmtSpecified = false;
        if (pNode != null) {
            bUsed = this.isNegNumFmtUsed();
            this.setNegNumFmt(BaseViewFormat.convertNegNumFmtToInt(pNode.getValueAsString()));
            bNegNumFmtSpecified = true;
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isNegNumFmtUsed()) {
                bResetNegNumFmtUsed = true;
            }
        }
        pNode = node.getProperty(a_posCurFmt);
        boolean bOldPosCurFmtUsed = this.isPosCurFmtUsed();
        boolean bResetPosCurFmtUsed = false;
        if (pNode != null) {
            bUsed = this.isPosCurFmtUsed();
            this.setPosCurFmt(BaseViewFormat.convertPosCurFmtToInt(pNode.getValueAsString()));
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isPosCurFmtUsed()) {
                bResetPosCurFmtUsed = true;
            }
        }
        pNode = node.getProperty(a_negCurFmt);
        boolean bOldNegCurFmtUsed = this.isNegCurFmtUsed();
        boolean bResetNegCurFmtUsed = false;
        if (pNode != null) {
            bUsed = this.isNegCurFmtUsed();
            this.setNegCurFmt(BaseViewFormat.convertNegCurFmtToInt(pNode.getValueAsString()));
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isNegCurFmtUsed()) {
                bResetNegCurFmtUsed = true;
            }
        }
        if ((pNode = node.getProperty(a_scaleFactor)) != null) {
            bUsed = this.isScaleFactorUsed();
            this.setScaleFactor(BaseViewFormat.convertScaleFactorToInt(pNode.getValueAsString()));
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isScaleFactorUsed()) {
                this.setScaleFactorUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_scaleDownThousands)) != null) {
            bUsed = this.isScaleDownThousandsUsed();
            scaleD = pNode.getValueAsString();
            if (scaleD.equals(scale_down_sym_loc)) {
                this.setScaleDownThousands("__sym_locale__");
            } else {
                this.setScaleDownThousands(scaleD);
            }
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isScaleDownThousandsUsed()) {
                this.setScaleDownThousandsUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_scaleDownMillions)) != null) {
            bUsed = this.isScaleDownMillionsUsed();
            scaleD = pNode.getValueAsString();
            if (scaleD.equals(scale_down_sym_loc)) {
                this.setScaleDownMillions("__sym_locale__");
            } else {
                this.setScaleDownMillions(scaleD);
            }
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isScaleDownMillionsUsed()) {
                this.setScaleDownMillionsUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_scaleDownBillions)) != null) {
            bUsed = this.isScaleDownBillionsUsed();
            scaleD = pNode.getValueAsString();
            if (scaleD.equals(scale_down_sym_loc)) {
                this.setScaleDownBillions("__sym_locale__");
            } else {
                this.setScaleDownBillions(scaleD);
            }
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isScaleDownBillionsUsed()) {
                this.setScaleDownBillionsUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_scaleDownTrillions)) != null) {
            bUsed = this.isScaleDownTrillionsUsed();
            scaleD = pNode.getValueAsString();
            if (scaleD.equals(scale_down_sym_loc)) {
                this.setScaleDownTrillions("__sym_locale__");
            } else {
                this.setScaleDownTrillions(scaleD);
            }
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isScaleDownTrillionsUsed()) {
                this.setScaleDownTrillionsUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_scaleDownQuadrillions)) != null) {
            bUsed = this.isScaleDownQuadrillionsUsed();
            scaleD = pNode.getValueAsString();
            if (scaleD.equals(scale_down_sym_loc)) {
                this.setScaleDownQuadrillions("__sym_locale__");
            } else {
                this.setScaleDownQuadrillions(scaleD);
            }
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isScaleDownQuadrillionsUsed()) {
                this.setScaleDownQuadrillionsUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_javaDateFormat)) != null) {
            bUsed = this.isJavaDateFormatUsed();
            if (version.equals("1.5.0.5")) {
                if (pNode.getValueAsString().equals("NULL")) {
                    this.setJavaDateFormat("");
                }
            } else {
                this.setJavaDateFormat(pNode.getValueAsString());
            }
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isJavaDateFormatUsed()) {
                this.setJavaDateFormatUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_oracleDateFormat)) != null) {
            bUsed = this.isOracleDateFormatUsed();
            this.setOracleDateFormat(pNode.getValueAsString());
            if (!bVersionBefore_2_4_0_16 && bUsed != this.isOracleDateFormatUsed()) {
                this.setOracleDateFormatUsed(bUsed);
            }
        }
        if ((pNode = node.getProperty(a_ISOC)) != null) {
            this.setISOCurrency(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_negPctFmt)) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals(neg_pctfmt_op_num_pct_cp)) {
                this.setNegPctFmt(1);
            } else if (tmp.equals(neg_pctfmt_neg_num_pct)) {
                this.setNegPctFmt(0);
            }
        }
        if ((pNode = node.getProperty(a_numberTypeUsed)) != null) {
            this.setNumberTypeUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_thousandSeparatorUsed)) != null) {
            this.setThousandSeparatorUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_decimalSeparatorUsed)) != null) {
            this.setDecimalSeparatorUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_currencySymbolUsed)) != null) {
            this.setCurrencySymbolUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_leadingZeroUsed)) != null) {
            this.setLeadingZeroUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_decimalDigitUsed)) != null) {
            this.setDecimalDigitUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_posNumFmtUsed)) != null) {
            this.setPosNumFmtUsed(pNode.getValueAsBoolean());
        } else if (bResetPosNumFmtUsed) {
            this.setPosNumFmtUsed(bOldPosNumFmtUsed);
        }
        pNode = node.getProperty(a_negNumFmtUsed);
        if (pNode != null) {
            this.setNegNumFmtUsed(pNode.getValueAsBoolean());
            if (bVersionBefore_2_4_0_16 && pNode.getValueAsBoolean() && !bNegNumFmtSpecified) {
                this.setNegNumFmt(0);
            }
        } else if (bResetNegNumFmtUsed) {
            this.setNegNumFmtUsed(bOldNegNumFmtUsed);
        }
        if ((pNode = node.getProperty(a_posCurFmtUsed)) != null) {
            this.setPosCurFmtUsed(pNode.getValueAsBoolean());
        } else if (bResetPosCurFmtUsed) {
            this.setPosCurFmtUsed(bOldPosCurFmtUsed);
        }
        pNode = node.getProperty(a_negCurFmtUsed);
        if (pNode != null) {
            this.setNegCurFmtUsed(pNode.getValueAsBoolean());
        } else if (bResetNegCurFmtUsed) {
            this.setNegCurFmtUsed(bOldNegCurFmtUsed);
        }
        pNode = node.getProperty(a_scaleFactorUsed);
        if (pNode != null) {
            this.setScaleFactorUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_scaleDownThousandsUsed)) != null) {
            this.setScaleDownThousandsUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_scaleDownMillionsUsed)) != null) {
            this.setScaleDownMillionsUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_scaleDownBillionsUsed)) != null) {
            this.setScaleDownBillionsUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_scaleDownTrillionsUsed)) != null) {
            this.setScaleDownTrillionsUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_scaleDownQuadrillionsUsed)) != null) {
            this.setScaleDownQuadrillionsUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_javaDateFormatUsed)) != null) {
            this.setJavaDateFormatUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_oracleDateFormatUsed)) != null) {
            this.setOracleDateFormatUsed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_negPctFmtUsed)) != null) {
            this.setNegPctFmtUsed(pNode.getValueAsBoolean());
        }
        if (this.m_jsfHashMap != null) {
            if (this.isNumberTypeUsed()) {
                this.m_jsfHashMap.put(a_numberType, new Integer(this.getNumberType()));
            }
            if (this.isThousandSeparatorUsed()) {
                this.m_jsfHashMap.put(a_thousandSeparator, new Character(this.getThousandSeparator()));
            }
            if (this.isDecimalSeparatorUsed()) {
                this.m_jsfHashMap.put(a_decimalSeparator, new Character(this.getDecimalSeparator()));
            }
            if (this.isCurrencySymbolUsed()) {
                this.m_jsfHashMap.put(a_currencySymbol, this.getCurrencySymbol());
            }
            if (this.isLeadingZeroUsed()) {
                this.m_jsfHashMap.put(a_leadingZero, new Boolean(this.isLeadingZero()));
            }
            if (this.isDecimalDigitUsed()) {
                this.m_jsfHashMap.put(a_decimalDigit, new Integer(this.getDecimalDigit()));
            }
            if (this.isPosNumFmtUsed()) {
                this.m_jsfHashMap.put(a_posNumFmt, new Integer(this.getPosNumFmt()));
            }
            if (this.isNegNumFmtUsed()) {
                this.m_jsfHashMap.put(a_negNumFmt, new Integer(this.getNegNumFmt()));
            }
            if (this.isPosCurFmtUsed()) {
                this.m_jsfHashMap.put(a_posCurFmt, new Integer(this.getPosCurFmt()));
            }
            if (this.isNegCurFmtUsed()) {
                this.m_jsfHashMap.put(a_negCurFmt, new Integer(this.getNegCurFmt()));
            }
            if (this.isScaleFactorUsed()) {
                this.m_jsfHashMap.put(a_scaleFactor, new Integer(this.getScaleFactor()));
            }
            if (this.isScaleDownThousandsUsed()) {
                this.m_jsfHashMap.put(a_scaleDownThousands, this.getScaleDownThousands());
            }
            if (this.isScaleDownMillionsUsed()) {
                this.m_jsfHashMap.put(a_scaleDownMillions, this.getScaleDownMillions());
            }
            if (this.isScaleDownBillionsUsed()) {
                this.m_jsfHashMap.put(a_scaleDownBillions, this.getScaleDownBillions());
            }
            if (this.isScaleDownTrillionsUsed()) {
                this.m_jsfHashMap.put(a_scaleDownTrillions, this.getScaleDownTrillions());
            }
            if (this.isScaleDownQuadrillionsUsed()) {
                this.m_jsfHashMap.put(a_scaleDownQuadrillions, this.getScaleDownQuadrillions());
            }
            if (this.isISOCurrencyUsed()) {
                this.m_jsfHashMap.put(a_ISOC, new Boolean(this.isISOCurrency()));
            }
            if (this.isNegPctFmtUsed()) {
                this.m_jsfHashMap.put(a_negPctFmt, new Integer(this.getNegPctFmt()));
            }
        }
        return true;
    }

    private String getConverterNumType(int type) {
        switch (type) {
            case 0: {
                return "number";
            }
            case 2: 
            case 3: {
                return "percent";
            }
            case 1: {
                return "currency";
            }
        }
        return "number";
    }

    private int getViewFormatNumType(String type) {
        int numType = type.equals("percent") ? 2 : (type.equals("currency") ? 1 : 0);
        return numType;
    }

    public static int convertNumberTypeToInt(String value) {
        if (value.equals(numtype_general)) {
            return 0;
        }
        if (value.equals(numtype_currency)) {
            return 1;
        }
        if (value.equals(numtype_percent)) {
            return 2;
        }
        if (value.equals(numtype_percent_s)) {
            return 3;
        }
        return -1;
    }

    public static int convertPosNumFmtToInt(String value) {
        if (value.equals(pos_numfmt_num)) {
            return 0;
        }
        if (value.equals(pos_numfmt_pos_num)) {
            return 1;
        }
        if (value.equals(pos_numfmt_num_pos)) {
            return 2;
        }
        if (value.equals(pos_numfmt_loc)) {
            return 4;
        }
        return -1;
    }

    public static int convertPosCurFmtToInt(String value) {
        if (value.equals(pos_curfmt_cur_num)) {
            return 0;
        }
        if (value.equals(pos_curfmt_num_cur)) {
            return 1;
        }
        if (value.equals(pos_curfmt_cur_spac_num)) {
            return 2;
        }
        if (value.equals(pos_curfmt_num_spac_cur)) {
            return 3;
        }
        if (value.equals(pos_curfmt_cur_num_pos)) {
            return 5;
        }
        if (value.equals(pos_curfmt_pos_cur_num)) {
            return 4;
        }
        if (value.equals(pos_curfmt_num_pos_cur)) {
            return 7;
        }
        if (value.equals(pos_curfmt_pos_num_cur)) {
            return 6;
        }
        if (value.equals(pos_curfmt_pos_num_spac_cur)) {
            return 9;
        }
        if (value.equals(pos_curfmt_num_cur_pos)) {
            return 8;
        }
        if (value.equals(pos_curfmt_num_spac_cur_pos)) {
            return 11;
        }
        if (value.equals(pos_curfmt_pos_cur_spac_num)) {
            return 10;
        }
        if (value.equals(pos_curfmt_loc)) {
            return 13;
        }
        return -1;
    }

    public static int convertNegCurFmtToInt(String value) {
        if (value.equals(neg_curfmt_op_cur_num_cp)) {
            return 0;
        }
        if (value.equals(neg_curfmt_neg_cur_num)) {
            return 1;
        }
        if (value.equals(neg_curfmt_cur_neg_num)) {
            return 2;
        }
        if (value.equals(neg_curfmt_cur_num_neg)) {
            return 3;
        }
        if (value.equals(neg_curfmt_neg_num_cur)) {
            return 5;
        }
        if (value.equals(neg_curfmt_op_num_cur_cp)) {
            return 4;
        }
        if (value.equals(neg_curfmt_num_cur_neg)) {
            return 7;
        }
        if (value.equals(neg_curfmt_num_neg_cur)) {
            return 6;
        }
        if (value.equals(neg_curfmt_neg_num_spac_cur)) {
            return 8;
        }
        if (value.equals(neg_curfmt_neg_cur_spac_num)) {
            return 9;
        }
        if (value.equals(neg_curfmt_num_spac_cur_neg)) {
            return 10;
        }
        if (value.equals(neg_curfmt_cur_spac_num_neg)) {
            return 12;
        }
        if (value.equals(neg_curfmt_cur_spac_neg_num)) {
            return 13;
        }
        if (value.equals(neg_curfmt_loc)) {
            return 14;
        }
        return -1;
    }

    public static int convertNegNumFmtToInt(String value) {
        if (value.equals(neg_numfmt_op_num_cp)) {
            return 0;
        }
        if (value.equals(neg_numfmt_neg_num)) {
            return 1;
        }
        if (value.equals(neg_numfmt_num_neg)) {
            return 2;
        }
        if (value.equals(neg_numfmt_num)) {
            return 3;
        }
        if (value.equals(neg_numfmt_loc)) {
            return 5;
        }
        return -1;
    }

    public static int convertScaleFactorToInt(String value) {
        if (value.equals(scalefactor_none)) {
            return 0;
        }
        if (value.equals(scalefactor_thousands)) {
            return 1;
        }
        if (value.equals(scalefactor_millions)) {
            return 2;
        }
        if (value.equals(scalefactor_billions)) {
            return 3;
        }
        if (value.equals(scalefactor_trillions)) {
            return 4;
        }
        if (value.equals(scalefactor_quadrillions)) {
            return 5;
        }
        return -1;
    }

    @Override
    public boolean isAnythingOverridden() {
        return !this.m_formatUsedFlags.equals(NoBitsSet);
    }

    @Override
    public Object clone() {
        BaseViewFormat myClone = new BaseViewFormat(this.m_iNumberType, this.m_cThousandSeparator, this.m_cDecimalSeparator, this.m_sCurrencySymbol, this.m_bLeadingZero, this.m_iDecimalDigit, this.m_iPosNumFmt, this.m_iNegNumFmt, this.m_iPosCurFmt, this.m_iNegCurFmt, this.m_iScaleFactor, this.m_sScaleDownThousands, this.m_sScaleDownMillions, this.m_sScaleDownBillions, this.m_sScaleDownTrillions, this.m_sScaleDownQuadrillions, this.m_sOracleDateFormat);
        NumberConverter converter = this.getNumberConverter();
        if (converter instanceof DvtNumberConverter) {
            myClone.setNumberConverter(((DvtNumberConverter)converter).cloneDvtNumberConverter());
        } else if (converter != null) {
            myClone.setNumberConverter(converter);
        }
        myClone.m_locale = this.m_locale;
        myClone.setLocale(this.m_locale, true);
        myClone.merge(this);
        myClone.m_eh = this.m_eh;
        myClone.setJavaDateFormat(this.m_sJavaDateFormat);
        myClone.setJavaDateFormatUsed(this.isJavaDateFormatUsed());
        myClone.setScaleFactorExponent(this.getScaleFactorExponent());
        return myClone;
    }

    @Override
    public void merge(Mergeable from) {
        BaseViewFormat vf = null;
        try {
            vf = (BaseViewFormat)from;
        }
        catch (ClassCastException e) {
            return;
        }
        if (vf.getNumberConverter() != null) {
            if (vf.getNumberConverter() instanceof DvtNumberConverter) {
                this.setNumberConverter(((DvtNumberConverter)vf.getNumberConverter()).cloneDvtNumberConverter());
            } else {
                this.setNumberConverter(vf.getNumberConverter());
            }
            return;
        }
        this.m_bUseCallback = false;
        if (vf.getNumberFormatType() == 2) {
            this.initWithString(vf.getNumberFormatString(), vf.getNumberFormatType());
        }
        if (vf.isNumberTypeUsed()) {
            this.setNumberType(vf.getNumberType());
        }
        if (vf.isThousandSeparatorUsed()) {
            this.setThousandSeparator(vf.getThousandSeparator());
        }
        if (vf.isDecimalSeparatorUsed()) {
            this.setDecimalSeparator(vf.getDecimalSeparator());
        }
        if (vf.isCurrencySymbolUsed()) {
            this.setCurrencySymbol(vf.getCurrencySymbol());
        }
        if (vf.isLeadingZeroUsed()) {
            this.setLeadingZero(vf.isLeadingZero());
        }
        if (vf.isDecimalDigitUsed()) {
            this.setDecimalDigit(vf.getDecimalDigit());
        }
        if (vf.isPosNumFmtUsed()) {
            this.setPosNumFmt(vf.getPosNumFmt());
        }
        if (vf.isNegNumFmtUsed()) {
            this.setNegNumFmt(vf.getNegNumFmt());
        }
        if (vf.isPosCurFmtUsed()) {
            this.setPosCurFmt(vf.getPosCurFmt());
        }
        if (vf.isNegCurFmtUsed()) {
            this.setNegCurFmt(vf.getNegCurFmt());
        }
        if (vf.isScaleFactorUsed()) {
            this.setScaleFactor(vf.getScaleFactor());
        }
        if (vf.isScaleDownThousandsUsed()) {
            this.setScaleDownThousands(vf.getScaleDownThousands());
        }
        if (vf.isScaleDownMillionsUsed()) {
            this.setScaleDownMillions(vf.getScaleDownMillions());
        }
        if (vf.isScaleDownBillionsUsed()) {
            this.setScaleDownBillions(vf.getScaleDownBillions());
        }
        if (vf.isScaleDownTrillionsUsed()) {
            this.setScaleDownTrillions(vf.getScaleDownTrillions());
        }
        if (vf.isScaleDownQuadrillionsUsed()) {
            this.setScaleDownQuadrillions(vf.getScaleDownQuadrillions());
        }
        if (vf.isJavaDateFormatUsed()) {
            this.setJavaDateFormat(vf.getJavaDateFormat());
        }
        if (vf.isOracleDateFormatUsed()) {
            this.setOracleDateFormat(vf.getOracleDateFormat());
        }
        if (vf.isScaleFactorExponentUsed()) {
            this.setScaleFactorExponent(vf.getScaleFactorExponent());
        }
        if (vf.isISOCurrencyUsed()) {
            this.setISOCurrency(vf.isISOCurrency());
        }
        if (vf.isNegativeAngleBracketsUsed()) {
            this.setNegativeAngleBracketsUsed(vf.isNegativeAngleBracketsUsed());
        }
        if (vf.isNegPctFmtUsed()) {
            this.setNegPctFmt(vf.getNegPctFmt());
        }
        this.m_bUseCallback = true;
    }

    public boolean equals(Object o) {
        BaseViewFormat other;
        if (o == null) {
            return false;
        }
        try {
            other = (BaseViewFormat)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.m_formatUsedFlags.equals(other.m_formatUsedFlags)) {
            return false;
        }
        if (this.getNumberType() != other.getNumberType()) {
            return false;
        }
        if (this.getThousandSeparator() != other.getThousandSeparator()) {
            return false;
        }
        if (this.getDecimalSeparator() != other.getDecimalSeparator()) {
            return false;
        }
        if (!this.getCurrencySymbol().equals(other.getCurrencySymbol())) {
            return false;
        }
        if (this.isLeadingZero() != other.isLeadingZero()) {
            return false;
        }
        if (this.getDecimalDigit() != other.getDecimalDigit()) {
            return false;
        }
        if (this.getPosNumFmt() != other.getPosNumFmt()) {
            return false;
        }
        if (this.getNegNumFmt() != other.getNegNumFmt()) {
            return false;
        }
        if (this.getPosCurFmt() != other.getPosCurFmt()) {
            return false;
        }
        if (this.getNegCurFmt() != other.getNegCurFmt()) {
            return false;
        }
        if (this.getScaleFactor() != other.getScaleFactor()) {
            return false;
        }
        if (!this.getScaleDownThousands().equals(other.getScaleDownThousands())) {
            return false;
        }
        if (!this.getScaleDownMillions().equals(other.getScaleDownMillions())) {
            return false;
        }
        if (!this.getScaleDownBillions().equals(other.getScaleDownBillions())) {
            return false;
        }
        if (!this.getScaleDownTrillions().equals(other.getScaleDownTrillions())) {
            return false;
        }
        if (!this.getScaleDownQuadrillions().equals(other.getScaleDownQuadrillions())) {
            return false;
        }
        if (!this.getJavaDateFormat().equals(other.getJavaDateFormat())) {
            return false;
        }
        if (!this.getOracleDateFormat().equals(other.getOracleDateFormat())) {
            return false;
        }
        return this.getNegPctFmt() == other.getNegPctFmt();
    }

    public void initWithString(String strNumberFormatString, int nNumberFormatType) {
        if (this.validateFormatString(strNumberFormatString, nNumberFormatType)) {
            this.setNumberFormatType(nNumberFormatType);
            this.setNumberFormatString(new String(strNumberFormatString));
        }
    }

    public boolean validateFormatString(String strNumberFormatString, int nNumberFormatType) {
        boolean bResult = false;
        switch (nNumberFormatType) {
            case 0: {
                bResult = this.initNumberFormatOEO(strNumberFormatString);
                break;
            }
            case 1: 
            case 2: {
                bResult = this.initNumberFormatOracle(strNumberFormatString, nNumberFormatType);
            }
        }
        return bResult;
    }

    public void clearUsedBits() {
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public String toString() {
        return "[VIEW_FORMAT - " + this.m_formatUsedFlags.toString() + "]";
    }

    public String BooleanToString(boolean bValue) {
        Boolean bTemp = new Boolean(bValue);
        return bTemp.toString();
    }

    public String DateToString(Date dateValue) {
        String sDate = null;
        OracleDateFormat oOracleDateFmt = this.getOracleDateInstance();
        if (oOracleDateFmt.getFormatString() != "") {
            try {
                sDate = oOracleDateFmt.format(dateValue);
                return sDate;
            }
            catch (Exception e) {
                if (this._getErrorHandler() != null) {
                    this._getErrorHandler().log("fail to format the date to oracle date format", this.getClass().getName(), m_method_dateToString);
                }
                e.printStackTrace();
            }
        }
        SimpleDateFormat oDateFmt = this.getJavaDateInstance();
        try {
            sDate = oDateFmt.format(dateValue);
        }
        catch (Exception e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to format the date to java date format", this.getClass().getName(), m_method_dateToString);
            } else {
                e.printStackTrace();
            }
            sDate = this.getDefJavaDateInstance().format(dateValue);
        }
        return sDate;
    }

    public String UtilDateToString(java.util.Date dateValue) {
        String sDate = null;
        OracleDateFormat oOracleDateFmt = this.getOracleDateInstance();
        if (oOracleDateFmt.getFormatString() != "") {
            try {
                sDate = oOracleDateFmt.format(dateValue);
                return sDate;
            }
            catch (Exception e) {
                if (this._getErrorHandler() != null) {
                    this._getErrorHandler().log("fail to format the date to oracle date format", this.getClass().getName(), m_method_dateToString);
                }
                e.printStackTrace();
            }
        }
        SimpleDateFormat oDateFmt = this.getJavaDateInstance();
        try {
            sDate = oDateFmt.format(dateValue);
        }
        catch (Exception e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to format the date to java date format", this.getClass().getName(), m_method_dateToString);
            } else {
                e.printStackTrace();
            }
            sDate = this.getDefJavaDateInstance().format(dateValue);
        }
        return sDate;
    }

    public String DoubleToString(double dValue) {
        if (this.getNumberConverter() != null) {
            return this.getNumberConverter().getAsString(new Double(dValue));
        }
        NumberFormat NumFmt = this.getNumberFormatInstance();
        this.setTSeparator(NumFmt);
        this.setDecimal(NumFmt);
        int iSaveMinIntDig = NumFmt.getMinimumIntegerDigits();
        boolean bProcessedLZ = false;
        dValue /= this.getScaleValue();
        if (dValue < 1.0 && dValue > -1.0 && (this.m_iNumberType != 2 || dValue < 0.01 && dValue > -0.01)) {
            if (this.isLeadingZero()) {
                NumFmt.setMinimumIntegerDigits(1);
            } else {
                NumFmt.setMinimumIntegerDigits(0);
            }
            bProcessedLZ = true;
        }
        this.setPrefSuff(NumFmt);
        String sFmtString = NumFmt.format(dValue);
        if (bProcessedLZ) {
            NumFmt.setMinimumIntegerDigits(iSaveMinIntDig);
        }
        sFmtString = this.appendSFString(sFmtString);
        sFmtString = this.appendPercentString(sFmtString, NumFmt);
        return sFmtString;
    }

    public String FloatToString(float fValue) {
        NumberFormat NumFmt = this.getNumberFormatInstance();
        this.setTSeparator(NumFmt);
        this.setDecimal(NumFmt);
        int iSaveMinIntDig = NumFmt.getMinimumIntegerDigits();
        boolean bProcessedLZ = false;
        fValue = (float)((double)fValue / this.getScaleValue());
        if ((double)fValue < 1.0 && (double)fValue > -1.0 && (this.m_iNumberType != 2 || (double)fValue < 0.01 && (double)fValue > -0.01)) {
            if (this.isLeadingZero()) {
                NumFmt.setMinimumIntegerDigits(1);
            } else {
                NumFmt.setMinimumIntegerDigits(0);
            }
            bProcessedLZ = true;
        }
        this.setPrefSuff(NumFmt);
        String sFmtString = NumFmt.format(fValue);
        if (bProcessedLZ) {
            NumFmt.setMinimumIntegerDigits(iSaveMinIntDig);
        }
        sFmtString = this.appendSFString(sFmtString);
        sFmtString = this.appendPercentString(sFmtString, NumFmt);
        return sFmtString;
    }

    public String TimeToString(Time timeValue) {
        String sTime = null;
        OracleDateFormat oOracleDateFmt = this.getOracleDateInstance();
        if (oOracleDateFmt.getFormatString() != "") {
            try {
                sTime = oOracleDateFmt.format(timeValue);
                return sTime;
            }
            catch (Exception e) {
                if (this._getErrorHandler() != null) {
                    this._getErrorHandler().log("fail to format time to oracle date format", this.getClass().getName(), m_method_timeToString);
                }
                e.printStackTrace();
            }
        }
        SimpleDateFormat oDateFmt = this.getJavaDateInstance();
        try {
            sTime = oDateFmt.format(timeValue);
        }
        catch (Exception e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to format time to java date format", this.getClass().getName(), m_method_timeToString);
            } else {
                e.printStackTrace();
            }
            sTime = this.getDefJavaDateInstance().format(timeValue);
        }
        return sTime;
    }

    public String TimestampToString(Timestamp timeValue) {
        String sTime = null;
        OracleDateFormat oOracleDateFmt = this.getOracleDateInstance();
        if (oOracleDateFmt.getFormatString() != "") {
            try {
                sTime = oOracleDateFmt.format(timeValue);
                return sTime;
            }
            catch (Exception e) {
                if (this._getErrorHandler() != null) {
                    this._getErrorHandler().log("fail to format the timestamp to oracle date format", this.getClass().getName(), m_method_timestampToString);
                }
                e.printStackTrace();
            }
        }
        SimpleDateFormat oDateFmt = this.getJavaDateInstance();
        try {
            sTime = oDateFmt.format(timeValue);
        }
        catch (Exception e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to format the timestamp to java date format", this.getClass().getName(), m_method_timestampToString);
            } else {
                e.printStackTrace();
            }
            sTime = this.getDefJavaDateInstance().format(timeValue);
        }
        return sTime;
    }

    public String getCurrencySymbol() {
        return this.m_sCurrencySymbol;
    }

    public int getDecimalDigit() {
        if (this.m_numberConverter != null && this.m_numberConverter instanceof DvtNumberConverter) {
            return ((DvtNumberConverter)this.m_numberConverter).getFractionDigits();
        }
        return this.m_iDecimalDigit;
    }

    public String getJavaDateFormat() {
        return this.m_sJavaDateFormat;
    }

    public String getOracleDateFormat() {
        return this.m_sOracleDateFormat;
    }

    public char getDecimalSeparator() {
        return this.m_cDecimalSeparator;
    }

    public char getDecimalSeparatorSymbol() {
        if (this.getDecimalSeparator() == '0') {
            return this.m_cDecSepLoc;
        }
        return this.getDecimalSeparator();
    }

    public boolean isLeadingZero() {
        return this.m_bLeadingZero;
    }

    public int getNegCurFmt() {
        return this.m_iNegCurFmt;
    }

    public int getNegCurFmtValue() {
        if (this.getNegCurFmt() == 14) {
            return this.m_iNegCurFmtLoc;
        }
        return this.getNegCurFmt();
    }

    public int getNegNumFmt() {
        return this.m_iNegNumFmt;
    }

    public int getNegNumFmtValue() {
        if (this.getNegNumFmt() == 5) {
            return this.m_iNegNumFmtLoc;
        }
        return this.getNegNumFmt();
    }

    public int getNumberType() {
        if (this.getNumberConverter() != null && this.getNumberConverter() instanceof DvtNumberConverter) {
            return this.getViewFormatNumType(((DvtNumberConverter)this.getNumberConverter()).getType());
        }
        return this.m_iNumberType;
    }

    public int getPosCurFmt() {
        return this.m_iPosCurFmt;
    }

    public int getPosCurFmtValue() {
        if (this.getPosCurFmt() == 13) {
            return this.m_iPosCurFmtLoc;
        }
        return this.getPosCurFmt();
    }

    public int getPosNumFmt() {
        return this.m_iPosNumFmt;
    }

    public int getPosNumFmtValue() {
        if (this.getPosNumFmt() == 4) {
            return this.m_iPosNumFmtLoc;
        }
        return this.getPosNumFmt();
    }

    public String getScaleDownBillions() {
        return this.m_sScaleDownBillions;
    }

    public String getScaleDownBillionsSymbol() {
        if (this.getScaleDownBillions().equals("__sym_locale__")) {
            return this.m_sSDBillionsLoc;
        }
        return this.getScaleDownBillions();
    }

    public String getScaleDownMillions() {
        return this.m_sScaleDownMillions;
    }

    public String getScaleDownMillionsSymbol() {
        if (this.getScaleDownMillions().equals("__sym_locale__")) {
            return this.m_sSDMillionsLoc;
        }
        return this.getScaleDownMillions();
    }

    public String getScaleDownQuadrillions() {
        return this.m_sScaleDownQuadrillions;
    }

    public String getScaleDownQuadrillionsSymbol() {
        if (this.getScaleDownQuadrillions().equals("__sym_locale__")) {
            return this.m_sSDQuadrillionsLoc;
        }
        return this.getScaleDownQuadrillions();
    }

    public String getScaleDownThousands() {
        return this.m_sScaleDownThousands;
    }

    public String getScaleDownThousandsSymbol() {
        if (this.getScaleDownThousands().equals("__sym_locale__")) {
            return this.m_sSDThousandsLoc;
        }
        return this.getScaleDownThousands();
    }

    public String getScaleDownTrillions() {
        return this.m_sScaleDownTrillions;
    }

    public String getScaleDownTrillionsSymbol() {
        if (this.getScaleDownTrillions().equals("__sym_locale__")) {
            return this.m_sSDTrillionsLoc;
        }
        return this.getScaleDownTrillions();
    }

    public int getScaleFactor() {
        if (this.getNumberConverter() != null && this.getNumberConverter() instanceof DvtNumberConverter) {
            return this.convertScalingToScaleFactor(((DvtNumberConverter)this.getNumberConverter()).getScaling());
        }
        return this.m_iScaleFactor;
    }

    public int convertScalingToScaleFactor(String scaling) {
        int scaleFactor = scaling == null || scaling.equals("auto") ? 0 : BaseViewFormat.convertNonAutoScalingToScaleFactor(scaling);
        return scaleFactor;
    }

    public static int convertNonAutoScalingToScaleFactor(String scaling) {
        int scaleFactor = 0;
        if (scaling.equalsIgnoreCase("none")) {
            scaleFactor = 0;
        } else if (scaling.equalsIgnoreCase("thousand")) {
            scaleFactor = 1;
        } else if (scaling.equalsIgnoreCase("million")) {
            scaleFactor = 2;
        } else if (scaling.equalsIgnoreCase("billion")) {
            scaleFactor = 3;
        } else if (scaling.equalsIgnoreCase("trillion")) {
            scaleFactor = 4;
        } else if (scaling.equalsIgnoreCase("quadrillion")) {
            scaleFactor = 5;
        }
        return scaleFactor;
    }

    public String convertScaleFactorToScaling(boolean isScaleFactorUsed, int scaleFactor) {
        String scaling = null;
        if (!isScaleFactorUsed) {
            scaling = "auto";
        } else {
            switch (scaleFactor) {
                case 0: {
                    scaling = "none";
                    break;
                }
                case 1: {
                    scaling = "thousand";
                    break;
                }
                case 2: {
                    scaling = "million";
                    break;
                }
                case 3: {
                    scaling = "billion";
                    break;
                }
                case 4: {
                    scaling = "trillion";
                    break;
                }
                case 5: {
                    scaling = "quadrillion";
                }
            }
        }
        return scaling;
    }

    public char getThousandSeparator() {
        return this.m_cThousandSeparator;
    }

    public boolean getThousandSeparatorUsed() {
        return this.m_formatUsedFlags.get(1);
    }

    public char getThousandSeparatorSymbol() {
        if (this.getThousandSeparator() == '0') {
            return this.m_cThouSepLoc;
        }
        return this.getThousandSeparator();
    }

    public String IntToString(int iValue) {
        NumberFormat NumFmt = this.getNumberFormatInstance();
        this.setTSeparator(NumFmt);
        this.setDecimal(NumFmt);
        this.setPrefSuff(NumFmt);
        double scaledValue = Long.valueOf(String.valueOf(iValue)).doubleValue() / this.getScaleValue();
        String sFmtString = NumFmt.format(scaledValue);
        sFmtString = this.appendSFString(sFmtString);
        sFmtString = this.appendPercentString(sFmtString, NumFmt);
        return sFmtString;
    }

    public boolean isCurrencySymbolUsed() {
        return this.m_formatUsedFlags.get(3);
    }

    public boolean isDecimalDigitUsed() {
        if (this.m_numberConverter != null && this.m_numberConverter instanceof DvtNumberConverter) {
            String autoPrecision = ((DvtNumberConverter)this.m_numberConverter).getAutoPrecision();
            boolean autoPrecisionOff = autoPrecision != null && autoPrecision.equalsIgnoreCase(off);
            int fractionDigits = ((DvtNumberConverter)this.m_numberConverter).getFractionDigits();
            return fractionDigits != -1 || autoPrecisionOff;
        }
        return this.m_formatUsedFlags.get(5);
    }

    public boolean isOracleDateFormatUsed() {
        return this.m_formatUsedFlags.get(17);
    }

    public boolean isJavaDateFormatUsed() {
        return this.m_formatUsedFlags.get(16);
    }

    public boolean isDecimalSeparatorUsed() {
        return this.m_formatUsedFlags.get(2);
    }

    public boolean isLeadingZeroUsed() {
        return this.m_formatUsedFlags.get(4);
    }

    public boolean isNegCurFmtUsed() {
        return this.m_formatUsedFlags.get(9);
    }

    public boolean isNegNumFmtUsed() {
        return this.m_formatUsedFlags.get(7);
    }

    public boolean isNumberTypeUsed() {
        if (this.getNumberConverter() != null && this.getNumberConverter() instanceof DvtNumberConverter) {
            return false;
        }
        return this.m_formatUsedFlags.get(0);
    }

    public boolean isPosCurFmtUsed() {
        return this.m_formatUsedFlags.get(8);
    }

    public boolean isPosNumFmtUsed() {
        return this.m_formatUsedFlags.get(6);
    }

    public boolean isScaleDownBillionsUsed() {
        return this.m_formatUsedFlags.get(13);
    }

    public boolean isScaleDownMillionsUsed() {
        return this.m_formatUsedFlags.get(12);
    }

    public boolean isScaleDownQuadrillionsUsed() {
        return this.m_formatUsedFlags.get(15);
    }

    public boolean isScaleDownThousandsUsed() {
        return this.m_formatUsedFlags.get(11);
    }

    public boolean isScaleDownTrillionsUsed() {
        return this.m_formatUsedFlags.get(14);
    }

    public boolean isScaleFactorUsed() {
        if (this.m_numberConverter != null && this.m_numberConverter instanceof DvtNumberConverter) {
            String scaling = ((DvtNumberConverter)this.m_numberConverter).getScaling();
            return scaling != null && !scaling.equalsIgnoreCase("auto");
        }
        return this.m_formatUsedFlags.get(10);
    }

    public boolean isThousandSeparatorUsed() {
        return this.m_formatUsedFlags.get(1);
    }

    public String LongToString(long lValue) {
        NumberFormat NumFmt = this.getNumberFormatInstance();
        this.setTSeparator(NumFmt);
        this.setDecimal(NumFmt);
        this.setPrefSuff(NumFmt);
        double scaledValue = Double.valueOf(String.valueOf(lValue)) / this.getScaleValue();
        String sFmtString = NumFmt.format(scaledValue);
        sFmtString = this.appendSFString(sFmtString);
        sFmtString = this.appendPercentString(sFmtString, NumFmt);
        return sFmtString;
    }

    public String ObjectToString(Object objValue) {
        if (objValue instanceof Boolean) {
            return this.BooleanToString((Boolean)objValue);
        }
        if (objValue instanceof Double) {
            return this.DoubleToString((Double)objValue);
        }
        if (objValue instanceof Float) {
            return this.FloatToString(((Float)objValue).floatValue());
        }
        if (objValue instanceof Integer) {
            return this.IntToString((Integer)objValue);
        }
        if (objValue instanceof Long) {
            return this.LongToString((Long)objValue);
        }
        if (objValue instanceof Short) {
            return this.ShortToString((Short)objValue);
        }
        if (objValue instanceof Date) {
            return this.DateToString((Date)objValue);
        }
        if (objValue instanceof Time) {
            return this.TimeToString((Time)objValue);
        }
        if (objValue instanceof Timestamp) {
            return this.TimestampToString((Timestamp)objValue);
        }
        if (objValue instanceof java.util.Date) {
            return this.UtilDateToString((java.util.Date)objValue);
        }
        if (objValue instanceof String) {
            return this.StringToString((String)objValue);
        }
        if (objValue instanceof java.util.Date) {
            long time = ((java.util.Date)objValue).getTime();
            Timestamp timestamp = new Timestamp(time);
            return this.TimestampToString(timestamp);
        }
        if (objValue != null) {
            return objValue.toString();
        }
        return "";
    }

    public void setCurrencySymbol(String sCurrencySymbol) {
        if (sCurrencySymbol == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid Currency Symbol", this.getClass().toString(), m_method_setCurrencySymbol);
            }
            return;
        }
        this.setCurrencySymbolUsed(true);
        this.setISOCurrency(false);
        if (this.m_sCurrencySymbol != sCurrencySymbol) {
            String oldVal = this.m_sCurrencySymbol;
            this.m_sCurrencySymbol = sCurrencySymbol;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(0, "CurrencySymbol", oldVal, sCurrencySymbol);
            }
        }
    }

    public void setCurrencySymbolUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(3);
        } else {
            this.m_formatUsedFlags.clear(3);
        }
    }

    public void setDecimalDigit(int iDecimalDigit) {
        if (this.m_numberConverter != null && this.m_numberConverter instanceof DvtNumberConverter) {
            ((DvtNumberConverter)this.m_numberConverter).setFractionDigits(iDecimalDigit);
        } else {
            this.setDecimalDigitUsed(true);
            if (this.m_iDecimalDigit != iDecimalDigit) {
                int oldVal = this.m_iDecimalDigit;
                this.m_iDecimalDigit = iDecimalDigit;
                if (this.m_bUseCallback && this.m_vfCallback != null) {
                    this.m_vfCallback.formatChanged(2, "DecimalDigit", new Integer(oldVal), new Integer(iDecimalDigit));
                }
            }
        }
    }

    public void setDecimalDigitUsed(boolean bValue) {
        if (this.m_numberConverter != null && this.m_numberConverter instanceof DvtNumberConverter) {
            ((DvtNumberConverter)this.m_numberConverter).setFractionDigits(-1);
        } else if (bValue) {
            this.m_formatUsedFlags.set(5);
        } else {
            this.m_formatUsedFlags.clear(5);
        }
    }

    public void setJavaDateFormat(String sDateFormat) {
        if (sDateFormat == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid Java Date Format", this.getClass().toString(), m_method_setJavaDateFormat);
            }
            return;
        }
        boolean wasUsed = this.isJavaDateFormatUsed();
        this.setJavaDateFormatUsed(true);
        if (this.m_sJavaDateFormat != sDateFormat) {
            String oldVal = this.m_sJavaDateFormat;
            this.m_sJavaDateFormat = sDateFormat;
            if (sDateFormat != null && sDateFormat.length() > 0) {
                this.getJavaDateInstance().applyPattern(sDateFormat);
            } else if (wasUsed) {
                this.m_oJavaDateInstance = (SimpleDateFormat)this.getDefJavaDateInstance().clone();
            }
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(1, "JavaDateFormat", oldVal, sDateFormat);
            }
        }
    }

    public void setOracleDateFormat(String sDateFormat) {
        if (sDateFormat == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid Oracle Date Format", this.getClass().toString(), m_method_setOracleDateFormat);
            }
            return;
        }
        boolean wasUsed = this.isOracleDateFormatUsed();
        this.setOracleDateFormatUsed(true);
        if (this.m_sOracleDateFormat != sDateFormat) {
            String oldVal = this.m_sOracleDateFormat;
            this.m_sOracleDateFormat = sDateFormat;
            if (sDateFormat != null && sDateFormat.length() > 0) {
                this.getOracleDateInstance().setFormatString(sDateFormat);
                if (this.m_sOracleDateFormat != this.getOracleDateInstance().getFormatString()) {
                    this.m_sOracleDateFormat = oldVal;
                }
            } else if (wasUsed) {
                this.m_oOracleDateInstance = (OracleDateFormat)this.getDefOracleDateInstance().clone();
            }
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(17, "OracleDateFormat", oldVal, sDateFormat);
            }
        }
    }

    public void setJavaDateFormatUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(16);
        } else {
            this.m_formatUsedFlags.clear(16);
        }
    }

    public void setOracleDateFormatUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(17);
        } else {
            this.m_formatUsedFlags.clear(17);
        }
    }

    public void setDecimalSeparator(char cDecimalSeparator) {
        this.setDecimalSeparatorUsed(true);
        if (this.m_cDecimalSeparator != cDecimalSeparator) {
            char oldVal = this.m_cDecimalSeparator;
            this.m_cDecimalSeparator = cDecimalSeparator;
            if (!this.m_initOracle) {
                this.m_oNumberInstance = null;
                this.m_oCurrencyInstance = null;
                this.m_oPercentInstance = null;
            }
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(3, "DecimalSeparator", new Character(oldVal), new Character(cDecimalSeparator));
            }
        }
    }

    public void setDecimalSeparatorUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(2);
        } else {
            this.m_formatUsedFlags.clear(2);
        }
    }

    public void setLeadingZero(boolean bLeadingZero) {
        this.setLeadingZeroUsed(true);
        if (this.m_bLeadingZero != bLeadingZero) {
            boolean oldVal = this.m_bLeadingZero;
            this.m_bLeadingZero = bLeadingZero;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(4, "LeadingZero", new Boolean(oldVal), new Boolean(bLeadingZero));
            }
        }
    }

    public void setLeadingZeroUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(4);
        } else {
            this.m_formatUsedFlags.clear(4);
        }
    }

    public void setNegCurFmt(int iNegCurFmt) {
        this.setNegCurFmtUsed(true);
        if (this.m_iNegCurFmt != iNegCurFmt) {
            int oldVal = this.m_iNegCurFmt;
            this.m_iNegCurFmt = iNegCurFmt > 14 || iNegCurFmt < 0 ? 14 : iNegCurFmt;
            if (!this.m_initOracle) {
                this.m_oNumberInstance = null;
                this.m_oCurrencyInstance = null;
                this.m_oPercentInstance = null;
            }
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(5, "NegCurFmt", new Integer(oldVal), new Integer(iNegCurFmt));
            }
        }
    }

    public void setNegCurFmtUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(9);
        } else {
            this.m_formatUsedFlags.clear(9);
            this.m_oCurrencyInstance = null;
        }
    }

    public void setNegNumFmt(int iNegNumFmt) {
        this.setNegNumFmtUsed(true);
        if (this.m_iNegNumFmt != iNegNumFmt) {
            int oldVal = this.m_iNegNumFmt;
            this.m_iNegNumFmt = iNegNumFmt > 5 || iNegNumFmt < 0 ? 5 : iNegNumFmt;
            if (!this.m_initOracle) {
                this.m_oNumberInstance = null;
                this.m_oCurrencyInstance = null;
                this.m_oPercentInstance = null;
            }
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(6, "NegNumFmt", new Integer(oldVal), new Integer(iNegNumFmt));
            }
        }
    }

    public void setNegNumFmtUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(7);
        } else {
            this.m_formatUsedFlags.clear(7);
            this.m_oNumberInstance = null;
        }
    }

    public void setNumberType(int iNumberType) {
        if (this.getNumberConverter() != null && this.getNumberConverter() instanceof DvtNumberConverter) {
            ((DvtNumberConverter)this.getNumberConverter()).setType(this.getConverterNumType(iNumberType));
        } else {
            this.setNumberTypeUsed(true);
            if (this.m_iNumberType != iNumberType) {
                int oldVal = this.m_iNumberType;
                this.m_iNumberType = iNumberType < 0 || iNumberType > 3 ? 0 : iNumberType;
                if (this.m_bUseCallback && this.m_vfCallback != null) {
                    this.m_vfCallback.formatChanged(7, "NumberType", new Integer(oldVal), new Integer(iNumberType));
                }
            }
        }
    }

    public void setNumberTypeUsed(boolean bValue) {
        if (this.getNumberConverter() != null && this.getNumberConverter() instanceof DvtNumberConverter) {
            ((DvtNumberConverter)this.getNumberConverter()).setTypeUsed(bValue);
        } else if (bValue) {
            this.m_formatUsedFlags.set(0);
        } else {
            this.m_formatUsedFlags.clear(0);
        }
    }

    public void setPosCurFmt(int iPosCurFmt) {
        this.setPosCurFmtUsed(true);
        if (this.m_iPosCurFmt != iPosCurFmt) {
            int oldVal = this.m_iPosCurFmt;
            this.m_iPosCurFmt = iPosCurFmt > 13 || iPosCurFmt < 0 ? 13 : iPosCurFmt;
            if (!this.m_initOracle) {
                this.m_oNumberInstance = null;
                this.m_oCurrencyInstance = null;
                this.m_oPercentInstance = null;
            }
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(8, "PosCurFmt", new Integer(oldVal), new Integer(iPosCurFmt));
            }
        }
    }

    public void setPosCurFmtUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(8);
        } else {
            this.m_formatUsedFlags.clear(8);
            this.m_oCurrencyInstance = null;
        }
    }

    public void setPosNumFmt(int iPosNumFmt) {
        this.setPosNumFmtUsed(true);
        if (this.m_iPosNumFmt != iPosNumFmt) {
            int oldVal = this.m_iPosNumFmt;
            this.m_iPosNumFmt = iPosNumFmt > 4 || iPosNumFmt < 0 ? 4 : iPosNumFmt;
            if (!this.m_initOracle) {
                this.m_oNumberInstance = null;
                this.m_oCurrencyInstance = null;
                this.m_oPercentInstance = null;
            }
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(9, "PosNumFmt", new Integer(oldVal), new Integer(iPosNumFmt));
            }
        }
    }

    public void setPosNumFmtUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(6);
        } else {
            this.m_formatUsedFlags.clear(6);
            this.m_oNumberInstance = null;
        }
    }

    public void setScaleDownBillions(String sValue) {
        if (sValue == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid value for ScaleDownBillions", this.getClass().toString(), m_method_setScaleDownBillions);
            }
            return;
        }
        this.setScaleDownBillionsUsed(true);
        if (this.m_sScaleDownBillions != sValue) {
            String oldVal = this.m_sScaleDownBillions;
            this.m_sScaleDownBillions = sValue;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(10, "ScaleDownBillions", oldVal, sValue);
            }
        }
    }

    public void setScaleDownBillionsUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(13);
        } else {
            this.m_formatUsedFlags.clear(13);
        }
    }

    public void setScaleDownMillions(String sValue) {
        if (sValue == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid value for ScaleDownMillions", this.getClass().toString(), m_method_setScaleDownMillions);
            }
            return;
        }
        this.setScaleDownMillionsUsed(true);
        if (this.m_sScaleDownMillions != sValue) {
            String oldVal = this.m_sScaleDownMillions;
            this.m_sScaleDownMillions = sValue;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(11, "ScaleDownMillions", oldVal, sValue);
            }
        }
    }

    public void setScaleDownMillionsUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(12);
        } else {
            this.m_formatUsedFlags.clear(12);
        }
    }

    public void setScaleDownQuadrillions(String sValue) {
        if (sValue == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid value for ScaleDownQuadrillions", this.getClass().toString(), m_method_setScaleDownQuadrillions);
            }
            return;
        }
        this.setScaleDownQuadrillionsUsed(true);
        if (this.m_sScaleDownQuadrillions != sValue) {
            String oldVal = this.m_sScaleDownQuadrillions;
            this.m_sScaleDownQuadrillions = sValue;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(12, "ScaleDownQuadrillions", oldVal, sValue);
            }
        }
    }

    public void setScaleDownQuadrillionsUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(15);
        } else {
            this.m_formatUsedFlags.clear(15);
        }
    }

    public void setScaleDownThousands(String sValue) {
        if (sValue == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid value for ScaleDownThousands", this.getClass().toString(), m_method_setScaleDownThousands);
            }
            return;
        }
        this.setScaleDownThousandsUsed(true);
        if (this.m_sScaleDownThousands != sValue) {
            String oldVal = this.m_sScaleDownThousands;
            this.m_sScaleDownThousands = sValue;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(13, "ScaleDownThousands", oldVal, sValue);
            }
        }
    }

    public void setScaleDownThousandsUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(11);
        } else {
            this.m_formatUsedFlags.clear(11);
        }
    }

    public void setScaleDownTrillions(String sValue) {
        if (sValue == null) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid value for ScaleDownTrillions", this.getClass().toString(), m_method_setScaleDownTrillions);
            }
            return;
        }
        this.setScaleDownTrillionsUsed(true);
        if (this.m_sScaleDownTrillions != sValue) {
            String oldVal = this.m_sScaleDownTrillions;
            this.m_sScaleDownTrillions = sValue;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(14, "ScaleDownTrillions", oldVal, sValue);
            }
        }
    }

    public void setScaleDownTrillionsUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(14);
        } else {
            this.m_formatUsedFlags.clear(14);
        }
    }

    public void setScaleFactor(int iScaleFactor) {
        if (this.m_numberConverter != null && this.m_numberConverter instanceof DvtNumberConverter) {
            ((DvtNumberConverter)this.getNumberConverter()).setScaling(this.convertScaleFactorToScaling(true, iScaleFactor));
        } else {
            boolean oldScaleFactorUsed = this.isScaleFactorUsed();
            this.setScaleFactorUsed(true);
            if (this.m_iScaleFactor != iScaleFactor || !oldScaleFactorUsed) {
                if (iScaleFactor > 6 || iScaleFactor < 0) {
                    if (this._getErrorHandler() != null) {
                        this._getErrorHandler().log("Invalid scale factor", this.getClass().getName(), m_method_setScaleFactor);
                    } else {
                        System.out.println("Invalid scale factor in: " + this.getClass().getName() + "::" + m_method_setScaleFactor);
                    }
                    return;
                }
                int oldVal = this.m_iScaleFactor;
                this.m_iScaleFactor = iScaleFactor;
                if (this.m_bUseCallback && this.m_vfCallback != null) {
                    this.m_vfCallback.formatChanged(15, "ScaleFactor", new Integer(oldVal), new Integer(iScaleFactor));
                }
            }
        }
    }

    public void setScaleFactorUsed(boolean bValue) {
        if (this.m_numberConverter != null && this.m_numberConverter instanceof DvtNumberConverter) {
            if (!bValue) {
                ((DvtNumberConverter)this.m_numberConverter).setScaling("auto");
            }
        } else if (bValue) {
            this.m_formatUsedFlags.set(10);
        } else {
            this.m_formatUsedFlags.clear(10);
        }
    }

    public void setThousandSeparator(char cThousandSeparator) {
        this.setThousandSeparatorUsed(true);
        if (this.m_cThousandSeparator != cThousandSeparator) {
            char oldVal = this.m_cThousandSeparator;
            if (!this.m_initOracle) {
                this.m_oNumberInstance = null;
                this.m_oCurrencyInstance = null;
                this.m_oPercentInstance = null;
            }
            this.m_cThousandSeparator = cThousandSeparator;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(16, "ThousandSeparator", new Character(oldVal), new Character(cThousandSeparator));
            }
        }
    }

    public void setThousandSeparatorUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(1);
        } else {
            this.m_formatUsedFlags.clear(1);
        }
    }

    public String ShortToString(short sValue) {
        NumberFormat NumFmt = this.getNumberFormatInstance();
        this.setTSeparator(NumFmt);
        this.setDecimal(NumFmt);
        this.setPrefSuff(NumFmt);
        double scaledValue = Long.valueOf(String.valueOf(sValue)).doubleValue() / this.getScaleValue();
        String sFmtString = NumFmt.format(scaledValue);
        sFmtString = this.appendSFString(sFmtString);
        sFmtString = this.appendPercentString(sFmtString, NumFmt);
        return sFmtString;
    }

    public Boolean StringToBoolean(String sValue) {
        Boolean oBool = new Boolean(sValue);
        return oBool;
    }

    public Date StringToDate(String sValue) {
        return this.StringToDate(sValue, true);
    }

    public Date StringToDate(String sValue, boolean dynamic) {
        Date oDate = null;
        try {
            OracleDateFormat oracleFmt = this.getOracleDateInstance();
            if (oracleFmt.getFormatString() != "") {
                oDate = new Date(oracleFmt.parse(sValue, dynamic).getTime());
            } else {
                SimpleDateFormat dateFmt = this.getJavaDateInstance();
                oDate = new Date(dateFmt.parse(sValue).getTime());
            }
        }
        catch (ParseException e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to parse string to date", this.getClass().getName(), m_method_stringToDate);
            }
            e.printStackTrace();
        }
        return oDate;
    }

    public java.util.Date StringToUtilDate(String sValue) {
        java.util.Date oDate = null;
        try {
            OracleDateFormat oracleFmt = this.getOracleDateInstance();
            if (oracleFmt.getFormatString() != "") {
                oDate = new java.util.Date(oracleFmt.parse(sValue, true).getTime());
            } else {
                SimpleDateFormat dateFmt = this.getJavaDateInstance();
                oDate = new java.util.Date(dateFmt.parse(sValue).getTime());
            }
        }
        catch (ParseException e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to parse string to date", this.getClass().getName(), m_method_stringToDate);
            }
            e.printStackTrace();
        }
        return oDate;
    }

    public double StringToDouble(String sValue) throws ParseException {
        double dValue = 0.0;
        sValue = this.removeSFString(sValue);
        NumberFormat NumFmt = this.getNumberFormatInstance();
        Number oNum = NumFmt.parse(sValue);
        dValue = oNum.doubleValue();
        return dValue *= this.getScaleValue();
    }

    public float StringToFloat(String sValue) throws ParseException {
        float fValue = 0.0f;
        sValue = this.removeSFString(sValue);
        NumberFormat NumFmt = this.getNumberFormatInstance();
        Number oNum = NumFmt.parse(sValue);
        fValue = oNum.floatValue();
        fValue = (float)((double)fValue * this.getScaleValue());
        return fValue;
    }

    public int StringToInt(String sValue) throws ParseException {
        int iValue = 0;
        sValue = this.removeSFString(sValue);
        NumberFormat NumFmt = this.getNumberFormatInstance();
        Number oNum = NumFmt.parse(sValue);
        iValue = oNum.intValue();
        iValue = (int)((double)iValue * this.getScaleValue());
        return iValue;
    }

    public long StringToLong(String sValue) throws ParseException {
        long lValue = 0L;
        sValue = this.removeSFString(sValue);
        NumberFormat NumFmt = this.getNumberFormatInstance();
        Number oNum = NumFmt.parse(sValue);
        lValue = oNum.longValue();
        lValue = (long)((double)lValue * this.getScaleValue());
        return lValue;
    }

    public Object StringToObject(String sValue, int iDataType) {
        Object oObj = null;
        if (iDataType > 11 || iDataType < 1) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("invalid data type", this.getClass().getName(), m_method_stringToObject);
            } else {
                System.out.println("invalid data type in " + this.getClass().getName() + "::" + m_method_stringToObject);
            }
            return oObj;
        }
        switch (iDataType) {
            case 1: {
                oObj = this.StringToBoolean(sValue);
                break;
            }
            case 2: {
                try {
                    short shValue = this.StringToShort(sValue);
                    Short sObj = new Short(shValue);
                    oObj = sObj;
                }
                catch (ParseException e) {
                    if (this._getErrorHandler() != null) {
                        this._getErrorHandler().log("fail to parse string to DATATYPE_SHORT", this.getClass().getName(), m_method_stringToObject);
                        break;
                    }
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    int iValue = this.StringToInt(sValue);
                    Integer iObj = new Integer(iValue);
                    oObj = iObj;
                }
                catch (ParseException e) {
                    if (this._getErrorHandler() != null) {
                        this._getErrorHandler().log("fail to parse string to DATATYPE_INT", this.getClass().getName(), m_method_stringToObject);
                        break;
                    }
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    long lValue = this.StringToLong(sValue);
                    Long lObj = new Long(lValue);
                    oObj = lObj;
                }
                catch (ParseException e) {
                    if (this._getErrorHandler() != null) {
                        this._getErrorHandler().log("fail to parse string to DATATYPE_LONG", this.getClass().getName(), m_method_stringToObject);
                        break;
                    }
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    double dValue = this.StringToDouble(sValue);
                    Double dObj = new Double(dValue);
                    oObj = dObj;
                }
                catch (ParseException e) {
                    if (this._getErrorHandler() != null) {
                        this._getErrorHandler().log("fail to parse string to DATATYPE_DOUBLE", this.getClass().getName(), m_method_stringToObject);
                        break;
                    }
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                try {
                    float fValue = this.StringToFloat(sValue);
                    Float fObj = new Float(fValue);
                    oObj = fObj;
                }
                catch (ParseException e) {
                    if (this._getErrorHandler() != null) {
                        this._getErrorHandler().log("fail to parse string to DATATYPE_FLOAT", this.getClass().getName(), m_method_stringToObject);
                        break;
                    }
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                oObj = this.StringToDate(sValue);
                break;
            }
            case 7: {
                oObj = this.StringToString(sValue);
                break;
            }
            case 10: {
                oObj = this.StringToTime(sValue);
                break;
            }
            case 11: {
                oObj = this.StringToTimestamp(sValue);
                break;
            }
            default: {
                oObj = null;
            }
        }
        return oObj;
    }

    public short StringToShort(String sValue) throws ParseException {
        short shValue = 0;
        sValue = this.removeSFString(sValue);
        NumberFormat NumFmt = this.getNumberFormatInstance();
        Number oNum = NumFmt.parse(sValue);
        shValue = oNum.shortValue();
        shValue = (short)((double)shValue * this.getScaleValue());
        return shValue;
    }

    public String StringToString(String sValue) {
        Date date = this.StringToDate(sValue);
        return ((java.util.Date)date).toString();
    }

    public Time StringToTime(String sValue) {
        Time oTime = null;
        try {
            OracleDateFormat oracleFmt = this.getOracleDateInstance();
            if (oracleFmt.getFormatString() != "") {
                oTime = new Time(oracleFmt.parse(sValue).getTime());
            } else {
                SimpleDateFormat dateFmt = this.getJavaDateInstance();
                oTime = new Time(dateFmt.parse(sValue).getTime());
            }
        }
        catch (ParseException e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to parse string to time", this.getClass().getName(), m_method_stringToTime);
            }
            e.printStackTrace();
        }
        return oTime;
    }

    public Timestamp StringToTimestamp(String sValue) {
        Timestamp oTime = null;
        try {
            OracleDateFormat oracleFmt = this.getOracleDateInstance();
            if (oracleFmt.getFormatString() != "") {
                oTime = new Timestamp(oracleFmt.parse(sValue).getTime());
            } else {
                SimpleDateFormat dateFmt = this.getJavaDateInstance();
                oTime = new Timestamp(dateFmt.parse(sValue).getTime());
            }
        }
        catch (ParseException e) {
            if (this._getErrorHandler() != null) {
                this._getErrorHandler().log("fail to parse string to timestamp", this.getClass().getName(), m_method_stringToTimestamp);
            }
            e.printStackTrace();
        }
        return oTime;
    }

    public void setViewFormatCallback(BaseViewFormatCallback vfc) {
        this.m_vfCallback = vfc;
    }

    public void setLocale(Locale loc) {
        this.setLocale(loc, false);
    }

    protected void setLocale(Locale loc, boolean setAlways) {
        if (!setAlways && (this.m_locale != null && this.m_locale.equals(loc) || this.m_locale == null && loc == null)) {
            return;
        }
        this.m_locale = LocaleUtils.getLocaleWithCountry((Locale)loc);
        this.m_locale = loc;
        this.m_oNumberInstance = null;
        this.m_oCurrencyInstance = null;
        this.m_oCurrencySymbol = null;
        this.m_oPercentInstance = null;
        this.m_oJavaDateInstance = null;
        this.m_oOracleDateInstance = null;
        this.updateDefaultSymbols();
        this.m_iPosNumFmtLoc = this._getDefPosNumFmt();
        this.m_iNegNumFmtLoc = this._getDefNegNumFmt();
        this.m_iPosCurFmtLoc = this._getDefPosCurFmt();
        this.m_iNegCurFmtLoc = this._getDefNegCurFmt();
        ResourceBundle resourceBundle = this._getResourceBundle(loc);
        if (resourceBundle != null) {
            if (!this.isCurrencySymbolUsed()) {
                this.updateDefaultCurrencySymbol();
            }
            this.m_sSDThousandsLoc = resourceBundle.getString("K");
            this.m_sSDMillionsLoc = resourceBundle.getString("M");
            this.m_sSDBillionsLoc = resourceBundle.getString("B");
            this.m_sSDTrillionsLoc = resourceBundle.getString("T");
            this.m_sSDQuadrillionsLoc = resourceBundle.getString("Q");
            this.m_true_str = resourceBundle.getString("true");
            this.m_false_str = resourceBundle.getString("false");
        }
    }

    public void updateDefaultSymbols() {
        char c;
        Object numberGroupingSeparator;
        char c2;
        this.m_cThouSepLoc = this.getDefDecimalFormatSymbols().getGroupingSeparator();
        this.m_cDecSepLoc = this.getDefDecimalFormatSymbols().getDecimalSeparator();
        Object decimalSeparator = this.getExternalDefault(a_decimalSeparator);
        if (decimalSeparator != null && decimalSeparator instanceof Character && (c2 = ((Character)decimalSeparator).charValue()) != '\u0000') {
            this.m_cDecSepLoc = c2;
        }
        if ((numberGroupingSeparator = this.getExternalDefault("numberGroupingSeparator")) != null && numberGroupingSeparator instanceof Character && (c = ((Character)numberGroupingSeparator).charValue()) != '\u0000') {
            this.m_cThouSepLoc = c;
        }
    }

    public void updateDefaultCurrencySymbol() {
        this.m_sCurrencySymbol = this.getDefDecimalFormatSymbols().getCurrencySymbol();
        Object currencyCode = this.getExternalDefault("currencyCode");
        if (currencyCode != null && currencyCode instanceof String) {
            Currency currency = Currency.getInstance((String)currencyCode);
            Locale loc = this.m_locale;
            if (loc == null) {
                loc = Locale.getDefault();
            }
            this.m_sCurrencySymbol = currency.getSymbol(loc);
        }
    }

    protected Object getExternalDefault(String attributeName) {
        return null;
    }

    private Object invokeNoArgumentMethod(Object obj, String methodName) throws Exception {
        Class<?> c = obj.getClass();
        Class[] partypes = new Class[]{};
        Object[] arglist = new Object[]{};
        Method method = c.getMethod(methodName, partypes);
        Object returnedValue = method.invoke(obj, arglist);
        return returnedValue;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    private ResourceBundle _getResourceBundle(Locale loc) {
        ResourceBundle resourceBundle = null;
        resourceBundle = loc != null ? ResourceBundle.getBundle(m_UtilBundle, loc) : ResourceBundle.getBundle(m_UtilBundle);
        return resourceBundle;
    }

    public void setTimeZone(TimeZone tz) {
        this.m_timeZone = tz;
        this.m_oOracleDateInstance = null;
    }

    public TimeZone getTimeZone() {
        return this.m_timeZone;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
        if (this.m_oOracleDateInstance != null) {
            this.m_oOracleDateInstance.setErrorHandler(this.m_eh);
        }
    }

    public String booleanToLocString(Boolean bValue) {
        if (bValue.booleanValue()) {
            return this.m_true_str;
        }
        return this.m_false_str;
    }

    public Boolean locStringToBoolean(String sValue) {
        String strTrue = null;
        String strValue = null;
        if (this.getLocale() != null) {
            strTrue = this.m_true_str.toUpperCase(this.getLocale());
            strValue = sValue.toUpperCase(this.getLocale());
        } else {
            strTrue = this.m_true_str.toUpperCase();
            strValue = sValue.toUpperCase();
        }
        if (strValue.equals(strTrue)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getNumberFormatString(int nNumberFormatType) {
        String strNumberFormat = null;
        switch (nNumberFormatType) {
            case 0: {
                strNumberFormat = this.getNumberFormatStringOEO();
                break;
            }
            case 1: 
            case 2: {
                strNumberFormat = this.getNumberFormatStringOracle(nNumberFormatType);
                break;
            }
        }
        return strNumberFormat;
    }

    public int setNumberFormatType(int nNumberFormatType) {
        switch (nNumberFormatType) {
            case 0: 
            case 1: 
            case 2: {
                this.m_nNumberFormatType = nNumberFormatType;
                break;
            }
        }
        return nNumberFormatType;
    }

    public int getNumberFormatType() {
        return this.m_nNumberFormatType;
    }

    public void setNumberFormatString(String strNumberFormatString) {
        this.m_strNumberFormatString = strNumberFormatString;
    }

    public String getNumberFormatString() {
        return this.m_strNumberFormatString;
    }

    public void setScaleFactorExponent(int nScaleFactorExponent) {
        boolean bOldScaleFactorExponentUsed = this.isScaleFactorExponentUsed();
        this.setScaleFactorExponentUsed(true);
        if (this.m_nScaleFactorExponent != nScaleFactorExponent || !bOldScaleFactorExponentUsed) {
            int nScaleFactorExponentOld = this.m_nScaleFactorExponent;
            this.m_nScaleFactorExponent = nScaleFactorExponent;
            if (this.m_bUseCallback && this.m_vfCallback != null) {
                this.m_vfCallback.formatChanged(18, "ScaleFactorExponent", new Double(nScaleFactorExponentOld), new Double(nScaleFactorExponent));
            }
        }
    }

    public int getScaleFactorExponent() {
        return this.m_nScaleFactorExponent;
    }

    private boolean initNumberFormatOEO(String strNumberFormatString) {
        this.m_bUseCallback = false;
        this.clearUsedBits();
        StringTokenizer t = new StringTokenizer(strNumberFormatString, ";", true);
        try {
            String nextClause;
            String negativeFormat;
            String positiveFormat;
            String numberFormat = t.nextToken().trim();
            if (!numberFormat.equals(";")) {
                this.initNumberFormat(numberFormat);
                if (!t.nextToken().equals(";")) {
                    throw new NoSuchElementException();
                }
            }
            if (!(positiveFormat = t.nextToken().trim()).equals(";")) {
                this.initPositiveFormat(positiveFormat);
                if (!t.nextToken().equals(";")) {
                    throw new NoSuchElementException();
                }
            }
            if (!(negativeFormat = t.nextToken().trim()).equals(";")) {
                this.initNegativeFormat(negativeFormat);
                if (!t.nextToken().equals(";")) {
                    throw new NoSuchElementException();
                }
            }
            if ((nextClause = t.nextToken().trim()).equals(";")) {
                nextClause = t.nextToken();
            }
            if (this.isCharsToUseClause(nextClause)) {
                nextClause = this.initCharsToUse(nextClause, t);
                this.initScaleClause(nextClause);
            } else {
                this.initScaleClause(nextClause);
                this.initCharsToUse(nextClause, t);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.m_bUseCallback = true;
        return true;
    }

    private void initScaleFactor(int nScaleFactor, boolean bUseScalingString) {
        switch (nScaleFactor) {
            case 0: {
                this.setScaleFactor(0);
                break;
            }
            case -3: {
                this.setScaleFactor(1);
                if (!bUseScalingString) {
                    this.setScaleDownThousands("");
                    break;
                }
                this.setScaleDownThousands("__sym_locale__");
                break;
            }
            case -6: {
                this.setScaleFactor(2);
                if (!bUseScalingString) {
                    this.setScaleDownMillions("");
                    break;
                }
                this.setScaleDownMillions("__sym_locale__");
                break;
            }
            case -9: {
                this.setScaleFactor(3);
                if (!bUseScalingString) {
                    this.setScaleDownBillions("");
                    break;
                }
                this.setScaleDownBillions("__sym_locale__");
                break;
            }
            case -12: {
                this.setScaleFactor(4);
                if (!bUseScalingString) {
                    this.setScaleDownTrillions("");
                    break;
                }
                this.setScaleDownTrillions("__sym_locale__");
                break;
            }
            case -15: {
                this.setScaleFactor(5);
                if (!bUseScalingString) {
                    this.setScaleDownQuadrillions("");
                    break;
                }
                this.setScaleDownQuadrillions("__sym_locale__");
                break;
            }
        }
    }

    private String processScalingToken(String strNumberFormatString, int nNumberFormatType) throws ParseException {
        boolean bUseScalingCharacter = false;
        int nExponent = 0;
        if (strNumberFormatString != null && strNumberFormatString.length() > 0) {
            if (strNumberFormatString.startsWith("VC-")) {
                if (nNumberFormatType != 2) {
                    return strNumberFormatString;
                }
                nExponent = -1;
                strNumberFormatString = strNumberFormatString.substring(3);
                bUseScalingCharacter = true;
            } else if (strNumberFormatString.startsWith("V-")) {
                if (nNumberFormatType != 2) {
                    return strNumberFormatString;
                }
                nExponent = -1;
                strNumberFormatString = strNumberFormatString.substring(2);
            } else if (strNumberFormatString.startsWith("V")) {
                if (nNumberFormatType != 2 && nNumberFormatType != 1) {
                    return strNumberFormatString;
                }
                nExponent = 1;
                strNumberFormatString = strNumberFormatString.substring(1);
            } else {
                return strNumberFormatString;
            }
        }
        if (nExponent != 0) {
            int nCount;
            String strTemp = strNumberFormatString;
            for (nCount = 0; nCount < strTemp.length() && (strTemp.charAt(nCount) == '0' || strTemp.charAt(nCount) == '9' || strTemp.charAt(nCount) == '*'); ++nCount) {
                strNumberFormatString = strNumberFormatString.substring(1);
            }
            nExponent *= nCount;
        }
        this.setScaleFactorExponent(nExponent);
        this.setScaleFactor(6);
        this.initScaleFactor(nExponent, bUseScalingCharacter);
        return strNumberFormatString;
    }

    private String processCurrencyToken(String strNumberFormatString, int nNumberFormatType) throws ParseException {
        if (nNumberFormatType != 2) {
            return strNumberFormatString;
        }
        if (strNumberFormatString != null && strNumberFormatString.length() > 0 && strNumberFormatString.startsWith("L[")) {
            this.setCurrencySymbolUsed(false);
            strNumberFormatString = strNumberFormatString.substring(2);
            int nIndex = strNumberFormatString.indexOf("]");
            if (nIndex == 0) {
                this.setCurrencySymbol("");
                strNumberFormatString = strNumberFormatString.substring(1);
            } else if (nIndex > 0) {
                String strCurrency = strNumberFormatString.substring(0, nIndex);
                this.setCurrencySymbol(strCurrency);
                strNumberFormatString = strNumberFormatString.substring(strCurrency.length() + 1);
            } else {
                throw new ParseException(strNumberFormatString, 0);
            }
        }
        return strNumberFormatString;
    }

    private String processPercentToken(String strNumberFormatString, int nNumberFormatType) throws ParseException {
        if (nNumberFormatType != 2) {
            return strNumberFormatString;
        }
        if (strNumberFormatString != null && strNumberFormatString.length() > 0 && strNumberFormatString.startsWith("%")) {
            strNumberFormatString = strNumberFormatString.substring(1);
            this.setNumberType(3);
        }
        return strNumberFormatString;
    }

    private String processParenToken(String strNumberFormatString, int nNumberFormatType) throws ParseException {
        if (nNumberFormatType != 2) {
            return strNumberFormatString;
        }
        if (strNumberFormatString != null && strNumberFormatString.length() > 0 && strNumberFormatString.startsWith("(")) {
            int nIndex = (strNumberFormatString = strNumberFormatString.substring(1)).indexOf(")");
            if (nIndex > 0 && nIndex == strNumberFormatString.length() - 1) {
                strNumberFormatString = strNumberFormatString.substring(0, nIndex);
            } else {
                throw new ParseException(strNumberFormatString, 0);
            }
        }
        return strNumberFormatString;
    }

    private boolean initNumberFormatOracle(String strNumberFormatString, int nNumberFormatType) {
        this.m_bUseCallback = false;
        this.m_initOracle = true;
        this.setPosNumFmt(4);
        this.setNegNumFmt(5);
        this.setPosCurFmt(13);
        this.setNegCurFmt(14);
        this.setThousandSeparator('0');
        this.setDecimalSeparator('0');
        this.setScaleDownThousands("__sym_locale__");
        this.setScaleDownMillions("__sym_locale__");
        this.setScaleDownBillions("__sym_locale__");
        this.setScaleDownTrillions("__sym_locale__");
        this.setScaleDownQuadrillions("__sym_locale__");
        this.clearUsedBits();
        this.setLeadingTrailingBlanksUsed(false);
        this.setNegativeAngleBracketsUsed(false);
        this.setNegativeMinusSpaceUsed(false);
        this.setScaleFactor(0);
        String srcFmtString = strNumberFormatString;
        String dstFmtString = "";
        String posPrefix = " ";
        String negPrefix = "-";
        String posSuffix = "";
        String negSuffix = "";
        String sepPosNeg = ";";
        boolean decSep = false;
        boolean bOccur = false;
        boolean currencyOccur = false;
        boolean bPercentOccur = false;
        boolean leadZero = false;
        boolean bPercent = false;
        boolean bCurrSpace = false;
        this.setNumberType(0);
        String strTokens = ", . $ 0 9 B VC- C D EEEE FM G K L[ L MI PR RN rn TM U V- V X % ( S";
        block10: while (srcFmtString.length() > 0) {
            StringTokenizer st = new StringTokenizer(strTokens);
            while (st.hasMoreTokens()) {
                String tmpString;
                String tokenString = st.nextToken();
                if (tokenString.compareTo(",") == 0 || tokenString.compareTo("G") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    if (dstFmtString.length() == 0) {
                        return false;
                    }
                    dstFmtString = dstFmtString + ",";
                    if (tokenString.compareTo("G") == 0) {
                        this.setThousandSeparator('0');
                    } else {
                        this.setThousandSeparator(',');
                    }
                    srcFmtString = srcFmtString.substring(1);
                    continue block10;
                }
                if (tokenString.compareTo(".") == 0 || tokenString.compareTo("D") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    if (tokenString.compareTo("D") == 0) {
                        this.setDecimalSeparator('0');
                    } else {
                        this.setDecimalSeparator('.');
                    }
                    dstFmtString = dstFmtString + ".";
                    srcFmtString = srcFmtString.substring(1);
                    decSep = true;
                    continue block10;
                }
                if (tokenString.compareTo("$") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    posPrefix = posPrefix + "$";
                    negPrefix = negPrefix + "$";
                    currencyOccur = true;
                    this.setCurrencySymbol("$");
                    this.setISOCurrency(false);
                    srcFmtString = srcFmtString.substring(1);
                    continue block10;
                }
                if (tokenString.compareTo("0") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    dstFmtString = dstFmtString + tokenString;
                    if (!decSep) {
                        leadZero = true;
                    }
                    srcFmtString = srcFmtString.substring(1);
                    continue block10;
                }
                if (tokenString.compareTo("9") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    dstFmtString = decSep && !this.isLeadingTrailingBlanksUsed() ? dstFmtString + "0" : dstFmtString + "#";
                    srcFmtString = srcFmtString.substring(1);
                    continue block10;
                }
                if (tokenString.compareTo("B") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    srcFmtString = srcFmtString.substring(1);
                    bOccur = true;
                    continue block10;
                }
                if (tokenString.compareTo("K") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    srcFmtString = srcFmtString.substring(1);
                    bCurrSpace = true;
                    continue block10;
                }
                if (tokenString.compareTo("L") == 0 || tokenString.compareTo("U") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    dstFmtString = dstFmtString + "\u00a4";
                    currencyOccur = true;
                    this.setISOCurrency(false);
                    srcFmtString = srcFmtString.substring(1);
                    continue block10;
                }
                if (tokenString.compareTo("C") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    dstFmtString = dstFmtString + "\u00a4";
                    currencyOccur = true;
                    this.setISOCurrency(true);
                    srcFmtString = srcFmtString.substring(1);
                    continue block10;
                }
                if (tokenString.compareTo("L[") == 0) {
                    if (srcFmtString.length() <= 1 || (tmpString = srcFmtString.substring(0, 2)).compareTo(tokenString) != 0) continue;
                    try {
                        srcFmtString = this.processCurrencyToken(srcFmtString, nNumberFormatType);
                        if (!this.isCurrencySymbolUsed()) continue;
                        posPrefix = posPrefix + "$";
                        negPrefix = negPrefix + "$";
                        currencyOccur = true;
                        this.setISOCurrency(false);
                        continue block10;
                    }
                    catch (ParseException parseException) {
                        return false;
                    }
                }
                if (tokenString.compareTo("(") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    try {
                        String strResult = this.processParenToken(srcFmtString, nNumberFormatType);
                        if (strResult.equals(srcFmtString)) continue;
                        negPrefix = "(";
                        negSuffix = ")";
                        posSuffix = " ";
                        srcFmtString = strResult;
                        continue block10;
                    }
                    catch (ParseException parseException) {
                        return false;
                    }
                }
                if (tokenString.compareTo("EEEE") == 0) {
                    if (srcFmtString.length() < 4 || (tmpString = srcFmtString.substring(0, 4)).compareTo(tokenString) != 0) continue;
                    srcFmtString = srcFmtString.substring(4);
                    continue block10;
                }
                if (tokenString.compareTo("FM") == 0) {
                    if (srcFmtString.length() < 2 || (tmpString = srcFmtString.substring(0, 2)).compareTo(tokenString) != 0) continue;
                    posPrefix = posPrefix.trim();
                    srcFmtString = srcFmtString.substring(2);
                    this.setLeadingTrailingBlanksUsed(true);
                    continue block10;
                }
                if (tokenString.compareTo("MI") == 0) {
                    if (srcFmtString.length() < 2 || (tmpString = srcFmtString.substring(0, 2)).compareTo(tokenString) != 0) continue;
                    posSuffix = " ";
                    negSuffix = "-";
                    posPrefix = "";
                    negPrefix = "";
                    srcFmtString = srcFmtString.substring(2);
                    this.setNegativeMinusSpaceUsed(true);
                    continue block10;
                }
                if (tokenString.compareTo("PR") == 0) {
                    if (srcFmtString.length() < 2 || (tmpString = srcFmtString.substring(0, 2)).compareTo(tokenString) != 0 || (srcFmtString = srcFmtString.substring(2)) != null && srcFmtString.length() != 0) continue;
                    negPrefix = "<";
                    negSuffix = ">";
                    posSuffix = " ";
                    this.setNegativeAngleBracketsUsed(true);
                    continue block10;
                }
                if (tokenString.compareTo("RN") == 0 || tokenString.compareTo("rn") == 0 || tokenString.compareTo("TM") == 0) {
                    if (srcFmtString.length() < 2 || (tmpString = srcFmtString.substring(0, 2)).compareTo(tokenString) != 0) continue;
                    srcFmtString = srcFmtString.substring(2);
                    continue block10;
                }
                if (tokenString.compareTo("%") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) != 0) continue;
                    try {
                        String strResult = this.processPercentToken(srcFmtString, nNumberFormatType);
                        if (strResult.equals(srcFmtString)) continue;
                        bPercentOccur = true;
                        srcFmtString = strResult;
                        continue block10;
                    }
                    catch (ParseException parseException) {
                        return false;
                    }
                }
                if (tokenString.compareTo("X") == 0 || tokenString.compareTo("VC-") == 0 || tokenString.compareTo("V-") == 0 || tokenString.compareTo("V") == 0) {
                    int minLength = tokenString.length();
                    if (srcFmtString.length() >= minLength) {
                        tmpString = srcFmtString.substring(0, minLength);
                        if (tmpString.compareTo(tokenString) != 0) continue;
                        try {
                            String strResult = this.processScalingToken(srcFmtString, nNumberFormatType);
                            if (strResult.equals(srcFmtString)) continue;
                            srcFmtString = strResult;
                            continue block10;
                        }
                        catch (ParseException parseException) {
                            return false;
                        }
                    }
                    if (minLength <= 1) continue block10;
                    continue;
                }
                if (tokenString.compareTo("S") == 0) {
                    if (srcFmtString.length() <= 0) continue block10;
                    tmpString = srcFmtString.substring(0, 1);
                    if (tmpString.compareTo(tokenString) == 0) {
                        if (dstFmtString.length() > 0) {
                            posSuffix = "+";
                            negSuffix = "-";
                            posPrefix = posPrefix.trim();
                            negPrefix = negPrefix.length() > 1 ? negPrefix.substring(1) : "";
                        } else {
                            posPrefix = posPrefix.trim();
                            posPrefix = posPrefix + "+";
                        }
                        srcFmtString = srcFmtString.substring(1);
                        continue block10;
                    }
                    return false;
                }
                return false;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(posPrefix);
        stringBuffer.append(dstFmtString);
        stringBuffer.append(posSuffix);
        stringBuffer.append(";");
        stringBuffer.append(negPrefix);
        stringBuffer.append(dstFmtString);
        stringBuffer.append(negSuffix);
        DecimalFormat decFmt = new DecimalFormat();
        try {
            decFmt.setDecimalFormatSymbols(new DecimalFormatSymbols(this.getLocale() != null ? this.getLocale() : Locale.getDefault()));
            decFmt.applyPattern(stringBuffer.toString());
        }
        catch (Exception e) {
            return false;
        }
        if (!decFmt.isGroupingUsed()) {
            this.setThousandSeparator('\u0000');
        }
        this.setDecimalDigit(((NumberFormat)decFmt).getMaximumFractionDigits());
        this.setLeadingZero(leadZero);
        if (currencyOccur) {
            int nIndexCurrency;
            int nIndexCB;
            this.m_oCurrencyInstance = decFmt;
            this.setNumberType(1);
            String nfString = new String(strNumberFormatString);
            int nIndexOB = nfString.indexOf("L[");
            if (nIndexOB > -1 && (nIndexCB = nfString.indexOf(93, nIndexOB)) > -1) {
                nfString = nfString.substring(0, nIndexOB + 1) + nfString.substring(nIndexCB + 1);
            }
            if ((nIndexCurrency = nfString.indexOf(76)) < 0) {
                int nIndexVC = nfString.indexOf("VC-");
                nIndexCurrency = nfString.indexOf(67);
                if (nIndexVC > -1 && nIndexCurrency == nIndexVC + 1 && nfString.length() - 1 > nIndexVC + 1) {
                    nIndexCurrency = nfString.indexOf(67, nIndexVC + 2);
                }
            }
            int nIndexSpace = -1;
            if (bCurrSpace) {
                nIndexSpace = nfString.indexOf(75);
            }
            int nIndexSign = nfString.indexOf(83);
            int nIndexZero = nfString.indexOf(48);
            int nIndexNine = nfString.indexOf(57);
            int nIndexNumber = Math.min(nIndexZero, nIndexNine);
            if (nIndexZero < 0) {
                nIndexNumber = nIndexNine;
            }
            if (nIndexNine < 0) {
                nIndexNumber = nIndexZero;
            }
            if (nIndexCurrency == 0) {
                if (nIndexSign > nIndexNumber && nIndexSpace < 0) {
                    this.setPosCurFmt(5);
                } else if (nIndexSpace == 1) {
                    this.setPosCurFmt(2);
                } else {
                    this.setPosCurFmt(0);
                }
                if (nIndexSign > nIndexCurrency) {
                    if (nIndexSign < nIndexNumber) {
                        if (nIndexSpace > nIndexCurrency && nIndexSpace < nIndexSign) {
                            this.setNegCurFmt(13);
                        } else {
                            this.setNegCurFmt(2);
                        }
                    } else if (nIndexSpace > nIndexCurrency && nIndexSpace < nIndexNumber) {
                        this.setNegCurFmt(12);
                    } else {
                        this.setNegCurFmt(3);
                    }
                } else if (nIndexSpace > nIndexCurrency && nIndexSpace < nIndexNumber) {
                    this.setNegCurFmt(9);
                } else {
                    this.setNegCurFmt(1);
                }
            } else if (nIndexCurrency == 1 && nIndexSign == 0) {
                if (nIndexSpace > nIndexCurrency && nIndexSpace < nIndexNumber) {
                    this.setPosCurFmt(10);
                    this.setNegCurFmt(9);
                } else {
                    this.setPosCurFmt(4);
                    this.setNegCurFmt(1);
                }
            } else if (nIndexSign > nIndexCurrency && nIndexCurrency != -1) {
                if (nIndexSpace != -1 && nIndexSpace > nIndexNumber && nIndexSpace < nIndexCurrency) {
                    this.setPosCurFmt(11);
                    this.setNegCurFmt(10);
                } else {
                    this.setPosCurFmt(8);
                    this.setNegCurFmt(7);
                }
            } else if (nIndexCurrency > nIndexNumber) {
                if (nIndexSpace != -1 && nIndexSpace > nIndexNumber && nIndexSpace < nIndexCurrency) {
                    if (nIndexSign > -1 && nIndexSign < nIndexNumber) {
                        this.setPosCurFmt(9);
                    } else {
                        this.setPosCurFmt(3);
                    }
                } else if (nIndexSign > -1 && nIndexSign < nIndexNumber) {
                    this.setPosCurFmt(6);
                } else if (nIndexSign > -1 && nIndexSign > nIndexNumber && nIndexSign < nIndexCurrency) {
                    this.setPosCurFmt(7);
                } else {
                    this.setPosCurFmt(1);
                }
                if (nIndexSign > nIndexNumber) {
                    this.setNegCurFmt(6);
                } else if (negPrefix.startsWith("(") && negSuffix.endsWith(")")) {
                    this.setNegCurFmt(4);
                } else if (nIndexSpace > nIndexNumber && nIndexSpace < nIndexCurrency) {
                    this.setNegCurFmt(8);
                } else {
                    this.setNegCurFmt(5);
                }
            } else {
                this.setPosCurFmt(0);
                if (negPrefix.startsWith("(") && negSuffix.endsWith(")")) {
                    if (nIndexNumber < nIndexCurrency) {
                        this.setNegCurFmt(4);
                    } else {
                        this.setNegCurFmt(0);
                    }
                } else {
                    this.setNegCurFmt(1);
                }
            }
        } else {
            this.m_oNumberInstance = decFmt;
            if (posPrefix.equals("+")) {
                this.setPosNumFmt(1);
            } else if (posSuffix.equals("+")) {
                this.setPosNumFmt(2);
            }
            if (negSuffix.equals("-")) {
                this.setNegNumFmt(2);
            } else if (negPrefix.equals("(") && negSuffix.equals(")")) {
                this.setNegNumFmt(0);
            } else if (negPrefix.equals("-")) {
                this.setNegNumFmt(1);
            }
        }
        if (bPercentOccur) {
            if (negPrefix.indexOf("(") > -1 && negSuffix.indexOf(")") > -1) {
                this.setNegPctFmt(1);
            } else {
                this.setNegPctFmt(0);
            }
        }
        this.m_bUseCallback = true;
        this.m_initOracle = false;
        return true;
    }

    private void setCurrencyNumberFormat(String strNumberFormatString) {
        if (strNumberFormatString != null && strNumberFormatString.length() != 0) {
            boolean bUseNumber;
            int nIndexCurrency = strNumberFormatString.indexOf(76);
            int nIndexSign = strNumberFormatString.indexOf(83);
            int nIndexZero = strNumberFormatString.indexOf(48);
            int nIndexNine = strNumberFormatString.indexOf(57);
            int nIndexNumber = Math.min(nIndexZero, nIndexNine);
            if (nIndexZero < 0) {
                nIndexNumber = nIndexNine;
            } else if (nIndexNine < 0) {
                nIndexNumber = nIndexZero;
            }
            boolean bUseCurrency = nIndexCurrency != -1;
            boolean bUseSign = nIndexSign != -1;
            boolean bl = bUseNumber = nIndexNumber != -1;
            if (nIndexCurrency == 0) {
                if (nIndexNumber > nIndexSign && bUseSign) {
                    this.setNegCurFmt(2);
                }
                if (nIndexSign != 0 || nIndexCurrency > nIndexNumber || bUseCurrency) {
                    // empty if block
                }
                if (nIndexNumber != 0 || (nIndexCurrency > nIndexSign ? bUseSign : nIndexSign <= nIndexCurrency || bUseCurrency)) {
                    // empty if block
                }
                this.setPosCurFmt(0);
                this.setPosCurFmt(4);
                if (nIndexSign > nIndexCurrency) {
                    if (nIndexSign < nIndexNumber) {
                        this.setNegCurFmt(2);
                    } else {
                        this.setNegCurFmt(3);
                    }
                } else {
                    this.setNegCurFmt(1);
                }
            } else if (nIndexCurrency == 1 && nIndexSign == 0) {
                this.setPosCurFmt(4);
                this.setNegCurFmt(1);
            } else if (nIndexSign > nIndexCurrency) {
                this.setPosCurFmt(8);
                this.setNegCurFmt(7);
            } else if (nIndexCurrency > nIndexSign) {
                this.setPosCurFmt(1);
                if (nIndexSign > nIndexNumber) {
                    this.setNegCurFmt(6);
                } else {
                    this.setNegCurFmt(5);
                }
            }
        }
    }

    private void initNumberFormat(String s) {
        if (s.equals("#")) {
            this.setLeadingZero(false);
            this.setDecimalDigit(0);
        } else if (s.equals("0")) {
            this.setLeadingZero(true);
            this.setDecimalDigit(0);
        } else if (s.equals("#.0")) {
            this.setLeadingZero(false);
            this.setDecimalDigit(1);
        } else if (s.equals("0.0")) {
            this.setLeadingZero(true);
            this.setDecimalDigit(1);
        } else if (s.equals("#.00")) {
            this.setLeadingZero(false);
            this.setDecimalDigit(2);
        } else if (s.equals("0.00")) {
            this.setLeadingZero(true);
            this.setDecimalDigit(2);
        } else if (s.equals("#.000")) {
            this.setLeadingZero(false);
            this.setDecimalDigit(3);
        } else if (s.equals("0.000")) {
            this.setLeadingZero(true);
            this.setDecimalDigit(3);
        } else if (s.equals("#.0000")) {
            this.setLeadingZero(false);
            this.setDecimalDigit(4);
        } else if (s.equals("0.0000")) {
            this.setLeadingZero(true);
            this.setDecimalDigit(4);
        } else if (s.equals("#.00000")) {
            this.setLeadingZero(false);
            this.setDecimalDigit(5);
        } else if (s.equals("0.00000")) {
            this.setLeadingZero(true);
            this.setDecimalDigit(5);
        } else if (s.equals("#.000000")) {
            this.setLeadingZero(false);
            this.setDecimalDigit(6);
        } else if (s.equals("0.000000")) {
            this.setLeadingZero(true);
            this.setDecimalDigit(6);
        }
    }

    private void initPositiveFormat(String s) {
        if (s.equals("1")) {
            this.setNumberType(0);
            this.setPosNumFmt(0);
        } else if (s.equals("+1")) {
            this.setNumberType(0);
            this.setPosNumFmt(1);
        } else if (s.equals("1+")) {
            this.setNumberType(0);
            this.setPosNumFmt(2);
        } else if (s.equals("$1")) {
            this.setNumberType(1);
            this.setPosCurFmt(0);
        } else if (s.equals("1$")) {
            this.setNumberType(1);
            this.setPosCurFmt(1);
        } else if (s.equals("$ 1")) {
            this.setNumberType(1);
            this.setPosCurFmt(2);
        } else if (s.equals("1 $")) {
            this.setNumberType(1);
            this.setPosCurFmt(3);
        } else if (s.equals("+$1")) {
            this.setNumberType(1);
            this.setPosCurFmt(4);
        } else if (s.equals("$1+")) {
            this.setNumberType(1);
            this.setPosCurFmt(5);
        } else if (s.equals("+1$")) {
            this.setNumberType(1);
            this.setPosCurFmt(6);
        } else if (s.equals("1+$")) {
            this.setNumberType(1);
            this.setPosCurFmt(7);
        } else if (s.equals("1$+")) {
            this.setNumberType(1);
            this.setPosCurFmt(8);
        } else if (s.equals("+1 $")) {
            this.setNumberType(1);
            this.setPosCurFmt(9);
        } else if (s.equals("+$ 1")) {
            this.setNumberType(1);
            this.setPosCurFmt(10);
        } else if (s.equals("1 $+")) {
            this.setNumberType(1);
            this.setPosCurFmt(11);
        }
    }

    private void initNegativeFormat(String s) {
        boolean bPercent = false;
        if (s.indexOf(36) != -1) {
            if (this.getNumberType() != 1) {
                return;
            }
        } else if (s.indexOf(37) != -1) {
            bPercent = true;
        } else if (this.getNumberType() != 0) {
            return;
        }
        if (s.equals("(1)")) {
            if (!bPercent) {
                this.setNegNumFmt(0);
            } else {
                this.setNegPctFmt(1);
            }
        } else if (s.equals("-1")) {
            if (!bPercent) {
                this.setNegNumFmt(1);
            } else {
                this.setNegPctFmt(0);
            }
        } else if (s.equals("1-")) {
            this.setNegNumFmt(2);
        } else if (s.equals("1")) {
            this.setNegNumFmt(3);
        } else if (s.equals("($1)")) {
            this.setNegCurFmt(0);
        } else if (s.equals("-$1")) {
            this.setNegCurFmt(1);
        } else if (s.equals("$-1")) {
            this.setNegCurFmt(2);
        } else if (s.equals("$1-")) {
            this.setNegCurFmt(3);
        } else if (s.equals("(1$)")) {
            this.setNegCurFmt(4);
        } else if (s.equals("-1$")) {
            this.setNegCurFmt(5);
        } else if (s.equals("1-$")) {
            this.setNegCurFmt(6);
        } else if (s.equals("1$-")) {
            this.setNegCurFmt(7);
        } else if (s.equals("-1 $")) {
            this.setNegCurFmt(8);
        } else if (s.equals("-$ 1")) {
            this.setNegCurFmt(9);
        } else if (s.equals("1 $-")) {
            this.setNegCurFmt(10);
        } else if (s.equals("$ 1-")) {
            this.setNegCurFmt(12);
        } else if (s.equals("$ -1")) {
            this.setNegCurFmt(13);
        }
    }

    private boolean isScaleFactorCharacterUsed() {
        boolean bScaleFactorCharacterUsed = false;
        switch (this.getScaleFactor()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getScaleDownThousands() == null || this.getScaleDownThousands().equals("")) break;
                bScaleFactorCharacterUsed = true;
                break;
            }
            case 2: {
                if (this.getScaleDownMillions() == null || this.getScaleDownMillions().equals("")) break;
                bScaleFactorCharacterUsed = true;
                break;
            }
            case 3: {
                if (this.getScaleDownBillions() == null || this.getScaleDownBillions().equals("")) break;
                bScaleFactorCharacterUsed = true;
                break;
            }
            case 4: {
                if (this.getScaleDownTrillions() == null || this.getScaleDownTrillions().equals("")) break;
                bScaleFactorCharacterUsed = true;
                break;
            }
            case 5: {
                if (this.getScaleDownQuadrillions() == null || this.getScaleDownQuadrillions().equals("")) break;
                bScaleFactorCharacterUsed = true;
            }
        }
        return bScaleFactorCharacterUsed;
    }

    private void setScaleFactorCharacter(boolean bUseScaleFactorCharacter) {
        switch (this.getScaleFactor()) {
            case 0: {
                break;
            }
            case 1: {
                if (bUseScaleFactorCharacter) {
                    this.setScaleDownThousands(DEFAULT_SCALE_DOWN_THOUSANDS_STRING);
                    break;
                }
                this.setScaleDownThousands("");
                break;
            }
            case 2: {
                if (bUseScaleFactorCharacter) {
                    this.setScaleDownMillions(DEFAULT_SCALE_DOWN_MILLIONS_STRING);
                    break;
                }
                this.setScaleDownMillions("");
                break;
            }
            case 3: {
                if (bUseScaleFactorCharacter) {
                    this.setScaleDownBillions(DEFAULT_SCALE_DOWN_BILLIONS_STRING);
                    break;
                }
                this.setScaleDownBillions("");
                break;
            }
            case 4: {
                if (bUseScaleFactorCharacter) {
                    this.setScaleDownTrillions(DEFAULT_SCALE_DOWN_TRILLIONS_STRING);
                    break;
                }
                this.setScaleDownTrillions("");
                break;
            }
            case 5: {
                if (bUseScaleFactorCharacter) {
                    this.setScaleDownQuadrillions(DEFAULT_SCALE_DOWN_QUADRILLIONS_STRING);
                    break;
                }
                this.setScaleDownQuadrillions("");
            }
        }
    }

    private String initCharsToUse(String s, StringTokenizer mainString) throws NoSuchElementException {
        String substitute = null;
        do {
            try {
                substitute = s.substring(2);
            }
            catch (StringIndexOutOfBoundsException e) {
                substitute = "";
            }
            if (s.indexOf(46, 0) == 0) {
                if (substitute.equals("")) {
                    this.setDecimalSeparator('\u0000');
                } else {
                    this.setDecimalSeparator(substitute.charAt(0));
                }
            } else if (s.indexOf(44, 0) == 0) {
                if (substitute.equals("")) {
                    this.setThousandSeparator('\u0000');
                } else {
                    this.setThousandSeparator(substitute.charAt(0));
                }
            } else if (s.indexOf(36, 0) == 0) {
                this.setCurrencySymbol(substitute);
            } else if (s.indexOf(37, 0) == 0) {
                this.setNumberType(2);
            } else if (s.indexOf("S=N", 0) == 0) {
                this.setScaleFactorCharacter(false);
            }
            s = mainString.nextToken();
            if (s.equals(";")) continue;
            throw new NoSuchElementException();
        } while (this.isCharsToUseClause(s = mainString.nextToken()));
        return s;
    }

    private boolean isCharsToUseClause(String s) {
        return s.indexOf(61, 1) == 1;
    }

    private void initScaleClause(String s) {
        if (s.equals("/0")) {
            this.setScaleFactor(0);
        } else if (s.equals("/3")) {
            this.setScaleFactor(1);
        } else if (s.equals("/6")) {
            this.setScaleFactor(2);
        } else if (s.equals("/9")) {
            this.setScaleFactor(3);
        } else if (s.equals("/12")) {
            this.setScaleFactor(4);
        } else if (s.equals("/15")) {
            this.setScaleFactor(5);
        }
    }

    protected ErrorHandler _getErrorHandler() {
        if (this.m_eh != null) {
            return this.m_eh;
        }
        return null;
    }

    private String appendSFString(String sFmtString) {
        String sSF = this.getSFString();
        if (sSF != null && sSF.length() > 0) {
            StringBuilder FmtString = new StringBuilder(sFmtString);
            int idx = -1;
            int max = -1;
            for (int i = 0; i < 10; ++i) {
                idx = sFmtString.lastIndexOf(48 + i);
                if (idx <= max) continue;
                max = idx;
            }
            FmtString.insert(max + 1, sSF);
            sFmtString = FmtString.toString();
        }
        return sFmtString;
    }

    private String appendPercentString(String strValue, NumberFormat numberFormat) {
        if (strValue != null && this.getNumberType() == 3) {
            StringBuilder stringBuffer = new StringBuilder(strValue);
            int nInsertPosition = strValue.length();
            if (numberFormat != null && numberFormat instanceof NumberFormat) {
                int nIndex;
                String strNegativeSuffix;
                int nIndex2;
                String strPositiveSuffix = ((DecimalFormat)numberFormat).getPositiveSuffix();
                if (strPositiveSuffix != null && strPositiveSuffix.length() != 0 && (nIndex2 = strValue.lastIndexOf(strPositiveSuffix)) != -1) {
                    nInsertPosition = nIndex2;
                }
                if ((strNegativeSuffix = ((DecimalFormat)numberFormat).getNegativeSuffix()) != null && strNegativeSuffix.length() != 0 && (nIndex = strValue.lastIndexOf(strNegativeSuffix)) != -1) {
                    nInsertPosition = nIndex;
                }
            }
            stringBuffer.insert(nInsertPosition, "%");
            strValue = stringBuffer.toString();
        }
        return strValue;
    }

    private NumberFormat getCurrencyInstance() {
        if (this.m_oCurrencyInstance == null) {
            this.m_oCurrencyInstance = (NumberFormat)this.getDefCurrencyInstance().clone();
        }
        return this.m_oCurrencyInstance;
    }

    private SimpleDateFormat getJavaDateInstance() {
        if (this.m_oJavaDateInstance == null) {
            this.m_oJavaDateInstance = (SimpleDateFormat)this.getDefJavaDateInstance().clone();
            String pattern = this.getJavaDateFormat();
            if (pattern != null && pattern.length() > 0) {
                this.m_oJavaDateInstance.applyPattern(pattern);
            }
        }
        return this.m_oJavaDateInstance;
    }

    private OracleDateFormat getOracleDateInstance() {
        if (this.m_oOracleDateInstance == null) {
            this.m_oOracleDateInstance = (OracleDateFormat)this.getDefOracleDateInstance().clone();
            this.m_oOracleDateInstance.setErrorHandler(this._getErrorHandler());
            String pattern = this.getOracleDateFormat();
            if (pattern != null && pattern.length() > 0) {
                this.m_oOracleDateInstance.setFormatString(this.m_sOracleDateFormat);
            }
        } else if (this._getErrorHandler() != this.m_oOracleDateInstance.getErrorHandler()) {
            this.m_oOracleDateInstance.setErrorHandler(this._getErrorHandler());
        }
        return this.m_oOracleDateInstance;
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        NumberFormat NumFmt = this.getNumberFormatInstance();
        return ((DecimalFormat)NumFmt).getDecimalFormatSymbols();
    }

    private NumberFormat getDefCurrencyInstance() {
        Object obj;
        NumberFormat ret = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((obj = m_hDefCurrencyInstances.get(locale)) == null) {
            ret = NumberFormat.getCurrencyInstance(locale);
            m_hDefCurrencyInstances.put(locale, ret);
        } else {
            ret = (NumberFormat)obj;
        }
        Object currencyCode = this.getExternalDefault("currencyCode");
        if (currencyCode != null && currencyCode instanceof String) {
            Currency currency = Currency.getInstance((String)currencyCode);
            ret.setCurrency(currency);
        }
        return ret;
    }

    private SimpleDateFormat getDefJavaDateInstance() {
        Object obj;
        SimpleDateFormat ret = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((obj = m_hDefJavaDateInstances.get(locale)) == null) {
            DateFormat fmt = DateFormat.getDateInstance(3, locale);
            ret = fmt instanceof SimpleDateFormat ? (SimpleDateFormat)fmt : new SimpleDateFormat();
            if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
                ret.setCalendar(new GregorianCalendar(locale));
            }
            m_hDefJavaDateInstances.put(locale, ret);
        } else {
            ret = (SimpleDateFormat)obj;
        }
        return ret;
    }

    private OracleDateFormat getDefOracleDateInstance() {
        String key;
        Object obj;
        TimeZone tz;
        OracleDateFormat ret = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((tz = this.getTimeZone()) == null) {
            tz = TimeZone.getDefault();
        }
        if ((obj = m_hDefOracleDateInstances.get(key = locale.toString() + tz.toString())) == null) {
            ret = new OracleDateFormat(locale, tz);
            m_hDefOracleDateInstances.put(key, ret);
        } else {
            ret = (OracleDateFormat)obj;
        }
        return ret;
    }

    private DecimalFormatSymbols getDefDecimalFormatSymbols() {
        NumberFormat NumFmt = this.getDefNumberFormatInstance();
        return ((DecimalFormat)NumFmt).getDecimalFormatSymbols();
    }

    private NumberFormat getDefNumberFormatInstance() {
        int iNumType = this.getNumberType();
        switch (iNumType) {
            case 2: {
                return this.getDefPercentInstance();
            }
            case 1: {
                return this.getDefCurrencyInstance();
            }
        }
        return this.getDefNumberInstance();
    }

    private NumberFormat getDefNumberInstance() {
        Object obj;
        NumberFormat ret = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((obj = m_hDefNumberInstances.get(locale)) == null) {
            ret = NumberFormat.getInstance(locale);
            m_hDefNumberInstances.put(locale, ret);
        } else {
            ret = (NumberFormat)obj;
        }
        return ret;
    }

    private NumberFormat getDefPercentInstance() {
        Object obj;
        NumberFormat ret = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((obj = m_hDefPercentInstances.get(locale)) == null) {
            ret = NumberFormat.getPercentInstance(locale);
            m_hDefPercentInstances.put(locale, ret);
        } else {
            ret = (NumberFormat)obj;
        }
        return ret;
    }

    private NumberFormat getNumberFormatInstance() {
        int iNumType = this.getNumberType();
        switch (iNumType) {
            case 2: {
                return this.getPercentInstance();
            }
            case 1: {
                return this.getCurrencyInstance();
            }
        }
        return this.getNumberInstance();
    }

    private NumberFormat getNumberInstance() {
        if (this.m_oNumberInstance == null) {
            this.m_oNumberInstance = (NumberFormat)this.getDefNumberInstance().clone();
        }
        return this.m_oNumberInstance;
    }

    private NumberFormat getPercentInstance() {
        if (this.m_oPercentInstance == null) {
            this.m_oPercentInstance = (NumberFormat)this.getDefPercentInstance().clone();
        }
        return this.m_oPercentInstance;
    }

    private int _getDefPosNumFmt() {
        NumberFormat nf = this.getDefNumberInstance();
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            String posPrefix = df.getPositivePrefix();
            String posSuffix = df.getPositiveSuffix();
            if (posPrefix.indexOf("+") > -1) {
                return 1;
            }
            if (posSuffix.indexOf("+") > -1) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    private int _getDefNegNumFmt() {
        NumberFormat nf = this.getDefNumberInstance();
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            String negPrefix = df.getNegativePrefix();
            String negSuffix = df.getNegativeSuffix();
            if (negPrefix.indexOf("(") > -1 && negSuffix.indexOf(")") > -1) {
                return 0;
            }
            if (negPrefix.indexOf("-") > -1) {
                return 1;
            }
            if (negSuffix.indexOf("-") > -1) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    private int _getDefPosCurFmt() {
        if (this.m_defPosCurFmt == -1) {
            NumberFormat nf = this.getDefCurrencyInstance();
            this.m_defPosCurFmt = this._calcDefPosCurFmt(nf);
        }
        return this.m_defPosCurFmt;
    }

    private int _calcDefPosCurFmt(NumberFormat nf) {
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            String posPrefix = df.getPositivePrefix();
            String posSuffix = df.getPositiveSuffix();
            String curSymbol = df.getDecimalFormatSymbols().getCurrencySymbol();
            int iCurPrefix = posPrefix.indexOf(curSymbol);
            int iCurSuffix = posSuffix.indexOf(curSymbol);
            int iCurSpacePrefix = posPrefix.indexOf(curSymbol + " ");
            int iSpaceCurSuffix = posSuffix.indexOf(" " + curSymbol);
            int iPosPrefix = posPrefix.indexOf("+");
            int iPosSuffix = posSuffix.indexOf("+");
            if (iPosPrefix > -1) {
                if (iPosPrefix < iCurSpacePrefix) {
                    return 10;
                }
                if (iPosPrefix < iCurPrefix) {
                    return 4;
                }
                if (iSpaceCurSuffix > -1) {
                    return 9;
                }
                if (iCurSuffix > -1) {
                    return 6;
                }
            } else if (iPosSuffix > -1) {
                if (iSpaceCurSuffix > -1 && iSpaceCurSuffix < iPosSuffix) {
                    return 11;
                }
                if (iCurPrefix > -1) {
                    return 5;
                }
                if (iPosSuffix < iCurSuffix) {
                    return 7;
                }
                if (iCurSuffix > -1 && iCurSuffix < iPosSuffix) {
                    return 8;
                }
            } else {
                if (iCurSpacePrefix > -1) {
                    return 2;
                }
                if (iCurPrefix > -1) {
                    return 0;
                }
                if (iSpaceCurSuffix > -1) {
                    return 3;
                }
                if (iCurSuffix > -1) {
                    return 1;
                }
            }
        }
        return 0;
    }

    private int _getDefNegCurFmt() {
        if (this.m_defNegCurFmt == -1) {
            NumberFormat nf = this.getDefCurrencyInstance();
            this.m_defNegCurFmt = this._calcDefNegCurFmt(nf);
        }
        return this.m_defNegCurFmt;
    }

    private int _calcDefNegCurFmt(NumberFormat nf) {
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            String negPrefix = df.getNegativePrefix();
            String negSuffix = df.getNegativeSuffix();
            String curSymbol = df.getDecimalFormatSymbols().getCurrencySymbol();
            int iCurPrefix = negPrefix.indexOf(curSymbol);
            int iCurSuffix = negSuffix.indexOf(curSymbol);
            int iCurSpacePrefix = negPrefix.indexOf(curSymbol + " ");
            int iSpaceCurSuffix = negSuffix.indexOf(" " + curSymbol);
            int iNegPrefix = negPrefix.indexOf("-");
            int iNegSuffix = negSuffix.indexOf("-");
            if (negPrefix.startsWith("(") && negSuffix.endsWith(")")) {
                if (iCurPrefix > -1) {
                    return 0;
                }
                if (iCurSuffix > -1) {
                    return 4;
                }
            } else if (iCurSpacePrefix > -1) {
                if (iNegPrefix > -1) {
                    if (iNegPrefix < iCurSpacePrefix) {
                        return 9;
                    }
                    return 13;
                }
                if (iNegSuffix > -1) {
                    return 12;
                }
            } else if (iSpaceCurSuffix > -1) {
                if (iNegPrefix > -1) {
                    return 8;
                }
                if (iNegSuffix > -1) {
                    return 10;
                }
            } else {
                if (iNegPrefix > -1) {
                    if (iCurPrefix > -1) {
                        if (iNegPrefix < iCurPrefix) {
                            return 1;
                        }
                        return 2;
                    }
                    return 5;
                }
                if (iNegSuffix > -1) {
                    if (iCurSuffix > -1) {
                        if (iNegSuffix < iCurSuffix) {
                            return 6;
                        }
                        return 7;
                    }
                    return 3;
                }
            }
        }
        return 0;
    }

    private double getScaleValue() {
        double dValue = 1.0;
        switch (this.getScaleFactor()) {
            case 1: {
                dValue = 1000.0;
                break;
            }
            case 2: {
                dValue = 1000000.0;
                break;
            }
            case 3: {
                dValue = 1.0E9;
                break;
            }
            case 4: {
                dValue = 1.0E12;
                break;
            }
            case 5: {
                dValue = 1.0E15;
                break;
            }
            case 6: {
                dValue = BaseViewFormat.pow(10, Math.abs(this.getScaleFactorExponent()));
                if (this.getScaleFactorExponent() <= 0) break;
                dValue = 1.0 / dValue;
                break;
            }
        }
        return dValue;
    }

    private String getSFString() {
        String sSFString = null;
        switch (this.getScaleFactor()) {
            case 1: {
                sSFString = this.getScaleDownThousands();
                if (!sSFString.equals("__sym_locale__")) break;
                sSFString = this.m_sSDThousandsLoc;
                break;
            }
            case 2: {
                sSFString = this.getScaleDownMillions();
                if (!sSFString.equals("__sym_locale__")) break;
                sSFString = this.m_sSDMillionsLoc;
                break;
            }
            case 3: {
                sSFString = this.getScaleDownBillions();
                if (!sSFString.equals("__sym_locale__")) break;
                sSFString = this.m_sSDBillionsLoc;
                break;
            }
            case 4: {
                sSFString = this.getScaleDownTrillions();
                if (!sSFString.equals("__sym_locale__")) break;
                sSFString = this.m_sSDTrillionsLoc;
                break;
            }
            case 5: {
                sSFString = this.getScaleDownQuadrillions();
                if (!sSFString.equals("__sym_locale__")) break;
                sSFString = this.m_sSDQuadrillionsLoc;
            }
        }
        return sSFString;
    }

    private String removeSFString(String sOrigStr) {
        int iIndex;
        String sSF = this.getSFString();
        if (sSF != null && sSF.length() > 0 && (iIndex = sOrigStr.lastIndexOf(sSF)) != -1) {
            return sOrigStr.substring(0, iIndex);
        }
        return sOrigStr;
    }

    private void setDecimal(NumberFormat oNumFmt) {
        oNumFmt.setMinimumFractionDigits(this.getDecimalDigit());
        oNumFmt.setMaximumFractionDigits(this.getDecimalDigit());
        if (this.getDecimalSeparator() == '0') {
            char defaultDecimalSeparator = this.m_cDecSepLoc;
            DecimalFormatSymbols oDecFmtSymb = ((DecimalFormat)oNumFmt).getDecimalFormatSymbols();
            oDecFmtSymb.setDecimalSeparator(defaultDecimalSeparator);
            oDecFmtSymb.setMonetaryDecimalSeparator(defaultDecimalSeparator);
            ((DecimalFormat)oNumFmt).setDecimalFormatSymbols(oDecFmtSymb);
            return;
        }
        if (this.getDecimalSeparator() != '\u0000') {
            DecimalFormatSymbols oDecFmtSymb = ((DecimalFormat)oNumFmt).getDecimalFormatSymbols();
            oDecFmtSymb.setDecimalSeparator(this.getDecimalSeparator());
            oDecFmtSymb.setMonetaryDecimalSeparator(this.getDecimalSeparator());
            ((DecimalFormat)oNumFmt).setDecimalFormatSymbols(oDecFmtSymb);
        } else {
            oNumFmt.setMinimumFractionDigits(0);
            oNumFmt.setMaximumFractionDigits(0);
        }
    }

    private String getLocaleCurrencySymbol() {
        if (this.m_oCurrencySymbol == null) {
            DecimalFormat oCurFmt = (DecimalFormat)this.getDefCurrencyInstance();
            String prefix = oCurFmt.getPositivePrefix().trim();
            String suffix = oCurFmt.getPositiveSuffix().trim();
            this.m_oCurrencySymbol = this.isISOCurrency() ? oCurFmt.getDecimalFormatSymbols().getInternationalCurrencySymbol() : (prefix != null && prefix.length() > 0 ? prefix : (suffix != null && suffix.length() > 0 ? suffix : this.getCurrencySymbol()));
        }
        return this.m_oCurrencySymbol;
    }

    private String getCurrentCurrencySymbol() {
        if (this.isCurrencySymbolUsed()) {
            return this.getCurrencySymbol();
        }
        return this.getLocaleCurrencySymbol();
    }

    private String replaceSubString(String original, String oldsubString, String newsubString) {
        int begIndex = original.indexOf(oldsubString);
        if (begIndex >= 0) {
            String finalString = new String();
            if (begIndex != 0) {
                finalString = original.substring(0, begIndex);
            }
            finalString = finalString + newsubString;
            if (oldsubString.length() + begIndex < original.length()) {
                finalString = finalString + original.substring(oldsubString.length() + begIndex);
            }
            return finalString;
        }
        return original;
    }

    private void setNegCurPrefSuff(NumberFormat oNumFmt) {
        if (this.m_iNegCurFmt == 14) {
            return;
        }
        switch (this.m_iNegCurFmt) {
            case 0: {
                String sTemp1 = "(" + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setNegativePrefix(sTemp1);
                ((DecimalFormat)oNumFmt).setNegativeSuffix(")");
                break;
            }
            case 2: {
                String sTemp3 = this.getCurrentCurrencySymbol() + "-";
                ((DecimalFormat)oNumFmt).setNegativePrefix(sTemp3);
                ((DecimalFormat)oNumFmt).setNegativeSuffix("");
                break;
            }
            case 3: {
                ((DecimalFormat)oNumFmt).setNegativePrefix(this.getCurrentCurrencySymbol());
                ((DecimalFormat)oNumFmt).setNegativeSuffix("-");
                break;
            }
            case 4: {
                ((DecimalFormat)oNumFmt).setNegativePrefix("(");
                String sTemp5 = this.getCurrentCurrencySymbol() + ")";
                ((DecimalFormat)oNumFmt).setNegativeSuffix(sTemp5);
                break;
            }
            case 5: {
                ((DecimalFormat)oNumFmt).setNegativePrefix("-");
                ((DecimalFormat)oNumFmt).setNegativeSuffix(this.getCurrentCurrencySymbol());
                break;
            }
            case 6: {
                String sTemp7 = "-" + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setNegativeSuffix(sTemp7);
                ((DecimalFormat)oNumFmt).setNegativePrefix("");
                break;
            }
            case 7: {
                String sTemp8 = this.getCurrentCurrencySymbol() + "-";
                ((DecimalFormat)oNumFmt).setNegativeSuffix(sTemp8);
                ((DecimalFormat)oNumFmt).setNegativePrefix("");
                break;
            }
            case 8: {
                ((DecimalFormat)oNumFmt).setNegativePrefix("-");
                String sTemp9 = " " + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setNegativeSuffix(sTemp9);
                break;
            }
            case 9: {
                String sTemp10 = "-" + this.getCurrentCurrencySymbol() + " ";
                ((DecimalFormat)oNumFmt).setNegativePrefix(sTemp10);
                ((DecimalFormat)oNumFmt).setNegativeSuffix("");
                break;
            }
            case 10: {
                String sTemp11 = " " + this.getCurrentCurrencySymbol() + "-";
                ((DecimalFormat)oNumFmt).setNegativeSuffix(sTemp11);
                ((DecimalFormat)oNumFmt).setNegativePrefix("");
                break;
            }
            case 12: {
                String sTemp12 = this.getCurrentCurrencySymbol() + " ";
                ((DecimalFormat)oNumFmt).setNegativePrefix(sTemp12);
                ((DecimalFormat)oNumFmt).setNegativeSuffix("-");
                break;
            }
            case 13: {
                String sTemp13 = this.getCurrentCurrencySymbol() + " " + "-";
                ((DecimalFormat)oNumFmt).setNegativePrefix(sTemp13);
                ((DecimalFormat)oNumFmt).setNegativeSuffix("");
                break;
            }
            case 11: {
                break;
            }
            default: {
                String sTempDef = "-" + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setNegativePrefix(sTempDef);
                ((DecimalFormat)oNumFmt).setNegativeSuffix("");
            }
        }
    }

    private void setNegNumPrefSuff(NumberFormat oNumFmt) {
        if (this.m_iNegNumFmt == 5) {
            return;
        }
        switch (this.m_iNegNumFmt) {
            case 0: {
                ((DecimalFormat)oNumFmt).setNegativePrefix("(");
                ((DecimalFormat)oNumFmt).setNegativeSuffix(")");
                break;
            }
            case 1: {
                ((DecimalFormat)oNumFmt).setNegativePrefix("-");
                ((DecimalFormat)oNumFmt).setNegativeSuffix("");
                break;
            }
            case 2: {
                ((DecimalFormat)oNumFmt).setNegativeSuffix("-");
                ((DecimalFormat)oNumFmt).setNegativePrefix("");
                break;
            }
            case 4: {
                break;
            }
            default: {
                ((DecimalFormat)oNumFmt).setNegativePrefix("");
                ((DecimalFormat)oNumFmt).setNegativeSuffix("");
            }
        }
    }

    private void _setNegPctPrefSuff(NumberFormat oNumFmt) {
        if (this.isNegPctFmtUsed()) {
            switch (this.getNegPctFmt()) {
                case 0: {
                    ((DecimalFormat)oNumFmt).setNegativePrefix("-");
                    if (this.getNumberType() != 2) break;
                    ((DecimalFormat)oNumFmt).setNegativeSuffix("%");
                    break;
                }
                case 1: {
                    ((DecimalFormat)oNumFmt).setNegativePrefix("(");
                    if (this.getNumberType() == 2) {
                        ((DecimalFormat)oNumFmt).setNegativeSuffix("%)");
                        break;
                    }
                    ((DecimalFormat)oNumFmt).setNegativeSuffix(")");
                    break;
                }
            }
        }
    }

    private void setPosCurPrefSuff(NumberFormat oNumFmt) {
        if (this.m_iPosCurFmt == 13) {
            return;
        }
        switch (this.m_iPosCurFmt) {
            case 1: {
                ((DecimalFormat)oNumFmt).setPositiveSuffix(this.getCurrentCurrencySymbol());
                ((DecimalFormat)oNumFmt).setPositivePrefix("");
                break;
            }
            case 2: {
                String sTemp3 = this.getCurrentCurrencySymbol() + " ";
                ((DecimalFormat)oNumFmt).setPositivePrefix(sTemp3);
                ((DecimalFormat)oNumFmt).setPositiveSuffix("");
                break;
            }
            case 3: {
                String sTemp4 = " " + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setPositiveSuffix(sTemp4);
                ((DecimalFormat)oNumFmt).setPositivePrefix("");
                break;
            }
            case 4: {
                String sTemp5 = "+" + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setPositivePrefix(sTemp5);
                ((DecimalFormat)oNumFmt).setPositiveSuffix("");
                break;
            }
            case 5: {
                ((DecimalFormat)oNumFmt).setPositivePrefix(this.getCurrentCurrencySymbol());
                ((DecimalFormat)oNumFmt).setPositiveSuffix("+");
                break;
            }
            case 6: {
                ((DecimalFormat)oNumFmt).setPositivePrefix("+");
                ((DecimalFormat)oNumFmt).setPositiveSuffix(this.getCurrentCurrencySymbol());
                break;
            }
            case 7: {
                String sTemp8 = "+" + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setPositiveSuffix(sTemp8);
                ((DecimalFormat)oNumFmt).setPositivePrefix("");
                break;
            }
            case 8: {
                String sTemp9 = this.getCurrentCurrencySymbol() + "+";
                ((DecimalFormat)oNumFmt).setPositiveSuffix(sTemp9);
                ((DecimalFormat)oNumFmt).setPositivePrefix("");
                break;
            }
            case 9: {
                ((DecimalFormat)oNumFmt).setPositivePrefix("+");
                String sTemp10 = " " + this.getCurrentCurrencySymbol();
                ((DecimalFormat)oNumFmt).setPositiveSuffix(sTemp10);
                break;
            }
            case 10: {
                String sTemp11 = "+" + this.getCurrentCurrencySymbol() + " ";
                ((DecimalFormat)oNumFmt).setPositivePrefix(sTemp11);
                ((DecimalFormat)oNumFmt).setPositiveSuffix("");
                break;
            }
            case 11: {
                String sTemp12 = " " + this.getCurrentCurrencySymbol() + "+";
                ((DecimalFormat)oNumFmt).setPositiveSuffix(sTemp12);
                ((DecimalFormat)oNumFmt).setPositivePrefix("");
                break;
            }
            case 12: {
                break;
            }
            default: {
                ((DecimalFormat)oNumFmt).setPositivePrefix(this.getCurrentCurrencySymbol());
                ((DecimalFormat)oNumFmt).setPositiveSuffix("");
            }
        }
    }

    private void setPosNumPrefSuff(NumberFormat oNumFmt) {
        if (this.m_iPosNumFmt == 4) {
            return;
        }
        switch (this.m_iPosNumFmt) {
            case 1: {
                ((DecimalFormat)oNumFmt).setPositivePrefix("+");
                ((DecimalFormat)oNumFmt).setPositiveSuffix("");
                break;
            }
            case 2: {
                ((DecimalFormat)oNumFmt).setPositiveSuffix("+");
                ((DecimalFormat)oNumFmt).setPositivePrefix("");
                break;
            }
            case 3: {
                break;
            }
            default: {
                ((DecimalFormat)oNumFmt).setPositivePrefix("");
                ((DecimalFormat)oNumFmt).setPositiveSuffix("");
            }
        }
    }

    private void setPrefSuff(NumberFormat oNumFmt) {
        if (this.m_iNumberType == 1) {
            DecimalFormatSymbols dfs = ((DecimalFormat)oNumFmt).getDecimalFormatSymbols();
            dfs.setCurrencySymbol(this.getCurrentCurrencySymbol());
            ((DecimalFormat)oNumFmt).setDecimalFormatSymbols(dfs);
            this.setPosCurPrefSuff(oNumFmt);
            this.setNegCurPrefSuff(oNumFmt);
        } else if (this.m_iNumberType == 0) {
            this.setPosNumPrefSuff(oNumFmt);
            this.setNegNumPrefSuff(oNumFmt);
        } else if (this.m_iNumberType == 2 || this.m_iNumberType == 3) {
            this._setNegPctPrefSuff(oNumFmt);
        }
    }

    private void setTSeparator(NumberFormat oNumFmt) {
        if (this.getThousandSeparator() == '0') {
            char defaultThousandSeparator = this.m_cThouSepLoc;
            DecimalFormatSymbols oDecFmtSymb = ((DecimalFormat)oNumFmt).getDecimalFormatSymbols();
            oDecFmtSymb.setGroupingSeparator(defaultThousandSeparator);
            ((DecimalFormat)oNumFmt).setDecimalFormatSymbols(oDecFmtSymb);
            return;
        }
        if (this.getThousandSeparator() == '\u0000') {
            oNumFmt.setGroupingUsed(false);
        } else {
            oNumFmt.setGroupingUsed(true);
        }
        DecimalFormatSymbols oDecFmtSymb = ((DecimalFormat)oNumFmt).getDecimalFormatSymbols();
        oDecFmtSymb.setGroupingSeparator(this.getThousandSeparator());
        ((DecimalFormat)oNumFmt).setDecimalFormatSymbols(oDecFmtSymb);
    }

    private StringBuffer appendNumberFormatOEO(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (this.isLeadingZero()) {
            stringBuffer.append("0");
        } else {
            stringBuffer.append("#");
        }
        int nDecimalDigits = this.getDecimalDigit();
        if (nDecimalDigits > 0) {
            stringBuffer.append(".");
        }
        for (int nCount = 0; nCount < nDecimalDigits; ++nCount) {
            stringBuffer.append("0");
        }
        return stringBuffer;
    }

    private StringBuffer appendPositiveFormatOEO(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (this.getPosCurFmt() != 13) {
            switch (this.getPosCurFmtValue()) {
                case 0: {
                    stringBuffer.append("$1");
                    break;
                }
                case 5: {
                    stringBuffer.append("$1+");
                    break;
                }
                case 2: {
                    stringBuffer.append("$ 1");
                    break;
                }
                case 1: {
                    stringBuffer.append("1$");
                    break;
                }
                case 8: {
                    stringBuffer.append("1$+");
                    break;
                }
                case 7: {
                    stringBuffer.append("1+$");
                    break;
                }
                case 3: {
                    stringBuffer.append("1 $");
                    break;
                }
                case 11: {
                    stringBuffer.append("1 $+");
                    break;
                }
                case 4: {
                    stringBuffer.append("+$1");
                    break;
                }
                case 10: {
                    stringBuffer.append("+$ 1");
                    break;
                }
                case 6: {
                    stringBuffer.append("+1$");
                    break;
                }
                case 9: {
                    stringBuffer.append("+1 $");
                    break;
                }
            }
        } else if (this.getPosNumFmt() != 4) {
            switch (this.getPosNumFmtValue()) {
                case 0: {
                    stringBuffer.append("1");
                    break;
                }
                case 2: {
                    stringBuffer.append("1+");
                    break;
                }
                case 1: {
                    stringBuffer.append("+1");
                    break;
                }
            }
        }
        return stringBuffer;
    }

    private StringBuffer appendNegativeFormatOEO(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (this.getNegCurFmt() != 14) {
            switch (this.getNegCurFmtValue()) {
                case 0: {
                    stringBuffer.append("($1)");
                    break;
                }
                case 2: {
                    stringBuffer.append("$-1");
                    break;
                }
                case 3: {
                    stringBuffer.append("$1-");
                    break;
                }
                case 1: {
                    stringBuffer.append("-$1");
                    break;
                }
                case 5: {
                    stringBuffer.append("-1$");
                    break;
                }
                case 7: {
                    stringBuffer.append("1$-");
                    break;
                }
                case 6: {
                    stringBuffer.append("1-$");
                    break;
                }
                case 4: {
                    stringBuffer.append("(1$)");
                    break;
                }
                case 9: {
                    stringBuffer.append("-$ 1");
                    break;
                }
                case 8: {
                    stringBuffer.append("-1 $");
                    break;
                }
                case 10: {
                    stringBuffer.append("1 $-");
                    break;
                }
                case 12: {
                    stringBuffer.append("$ 1-");
                    break;
                }
                case 13: {
                    stringBuffer.append("$ -1");
                    break;
                }
            }
        } else if (this.getNumberType() == 2 || this.getNumberType() == 3) {
            switch (this.getNegPctFmt()) {
                case 0: {
                    stringBuffer.append("-1");
                    break;
                }
                case 1: {
                    stringBuffer.append("(1)");
                    break;
                }
            }
        } else if (this.getNegNumFmt() != 5) {
            switch (this.getNegNumFmtValue()) {
                case 0: {
                    stringBuffer.append("(1)");
                    break;
                }
                case 1: {
                    stringBuffer.append("-1");
                    break;
                }
                case 2: {
                    stringBuffer.append("1-");
                    break;
                }
            }
        }
        return stringBuffer;
    }

    private StringBuffer appendScaleOEO(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (this.isScaleFactorUsed()) {
            switch (this.getScaleFactor()) {
                case 0: {
                    stringBuffer.append("/0");
                    break;
                }
                case 1: {
                    stringBuffer.append("/3");
                    break;
                }
                case 2: {
                    stringBuffer.append("/6");
                    break;
                }
                case 3: {
                    stringBuffer.append("/9");
                    break;
                }
                case 4: {
                    stringBuffer.append("/12");
                    break;
                }
                case 5: {
                    stringBuffer.append("/15");
                    break;
                }
            }
        }
        return stringBuffer;
    }

    private StringBuffer appendCharsToUseOEO(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        boolean bFirst = true;
        if (this.getThousandSeparator() != '0') {
            stringBuffer.append(",=");
            stringBuffer.append(this.getThousandSeparator());
            bFirst = false;
        }
        if (this.getDecimalSeparator() != '0') {
            if (!bFirst) {
                stringBuffer.append(";");
            }
            stringBuffer.append(".=");
            stringBuffer.append(this.getDecimalSeparator());
            bFirst = false;
        }
        if (this.isCurrencySymbolUsed()) {
            if (!bFirst) {
                stringBuffer.append(";");
            }
            stringBuffer.append("$=");
            stringBuffer.append(this.getCurrencySymbol());
            bFirst = false;
        }
        if (this.getNumberType() == 2) {
            if (!bFirst) {
                stringBuffer.append(";");
            }
            stringBuffer.append("%=%");
        }
        if (!this.isScaleFactorCharacterUsed()) {
            if (!bFirst) {
                stringBuffer.append(";");
            }
            stringBuffer.append("S=N");
        }
        return stringBuffer;
    }

    private void setScaleFactorExponentUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(18);
        } else {
            this.m_formatUsedFlags.clear(18);
        }
    }

    public boolean isScaleFactorExponentUsed() {
        return this.m_formatUsedFlags.get(18);
    }

    private static long pow(int nBase, int nExponent) {
        if (nExponent < 0) {
            return 0L;
        }
        long lPower = nBase;
        long lResult = 1L;
        while (nExponent > 0) {
            while ((nExponent & 1) == 0) {
                lPower *= lPower;
                nExponent >>>= 1;
            }
            lResult *= lPower;
            --nExponent;
        }
        return lResult;
    }

    private String getNumberFormatStringOEO() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bFirst = true;
        int nLength = stringBuffer.length();
        this.appendNumberFormatOEO(stringBuffer);
        if (stringBuffer.length() != nLength) {
            stringBuffer.append(";");
            nLength = stringBuffer.length();
        }
        this.appendPositiveFormatOEO(stringBuffer);
        if (stringBuffer.length() != nLength) {
            stringBuffer.append(";");
            nLength = stringBuffer.length();
        }
        this.appendNegativeFormatOEO(stringBuffer);
        if (stringBuffer.length() != nLength) {
            stringBuffer.append(";");
            nLength = stringBuffer.length();
        }
        this.appendScaleOEO(stringBuffer);
        if (stringBuffer.length() != nLength) {
            stringBuffer.append(";");
            nLength = stringBuffer.length();
        }
        this.appendCharsToUseOEO(stringBuffer);
        return stringBuffer.toString();
    }

    private String getNumberFormatStringOracle(int nNumberFormatType) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendNumberFormatOracle(stringBuffer);
        this.appendScaleOracle(stringBuffer);
        this.appendPositiveFormatOracle(stringBuffer);
        this.appendNegativeFormatOracle(stringBuffer);
        this.appendCharsToUseOracle(stringBuffer);
        return stringBuffer.toString();
    }

    private StringBuffer appendNumberFormatOracle(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (this.isLeadingTrailingBlanksUsed()) {
            stringBuffer.append("FM");
        }
        boolean bThouSep = false;
        char cThouSep = '\u0000';
        if (this.getThousandSeparator() != '0') {
            if (this.getThousandSeparator() == ',') {
                bThouSep = true;
                cThouSep = this.getDecimalSeparator() == '.' ? (char)this.getThousandSeparator() : (char)'G';
            } else if (this.getThousandSeparator() != '\u0000') {
                bThouSep = true;
                cThouSep = 'G';
            }
        } else {
            bThouSep = true;
            cThouSep = 'G';
        }
        if (bThouSep) {
            stringBuffer.append("9");
            stringBuffer.append(cThouSep);
            stringBuffer.append("99");
        }
        if (this.isLeadingZero()) {
            stringBuffer.append("0");
        } else {
            stringBuffer.append("9");
        }
        int nDecimalDigits = this.getDecimalDigit();
        if (nDecimalDigits > 0) {
            if (this.getDecimalSeparator() != '0') {
                if (this.getDecimalSeparator() == '.') {
                    if (this.getThousandSeparator() == ',' || this.getThousandSeparator() == '\u0000') {
                        stringBuffer.append(this.getDecimalSeparator());
                    } else {
                        stringBuffer.append('D');
                    }
                } else {
                    stringBuffer.append('D');
                }
            } else {
                stringBuffer.append('D');
            }
        }
        for (int nCount = 0; nCount < nDecimalDigits; ++nCount) {
            stringBuffer.append("0");
        }
        return stringBuffer;
    }

    private StringBuffer appendPositiveFormatOracle(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        String strCurrencySymbol = "L";
        if (this.isISOCurrency()) {
            strCurrencySymbol = "C";
        }
        if (this.isCurrencySymbolUsed()) {
            strCurrencySymbol = "L[" + this.getCurrencySymbol() + "]";
        }
        if (this.getNumberType() == 1 && this.getPosCurFmt() != 13) {
            switch (this.getPosCurFmtValue()) {
                case 0: {
                    stringBuffer.insert(0, strCurrencySymbol);
                    break;
                }
                case 5: {
                    stringBuffer.insert(0, strCurrencySymbol);
                    stringBuffer.append("S");
                    break;
                }
                case 2: {
                    stringBuffer.insert(0, strCurrencySymbol + "K");
                    break;
                }
                case 1: {
                    stringBuffer.append(strCurrencySymbol);
                    break;
                }
                case 8: {
                    stringBuffer.append(strCurrencySymbol);
                    stringBuffer.append("S");
                    break;
                }
                case 7: {
                    stringBuffer.append("S");
                    stringBuffer.append(strCurrencySymbol);
                    break;
                }
                case 3: {
                    stringBuffer.append("K");
                    stringBuffer.append(strCurrencySymbol);
                    break;
                }
                case 11: {
                    stringBuffer.append("K");
                    stringBuffer.append(strCurrencySymbol);
                    stringBuffer.append("S");
                    break;
                }
                case 4: {
                    stringBuffer.insert(0, "S" + strCurrencySymbol);
                    break;
                }
                case 10: {
                    stringBuffer.insert(0, "S" + strCurrencySymbol + "K");
                    break;
                }
                case 6: {
                    stringBuffer.insert(0, "S");
                    stringBuffer.append(strCurrencySymbol);
                    break;
                }
                case 9: {
                    stringBuffer.insert(0, "S");
                    stringBuffer.append("K");
                    stringBuffer.append(strCurrencySymbol);
                    break;
                }
            }
        } else if (this.getPosNumFmt() != 4) {
            switch (this.getPosNumFmtValue()) {
                case 0: {
                    break;
                }
                case 2: {
                    stringBuffer.append("S");
                    break;
                }
                case 1: {
                    stringBuffer.insert(0, "S");
                    break;
                }
            }
        }
        return stringBuffer;
    }

    private StringBuffer appendNegativeFormatOracle(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (this.getNumberType() == 1 && this.getNegCurFmt() != 14) {
            int nIndexSpace;
            int nIndexSign;
            int nIndexCurrency;
            String strCurrencySymbol = "L";
            if (this.isISOCurrency()) {
                strCurrencySymbol = "C";
            }
            if (this.isCurrencySymbolUsed()) {
                strCurrencySymbol = "L[" + this.getCurrencySymbol() + "]";
            }
            if ((nIndexCurrency = stringBuffer.toString().indexOf(strCurrencySymbol)) != -1) {
                stringBuffer.delete(nIndexCurrency, nIndexCurrency + strCurrencySymbol.length());
            }
            if ((nIndexSign = stringBuffer.toString().indexOf("S")) != -1) {
                stringBuffer.deleteCharAt(nIndexSign);
            }
            if ((nIndexSpace = stringBuffer.toString().indexOf("K")) != -1) {
                stringBuffer.deleteCharAt(nIndexSpace);
            }
            switch (this.getNegCurFmtValue()) {
                case 0: {
                    stringBuffer.insert(0, "(" + strCurrencySymbol);
                    stringBuffer.append(")");
                    break;
                }
                case 2: {
                    stringBuffer.insert(0, strCurrencySymbol + "S");
                    break;
                }
                case 3: {
                    stringBuffer.insert(0, strCurrencySymbol);
                    stringBuffer.append("S");
                    break;
                }
                case 1: {
                    stringBuffer.insert(0, strCurrencySymbol);
                    if (nIndexSign <= -1) break;
                    stringBuffer.insert(0, "S");
                    break;
                }
                case 5: {
                    stringBuffer.append(strCurrencySymbol);
                    if (nIndexSign <= -1) break;
                    stringBuffer.insert(0, "S");
                    break;
                }
                case 7: {
                    stringBuffer.append(strCurrencySymbol + "S");
                    break;
                }
                case 6: {
                    stringBuffer.append("S" + strCurrencySymbol);
                    break;
                }
                case 4: {
                    stringBuffer.insert(0, "(");
                    stringBuffer.append(strCurrencySymbol + ")");
                    break;
                }
                case 9: {
                    stringBuffer.insert(0, strCurrencySymbol + "K");
                    if (nIndexSign <= -1) break;
                    stringBuffer.insert(0, "S");
                    break;
                }
                case 8: {
                    stringBuffer.append("K" + strCurrencySymbol);
                    if (nIndexSign <= -1) break;
                    stringBuffer.insert(0, "S");
                    break;
                }
                case 10: {
                    stringBuffer.append("K" + strCurrencySymbol + "S");
                    break;
                }
                case 12: {
                    stringBuffer.insert(0, strCurrencySymbol + "K");
                    stringBuffer.append("S");
                    break;
                }
                case 13: {
                    stringBuffer.insert(0, strCurrencySymbol + "K" + "S");
                    break;
                }
            }
        } else if (this.getNumberType() == 2 || this.getNumberType() == 3) {
            switch (this.getNegPctFmt()) {
                case 0: {
                    break;
                }
                case 1: {
                    stringBuffer.insert(0, "(");
                    stringBuffer.append(")");
                    break;
                }
            }
        } else if (this.getNegNumFmt() != 5) {
            int nIndexSign = stringBuffer.toString().indexOf("S");
            if (nIndexSign != -1) {
                stringBuffer.deleteCharAt(nIndexSign);
            }
            switch (this.getNegNumFmtValue()) {
                case 0: {
                    stringBuffer.insert(0, "(");
                    stringBuffer.append(")");
                    break;
                }
                case 1: {
                    if (nIndexSign == -1) break;
                    stringBuffer.insert(0, "S");
                    break;
                }
                case 2: {
                    stringBuffer.append("S");
                    break;
                }
            }
        }
        return stringBuffer;
    }

    private StringBuffer appendScaleOracle(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (this.getNumberType() == 2) {
            this.setScaleFactor(6);
            this.setScaleFactorExponent(2);
        }
        if (this.isScaleFactorUsed()) {
            int nScaleFactorExponent = this.getScaleFactorExponent();
            switch (this.getScaleFactor()) {
                case 0: {
                    nScaleFactorExponent = 0;
                    break;
                }
                case 1: {
                    nScaleFactorExponent = -3;
                    break;
                }
                case 2: {
                    nScaleFactorExponent = -6;
                    break;
                }
                case 3: {
                    nScaleFactorExponent = -9;
                    break;
                }
                case 4: {
                    nScaleFactorExponent = -12;
                    break;
                }
                case 5: {
                    nScaleFactorExponent = -15;
                    break;
                }
                case 6: {
                    nScaleFactorExponent = this.getScaleFactorExponent();
                    break;
                }
            }
            if (nScaleFactorExponent != 0) {
                stringBuffer.append("V");
            }
            if (this.isScaleFactorCharacterUsed()) {
                stringBuffer.append("C");
            }
            if (nScaleFactorExponent < 0) {
                stringBuffer.append("-");
            }
            for (int nIndex = 0; nIndex < Math.abs(nScaleFactorExponent); ++nIndex) {
                stringBuffer.append("9");
            }
        }
        return stringBuffer;
    }

    private StringBuffer appendCharsToUseOracle(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        int nInsertPosition = stringBuffer.length() - 1;
        if (nInsertPosition >= 0) {
            char charLast = stringBuffer.charAt(nInsertPosition);
            if (charLast != ')') {
                ++nInsertPosition;
            }
        } else {
            nInsertPosition = 0;
        }
        if (this.getNumberType() == 3 || this.getNumberType() == 2) {
            stringBuffer.insert(nInsertPosition, "%");
        }
        if (this.isNegativeAngleBracketsUsed()) {
            stringBuffer.append("PR");
        } else if (this.isNegativeMinusSpaceUsed()) {
            stringBuffer.append("MI");
        }
        return stringBuffer;
    }

    private boolean isLeadingTrailingBlanksUsed() {
        return this.m_bLeadingTrailingBlanksUsed;
    }

    private void setLeadingTrailingBlanksUsed(boolean bLeadingTrailingBlanksUsed) {
        this.m_bLeadingTrailingBlanksUsed = bLeadingTrailingBlanksUsed;
    }

    public void setNegativeAngleBracketsUsed(boolean bNegativeAngleBracketsUsed) {
        this.m_bNegativeAngleBracketsUsed = bNegativeAngleBracketsUsed;
    }

    public boolean isNegativeAngleBracketsUsed() {
        return this.m_bNegativeAngleBracketsUsed;
    }

    private void setNegativeMinusSpaceUsed(boolean bNegativeMinusSpaceUsed) {
        this.m_bNegativeMinusSpaceUsed = bNegativeMinusSpaceUsed;
    }

    private boolean isNegativeMinusSpaceUsed() {
        return this.m_bNegativeMinusSpaceUsed;
    }

    public void setPercentUsed(boolean bPercentUsed) {
        if (bPercentUsed) {
            this.setNumberType(3);
        } else {
            this.setNumberType(0);
        }
    }

    public boolean isPercentUsed() {
        return this.getNumberType() == 3;
    }

    public void setDefaultThousandSeparator(char thouSep) {
        this.d_thousandSeparator = thouSep;
    }

    public void setDefaultDecimalSeparator(char decSep) {
        this.d_decimalSeparator = decSep;
    }

    public void setDefaultCurrencySymbol(String currSym) {
        this.d_currencySymbol = currSym;
    }

    public void setNumberConverter(NumberConverter converter) {
        this.m_numberConverter = converter;
    }

    public NumberConverter getNumberConverter() {
        return this.m_numberConverter;
    }

    public void setISOCurrency(boolean bISOCurr) {
        if (bISOCurr != this.m_bISOCurrency) {
            this.m_oCurrencySymbol = null;
        }
        this.m_bISOCurrency = bISOCurr;
        this.setISOCurrencyUsed(true);
    }

    public boolean isISOCurrency() {
        return this.m_bISOCurrency;
    }

    public void setISOCurrencyUsed(boolean bISOCurrUsed) {
        this.m_bISOCurrencyUsed = bISOCurrUsed;
    }

    public boolean isISOCurrencyUsed() {
        return this.m_bISOCurrencyUsed;
    }

    public void setNegPctFmt(int format) {
        this.m_negPctFmt = format;
        this.setNegPctFmtUsed(true);
    }

    public int getNegPctFmt() {
        return this.m_negPctFmt;
    }

    public void setNegPctFmtUsed(boolean bUsed) {
        if (bUsed) {
            this.m_formatUsedFlags.set(19);
        } else {
            this.m_formatUsedFlags.clear(19);
        }
    }

    public boolean isNegPctFmtUsed() {
        return this.m_formatUsedFlags.get(19);
    }

    public void setNumberFormatStringUsed(boolean used) {
        this.m_nfsUsed = used;
    }

    public boolean isNumberFormatStringUsed() {
        return this.m_nfsUsed;
    }

    public NumberFormat getNumberFormat() {
        if (this.m_numberConverter != null) {
            if (this.m_numberConverter instanceof DvtNumberConverter) {
                return ((DvtNumberConverter)this.m_numberConverter).getDecimalFormat();
            }
            return null;
        }
        NumberFormat NumFmt = this.getNumberFormatInstance();
        this.setTSeparator(NumFmt);
        this.setDecimal(NumFmt);
        this.setPrefSuff(NumFmt);
        return NumFmt;
    }

    static {
        for (int i = 0; i < 20; ++i) {
            NoBitsSet.clear(i);
        }
    }
}

