/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JTextField;
import oracle.dss.util.dimensionList.DimListCellEditor;
import oracle.dss.util.dimensionList.DimListCellEditorEvent;
import oracle.dss.util.dimensionList.DimListCellEditorListener;

public class DefaultListCellEditor
extends JTextField
implements DimListCellEditor,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Vector m_listeners = new Vector();
    private transient int m_index = -1;

    public DefaultListCellEditor() {
        this.setVisible(false);
        this.setText("");
    }

    @Override
    public synchronized void addEditListener(DimListCellEditorListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.addElement(l);
        }
    }

    @Override
    public synchronized void removeEditListener(DimListCellEditorListener l) {
        if (this.m_listeners != null && this.m_listeners.contains(l)) {
            this.m_listeners.removeElement(l);
        }
    }

    @Override
    public int getIndex() {
        return this.m_index;
    }

    @Override
    public void setIndex(int index) {
        this.m_index = index;
    }

    @Override
    public synchronized void startEdit(Component parent, String value, int index, Rectangle rect) {
        this.m_index = index;
        this.setText(value);
        this.setBounds(rect);
        this.setVisible(true);
        this.requestFocus();
        DimListCellEditorEvent e = new DimListCellEditorEvent(this, DimListCellEditorEvent.START);
        this.notifyListeners(e);
    }

    @Override
    public synchronized void acceptEdit() {
        DimListCellEditorEvent e = new DimListCellEditorEvent(this, DimListCellEditorEvent.ACCEPT, this.getText(), this.getIndex());
        this.notifyListeners(e);
    }

    @Override
    public synchronized void stopEdit() {
        DimListCellEditorEvent e = new DimListCellEditorEvent(this, DimListCellEditorEvent.CANCEL);
        this.notifyListeners(e);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005) {
            this.acceptEdit();
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        int key = e.getKeyCode();
        if (key == 10) {
            this.acceptEdit();
        } else if (key == 27) {
            this.stopEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(DimListCellEditorEvent e) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector v;
            DefaultListCellEditor defaultListCellEditor = this;
            synchronized (defaultListCellEditor) {
                v = (Vector)this.m_listeners.clone();
            }
            int count = v.size();
            DimListCellEditorListener client = null;
            for (int i = 0; i < count; ++i) {
                client = (DimListCellEditorListener)v.elementAt(i);
                if (client == null) continue;
                client.DimListCellEditorAction(e);
            }
        }
    }
}

