/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.converter;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import oracle.dss.util.converter.ResourceBundleToXMLInfo;

public class ResourceBundleToXMLProductCodeInfo {
    public static final String ERROR_DOC_ERROR_MSG_BOUNDARY_SEP = ":";
    public String m_strProductCode = null;
    public long m_lLowerBound = -1L;
    public long m_lUpperBound = -1L;
    public Vector m_vErrorComments = new Vector();

    public Vector getInvalidErrorComments() {
        Vector<ResourceBundleToXMLInfo> vInvalidComments = new Vector<ResourceBundleToXMLInfo>();
        for (int i = 0; i < this.m_vErrorComments.size(); ++i) {
            ResourceBundleToXMLInfo curEdi = (ResourceBundleToXMLInfo)this.m_vErrorComments.elementAt(i);
            if (null == curEdi || -1L != curEdi.m_lErrNum) continue;
            vInvalidComments.add(curEdi);
        }
        return vInvalidComments;
    }

    public Vector getValidErrorCommentsSortedByErrorNumber() {
        Vector<ResourceBundleToXMLInfo> vValidComments = new Vector<ResourceBundleToXMLInfo>();
        for (int i = 0; i < this.m_vErrorComments.size(); ++i) {
            ResourceBundleToXMLInfo curEdi = (ResourceBundleToXMLInfo)this.m_vErrorComments.elementAt(i);
            if (null == curEdi || curEdi.m_lErrNum < 0L) continue;
            vValidComments.add(curEdi);
        }
        Collections.sort(vValidComments, new SortByErrorNumberComparator());
        return vValidComments;
    }

    public String lowerBoundAsString() {
        if (-1L == this.m_lLowerBound) {
            return "";
        }
        return Long.toString(this.m_lLowerBound);
    }

    public String upperBoundAsString() {
        if (-1L == this.m_lUpperBound) {
            return "";
        }
        return Long.toString(this.m_lUpperBound);
    }

    public static ResourceBundleToXMLProductCodeInfo createObject(String strCurProdCode, String strCurErrorMsgBound) {
        ResourceBundleToXMLProductCodeInfo edpci = new ResourceBundleToXMLProductCodeInfo();
        edpci.m_strProductCode = strCurProdCode;
        if (strCurErrorMsgBound != null) {
            try {
                int nBoundSepIndex = strCurErrorMsgBound.indexOf(ERROR_DOC_ERROR_MSG_BOUNDARY_SEP);
                String strLowerBound = strCurErrorMsgBound.substring(0, nBoundSepIndex);
                String strUpperBound = strCurErrorMsgBound.substring(nBoundSepIndex + 1);
                edpci.m_lLowerBound = Long.parseLong(strLowerBound);
                edpci.m_lUpperBound = Long.parseLong(strUpperBound);
            }
            catch (Throwable t) {
                edpci.m_lLowerBound = -1L;
                edpci.m_lUpperBound = -1L;
            }
        }
        return edpci;
    }

    private class SortByErrorNumberComparator
    implements Comparator {
        public int compare(Object first, Object second) {
            ResourceBundleToXMLInfo firstComment = null;
            ResourceBundleToXMLInfo secondComment = null;
            if (first instanceof ResourceBundleToXMLInfo) {
                firstComment = (ResourceBundleToXMLInfo)first;
            }
            if (second instanceof ResourceBundleToXMLInfo) {
                secondComment = (ResourceBundleToXMLInfo)second;
            }
            if (null == firstComment || null == secondComment) {
                return 0;
            }
            if (firstComment.m_lErrNum < secondComment.m_lErrNum) {
                return -1;
            }
            return firstComment.m_lErrNum <= secondComment.m_lErrNum ? 0 : 1;
        }

        SortByErrorNumberComparator() {
        }
    }
}

