/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.converter;

import java.io.File;
import java.util.Vector;
import oracle.dss.util.converter.ResourceBundleToXMLUtil;

class ResourceBundleToXMLInfo {
    public static final long INVALID_ERROR_NUMBER = -1L;
    public static final int INVALID_SEVERITY_CODE = -1;
    public static final int SEVERITY_CODE_MIN = 1;
    public static final int SEVERITY_CODE_MAX = 32;
    public long m_lErrNum = -1L;
    public String m_strErrNum = null;
    public String m_strProdCode;
    public int m_nSeverityCode = -1;
    public String m_strError = null;
    public String m_strErrorKey = null;
    public String m_strErrorText = null;
    public String m_strErrorCategory;
    public String m_strErrorType = new String("ERROR");
    public Integer m_strErrorLevel = 1;
    public String m_strCause = null;
    public String m_strAction = null;
    public ResourceBundleToXMLStatusInfo m_oStatusInfo = null;
    public Vector m_oUnknownTags = null;
    public String m_strFilePath = null;
    public String m_strFileName = null;
    public String[] m_categories = new String[]{"Backup and Recovery", "Browser", "Cloning", "Compliance", "Configuration", "Data", "Deployment", "Failover", "Files", "Installation", "Logging", "Memory", "Network", "Operating System", "Other", "Performance", "Ports", "Process", "Programmatic", "Requests/Responses", "Security", "Session", "Threads", "Topology", "Upgrade"};
    public String[] m_errType = new String[]{"ERROR", "INTERNAL_ERROR", "INCIDENT_ERROR", "NOTIFICATION", "TRACE", "WARNING", "SET_AT_RUNTIME"};

    ResourceBundleToXMLInfo(String strFilePath) {
        this.m_oStatusInfo = new ResourceBundleToXMLStatusInfo();
        this.m_oUnknownTags = new Vector();
        this.m_strFilePath = new String(strFilePath);
    }

    public boolean isValidCategory(String catName) {
        boolean bRetVal = false;
        if (catName != null) {
            for (int i = 0; i < this.m_categories.length; ++i) {
                if (!this.m_categories[i].equals(catName)) continue;
                bRetVal = true;
                break;
            }
        }
        return bRetVal;
    }

    public boolean isValidType(String typeName) {
        boolean bRetVal = false;
        if (typeName != null) {
            for (int i = 0; i < this.m_errType.length; ++i) {
                if (!this.m_errType[i].equals(typeName)) continue;
                bRetVal = true;
                break;
            }
        }
        return bRetVal;
    }

    public String getFileName() {
        if (null == this.m_strFileName) {
            try {
                File fTemp = new File(this.m_strFilePath);
                this.m_strFileName = fTemp.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_strFileName;
    }

    public boolean isValidInfo() {
        return this.m_strError != null && this.m_strError.length() > 0 || this.m_strCause != null && this.m_strCause.length() > 0 || this.m_strAction != null && this.m_strAction.length() > 0;
    }

    class ResourceBundleToXMLStatusInfo {
        public String m_strValue;
        public String m_strComment;

        public boolean isValidInfo() {
            return this.m_strValue.length() > 0 && ResourceBundleToXMLUtil.isValidStatusType(this.m_strValue, false);
        }

        ResourceBundleToXMLStatusInfo() {
        }
    }
}

