/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.converter;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import oracle.dss.util.converter.ResourceBundleToXMLInfo;
import oracle.dss.util.converter.ResourceBundleToXMLProductCodeInfo;
import oracle.dss.util.converter.ResourceBundleToXMLUtil;

public class ResourceBundleToXMLFile {
    public String m_strFilePath = null;
    public ResourceBundleToXMLUtil m_rb2XmlUtil = null;

    public ResourceBundleToXMLFile(String strFilePath, ResourceBundleToXMLUtil rb2XmlUtil) {
        this.m_strFilePath = strFilePath;
        this.m_rb2XmlUtil = rb2XmlUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean processErrorFile() {
        boolean flag2;
        Vector<String> vLines;
        BufferedReader br;
        FileInputStream fis;
        block21: {
            boolean flag1;
            fis = null;
            br = null;
            this.m_rb2XmlUtil.logMessage("Error codes for resource " + this.m_strFilePath + ":");
            fis = new FileInputStream(this.m_strFilePath);
            br = new BufferedReader(new InputStreamReader(fis));
            vLines = new Vector<String>();
            String strCurLine = br.readLine();
            while (br.ready()) {
                vLines.addElement(new String(strCurLine));
                strCurLine = br.readLine();
            }
            if (0 != vLines.size()) break block21;
            boolean bl = flag1 = false;
            try {
                if (br != null) {
                    br.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = flag2 = this.reallyProcessErrorFile(vLines);
        try {
            if (br != null) {
                br.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
        catch (Throwable t) {
            try {
                boolean flag;
                t.printStackTrace();
                this.m_rb2XmlUtil.logMessage("Error processing file = " + this.m_strFilePath + "." + t);
                boolean bl2 = flag = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected boolean reallyProcessErrorFile(Vector vLines) {
        boolean bInComment = false;
        int nLastTagCode = -1;
        ResourceBundleToXMLInfo rbInfo = null;
        for (int i = 0; i < vLines.size(); ++i) {
            String strCurLine = new String((String)vLines.elementAt(i));
            if (0 == (strCurLine = strCurLine.trim()).length()) continue;
            if (strCurLine.equalsIgnoreCase("/**")) {
                bInComment = true;
                nLastTagCode = -1;
                rbInfo = new ResourceBundleToXMLInfo(this.m_strFilePath);
            }
            if (strCurLine.equalsIgnoreCase("*/") || strCurLine.equalsIgnoreCase("**/")) {
                bInComment = false;
                nLastTagCode = -1;
                continue;
            }
            if (strCurLine.startsWith("{") && rbInfo != null && rbInfo.isValidInfo()) {
                ResourceBundleToXMLProductCodeInfo curEdpci;
                HashMap hCompNames;
                String _errText;
                String _errKey;
                int lastBracketIdx = strCurLine.lastIndexOf("}");
                if (lastBracketIdx > 0) {
                    int _separatorIdx;
                    String _keyAndText = strCurLine.substring(1, lastBracketIdx);
                    char _c1 = _keyAndText.charAt(0);
                    String firstChar = String.valueOf(_c1);
                    boolean _shouldSkipKey = false;
                    if (firstChar.equals("\"")) {
                        int lastQuoteIdx = _keyAndText.indexOf("\"", 1);
                        _separatorIdx = _keyAndText.indexOf(",", lastQuoteIdx);
                        _shouldSkipKey = true;
                    } else {
                        _separatorIdx = _keyAndText.indexOf(",");
                    }
                    _errKey = new String();
                    if (!_shouldSkipKey) {
                        _errKey = _keyAndText.substring(0, _separatorIdx);
                        _errKey = _errKey.trim();
                    } else {
                        _errKey = "DVT-" + rbInfo.m_strErrNum;
                    }
                    _errText = _keyAndText.substring(_separatorIdx + 1);
                    _errText = _errText.trim();
                    _errText = _errText.substring(1, _errText.length() - 1);
                    if (_errText.startsWith("DVT-")) {
                        int spaceIdx = _errText.indexOf(" ");
                        _errText = _errText.substring(spaceIdx + 1).trim();
                    }
                } else {
                    this.m_rb2XmlUtil.logMessage("Error: the {key, error text} component has invalid format. Missing closing paranthesis }");
                    rbInfo.m_lErrNum = -1L;
                    continue;
                }
                rbInfo.m_strErrorKey = _errKey;
                rbInfo.m_strErrorText = _errText;
                this.m_rb2XmlUtil.logMessage("   " + rbInfo.m_strErrNum);
                if (rbInfo.m_oUnknownTags.size() > 0) {
                    rbInfo.m_lErrNum = -1L;
                }
                if ((hCompNames = this.m_rb2XmlUtil.getComponentNames()).containsKey(rbInfo.m_strProdCode) && (curEdpci = (ResourceBundleToXMLProductCodeInfo)hCompNames.get(rbInfo.m_strProdCode)) != null) {
                    curEdpci.m_vErrorComments.add(rbInfo);
                }
                rbInfo = null;
            }
            if (!bInComment) continue;
            strCurLine = this.processLine(strCurLine);
            strCurLine = strCurLine.replace("<code>", "");
            if (0 == (strCurLine = strCurLine.replace("</code>", "")).length()) continue;
            if (strCurLine.startsWith("@")) {
                String strTextAfterTag;
                String strTemp;
                String strFirstWord = this._getFirstWord(strCurLine);
                if (strFirstWord.equalsIgnoreCase("@Error") && rbInfo != null) {
                    nLastTagCode = 0;
                    if (rbInfo != null && (strTemp = strCurLine.substring(strFirstWord.length())) != null) {
                        rbInfo.m_strError = strTemp.trim();
                    }
                    try {
                        int nHyphenIndex = rbInfo.m_strError.indexOf("-");
                        if (nHyphenIndex < 0) {
                            throw new Exception();
                        }
                        String strProdCode = rbInfo.m_strError.substring(0, nHyphenIndex);
                        if (strProdCode.equalsIgnoreCase("BIB")) {
                            strProdCode = "DVT";
                        }
                        String strTemp2 = rbInfo.m_strError.substring(nHyphenIndex + 1);
                        int nNextWhitespaceIndex = strTemp2.indexOf(" ");
                        String strErrorNum = strTemp2.substring(0, nNextWhitespaceIndex);
                        long lErrorNum = -1L;
                        try {
                            strErrorNum = this.paddingString(strErrorNum, 5, '0', true);
                            StringBuffer _sb = new StringBuffer();
                            boolean wrongNumber = false;
                            for (int _i = 0; _i < strErrorNum.length(); ++_i) {
                                char _c = strErrorNum.charAt(_i);
                                if (Character.isDigit(_c)) {
                                    _sb.append(String.valueOf(_c));
                                    continue;
                                }
                                if (_i == 0 || _i == strErrorNum.length() - 1) continue;
                                wrongNumber = true;
                                break;
                            }
                            if (!wrongNumber) {
                                strErrorNum = _sb.toString();
                                lErrorNum = Long.parseLong(strErrorNum);
                            } else {
                                lErrorNum = -1L;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            lErrorNum = -1L;
                        }
                        HashMap hProdCodes = this.m_rb2XmlUtil.getComponentNames();
                        if (this.m_rb2XmlUtil.shouldInferProdCodesFromErrorComments()) {
                            if (!hProdCodes.containsKey(strProdCode)) {
                                hProdCodes.put(strProdCode, ResourceBundleToXMLProductCodeInfo.createObject(strProdCode, null));
                            }
                            rbInfo.m_strProdCode = strProdCode;
                            rbInfo.m_lErrNum = lErrorNum;
                            rbInfo.m_strErrNum = strErrorNum;
                            continue;
                        }
                        if (!hProdCodes.containsKey(strProdCode)) continue;
                        if (-1L == lErrorNum) {
                            rbInfo.m_strProdCode = strProdCode;
                            rbInfo.m_lErrNum = -1L;
                            continue;
                        }
                        ResourceBundleToXMLProductCodeInfo edpci = (ResourceBundleToXMLProductCodeInfo)hProdCodes.get(strProdCode);
                        if (-1L == edpci.m_lLowerBound && -1L == edpci.m_lUpperBound) {
                            rbInfo.m_strProdCode = strProdCode;
                            rbInfo.m_lErrNum = lErrorNum;
                            rbInfo.m_strErrNum = strErrorNum;
                            continue;
                        }
                        if (edpci.m_lLowerBound > lErrorNum || lErrorNum > edpci.m_lUpperBound) continue;
                        rbInfo.m_strProdCode = strProdCode;
                        rbInfo.m_lErrNum = lErrorNum;
                    }
                    catch (Throwable t) {
                        this.m_rb2XmlUtil.logMessage("Error encountered while parsing documentation comments. File = " + this.m_strFilePath + ". ");
                        this.m_rb2XmlUtil.logMessage("@error = " + rbInfo.m_strError);
                        this.m_rb2XmlUtil.logMessage("Warning. The error is expected to be in the format DVT-XXXX <Error Message> or the format DVT-XXXXX <Error Message>.");
                        rbInfo.m_lErrNum = -1L;
                    }
                    continue;
                }
                if (strFirstWord.equalsIgnoreCase("@Cause") && rbInfo != null) {
                    nLastTagCode = 1;
                    strTemp = strCurLine.substring(strFirstWord.length());
                    if (strTemp == null) continue;
                    rbInfo.m_strCause = strTemp.trim();
                    continue;
                }
                if (strFirstWord.equalsIgnoreCase("@Action") && rbInfo != null) {
                    nLastTagCode = 2;
                    strTemp = strCurLine.substring(strFirstWord.length());
                    if (strTemp == null) continue;
                    rbInfo.m_strAction = strTemp.trim();
                    continue;
                }
                if (strFirstWord.equalsIgnoreCase("@Status") && rbInfo != null) {
                    int nWhitespaceIndex;
                    nLastTagCode = 3;
                    strTextAfterTag = strCurLine.substring(strFirstWord.length());
                    if (strTextAfterTag != null) {
                        strTextAfterTag = strTextAfterTag.trim();
                    }
                    if ((nWhitespaceIndex = strTextAfterTag.indexOf(" ")) > 0) {
                        rbInfo.m_oStatusInfo.m_strValue = strTextAfterTag.substring(0, nWhitespaceIndex);
                        rbInfo.m_oStatusInfo.m_strComment = strTextAfterTag.substring(nWhitespaceIndex + 1);
                        continue;
                    }
                    rbInfo.m_oStatusInfo.m_strValue = strTextAfterTag;
                    rbInfo.m_oStatusInfo.m_strComment = "";
                    continue;
                }
                if (strFirstWord.equalsIgnoreCase("@category") && rbInfo != null) {
                    nLastTagCode = 6;
                    strTextAfterTag = strCurLine.substring(strFirstWord.length());
                    if (strTextAfterTag == null || !rbInfo.isValidCategory(strTextAfterTag = strTextAfterTag.trim())) continue;
                    rbInfo.m_strErrorCategory = strTextAfterTag;
                    continue;
                }
                if (strFirstWord.equalsIgnoreCase("@type") && rbInfo != null) {
                    nLastTagCode = 7;
                    strTextAfterTag = strCurLine.substring(strFirstWord.length());
                    if (strTextAfterTag == null || !rbInfo.isValidType(strTextAfterTag = strTextAfterTag.trim())) continue;
                    rbInfo.m_strErrorType = strTextAfterTag;
                    continue;
                }
                if (strFirstWord.equalsIgnoreCase("@level") && rbInfo != null) {
                    nLastTagCode = 8;
                    strTextAfterTag = strCurLine.substring(strFirstWord.length());
                    if (strTextAfterTag != null) {
                        strTextAfterTag = strTextAfterTag.trim();
                        try {
                            int nLevel = Integer.parseInt(strTextAfterTag);
                            if (nLevel < 1 || nLevel > 32) {
                                throw new Exception();
                            }
                            rbInfo.m_strErrorLevel = nLevel;
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    this.m_rb2XmlUtil.logMessage("Warning. The Level is expected to be a number ranging from 1 to 32.");
                    continue;
                }
                if (strFirstWord.equalsIgnoreCase("@SeverityCode") && rbInfo != null) {
                    nLastTagCode = 5;
                    strTemp = strCurLine.substring(strFirstWord.length());
                    strTemp = strTemp.trim();
                    int nSeverityCode = -1;
                    try {
                        nSeverityCode = Integer.parseInt(strTemp);
                        if (nSeverityCode < 1 || nSeverityCode > 32) {
                            throw new Exception();
                        }
                        rbInfo.m_nSeverityCode = nSeverityCode;
                        rbInfo.m_strErrorLevel = nSeverityCode;
                    }
                    catch (Throwable t) {
                        rbInfo.m_nSeverityCode = -1;
                        this.m_rb2XmlUtil.logMessage("Error encountered while parsing documentation comments. File = " + this.m_strFilePath + ". ");
                        this.m_rb2XmlUtil.logMessage("@Severity Code = " + strTemp);
                        this.m_rb2XmlUtil.logMessage("Warning. The Severity Code is expected to be a number ranging from 1 to 32.");
                    }
                    continue;
                }
                nLastTagCode = 4;
                if (rbInfo == null) continue;
                rbInfo.m_oUnknownTags.addElement(new String(strCurLine));
                continue;
            }
            if (0 == nLastTagCode && rbInfo != null) {
                rbInfo.m_strError = rbInfo.m_strError.concat("<>");
                rbInfo.m_strError = rbInfo.m_strError.concat(strCurLine);
                continue;
            }
            if (1 == nLastTagCode) {
                rbInfo.m_strCause = rbInfo.m_strCause.concat("<>");
                rbInfo.m_strCause = rbInfo.m_strCause.concat(strCurLine);
                continue;
            }
            if (2 == nLastTagCode) {
                rbInfo.m_strAction = rbInfo.m_strAction.concat("<>");
                rbInfo.m_strAction = rbInfo.m_strAction.concat(strCurLine);
                continue;
            }
            if (3 == nLastTagCode) {
                rbInfo.m_oStatusInfo.m_strComment = rbInfo.m_oStatusInfo.m_strComment.concat("<>");
                rbInfo.m_oStatusInfo.m_strComment = rbInfo.m_oStatusInfo.m_strComment.concat(strCurLine);
                continue;
            }
            if (5 == nLastTagCode || 4 != nLastTagCode) continue;
            String strTemp = (String)rbInfo.m_oUnknownTags.elementAt(rbInfo.m_oUnknownTags.size() - 1);
            strTemp = strTemp.concat("<>");
            strTemp = strTemp.concat(strCurLine);
            rbInfo.m_oUnknownTags.setElementAt(strTemp, rbInfo.m_oUnknownTags.size() - 1);
        }
        return true;
    }

    private String _getFirstWord(String strCurLine) {
        int nWhitespaceIndex = strCurLine.indexOf(" ");
        if (nWhitespaceIndex < 0) {
            return strCurLine;
        }
        return strCurLine.substring(0, nWhitespaceIndex);
    }

    protected boolean isValidChar(String strCheck) {
        return !strCheck.equalsIgnoreCase("*") && !strCheck.equalsIgnoreCase("/") && !strCheck.equalsIgnoreCase(" ");
    }

    protected String processLine(String strCurLine) {
        StringBuffer strNewLine = new StringBuffer("");
        for (int i = 0; i < strCurLine.length(); ++i) {
            char chTemp = strCurLine.charAt(i);
            String strChar = new String();
            strChar = String.valueOf(chTemp);
            if (!this.isValidChar(strChar)) continue;
            strNewLine = strNewLine.append(strCurLine.substring(i));
            break;
        }
        return strNewLine.toString().trim();
    }

    public synchronized String paddingString(String s, int n, char c, boolean paddingLeft) {
        StringBuffer str = new StringBuffer(s);
        int strLength = str.length();
        if (n > 0 && n > strLength) {
            for (int i = 0; i <= n; ++i) {
                if (paddingLeft) {
                    if (i >= n - strLength) continue;
                    str.insert(0, c);
                    continue;
                }
                if (i <= strLength) continue;
                str.append(c);
            }
        }
        return str.toString();
    }
}

