/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    public static final String BUILD_VERSION = "ComponentBuildVersion";
    public static final String COMPONENT_NUMBER = "ComponentNumber";
    public static final String RELEASE_DESCRIPTION = "ReleaseDescription";
    public static final String BUILD_MODE = "ComponentBuildMode";
    public static final String PACKAGE_NAME = "RuntimePackageName";
    public static final String SOURCE_URL = "RuntimeURL";
    private static final String VERSION_FILENAME = "version.txt";

    public static Properties getProperties(Class versionClass) {
        return VersionInfo.getProperties(versionClass.getPackage().getName());
    }

    public static Properties getProperties(Object versionObject) {
        return VersionInfo.getProperties(versionObject.getClass().getPackage().getName());
    }

    public static Properties getProperties(String versionPackage) {
        return VersionInfo.getProperties(versionPackage.replace('.', '/'), new Properties());
    }

    public static String getProperty(Class versionClass, String key) {
        Properties _props = VersionInfo.getProperties(versionClass);
        if (_props != null) {
            return (String)_props.get(key);
        }
        return null;
    }

    public static String getProperty(Object versionObject, String key) {
        Properties _props = VersionInfo.getProperties(versionObject);
        if (_props != null) {
            return (String)_props.get(key);
        }
        return null;
    }

    public static String getProperty(String versionPackage, String key) {
        Properties _props = VersionInfo.getProperties(versionPackage.replace('.', '/'), new Properties());
        if (_props != null) {
            return (String)_props.get(key);
        }
        return null;
    }

    private static Properties getProperties(String packageName, Properties properties) {
        try {
            String _fullPath;
            InputStream _stream;
            if (packageName.indexOf("/") > 0) {
                packageName = "oracle/dss";
            }
            if ((_stream = VersionInfo.class.getResourceAsStream(_fullPath = "/" + packageName + "/" + VERSION_FILENAME)) != null) {
                properties.load(_stream);
                properties.put(PACKAGE_NAME, packageName.replace('/', '.'));
                properties.put(SOURCE_URL, VersionInfo.class.getResource(_fullPath));
                return properties;
            }
            int _lastIndex = packageName.lastIndexOf(47);
            if (_lastIndex > 0) {
                return VersionInfo.getProperties(packageName.substring(0, _lastIndex));
            }
            return null;
        }
        catch (Exception e) {
            int _lastIndex = packageName.lastIndexOf(47);
            if (_lastIndex > 0) {
                return VersionInfo.getProperties(packageName.substring(0, _lastIndex - 1));
            }
            return null;
        }
    }
}

