/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import oracle.ide.IdeConstants;

public class WindowingConstants {
    public static final int DIVIDER_SIZE = 4;
    public static final Color COLOR_BACKGROUND = WindowingConstants.getBackgroundColor();
    public static final Border FLAT_COMPOUND_BORDER = WindowingConstants.getFlatCompoundBorder();
    public static final Color CONTROL_SHADOW_COLOR;

    private static Border getFlatCompoundBorder() {
        return new RoundedLineBorder(IdeConstants.COLOR_IDE_LINES);
    }

    private static Color getBackgroundColor() {
        Color c = UIManager.getColor("Panel.background");
        return new Color((int)((double)c.getRed() * 0.92), (int)((double)c.getGreen() * 0.92), (int)((double)c.getBlue() * 0.92));
    }

    static {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Color controlShadow = defaults.getColor("controlShadow");
        CONTROL_SHADOW_COLOR = controlShadow != null ? controlShadow : SystemColor.controlShadow;
    }

    private static final class RoundedLineBorder
    extends LineBorder {
        public RoundedLineBorder(Color c) {
            super(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.getLineColor());
            g.translate(x, y);
            g.drawLine(1, 0, width - 2, 0);
            g.drawLine(0, 1, 0, height - 2);
            g.drawLine(1, height - 1, width - 2, height - 1);
            g.drawLine(width - 1, 1, width - 1, height - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

