/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.BitField;

public final class DropFileUtil {
    private static DropTargetListener defaultDropFileListener;

    private DropFileUtil() {
    }

    public static DropTargetListener getDefaultDropFileListener() {
        if (defaultDropFileListener == null) {
            defaultDropFileListener = new DropFileListener();
        }
        return defaultDropFileListener;
    }

    public static boolean canDrop(DropTargetDragEvent dtde) {
        int dropAction = dtde.getDropAction();
        boolean isValidAction = BitField.isSet((int)dropAction, (int)1) || BitField.isSet((int)dropAction, (int)2);
        return isValidAction && dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    public static boolean drop(DropTargetDropEvent dtde) {
        boolean bRet = false;
        try {
            Transferable transferable = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                EditorManager editorManager = EditorManager.getEditorManager();
                dtde.acceptDrop(3);
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    bRet &= DropFileUtil.drop(editorManager, file);
                }
                dtde.getDropTargetContext().dropComplete(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    private static boolean drop(EditorManager editorManager, File f) {
        boolean bRet = true;
        if (f.isFile()) {
            URL fileURL = URLFactory.newFileURL((File)f);
            Editor ed = EditorUtil.openDefaultEditorInFrame((URL)fileURL);
            if (ed == null) {
                bRet = false;
            } else {
                EditorManager.getEditorManager().setExplicit(ed, true);
            }
        } else {
            File[] subs = f.listFiles();
            for (int i = 0; i < subs.length; ++i) {
                bRet &= DropFileUtil.drop(editorManager, subs[i]);
            }
        }
        return bRet;
    }

    public static class DropFileListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.handleDropTargetDragEvent(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.handleDropTargetDragEvent(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.handleDropTargetDragEvent(dtde);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DropFileUtil.drop(dtde);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        private void handleDropTargetDragEvent(DropTargetDragEvent dtde) {
            if (DropFileUtil.canDrop(dtde)) {
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }
    }
}

