/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print;

import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import oracle.ide.print.PrintManager;
import oracle.ideimpl.print.PrintManagerImpl;

public class PrintThread
extends Thread {
    Pageable _pageable = null;
    Pageable[] _pageables = null;
    PrinterJob _printerJob;
    Printable _printable;
    PrintRequestAttributeSet _printRequestAttributeSet;

    public PrintThread(Pageable pageable, PrinterJob printerJob, PrintRequestAttributeSet aSet) {
        this._printerJob = printerJob;
        this._pageable = pageable;
        this._printRequestAttributeSet = aSet;
        ((PrintManagerImpl)PrintManager.getPrintManager()).incrementPrintThread();
    }

    public PrintThread(Pageable[] pageables, PrinterJob printerJob, PrintRequestAttributeSet aSet) {
        this._printerJob = printerJob;
        this._pageables = pageables;
        this._printRequestAttributeSet = aSet;
        ((PrintManagerImpl)PrintManager.getPrintManager()).incrementPrintThread();
    }

    public PrintThread(Printable printable, PrinterJob printerJob, PrintRequestAttributeSet aSet) {
        this._printerJob = printerJob;
        this._printable = printable;
        this._printRequestAttributeSet = aSet;
        ((PrintManagerImpl)PrintManager.getPrintManager()).incrementPrintThread();
    }

    @Override
    public void run() {
        try {
            PrintService printService = this._printerJob.getPrintService();
            if (this._pageable != null) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintService(printService);
                printerJob.setPageable(this._pageable);
                printerJob.print(this._printRequestAttributeSet);
            } else if (this._pageables != null) {
                for (int i = 0; i < this._pageables.length; ++i) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintService(printService);
                    printerJob.setPageable(this._pageables[i]);
                    printerJob.print(this._printRequestAttributeSet);
                }
            } else if (this._printable != null) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintService(printService);
                printerJob.setPrintable(this._printable);
                printerJob.print(this._printRequestAttributeSet);
            }
            ((PrintManagerImpl)PrintManager.getPrintManager()).decrementPrintThread();
        }
        catch (PrinterException pe) {
            ((PrintManagerImpl)PrintManager.getPrintManager()).decrementPrintThread();
        }
    }
}

