/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.RepaintManager;
import oracle.ide.Context;
import oracle.ide.print.PageableFactory;

public class ComponentPageableFactory
implements Printable,
Pageable,
PageableFactory {
    private Component _component;
    private PageFormat _pageFormat;
    private static int _numberOfPages = 1;

    public Pageable create(Object object, PageFormat pageFormat) {
        return this.create(null, object, pageFormat);
    }

    public Pageable create(Context context, Object object, PageFormat pageFormat) {
        this._component = (Component)object;
        this._pageFormat = pageFormat;
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int response = 1;
        Graphics2D g2 = (Graphics2D)graphics;
        ComponentPageableFactory.disableDoubleBuffering(this._component);
        Dimension d = this._component.getSize();
        double compWidth = d.width;
        double compHeight = d.height;
        double pageHeight = pageFormat.getImageableHeight();
        double pageWidth = pageFormat.getImageableWidth();
        double scale = pageWidth / compWidth;
        int totalNumPages = (int)Math.ceil(scale * compHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            response = 1;
        } else {
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2.translate(0.0, (double)(-pageIndex) * pageHeight);
            g2.scale(scale, scale);
            this._component.paint(g2);
            ComponentPageableFactory.enableDoubleBuffering(this._component);
            response = 0;
        }
        return response;
    }

    private static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    private static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    @Override
    public int getNumberOfPages() {
        return _numberOfPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex > _numberOfPages) {
            throw new IndexOutOfBoundsException();
        }
        return this._pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex > _numberOfPages) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }
}

