/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.model;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLPath;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.javatools.data.PropertyStorage;

public class ProjectModel {
    final Project m_project;
    final File m_projectBase;
    final File m_outputDirectory;
    final URLPath m_contentSets;

    public ProjectModel(Project project) {
        this.m_project = project;
        this.m_projectBase = new File(FileSystemModelUtils.urlToFile(project.getURL()).getParent());
        this.m_outputDirectory = ProjectModel.determineOutputDirectory(this.m_project.getProperty("oracle.jdevimpl.config.JProjectPaths/outputDirectory"));
        this.m_contentSets = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
    }

    public Project getProject() {
        return this.m_project;
    }

    public File getOutputDirectory() {
        return this.m_outputDirectory;
    }

    public File getProjectBaseDirectory() {
        return this.m_projectBase;
    }

    public URLPath getContentRootDirectories() {
        return this.m_contentSets;
    }

    public List<File> getContentRootsOutsideProjectRoot() {
        ArrayList<File> outsideRoots = new ArrayList<File>();
        for (URL sourceRootDirectoryURL : this.m_contentSets) {
            File f = FileSystemModelUtils.urlToFile(sourceRootDirectoryURL);
            if (ProjectModel.isSourceInProjectRoot(this.m_projectBase, f)) continue;
            outsideRoots.add(f);
        }
        return outsideRoots;
    }

    private static File determineOutputDirectory(String outputDirectory) {
        File outputFile;
        if (outputDirectory == null) {
            return null;
        }
        try {
            URI outputFileUri = new URI(outputDirectory);
            outputFile = new File(outputFileUri);
        }
        catch (URISyntaxException e) {
            int indexOfProtocolEnd = outputDirectory.indexOf(":");
            outputFile = indexOfProtocolEnd != -1 ? new File(outputDirectory.substring(indexOfProtocolEnd + 1)) : new File(outputDirectory);
        }
        return outputFile;
    }

    private static boolean isSourceInProjectRoot(File projectRoot, File source) {
        return source.getPath().startsWith(projectRoot.getPath());
    }
}

