/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.handler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.DeleteActionHandler;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ideimpl.navigator.ConcurrencySupport;
import oracle.ideimpl.navigator.delete.handler.DeleteProjectActionHandler;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.model.WorkspaceModel;
import oracle.ideimpl.navigator.delete.ui.IdeModelTree;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeBuilder;
import oracle.ideimpl.navigator.delete.ui.UIUtils;
import oracle.javatools.icons.OracleIcons;

public class DeleteWorkspaceActionHandler
extends DeleteActionHandler<Workspace> {
    private volatile IdeModelTree m_ideModel = null;
    private volatile JTree m_contentsTree = null;
    private volatile JTree m_errorTree = null;
    private JPanel m_detailsPanel = null;
    private JScrollPane m_detailsContents = null;
    private JLabel m_detailsHint = null;

    private boolean hasError() {
        return this.m_errorTree != null;
    }

    public DeleteWorkspaceActionHandler(Context context) {
        super(context);
        this.setDeleteStrategy(new WorkspaceDeleteStrategy());
    }

    public DeleteWorkspaceActionHandler(List<Workspace> workspaces) {
        super(workspaces);
    }

    private void buildWorkspaceContentsTree() {
        Runnable buildAppTreeRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IdeModelTreeBuilder treeBuilder = new IdeModelTreeBuilder();
                try {
                    for (Workspace w : DeleteWorkspaceActionHandler.this.getNodes()) {
                        treeBuilder.workspace(w);
                    }
                    DeleteWorkspaceActionHandler.this.m_ideModel = treeBuilder.build();
                    DeleteWorkspaceActionHandler.this.m_contentsTree = DeleteWorkspaceActionHandler.this.m_ideModel.getTree();
                }
                catch (Throwable t) {
                    try {
                        DeleteWorkspaceActionHandler.this.m_errorTree = UIUtils.createErrorTree(t);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeleteWorkspaceActionHandler.this.m_detailsContents.setViewportView(DeleteWorkspaceActionHandler.this.m_contentsTree);
                                if (DeleteWorkspaceActionHandler.this.m_ideModel != null && DeleteWorkspaceActionHandler.this.m_ideModel.hasOptionalItems()) {
                                    DeleteWorkspaceActionHandler.this.m_detailsHint.setText(DeleteDialogArb.getString((int)28));
                                }
                                DeleteWorkspaceActionHandler.this.deleteDetailsAvailable(true);
                                DeleteWorkspaceActionHandler.this.clearStatus();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        ConcurrencySupport.getSharedExecutor().execute(buildAppTreeRunnable);
    }

    protected Component createDeleteDetailsComponent() {
        this.m_detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsHint = new JLabel();
        this.m_detailsContents = new JScrollPane();
        this.m_detailsPanel.add((Component)this.m_detailsContents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_detailsPanel.add((Component)this.m_detailsHint, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(4, 0, 8, 0), 0, 0));
        return this.m_detailsPanel;
    }

    protected DeleteActionHandler.DetailsTextConfig getDetailsTextConfig() {
        return new DeleteActionHandler.DetailsTextConfigBuilder().title(DeleteDialogArb.getString((int)19)).header(MessageFormat.format(DeleteDialogArb.getString((int)20), this.getNodes().get(0))).description(DeleteDialogArb.getString((int)21)).showDetails(DeleteDialogArb.getString((int)22)).hideDetails(DeleteDialogArb.getString((int)23)).confirmTitle(DeleteDialogArb.getString((int)25)).confirmMessage(DeleteDialogArb.getString((int)26)).helpTopicId("f1_idedconfirmdeleteapp_html").build();
    }

    protected void preLaunchDialog() {
        super.preLaunchDialog();
        this.deleteDetailsAvailable(false);
        this.setStatus(DeleteDialogArb.getString((int)27), OracleIcons.getIcon((String)"throbber.gif"));
        this.buildWorkspaceContentsTree();
    }

    private static Context newWorkspaceContext(Context baseContext) {
        Context context = new Context(baseContext);
        Workspace workspace = baseContext.getWorkspace();
        context.setNode((Node)workspace);
        context.setElement((Element)workspace);
        context.setProject(null);
        ExplorerContext.setTNodes((Context)context, (TNode[])new TNode[0]);
        return context;
    }

    private class WorkspaceDeleteStrategy
    extends DeleteActionHandler.DeleteStrategy<Workspace> {
        private WorkspaceDeleteStrategy() {
        }

        public boolean delete(Workspace node) {
            if (DeleteWorkspaceActionHandler.this.hasError()) {
                return false;
            }
            IdeAction removeAction = IdeActions.getFileRemoveFromIDEAction();
            try {
                removeAction.performAction(DeleteWorkspaceActionHandler.newWorkspaceContext(DeleteWorkspaceActionHandler.this.getContext()));
            }
            catch (Exception e) {
                // empty catch block
            }
            WorkspaceModel workspaceModel = new WorkspaceModel(node);
            if (DeleteActionHandler.getDefaultDeleteStrategy().delete((Element)node)) {
                DeleteFileVisitor deletor = new DeleteFileVisitor();
                ArrayList<URL> exclusions = DeleteWorkspaceActionHandler.this.m_ideModel != null ? DeleteWorkspaceActionHandler.this.m_ideModel.getExcludedURLs() : new ArrayList();
                for (Project project : workspaceModel.getProjects()) {
                    DeleteProjectActionHandler.deleteProject(project, exclusions, deletor);
                }
                if (FileSystemModelUtils.isFolderEmpty(workspaceModel.getWorkspaceBaseDirectory())) {
                    FileSystemModelUtils.deleteFolderRecursively(workspaceModel.getWorkspaceBaseDirectory(), deletor);
                }
                this.addAllToNondeleted(deletor.getUndeleted());
                return true;
            }
            return false;
        }
    }
}

