/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigation;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.EditorNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigation.NavigationPointEvent;
import oracle.ide.navigation.NavigationPointListener;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.icons.OracleIcons;

public final class NavigationManagerImpl
extends NavigationManager
implements EditorListener,
NavigationPointListener,
Addin {
    private final Stack _STACK = new Stack();
    private final HashMap _EDITOR_MAP = new HashMap();
    private final HashMap _ACTION_MAP = new HashMap();
    private final int _HISTORY_MAX = 15;
    private int _navigationLevel = 100;
    private int _stackPointer = -1;
    private int _navigating = 0;
    private NavigationPoint _lastEditLocation;

    public NavigationManagerImpl() {
        EditorManager mgr = EditorManager.getEditorManager();
        if (mgr != null) {
            mgr.addEditorListener((EditorListener)this);
        }
        EnvironOptions options = Ide.getEnvironOptions();
        options.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int level = ((EnvironOptions)e.getSource()).getNavigationLevel();
                NavigationManagerImpl.this.navigationLevelChanged(level);
            }
        });
        this.navigationLevelChanged(options.getNavigationLevel());
    }

    public void initialize() {
        NavigationManager.setNavigationManager((NavigationManager)this);
        AddinManager addMgr = AddinManager.getAddinManager();
        Action[] emptyActions = new Action[]{};
        IdeAction backAction = IdeAction.get((int)73, (String)addMgr.getCommand(73, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)428), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)IdeArb.getInteger((int)429), (Icon)OracleIcons.getIcon((String)"navigateBack.png"), null, (boolean)false);
        backAction.putValue("ActionMenuActions", (Object)emptyActions);
        IdeAction forwardAction = IdeAction.get((int)74, (String)addMgr.getCommand(74, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)432), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)IdeArb.getInteger((int)433), (Icon)OracleIcons.getIcon((String)"navigateForward.png"), null, (boolean)false);
        forwardAction.putValue("ActionMenuActions", (Object)emptyActions);
        IdeAction lastEditAction = IdeAction.get((int)75, (String)addMgr.getCommand(75, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)436), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)IdeArb.getInteger((int)437), (ArrayResourceBundle)IdeArb.getInstance(), (int)438, null, (boolean)false);
        Menubar menuMgr = Ide.getMenubar();
        JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
        JMenuItem backItem = menuMgr.createMenuItem((ToggleAction)backAction, 1.0f);
        JMenuItem forwardItem = menuMgr.createMenuItem((ToggleAction)forwardAction, MenuConstants.WEIGHT_NAVIGATE_FORWARD);
        JMenuItem lastEditItem = menuMgr.createMenuItem((ToggleAction)lastEditAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_LAST_EDIT);
        menuMgr.add((Component)backItem, navigateMenu, 1.0f);
        menuMgr.add((Component)forwardItem, navigateMenu, 1.0f);
        menuMgr.add((Component)lastEditItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
    }

    public synchronized boolean canNavigateBack() {
        return this._stackPointer > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int navigateBack() throws Exception {
        int status = 1;
        try {
            ++this._navigating;
            if (this.canNavigateBack()) {
                this.updateNavigationPoint();
                NavigationPoint point = (NavigationPoint)this._STACK.get(this._stackPointer - 1);
                status = point.navigate();
                if (status == 0) {
                    --this._stackPointer;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    public synchronized boolean canNavigateForward() {
        int size = this._STACK.size();
        return size > 0 && this._stackPointer < size - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int navigateForward() throws Exception {
        int status = 1;
        try {
            ++this._navigating;
            if (this.canNavigateForward()) {
                this.updateNavigationPoint();
                NavigationPoint point = (NavigationPoint)this._STACK.get(this._stackPointer + 1);
                status = point.navigate();
                if (status == 0) {
                    ++this._stackPointer;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int navigateTo(NavigationPoint destination) throws Exception {
        int status = 1;
        Context context = destination.getContext();
        View view = context.getView();
        if (view instanceof Editor) {
            EditorAddin addin = ((Editor)view).getEditorAddin();
            if (addin == null) {
                Class<?> viewClass = view.getClass();
                addin = EditorManager.getEditorManager().getEditorAddin(viewClass);
            }
            if (addin != null && !EditorManagerImpl.isRestorable(context, addin)) {
                return destination.navigate();
            }
        }
        try {
            ++this._navigating;
            if (this._navigating == 1) {
                this.updateNavigationPoint();
            }
            if ((status = destination.navigate()) == 0 && this._navigating == 1) {
                for (int last = this._STACK.size() - 1; last > this._stackPointer; --last) {
                    NavigationPoint point = (NavigationPoint)this._STACK.pop();
                    point.removeNavigationPointListener((NavigationPointListener)this);
                    this._ACTION_MAP.remove(point);
                }
                this._STACK.push(destination);
                destination.addNavigationPointListener((NavigationPointListener)this);
                if (this._STACK.size() > this._navigationLevel) {
                    NavigationPoint point = (NavigationPoint)this._STACK.remove(0);
                    point.removeNavigationPointListener((NavigationPointListener)this);
                    this._ACTION_MAP.remove(point);
                } else {
                    ++this._stackPointer;
                }
                this.updateHistory();
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    public synchronized int navigateTo(NavigationPoint point, boolean isEdit) throws Exception {
        int status = 1;
        if (point != null && (status = this.navigateTo(point)) == 0 && isEdit) {
            this.setLastEdit((NavigationPoint)point.copyTo(null));
        }
        return status;
    }

    public void registerEditorNavigationPoint(Class pt, Class editor) {
        if (editor != null) {
            if (pt != null) {
                this._EDITOR_MAP.put(editor, pt);
            } else {
                this._EDITOR_MAP.remove(editor);
            }
        }
    }

    public synchronized void setLastEdit(Context context) {
        EditorNavigationPoint point = this.createDefaultNavigationPoint(context);
        if (point != null) {
            try {
                point.navigate();
                point.refresh();
                this.setLastEdit((NavigationPoint)point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canNavigateToLastEdit() {
        return this._lastEditLocation != null;
    }

    public synchronized int navigateToLastEdit() throws Exception {
        int status = 1;
        if (this._lastEditLocation != null) {
            status = this.navigateTo((NavigationPoint)this._lastEditLocation.copyTo(null));
        }
        return status;
    }

    private void setLastEdit(NavigationPoint point) {
        if (point != null) {
            try {
                point.addNavigationPointListener((NavigationPointListener)this);
                if (this._lastEditLocation != null) {
                    this._lastEditLocation.removeNavigationPointListener((NavigationPointListener)this);
                }
                this._lastEditLocation = point;
                this.updateLastEdit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private EditorNavigationPoint createDefaultNavigationPoint(Context context) {
        View view;
        EditorNavigationPoint point = null;
        View view2 = view = context != null ? context.getView() : null;
        if (view == null && context != null) {
            Context ctx;
            EditorManager mgr = EditorManager.getEditorManager();
            Editor editor = mgr != null ? mgr.getCurrentEditor() : null;
            Context context2 = ctx = editor != null ? editor.getContext() : null;
            if (ctx != null && ctx.getNode() == context.getNode()) {
                context = new Context(context);
                context.setView((View)editor);
                view = editor;
            }
        }
        if (view instanceof Editor) {
            try {
                Class<?> viewCls = view.getClass();
                Class enpCls = (Class)this._EDITOR_MAP.get(viewCls);
                if (enpCls == null) {
                    for (viewCls = viewCls.getSuperclass(); viewCls != null && Editor.class.isAssignableFrom(viewCls) && (enpCls = (Class)this._EDITOR_MAP.get(viewCls)) == null; viewCls = viewCls.getSuperclass()) {
                    }
                    if (enpCls == null) {
                        enpCls = DefaultNavigationPoint.class;
                    }
                }
                point = (EditorNavigationPoint)enpCls.newInstance();
                point.setContext(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return point;
    }

    private synchronized void navigationLevelChanged(int level) {
        int overage = this._STACK.size() - ++level;
        Object orphan = null;
        if (this._stackPointer < overage && level > 0) {
            orphan = this._STACK.remove(this._stackPointer);
        }
        if (overage > 0) {
            List sublist = this._STACK.subList(0, overage);
            ArrayList uniqueList = new ArrayList(sublist);
            Iterator i = uniqueList.iterator();
            if (i != null) {
                while (i.hasNext()) {
                    NavigationPoint point = (NavigationPoint)i.next();
                    point.removeNavigationPointListener((NavigationPointListener)this);
                    this._ACTION_MAP.remove(point);
                }
            }
            this._STACK.removeAll(uniqueList);
            if (orphan != null) {
                this._STACK.add(0, orphan);
                this._stackPointer = 0;
            } else {
                this._stackPointer -= overage;
            }
        }
        this._navigationLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int jumpTo(NavigationPoint destination) throws Exception {
        int status = 1;
        int index = destination != null ? this._STACK.indexOf(destination) : -1;
        try {
            ++this._navigating;
            if (index >= 0) {
                if (this._navigating == 1) {
                    this.updateNavigationPoint();
                }
                if ((status = destination.navigate()) == 0 && this._navigating == 1) {
                    this._stackPointer = index;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    private void updateNavigationPoint() {
        NavigationPoint current = this.getCurrentNavigationPoint();
        if (current != null) {
            current.refresh();
        }
    }

    private synchronized NavigationPoint getCurrentNavigationPoint() {
        return this._stackPointer >= 0 ? (NavigationPoint)this._STACK.get(this._stackPointer) : null;
    }

    private synchronized void updateHistory() {
        IdeAction forwardAction;
        IdeAction backAction = IdeAction.find((int)73);
        if (backAction != null) {
            ArrayList<Action> history = new ArrayList<Action>();
            int minimum = this._stackPointer > 15 ? this._stackPointer - 15 : 0;
            for (int i = this._stackPointer - 1; i >= minimum; --i) {
                history.add(this.findOrCreateAction((NavigationPoint)this._STACK.get(i)));
            }
            backAction.putValue("ActionMenuActions", (Object)history.toArray(new Action[history.size()]));
            if (history.size() > 0) {
                this.updateBackTooltip((Action)history.get(0));
            } else {
                this.updateBackTooltip(null);
            }
            backAction.updateAction();
        }
        if ((forwardAction = IdeAction.find((int)74)) != null) {
            ArrayList<Action> history = new ArrayList<Action>();
            int size = this._STACK.size();
            int maximum = size - 1 - this._stackPointer > 15 ? this._stackPointer + 15 : size - 1;
            for (int i = this._stackPointer + 1; i <= maximum; ++i) {
                history.add(this.findOrCreateAction((NavigationPoint)this._STACK.get(i)));
            }
            forwardAction.putValue("ActionMenuActions", (Object)history.toArray(new Action[history.size()]));
            if (history.size() > 0) {
                this.updateForwardTooltip((Action)history.get(0));
            } else {
                this.updateForwardTooltip(null);
            }
            forwardAction.updateAction();
        }
    }

    private void updateBackTooltip(Action action) {
        IdeAction backAction = IdeAction.find((int)73);
        if (backAction != null) {
            if (action != null) {
                String tooltip = (String)action.getValue("ShortDescription");
                backAction.putValue("ShortDescription", (Object)IdeArb.format((int)431, (Object[])new String[]{tooltip}));
            } else {
                backAction.putValue("ShortDescription", (Object)IdeArb.getString((int)428));
            }
        }
    }

    private void updateForwardTooltip(Action action) {
        IdeAction forwardAction = IdeAction.find((int)74);
        if (forwardAction != null) {
            if (action != null) {
                String tooltip = (String)action.getValue("ShortDescription");
                forwardAction.putValue("ShortDescription", (Object)IdeArb.format((int)435, (Object[])new String[]{tooltip}));
            } else {
                forwardAction.putValue("ShortDescription", (Object)IdeArb.getString((int)432));
            }
        }
    }

    private void updateLastEdit() {
        IdeAction lastEditAction = IdeAction.find((int)75);
        if (lastEditAction != null) {
            lastEditAction.setEnabled(this.canNavigateToLastEdit());
        }
    }

    private synchronized Action findOrCreateAction(NavigationPoint point) {
        Object action = null;
        if (point != null && (action = (Action)this._ACTION_MAP.get(point)) == null) {
            action = new HistoryAction(point);
            this._ACTION_MAP.put(point, action);
        }
        return action;
    }

    public void editorOpened(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public synchronized void editorClosed(Editor editor) {
        EditorManager eMgr;
        List editorList;
        if (this._navigating == 0 && ((editorList = (eMgr = EditorManager.getEditorManager()).getAllEditors()) == null || editorList.size() == 0)) {
            this._STACK.clear();
            this._stackPointer = -1;
        }
    }

    public synchronized void editorActivated(Editor editor) {
        if (this._navigating == 0) {
            View view;
            NavigationPoint current = this.getCurrentNavigationPoint();
            Context context = current != null ? current.getContext() : null;
            View view2 = view = context != null ? context.getView() : null;
            if (view == editor) {
                return;
            }
            Context context2 = context = editor != null ? editor.getContext() : null;
            if (context != null) {
                try {
                    EditorNavigationPoint point = this.createDefaultNavigationPoint(context);
                    if (point != null) {
                        this.navigateTo((NavigationPoint)point);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void expired(NavigationPointEvent e) {
        NavigationPoint point;
        NavigationPoint navigationPoint = point = e != null ? (NavigationPoint)e.getSource() : null;
        if (point != null) {
            int index = this._STACK.indexOf(point);
            if (index >= 0) {
                point.removeNavigationPointListener((NavigationPointListener)this);
                this._STACK.remove(point);
                this._ACTION_MAP.remove(point);
                if (this._stackPointer >= index) {
                    --this._stackPointer;
                }
                this.updateHistory();
            } else if (point == this._lastEditLocation) {
                point.removeNavigationPointListener((NavigationPointListener)this);
                this._lastEditLocation = null;
                this.updateLastEdit();
            }
        }
    }

    public synchronized void descriptionChanged(NavigationPointEvent e) {
        Action action;
        NavigationPoint point = e != null ? (NavigationPoint)e.getSource() : null;
        Action action2 = action = point != null ? (Action)this._ACTION_MAP.get(point) : null;
        if (action != null) {
            int index;
            Object newValue = point.getIcon();
            if (action.getValue("SmallIcon") != newValue) {
                action.putValue("SmallIcon", newValue);
            }
            newValue = point.getLongLabel();
            if (action.getValue("Name") != newValue) {
                action.putValue("Name", newValue);
            }
            newValue = point.getShortLabel();
            if (action.getValue("ShortDescription") != newValue) {
                action.putValue("ShortDescription", newValue);
            }
            if ((index = this._STACK.indexOf(point)) == this._stackPointer - 1) {
                this.updateBackTooltip(action);
            } else if (index == this._stackPointer + 1) {
                this.updateForwardTooltip(action);
            }
        }
    }

    private final class HistoryAction
    extends ToggleAction {
        NavigationPoint point;

        HistoryAction(NavigationPoint point) {
            super(point.getLongLabel(), point.getIcon());
            this.point = point;
            this.putValue("ShortDescription", point.getShortLabel());
        }

        public void actionPerformed(ActionEvent event) {
            try {
                NavigationManagerImpl.this.jumpTo(this.point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

