/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import javax.ide.util.Version;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSystemMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.migration.MigrationClassInfo;
import oracle.ideimpl.migration.MigrationDialog;
import oracle.ideimpl.migration.MigratorsHook;
import oracle.javatools.controls.SplashScreen;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class MigrationManagerImpl
extends MigrationManager {
    private final String MINIMUM_JDEVELOPER_SUPPORTED_VERSION = "10.1.29999";
    private final String MINIMUM_OTHER_SUPPORTED_VERSION = "0";
    private final String SYSTEM_DIR_PREFIX = "system";
    private final String ORACLE_JDEVELOPER_DIR_PREFIX = "oracle.jdeveloper.";
    private boolean migrationInitiated = false;
    private Map<MigrationClassInfo, Extension> _registrations = new HashMap<MigrationClassInfo, Extension>();
    private List<Migrator> _migrators;
    private HashMap<Extension, List<Migrator>> _migratorsPerExtensionMap = new HashMap();
    private boolean migrationDone;
    private static MigrationManager _instance;
    private final String IS_MIGRATIONDIALOG_FILE = ".ismigration";
    private final boolean DEFAULT_VALUE_USER_CANCELLED = false;
    private File migrationFile;

    public static synchronized MigrationManager getInstance() {
        if (_instance == null) {
            _instance = new MigrationManagerImpl();
        }
        return _instance;
    }

    private List<Migrator> getMigrators(Extension descriptor) {
        this.getMigrators();
        return this._migratorsPerExtensionMap.get(descriptor);
    }

    public synchronized List<Migrator> getMigrators() {
        if (this._migrators == null) {
            this.registerHookMigrators();
            this._migrators = new ArrayList<Migrator>();
            for (Map.Entry<MigrationClassInfo, Extension> entry : this._registrations.entrySet()) {
                Migrator migrator = this.buildMigrator(entry.getKey());
                if (migrator == null) continue;
                Extension desc = entry.getValue();
                List<Migrator> list = this.getMigrators(desc);
                if (list == null) {
                    list = new ArrayList<Migrator>();
                    this._migratorsPerExtensionMap.put(desc, list);
                }
                list.add(migrator);
                this._migrators.add(migrator);
            }
        }
        return this._migrators;
    }

    private void registerHookMigrators() {
        ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
        MigratorsHook migHook = (MigratorsHook)reg.getHook(MigratorsHook.ELEMENT);
        if (migHook != null) {
            for (Map.Entry<Extension, Collection<MigrationClassInfo>> entry : migHook.getMigratorClassesByExtension().entrySet()) {
                Extension ext = entry.getKey();
                for (MigrationClassInfo migratorClassInfo : entry.getValue()) {
                    this.registerMigrator(migratorClassInfo, ext);
                }
            }
        }
    }

    private Migrator buildMigrator(MigrationClassInfo migrationClassInfo) {
        Migrator migrator = null;
        try {
            MetaClass metaClass = migrationClassInfo.getMetaClass();
            Class<?> clazz = Class.forName(metaClass.getClassName(), true, metaClass.getClassLoader());
            migrator = (Migrator)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return migrator;
    }

    public Migrator getMigrator(Class cls) {
        for (Migrator migrator : this.getMigrators()) {
            if (cls != migrator.getClass()) continue;
            return migrator;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOracleHomeDirectory(File systemDir) {
        try {
            String path = Ide.getInstallDirectory((File)systemDir);
            if (path != null && ModelUtil.hasLength((String)path)) {
                File jDevBinDir = new File(path);
                return jDevBinDir.getParentFile().getParentFile();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedInputStream in = null;
        try {
            File paletteXmlFile = new File(systemDir, "palette.xml");
            if (paletteXmlFile.exists()) {
                in = new BufferedInputStream(new FileInputStream(paletteXmlFile));
                DOMParser domParser = new DOMParser();
                domParser.parse((InputStream)in);
                XMLDocument doc = domParser.getDocument();
                final XMLElement rootElem = (XMLElement)doc.getDocumentElement();
                NSResolver xmlns = new NSResolver(){
                    private final String uri;
                    {
                        this.uri = rootElem.getNamespaceURI();
                    }

                    public String resolveNamespacePrefix(String prefix) {
                        return "a".equals(prefix) ? this.uri : null;
                    }
                };
                NodeList bc4jTaglibs = rootElem.selectNodes("a:jsplibrary[a:prefix='jbo' or a:prefix='bc4juix' or a:prefix='uix']/a:location/text()", xmlns);
                File oracleHome = MigrationManagerImpl.findOracleHome(bc4jTaglibs, 3);
                if (oracleHome != null) {
                    File file = oracleHome;
                    return file;
                }
                NodeList ojspTaglibs = rootElem.selectNodes("a:jsplibrary[a:prefix='email' or a:prefix='fileaccess' or a:prefix='JESI' or a:prefix='jwcache' or a:prefix='database' or a:prefix='util' or a:prefix='XML' or a:prefix='EJB']/a:location/text()", xmlns);
                File file = MigrationManagerImpl.findOracleHome(ojspTaglibs, 4);
                return file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static File findOracleHome(NodeList nodes, int levelsUp) {
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node node = nodes.item(i);
            String dirStr = node.getNodeValue();
            if (!ModelUtil.hasLength((String)dirStr)) continue;
            File dir = new File(dirStr);
            for (int j = 0; j < levelsUp && dir != null; dir = dir.getParentFile(), ++j) {
            }
            if (dir == null) continue;
            return dir;
        }
        return null;
    }

    public void registerMigrator(String className, Extension desc) {
        this.registerMigrator(new MigrationClassInfo(className, new MetaClass(((Object)((Object)this)).getClass().getClassLoader(), className)), desc);
    }

    private synchronized void registerMigrator(MigrationClassInfo migrationClassInfo, Extension desc) {
        Migrator migrator;
        if (migrationClassInfo == null || desc == null) {
            return;
        }
        if (!this._registrations.containsKey(migrationClassInfo)) {
            this._registrations.put(migrationClassInfo, desc);
        }
        if (this._migrators != null && (migrator = this.buildMigrator(migrationClassInfo)) != null) {
            this._migrators.add(migrator);
            List<Migrator> list = this.getMigrators(desc);
            if (list == null) {
                list = new ArrayList<Migrator>();
                this._migratorsPerExtensionMap.put(desc, list);
            }
            list.add(migrator);
        }
    }

    public String migrate(boolean userDirectoryCreated, boolean systemDirectoryCreated) {
        IdeArgs args = Ide.getIdeArgs();
        boolean migrateFlag = args.isMigrate();
        boolean noMigrateFlag = System.getProperty("nomigrate", null) != null;
        boolean noNagFlag = args.hasArg("-nonag");
        boolean headless = !args.getCreateUI();
        this.migrationFile = new File(Ide.getSystemDirectory(), ".ismigration");
        URL currentSystemDirectory = URLFactory.newDirURL((String)Ide.getSystemDirectory());
        Version currentVersion = this.versionFromFolderName(currentSystemDirectory);
        SortedMap<Version, String> previousInstallations = this.getPreviousInstallations(currentVersion);
        File sourceInstallation = !previousInstallations.isEmpty() ? new File((String)previousInstallations.get(previousInstallations.firstKey())) : null;
        if (noMigrateFlag || noNagFlag || headless) {
            return null;
        }
        if (!this.migratorsAvailable()) {
            return null;
        }
        if (migrateFlag) {
            this.deleteMigrationFile();
        }
        if (!migrateFlag) {
            if (userDirectoryCreated) {
                return null;
            }
            if (previousInstallations.isEmpty() && !systemDirectoryCreated) {
                return null;
            }
            if (!this.newExtensionInstalled()) {
                return null;
            }
            if (!this.newExtensionExisted(previousInstallations)) {
                return null;
            }
            if (!this.userSuppressedDialog()) {
                File userSelectedSourceInstallation = this.getUserSelectionSourceInstallation(previousInstallations, currentVersion, false);
                if (userSelectedSourceInstallation == null) {
                    return null;
                }
                sourceInstallation = userSelectedSourceInstallation;
                return this.executeMigration(sourceInstallation, false);
            }
            if (!this.userOKedInThePast()) {
                return null;
            }
            return this.executeMigration(sourceInstallation, false);
        }
        File userSelectedSourceInstallation = this.getUserSelectionSourceInstallation(previousInstallations, currentVersion, true);
        if (userSelectedSourceInstallation == null) {
            return null;
        }
        sourceInstallation = userSelectedSourceInstallation;
        return this.executeMigration(sourceInstallation, false);
    }

    private void showSplashScreen() {
        if (!SplashScreen.isDismissed()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.setKeepHidden((boolean)false);
                    SplashScreen.setVisible((boolean)true);
                }
            });
        }
    }

    private void hideSplashScreen() {
        if (!SplashScreen.isDismissed()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.setVisible((boolean)false);
                    SplashScreen.setKeepHidden((boolean)true);
                }
            });
        }
    }

    public Version versionFromFolderName(URL dir) {
        Version version = null;
        String folderName = URLFileSystem.getFileName((URL)dir);
        if (folderName.startsWith("system") && folderName.length() > "system".length()) {
            String versionNumber = folderName.substring("system".length());
            if (!Version.isValid((String)versionNumber)) {
                return null;
            }
            try {
                version = new Version(versionNumber);
            }
            catch (NumberFormatException nfe) {}
        } else if (folderName.equalsIgnoreCase("system")) {
            URL[] subdirs;
            for (URL subdir : subdirs = URLFileSystem.list((URL)dir)) {
                String subdirName = URLFileSystem.getFileName((URL)subdir);
                if (!subdirName.startsWith("oracle.jdeveloper.")) continue;
                String versionNumber = subdirName.substring("oracle.jdeveloper.".length());
                try {
                    version = new Version(versionNumber);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return version;
    }

    private String executeMigration(File sourceInstallation, boolean migrateFlag) {
        StringBuilder errorBuffer = new StringBuilder();
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection allExtensions = extReg.getExtensions();
        ArrayList<Extension> extensionsToMigrate = new ArrayList<Extension>();
        for (Extension extension : allExtensions) {
            if (!migrateFlag && !extReg.isNewlyInstalled(extension.getID())) continue;
            extensionsToMigrate.add(extension);
        }
        try {
            String productID = ProductInformation.getProductID();
            boolean isSameSystemDirectoryAsBefore = new File(Ide.getSystemDirectory()).equals(sourceInstallation);
            for (Extension extension : extensionsToMigrate) {
                File preferencesFileSrc;
                Iterator<Migrator> iter;
                URL sourceInstallationURL = MigrationManagerImpl.findNewestSystemDir(URLFactory.newFileURL((File)sourceInstallation), extension, isSameSystemDirectoryAsBefore);
                File src = new File(URLFileSystem.getPlatformPathName((URL)sourceInstallationURL));
                URL url = extReg.getSystemDirectory(extension.getID());
                File dest = new File(url.getPath());
                if (src == null || dest == null || src.equals(dest)) continue;
                List<Migrator> list = this.getMigrators(extension);
                Iterator<Migrator> iterator = iter = list != null ? list.iterator() : null;
                if (iter != null) {
                    while (iter.hasNext()) {
                        Migrator migrator = iter.next();
                        int[] categories = migrator.getMigrationCategories();
                        for (int index = 0; index < categories.length; ++index) {
                            int category = categories[index];
                            migrator.setSelected(category, migrator.canMigrate(category, src));
                        }
                        String[] errors = null;
                        try {
                            errors = migrator.migrate(src, dest);
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            FeedbackManager.reportException((Throwable)t);
                        }
                        if (errors == null || errors.length <= 0) continue;
                        for (int j = 0; j < errors.length; ++j) {
                            errorBuffer.append(errors[j]);
                            errorBuffer.append("\n");
                        }
                        errorBuffer.append("\n");
                    }
                }
                if (productID.equals(extension.getID())) {
                    File productPrefsSrc = new File(src, "product-preferences.xml");
                    HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/hash", "ide:preferences");
                    try {
                        Preferences prefs = Preferences.getPreferences();
                        io.open(URLFactory.newFileURL((File)productPrefsSrc), (Object)prefs.getProperties());
                        prefs.save();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                if (!(preferencesFileSrc = new File(src, "preferences.xml")).isFile() || !preferencesFileSrc.canRead()) continue;
                File preferencesFileDest = new File(dest, "preferences.xml");
                try {
                    URLFileSystem.copy((URL)URLFactory.newFileURL((File)preferencesFileSrc), (URL)URLFactory.newFileURL((File)preferencesFileDest));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this.migrationInitiated = true;
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            errorBuffer.append(pw.toString());
        }
        return errorBuffer.toString();
    }

    private File getUserSelectionSourceInstallation(SortedMap<Version, String> previousInstallations, Version currentVersion, boolean migrateFlag) {
        MigrationDialog dlg = new MigrationDialog(SwingUtils.getToplevelWindow(), previousInstallations, migrateFlag, currentVersion, this);
        this.hideSplashScreen();
        boolean userOKedMigration = dlg.runDialog();
        this.showSplashScreen();
        if (dlg.userChoiceCheckBoxIsSelelected()) {
            this.saveUserSuppressedDialog(false, userOKedMigration);
        }
        if (!userOKedMigration) {
            return null;
        }
        File sourceInstallation = dlg.sourceSelected();
        dlg.dispose();
        return sourceInstallation;
    }

    private boolean migratorsAvailable() {
        List<Migrator> migrators = this.getMigrators();
        return migrators != null && !migrators.isEmpty();
    }

    private boolean newExtensionExisted(SortedMap previousInstallations) {
        return true;
    }

    private boolean newExtensionInstalled() {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection allExtensions = extReg.getExtensions();
        for (Extension extension : allExtensions) {
            if (!extReg.isNewlyInstalled(extension.getID())) continue;
            return true;
        }
        return false;
    }

    private SortedMap<Version, String> getPreviousInstallations(Version currentVersion) {
        if (ProductInformation.getProductInformation().getShortName() == null) {
            return new TreeMap<Version, String>();
        }
        String product = ProductInformation.getProductInformation().getShortName();
        Version MIN_VERSION_FOR_MIGRATION = product.startsWith("JDev") ? new Version("10.1.29999") : new Version("0");
        URL currentSystemDirectory = URLFactory.newDirURL((String)Ide.getSystemDirectory());
        URL userDirectory = URLFactory.newDirURL((String)Ide.getUserSettingsDirectory());
        URL[] subFolders = URLFileSystem.list((URL)userDirectory);
        TreeMap<Version, String> previousInstallations = new TreeMap<Version, String>();
        if (subFolders != null) {
            for (URL dir : subFolders) {
                Version candiateVersionToMigrateFrom;
                if (!URLFileSystem.isDirectory((URL)dir) || URLFileSystem.equals((URL)dir, (URL)currentSystemDirectory) || (candiateVersionToMigrateFrom = this.versionFromFolderName(dir)) == null || candiateVersionToMigrateFrom.compareTo(currentVersion) >= 0 || candiateVersionToMigrateFrom.compareTo(MIN_VERSION_FOR_MIGRATION) < 0) continue;
                previousInstallations.put(candiateVersionToMigrateFrom, URLFileSystem.getPlatformPathName((URL)dir));
            }
        }
        return previousInstallations;
    }

    public void migrate() {
        boolean userDirectoryCreated = false;
        boolean systemDirectoryCreated = false;
        this.migrate(userDirectoryCreated, systemDirectoryCreated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMigration() {
        block10: {
            try {
                XMLMigrator migrator;
                XMLMigrator xMLMigrator = migrator = this.migrationInitiated ? (XMLMigrator)this.getMigrator(IdeSystemMigrator.class) : null;
                if (migrator == null || !migrator.isSelected(0)) break block10;
                MigrationManagerImpl migrationManagerImpl = this;
                synchronized (migrationManagerImpl) {
                    SwingUtilities.invokeLater(new WorkspacesMigrator(this));
                    while (!this.migrationDone) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException e) {
                        }
                        catch (Throwable t) {
                            if (!(t instanceof ThreadDeath)) break;
                            throw (ThreadDeath)t;
                        }
                    }
                }
            }
            finally {
                MigrationManagerImpl.setMigrationManager(null);
            }
        }
    }

    private static String expandExtensionId(String name) {
        if (name != null && name.startsWith("o.") && name.length() > "o.".length()) {
            return "oracle." + name.substring("o.".length());
        }
        return name;
    }

    private static boolean hasPrefix(String text, String prefix) {
        return text.startsWith(prefix) && text.length() > prefix.length();
    }

    private static String removePrefix(String text, String prefix) {
        return text.substring(prefix.length());
    }

    private static boolean isNewerThan(Version one, Version two) {
        return one.compareTo(two) > 0;
    }

    private static boolean isOlderThan(Version one, Version two) {
        return one.compareTo(two) < 0;
    }

    private static Version versionOrNull(String version) {
        try {
            return new Version(version);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    static URL findNewestSystemDir(URL root, Extension extension, boolean isSameSystemDirectoryAsBefore) {
        URL[] subdirs = URLFileSystem.list((URL)root);
        if (subdirs == null) {
            return root;
        }
        String extensionId = extension.getID();
        Version extensionVersion = extension.getVersion();
        Version productVersion = null;
        String rootName = URLFileSystem.getFileName((URL)root);
        if (MigrationManagerImpl.hasPrefix(rootName, "system")) {
            productVersion = MigrationManagerImpl.versionOrNull(MigrationManagerImpl.removePrefix(rootName, "system"));
        }
        Version latestVersion = null;
        URL latestUrl = null;
        for (URL dir : subdirs) {
            if (!URLFileSystem.isDirectory((URL)dir)) continue;
            String name = MigrationManagerImpl.expandExtensionId(URLFileSystem.getFileName((URL)dir));
            Version candidateVersion = null;
            if (productVersion != null && name.equals(extensionId)) {
                candidateVersion = productVersion;
            } else if (MigrationManagerImpl.hasPrefix(name, extensionId + ".")) {
                candidateVersion = MigrationManagerImpl.versionOrNull(MigrationManagerImpl.removePrefix(name, extensionId + "."));
            }
            if (candidateVersion == null) continue;
            if (!isSameSystemDirectoryAsBefore && candidateVersion.equals((Object)extensionVersion)) {
                latestVersion = candidateVersion;
                latestUrl = dir;
                break;
            }
            if (!MigrationManagerImpl.isOlderThan(candidateVersion, extensionVersion) || latestVersion != null && !MigrationManagerImpl.isNewerThan(candidateVersion, latestVersion)) continue;
            latestVersion = candidateVersion;
            latestUrl = dir;
            break;
        }
        if (latestUrl == null) {
            return root;
        }
        return latestUrl;
    }

    private boolean userSuppressedDialog() {
        return this.migrationFile.exists();
    }

    private void saveUserSuppressedDialog(boolean showMigrationDialog, boolean okToMigrate) {
        if (showMigrationDialog) {
            this.deleteMigrationFile();
        } else {
            if (this.migrationFile.exists()) {
                this.deleteMigrationFile();
            }
            try {
                DataOutputStream ds = new DataOutputStream(new FileOutputStream(this.migrationFile));
                ds.writeBoolean(okToMigrate);
                ds.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean userOKedInThePast() {
        if (this.migrationFile.exists()) {
            try {
                DataInputStream is = new DataInputStream(new FileInputStream(this.migrationFile));
                boolean res = is.readBoolean();
                is.close();
                return res;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean deleteMigrationFile() {
        if (this.migrationFile.exists()) {
            return this.migrationFile.delete();
        }
        return false;
    }

    static {
        Object2Dom.obsoleteClassNames.add("oracle.jdeveloper.ceditor.template.TemplateOptions");
        Object2Dom.obsoleteClassNames.add("oracle.jdevimpl.runner.profile.ProfilerSettings");
        Object2Dom.obsoleteClassNames.add("oracle.jdevimpl.cm.dt.config.ConnectionOptions");
    }

    private static final class WorkspacesMigrator
    implements Runnable {
        MigrationManagerImpl _manager;

        WorkspacesMigrator(MigrationManagerImpl manager) {
            this._manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            MigrationManagerImpl migrationManagerImpl = this._manager;
            synchronized (migrationManagerImpl) {
                block20: {
                    try {
                        Node[] workspaceNodes;
                        MigrationInfo[] minfos;
                        Workspaces workspacesToMigrate = null;
                        Iterator iter = Ide.getSystem().getChildren();
                        if (iter != null) {
                            while (iter.hasNext()) {
                                Object o = iter.next();
                                if (!(o instanceof Workspaces)) continue;
                                workspacesToMigrate = (Workspaces)o;
                                break;
                            }
                        }
                        if (workspacesToMigrate == null) {
                            return;
                        }
                        ArrayList list = new ArrayList();
                        iter = workspacesToMigrate.getChildren();
                        if (iter != null) {
                            while (iter.hasNext()) {
                                Object wo = iter.next();
                                if (!(wo instanceof Workspace)) continue;
                                list.add(wo);
                            }
                        }
                        if (list.size() == 0) {
                            return;
                        }
                        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator((String)NodeMigrator.getLookupKey((Node)((Node)list.get(0))));
                        if (nodeMigrator == null || nodeMigrator.checkVersions(minfos = nodeMigrator.getMigrationInfos(workspaceNodes = list.toArray(new Node[list.size()]))) != MigrationInfo.MIGRATION_PENDING) break block20;
                        MigrationInfo[] resultInfo = nodeMigrator.migrate(minfos);
                        ArrayList<Node> nodes = null;
                        for (int i = 0; i < resultInfo.length; ++i) {
                            if (resultInfo[i].getMigrationStatus() == MigrationInfo.MIGRATION_DONE) continue;
                            Node toRemove = resultInfo[i].getNode();
                            workspacesToMigrate.remove((Element)toRemove);
                            if (nodes == null) {
                                nodes = new ArrayList<Node>();
                            }
                            nodes.add(toRemove);
                        }
                        if (nodes != null && nodes.size() > 0) {
                            UpdateMessage.fireChildrenRemoved((Subject)workspacesToMigrate, (Collection)nodes);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        this._manager.migrationDone = true;
                        ((Object)((Object)this._manager)).notifyAll();
                    }
                }
                try {
                    Ide.getDefaultProject().save();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }
}

