/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.io.File;
import oracle.ide.migration.Migrator;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.resource.IdeImplArb;

public final class LayoutsMigrator
implements Migrator {
    private static final int LAYOUT_CATEGORY = 0;
    boolean _selected = true;

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        switch (category) {
            case 0: {
                return IdeImplArb.getString(81);
            }
        }
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        File sourceFile;
        return category == 0 && sourceDir != null && sourceDir.exists() && (sourceFile = LayoutsMigrator.getLayoutsFile(sourceDir)).exists() && sourceFile.canRead();
    }

    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this._selected = selected;
        }
    }

    public boolean isSelected(int category) {
        return category == 0 ? this._selected : false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        String sourceDirName;
        if (!this._selected) {
            return null;
        }
        File sourceFile = LayoutsMigrator.getLayoutsFile(sourceDir);
        if (sourceFile.exists() && (sourceDirName = sourceDir.getName()) != null && sourceDirName.startsWith("oracle.ide.")) {
            DefaultStructuredPropertyAccess layoutInfo = null;
            try {
                layoutInfo = DefaultStructuredPropertyAccess.loadFromXML((File)sourceFile);
                if (layoutInfo != null) {
                    StructuredPropertyAccess knownDockableFactories = layoutInfo.getChildNode("knownDockableFactories");
                    if (knownDockableFactories != null) {
                        LayoutsMigrator.removeChild(knownDockableFactories, "SystemNavigatorWindow");
                        LayoutsMigrator.removeChild(knownDockableFactories, "_SUB_SystemNavigatorWindow");
                        LayoutsMigrator.removeChild(knownDockableFactories, "ApplicationNavigatorWindow");
                        LayoutsMigrator.removeChild(knownDockableFactories, "_SUB_ApplicationNavigatorWindow");
                    }
                    LayoutsMigrator.removeChild((StructuredPropertyAccess)layoutInfo, "editorPositions");
                }
            }
            catch (Exception ex) {
                return new String[]{ex.getLocalizedMessage()};
            }
            File destFile = LayoutsMigrator.getLayoutsFile(destDir);
            try {
                DefaultStructuredPropertyAccess.saveToXML((StructuredPropertyAccess)layoutInfo, (File)destFile);
            }
            catch (Exception ex) {
                return new String[]{ex.getLocalizedMessage()};
            }
        }
        return null;
    }

    private static void removeChild(StructuredPropertyAccess props, String childName) {
        StructuredPropertyAccess childNode = props.getChildNode(childName);
        if (childNode != null) {
            props.removeChild(childNode);
        }
    }

    private static final File getLayoutsFile(File sourceDir) {
        return new File(sourceDir, "windowinglayout.xml");
    }
}

