/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.extension.spi.ListenerInfo;
import javax.ide.model.Document;
import javax.ide.model.DocumentEvent;
import javax.ide.model.DocumentFactory;
import javax.ide.model.DocumentListener;
import javax.ide.model.Recognizer;
import javax.ide.model.spi.DocumentHook;
import javax.ide.model.spi.SuffixRecognizer;
import javax.ide.model.spi.XMLRootElementRecognizer;
import javax.ide.model.text.TextDocument;
import javax.ide.model.xml.XMLDocument;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLRecognizer;
import oracle.ide.xml.XMLUtil;
import oracle.ideimpl.jsr198.Util;
import oracle.ideimpl.jsr198.model.Custom;
import oracle.ideimpl.jsr198.model.CustomNode;
import oracle.ideimpl.jsr198.model.CustomTextNode;

public class OracleDocumentFactory
extends DocumentFactory {
    private Collection _recognizers;
    private CustomNodeRootListener _customNodeRootListener;

    public final Document findOrCreate(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        try {
            URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
            if (!URLFileSystem.exists((URL)url)) {
                return null;
            }
            Node ideNode = NodeFactory.findOrCreate((URL)url);
            return this.convert(uri, ideNode);
        }
        catch (Exception mue) {
            mue.printStackTrace();
            return null;
        }
    }

    public final Document find(URI uri) {
        try {
            URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
            Node ideNode = NodeFactory.find((URL)url);
            return this.convert(uri, ideNode);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    public final Document recache(URI oldURI, URI newURI) {
        if (oldURI == null) {
            throw new NullPointerException("oldURI is null");
        }
        if (newURI == null) {
            throw new NullPointerException("newURI is null");
        }
        try {
            Document doc = this.find(oldURI);
            if (doc == null) {
                return null;
            }
            URL oldURL = VirtualFileSystem.getVirtualFileSystem().toURL(oldURI);
            URL newURL = VirtualFileSystem.getVirtualFileSystem().toURL(newURI);
            Node ideNode = NodeFactory.find((URL)oldURL);
            if (ideNode != null) {
                NodeFactory.recache((URL)oldURL, (URL)newURL, (Node)ideNode);
            }
            return doc;
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
            return null;
        }
    }

    public final Collection getCachedDocuments() {
        ArrayList<Document> cachedNodes = new ArrayList<Document>();
        Iterator i = NodeFactory.getCachedNodes();
        while (i.hasNext()) {
            Node ideNode = (Node)i.next();
            URL nodeURL = ideNode.getURL();
            URI nodeURI = URIFactory.newURI((URL)nodeURL);
            cachedNodes.add(this.find(nodeURI));
        }
        return Collections.unmodifiableCollection(cachedNodes);
    }

    public MetaClass recognize(URI uri) {
        DocumentHook docHook = (DocumentHook)ExtensionRegistry.getExtensionRegistry().getHook(DocumentHook.ELEMENT);
        String suffix = VirtualFileSystem.getVirtualFileSystem().getSuffix(uri);
        Collection suffixRecognizers = docHook.getSuffixRecognizers();
        for (SuffixRecognizer sr : suffixRecognizers) {
            if (!sr.containsSuffix(suffix)) continue;
            return sr.getDocumentClass();
        }
        StartElementPacket sep = null;
        Collection xmlRecognizers = docHook.getXMLRecognizers();
        for (SuffixRecognizer sr : xmlRecognizers) {
            if (!sr.containsSuffix(suffix)) continue;
            if (sep == null) {
                try {
                    URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                    sep = XMLUtil.getXMLRootElement((URL)url);
                }
                catch (FileNotFoundException fnfe) {
                    break;
                }
                catch (MalformedURLException mue) {
                    mue.printStackTrace();
                    break;
                }
            }
            if (!this.matchesXMLRecognizer(sep, sr)) continue;
            return sr.getDocumentClass();
        }
        for (Recognizer recognizer : this.getRecognizers()) {
            MetaClass metaClass = recognizer.recognize(uri);
            if (metaClass == null) continue;
            return metaClass;
        }
        return null;
    }

    private Collection getRecognizers() {
        DocumentHook docHook = (DocumentHook)ExtensionRegistry.getExtensionRegistry().getHook(DocumentHook.ELEMENT);
        if (this._recognizers == null) {
            this._recognizers = new ArrayList();
            Collection customRecognizers = docHook.getCustomRecognizers();
            for (MetaClass recognizerClass : customRecognizers) {
                Recognizer recognizer = (Recognizer)Util.createInstance(recognizerClass, Recognizer.class, "recognizer");
                if (recognizer == null) continue;
                this._recognizers.add(recognizer);
            }
        }
        return this._recognizers;
    }

    private boolean matchesXMLRecognizer(StartElementPacket sep, SuffixRecognizer xmlRec) {
        if (xmlRec instanceof XMLRootElementRecognizer) {
            XMLRootElementRecognizer xmlRecognizer = (XMLRootElementRecognizer)xmlRec;
            for (ElementName en : xmlRecognizer.getRootElements()) {
                if ((sep.localName == null || !sep.localName.equals(en.getLocalName())) && en.getLocalName() != null || (sep.namespaceURI == null || !sep.namespaceURI.equals(en.getNamespaceURI())) && en.getNamespaceURI() != null) continue;
                return true;
            }
        }
        return false;
    }

    protected Document convert(URI uri, Node ideNode) {
        if (ideNode == null) {
            return null;
        }
        Object document = null;
        if (ideNode instanceof Custom) {
            return ((Custom)ideNode).getJSRDocument();
        }
        document = ideNode instanceof Project ? new javax.ide.model.Project() : (ideNode instanceof TextNode ? new TextDocument() : new Document());
        document.setURI(uri);
        return document;
    }

    protected void initialize() {
        DocumentHook docHook = (DocumentHook)ExtensionRegistry.getExtensionRegistry().getHook(DocumentHook.ELEMENT);
        this.registerDocumentListeners(docHook);
        this.registerDocumentTypes(docHook);
    }

    protected void registerDocumentTypes(DocumentHook docHook) {
        Collection suffixRecognizers = docHook.getSuffixRecognizers();
        for (SuffixRecognizer sr : suffixRecognizers) {
            MetaClass docClass = sr.getDocumentClass();
            Class ideClass = this.getOracleNodeClassFor(docClass.getClassName());
            if (ideClass == null) {
                Document doc = (Document)Util.createInstance(docClass, Document.class, "document");
                ideClass = this.getCustomNodeClassFor(doc.getClass());
            }
            for (String suffix : sr.getSuffixes()) {
                if (docClass.getClass().equals(XMLDocument.class.getName())) {
                    XMLRecognizer.treatExtensionAsXML((String)suffix);
                    continue;
                }
                oracle.ide.model.Recognizer.mapExtensionToClass((String)suffix, (Class)ideClass);
            }
        }
        if (!docHook.getCustomRecognizers().isEmpty()) {
            oracle.ide.model.Recognizer.registerLowPriorityRecognizer((oracle.ide.model.Recognizer)new oracle.ide.model.Recognizer(){

                public Class recognize(URL url) {
                    URI uri = URIFactory.newURI((URL)url);
                    for (Recognizer recognizer : OracleDocumentFactory.this.getRecognizers()) {
                        Class customClass;
                        MetaClass docMetaClass = recognizer.recognize(uri);
                        if (docMetaClass == null || (customClass = OracleDocumentFactory.this.getCustomNodeClassFor(docMetaClass)) == null) continue;
                        return customClass;
                    }
                    return null;
                }
            });
        }
    }

    private void registerDocumentListeners(DocumentHook docHook) {
        Collection docListeners = docHook.getDocumentListeners();
        for (ListenerInfo info : docListeners) {
            Class oracleNodeClass;
            MetaClass listenerClass = info.getListenerClass();
            String typeClass = info.getSourceID();
            if (typeClass == null || typeClass.trim().length() == 0) {
                typeClass = "javax.ide.model.Document";
            }
            if ((oracleNodeClass = this.getOracleNodeClassFor(typeClass)) != null) {
                Node.addNodeListenerForTypeHierarchy((Class)oracleNodeClass, (NodeListener)new NodeListenerAdapter(listenerClass));
                continue;
            }
            if (this._customNodeRootListener == null) {
                this._customNodeRootListener = new CustomNodeRootListener();
                Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)this._customNodeRootListener);
            }
            this._customNodeRootListener.addDelegateListener(typeClass, new NodeListenerAdapter(listenerClass));
        }
    }

    private final Class getCustomNodeClassFor(MetaClass jsrCustomClass) {
        Document document = (Document)Util.createInstance(jsrCustomClass, Document.class, "document");
        return document == null ? null : this.getCustomNodeClassFor(document.getClass());
    }

    protected Class getCustomNodeClassFor(Class jsrCustomClass) {
        if (TextDocument.class.isAssignableFrom(jsrCustomClass)) {
            return CustomTextNode.class;
        }
        if (Document.class.isAssignableFrom(jsrCustomClass)) {
            return CustomNode.class;
        }
        return null;
    }

    protected Class getOracleNodeClassFor(String jsrClass) {
        if (TextDocument.class.getName().equals(jsrClass)) {
            return TextNode.class;
        }
        if (Document.class.getName().equals(jsrClass)) {
            return Node.class;
        }
        if (javax.ide.model.Project.class.getName().equals(jsrClass)) {
            return Project.class;
        }
        return null;
    }

    public Document uncache(URI uri) {
        try {
            Document doc = this.find(uri);
            if (doc == null) {
                return null;
            }
            URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
            Node node = NodeFactory.uncache((URL)url);
            node.close();
            return doc;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static final class NullDocumentListener
    implements DocumentListener {
        private NullDocumentListener() {
        }

        public void opened(DocumentEvent event) {
        }

        public void willBeClosed(DocumentEvent event) {
        }

        public void closed(DocumentEvent event) {
        }

        public void modified(DocumentEvent event) {
        }

        public void willBeSaved(DocumentEvent event) {
        }

        public void saved(DocumentEvent event) {
        }
    }

    private final class NodeListenerAdapter
    extends NodeListener {
        private final MetaClass _listenerClass;
        private DocumentListener _jsrListener;

        NodeListenerAdapter(MetaClass listenerClass) {
            this._listenerClass = listenerClass;
        }

        private DocumentListener getJSRListener() {
            if (this._jsrListener == null) {
                try {
                    this._jsrListener = (DocumentListener)this._listenerClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._jsrListener = new NullDocumentListener();
                }
            }
            return this._jsrListener;
        }

        private DocumentEvent convertEvent(NodeEvent e) {
            URL url = e.getNodeURL();
            URI uri = URIFactory.newURI((URL)url);
            Document doc = OracleDocumentFactory.this.find(uri);
            if (doc == null) {
                ExtensionRegistry.getOracleRegistry().getLogger().fine("Not firing JSR-198 document event for " + URLFileSystem.getFileName((URL)url) + ". (it's probably not in jdeveloper's node factory)");
                return null;
            }
            return new DocumentEvent(doc);
        }

        public void nodeOpened(NodeEvent e) {
            DocumentEvent de = this.convertEvent(e);
            if (de != null) {
                this.getJSRListener().opened(de);
            }
        }

        public void nodeWillClose(NodeEvent e) {
            DocumentEvent de = this.convertEvent(e);
            if (de != null) {
                this.getJSRListener().willBeClosed(de);
            }
        }

        public void nodeClosed(NodeEvent e) {
            DocumentEvent de = this.convertEvent(e);
            if (de != null) {
                this.getJSRListener().closed(de);
            }
        }

        public void nodeWillBeSaved(NodeEvent e) {
            DocumentEvent de = this.convertEvent(e);
            if (de != null) {
                this.getJSRListener().willBeSaved(de);
            }
        }

        public void nodeSaved(NodeEvent e) {
            DocumentEvent de = this.convertEvent(e);
            if (de != null) {
                this.getJSRListener().saved(de);
            }
        }

        public void nodeReverted(NodeEvent e) {
        }
    }

    private final class CustomNodeRootListener
    extends NodeListener {
        private Map _classNamesToListenerLists = new HashMap();

        private CustomNodeRootListener() {
        }

        public void addDelegateListener(String customNodeClass, NodeListener listener) {
            ArrayList<NodeListener> list = (ArrayList<NodeListener>)this._classNamesToListenerLists.get(customNodeClass);
            if (list == null) {
                list = new ArrayList<NodeListener>();
                this._classNamesToListenerLists.put(customNodeClass, list);
            }
            list.add(listener);
        }

        private List findListeners(Node jdevNode) {
            Document jsrDoc;
            List listeners;
            if (jdevNode instanceof Custom && (listeners = (List)this._classNamesToListenerLists.get((jsrDoc = ((Custom)jdevNode).getJSRDocument()).getClass().getName())) != null) {
                return listeners;
            }
            return Collections.EMPTY_LIST;
        }

        public void nodeOpened(NodeEvent e) {
            Iterator i = this.findListeners(e.getNode()).iterator();
            while (i.hasNext()) {
                ((NodeListener)i.next()).nodeOpened(e);
            }
        }

        public void nodeWillClose(NodeEvent e) {
            Iterator i = this.findListeners(e.getNode()).iterator();
            while (i.hasNext()) {
                ((NodeListener)i.next()).nodeOpened(e);
            }
        }

        public void nodeClosed(NodeEvent e) {
            Iterator i = this.findListeners(e.getNode()).iterator();
            while (i.hasNext()) {
                ((NodeListener)i.next()).nodeClosed(e);
            }
        }

        public void nodeWillBeSaved(NodeEvent e) {
            Iterator i = this.findListeners(e.getNode()).iterator();
            while (i.hasNext()) {
                ((NodeListener)i.next()).nodeWillBeSaved(e);
            }
        }

        public void nodeSaved(NodeEvent e) {
            Iterator i = this.findListeners(e.getNode()).iterator();
            while (i.hasNext()) {
                ((NodeListener)i.next()).nodeSaved(e);
            }
        }

        public void nodeReverted(NodeEvent e) {
            Iterator i = this.findListeners(e.getNode()).iterator();
            while (i.hasNext()) {
                ((NodeListener)i.next()).nodeReverted(e);
            }
        }
    }
}

