/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.editor;

import java.awt.Component;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.ide.command.Controller;
import javax.ide.editor.Editor;
import javax.ide.util.MetaClass;
import javax.ide.view.GUIPanel;
import javax.ide.view.View;
import javax.swing.JLabel;
import oracle.ide.Context;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.jsr198.Util;
import oracle.ideimpl.jsr198.model.ContextFactory;
import oracle.ideimpl.jsr198.prefs.JavaxIdePreferences;

public final class JavaxIdeEditor
extends oracle.ide.editor.Editor {
    private final MetaClass _javaxIdeEditorClass;
    private Editor _javaxEditor;

    public JavaxIdeEditor(MetaClass javaxEditorClass) {
        this._javaxIdeEditorClass = javaxEditorClass;
    }

    Editor getJavaxIdeEditor() {
        if (this._javaxEditor == null) {
            this._javaxEditor = (Editor)Util.createInstance(this._javaxIdeEditorClass, Editor.class, "editor");
            if (this._javaxEditor == null) {
                this._javaxEditor = new NullJavaxIdeEditor();
            }
        }
        return this._javaxEditor;
    }

    public void open() {
    }

    public void close() {
        super.close();
        this.getJavaxIdeEditor().close();
        this.saveSettings(null);
    }

    public void activate() {
        super.activate();
        this.getJavaxIdeEditor().activate();
    }

    public void deactivate() {
        super.deactivate();
        this.getJavaxIdeEditor().deactivate();
    }

    public Component getGUI() {
        return (Component)this.getJavaxIdeEditor().getGUI().getRootComponent();
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        this.getJavaxIdeEditor().open(ContextFactory.createJsrContext(context));
        this.loadSettings(null);
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public void saveSettings(StructuredPropertyAccess element) {
        try {
            Preferences prefs = JavaxIdePreferences.getEditorPreferences(this.getJavaxIdeEditor());
            this.getJavaxIdeEditor().save(prefs);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public void loadSettings(StructuredPropertyAccess element) {
        try {
            Preferences prefs = JavaxIdePreferences.getEditorPreferences(this.getJavaxIdeEditor());
            this.getJavaxIdeEditor().restore(prefs);
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    private class NullJavaxIdeEditor
    extends Editor {
        private JLabel _error = new JLabel("Error");
        private GUIPanel _gui = new GUIPanel((Object)this._error, null);

        private NullJavaxIdeEditor() {
        }

        public void open(javax.ide.command.Context context) {
        }

        public void close() {
        }

        public void restore(Preferences preference) {
        }

        public void save(Preferences preference) {
        }

        public GUIPanel getGUI() {
            return this._gui;
        }

        public javax.ide.command.Context getContext() {
            return null;
        }

        public void activate() {
        }

        public void deactivate() {
        }

        public Controller getController() {
            return null;
        }

        public View parent() {
            return null;
        }

        public String getID() {
            return null;
        }

        public void setVisible(boolean visible) {
        }

        public boolean isVisible() {
            return false;
        }
    }
}

