/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.build;

import java.util.ArrayList;
import java.util.Collections;
import javax.ide.build.AbortBuildException;
import javax.ide.build.BuildEvent;
import javax.ide.build.BuildListener;
import javax.ide.build.BuildSystem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ideimpl.jsr198.model.ContextFactory;

public final class OracleBuildSystem
extends BuildSystem {
    public void build(javax.ide.command.Context context) {
        Context oideContext = ContextFactory.createOracleContext(context);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.compile(oideContext, true, false);
        }
    }

    public boolean isBuilding() {
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            return compiler.isBusy(Ide.getMainWindow().getIdeMainWindowView().getContext());
        }
        return false;
    }

    protected void initialize() {
        super.initialize();
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)new JavaxBuildSystemListener());
        }
    }

    private class JavaxBuildSystemListener
    implements BuildSystemListener {
        private javax.ide.command.Context _javaxContext;
        private boolean _abortedDuringPreBuild = false;

        private JavaxBuildSystemListener() {
        }

        public void buildWillStart(Context context) throws BuildSystemVetoException {
            this._abortedDuringPreBuild = false;
            if (OracleBuildSystem.this.hasListeners()) {
                this._javaxContext = ContextFactory.createJsrContext(context);
                BuildEvent be = new BuildEvent((BuildSystem)OracleBuildSystem.this, this._javaxContext);
                ArrayList<BuildListener> notifiedListeners = new ArrayList<BuildListener>();
                try {
                    for (BuildListener listener : OracleBuildSystem.this.getListeners()) {
                        notifiedListeners.add(listener);
                        listener.preBuild(be);
                    }
                }
                catch (AbortBuildException abe) {
                    this._abortedDuringPreBuild = true;
                    be = new BuildEvent((BuildSystem)OracleBuildSystem.this, this._javaxContext, false);
                    Collections.reverse(notifiedListeners);
                    for (BuildListener listener : notifiedListeners) {
                        try {
                            listener.postBuild(be);
                        }
                        catch (AbortBuildException e) {}
                    }
                    throw new BuildSystemVetoException(abe.getMessage());
                }
            }
        }

        public void buildFinished(int errorCount, int warningCount, int infoCount) throws BuildSystemVetoException {
            if (OracleBuildSystem.this.hasListeners() && !this._abortedDuringPreBuild) {
                boolean success = errorCount == 0;
                BuildEvent be = new BuildEvent((BuildSystem)OracleBuildSystem.this, this._javaxContext, success);
                for (BuildListener l : OracleBuildSystem.this.getListeners()) {
                    try {
                        l.postBuild(be);
                    }
                    catch (AbortBuildException e) {
                        be = new BuildEvent((BuildSystem)OracleBuildSystem.this, this._javaxContext, false);
                    }
                }
            }
            this._javaxContext = null;
        }

        public void cleanWillStart(Context context) throws BuildSystemVetoException {
        }

        public void cleanFinished(Context context) throws BuildSystemVetoException {
        }
    }
}

