/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.history.Historian;
import oracle.ide.history.HistoryContext;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.HistoryPersistenceException;
import oracle.ide.history.LocalState;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.history.HistoryOptions;
import oracle.ideimpl.history.LocalStateImpl2;
import oracle.ideimpl.history.NodeInfo;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.IntArrayFactory;
import oracle.javatools.dialogs.MessageDialog;

public final class HistoryManagerImpl2
extends HistoryManager
implements Observer {
    static final String HISTORY_DIRNAME = ".history";
    static final String HISTORY_DIR;
    private static final String NS_STATES = "LocalHistory2:States";
    private static final String NS_NODES = "LocalHistory2:Nodes";
    private static HistoryManager INSTANCE;
    private static final Map LOCTYPE_TO_HISTORIANTYPE;
    private static final Map HISTORIANTYPE_TO_HISTORIAN;
    private static final LocalState[] EMPTY_STATE_ARRAY;
    private static final Object[] EMPTY_DELETIONS_ARRAY;
    private static URL _tmpDir;
    private boolean _active;
    private boolean _alreadyMigrated;
    private boolean _alreadyPruned;
    private boolean _testingEnabled;
    private Date _lastPrunedTimestamp;
    private int _lastPrunedRevisions = Integer.MAX_VALUE;
    private NameSpace _nodeNameSpace = NameSpace.getNameSpace((String)"LocalHistory2:Nodes", (SecondaryKeyProvider)NodeInfo.SECONDARY_KEY_PROVIDER);
    private NameSpace _stateNameSpace = NameSpace.getNameSpace((String)"LocalHistory2:States");
    private HistoryMigrator _historyMigrator;
    private static Logger logger;

    public static HistoryManager getInstance() {
        return INSTANCE;
    }

    private HistoryManagerImpl2() {
        this._nodeNameSpace.setAutoFlush(1500L);
        this._stateNameSpace.setAutoFlush(1500L);
    }

    public boolean hasLocalHistory(URL url) {
        if (!this.isSupported(url)) {
            return false;
        }
        if (!this.sanityCheck()) {
            return false;
        }
        try {
            this.persistInitialState(new URL[]{url});
        }
        catch (HistoryPersistenceException e) {
            logger.log(Level.WARNING, "An error occurred while fetching local history.", e);
        }
        NodeInfo nodeInfo = this.findNode(url, false);
        if (nodeInfo != null) {
            Iterator i = this._stateNameSpace.getKeyIterator(LocalStateImpl2.asKey(nodeInfo.getNodeId()));
            return i != null && i.hasNext();
        }
        return false;
    }

    public LocalState[] getLocalHistory(URL url) {
        if (!this.isSupported(url)) {
            return EMPTY_STATE_ARRAY;
        }
        if (!this.sanityCheck()) {
            return EMPTY_STATE_ARRAY;
        }
        try {
            this.persistInitialState(new URL[]{url});
        }
        catch (HistoryPersistenceException e) {
            logger.log(Level.WARNING, "An error occurred while fetching local history.", e);
        }
        NodeInfo nodeInfo = this.findNode(url);
        if (nodeInfo == null) {
            return EMPTY_STATE_ARRAY;
        }
        LinkedList<LocalState> list = this.findStatesByNodeId(nodeInfo.getNodeId());
        if (list.isEmpty()) {
            return EMPTY_STATE_ARRAY;
        }
        Object[] states = new LocalState[list.size()];
        list.toArray(states);
        Arrays.sort(states);
        return states;
    }

    public LocalState[] getLocalHistory(Object objId) {
        if (!this.sanityCheck()) {
            return EMPTY_STATE_ARRAY;
        }
        if (!(objId instanceof Integer)) {
            return EMPTY_STATE_ARRAY;
        }
        Integer nodeId = (Integer)objId;
        LinkedList<LocalState> list = this.findStatesByNodeId(nodeId);
        if (list.isEmpty()) {
            return EMPTY_STATE_ARRAY;
        }
        Object[] states = new LocalState[list.size()];
        list.toArray(states);
        Arrays.sort(states);
        return states;
    }

    public LocalState getLastState(Object objId) {
        if (!this.sanityCheck()) {
            return null;
        }
        if (!(objId instanceof Integer)) {
            return null;
        }
        Integer nodeId = (Integer)objId;
        Iterator keys = this._stateNameSpace.getReverseKeyIterator(LocalStateImpl2.asKey(nodeId));
        LocalStateImpl2 state = LocalStateImpl2.assemble(this._stateNameSpace.getRecord((String)keys.next()));
        NodeInfo activeNode = this.findActiveNode(nodeId);
        state.setNodeUrl(activeNode.getNodeURL());
        return state;
    }

    public Object[] getDeletions(URL url) {
        if (!this.sanityCheck()) {
            return EMPTY_DELETIONS_ARRAY;
        }
        List<NodeInfo> deletedNodes = this.findDeletedNodes();
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        for (NodeInfo nodeInfo : deletedNodes) {
            try {
                LocalStateImpl2 state;
                Iterator states = this._stateNameSpace.getReverseKeyIterator(LocalStateImpl2.asKey(nodeInfo.getNodeId()));
                if (states == null || !URLFileSystem.isBaseURLFor((URL)url, (URL)(state = LocalStateImpl2.assemble(this._stateNameSpace.getRecord((String)states.next()))).getStateURL())) continue;
                nodeIds.add(nodeInfo.getNodeId());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "An error occurred while fetching local history.", e);
            }
        }
        Object[] result = new Object[nodeIds.size()];
        nodeIds.toArray(result);
        return result;
    }

    public void persistInitialState(URL[] urls) throws HistoryPersistenceException {
        if (!this.areSupported(urls)) {
            return;
        }
        if (!this.sanityCheck()) {
            return;
        }
        if (urls == null || urls.length == 0) {
            return;
        }
        Date timestamp = null;
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            Historian historian = null;
            Node node = null;
            if (!URLFileSystem.isDirectory((URL)url)) {
                try {
                    node = NodeFactory.findOrCreate((URL)url);
                }
                catch (Exception e) {
                    throw new HistoryPersistenceException((Throwable)e);
                }
                Historian historian2 = historian = node != null ? HistoryManagerImpl2.getHistorian(node.getClass()) : null;
            }
            if (historian == null) continue;
            NodeInfo nodeInfo = this.findNode(url, true);
            boolean needState = false;
            Iterator states = this._stateNameSpace.getReverseKeyIterator(LocalStateImpl2.asKey(nodeInfo.getNodeId()));
            if (states == null || !states.hasNext()) {
                needState = true;
            } else {
                LocalState state = this.findState((String)states.next());
                boolean bl = needState = URLFileSystem.lastModified((URL)url) > state.getDate().getTime();
            }
            if (!needState || !URLFileSystem.exists((URL)url)) continue;
            timestamp = timestamp == null ? new Date(System.currentTimeMillis()) : timestamp;
            LocalStateImpl2 newState = new LocalStateImpl2(nodeInfo.getNodeId(), timestamp, url, url, IdeImplArb.getString(73));
            URL dataUrl = newState.createDataURL();
            try {
                historian.copy(url, dataUrl);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "An error occurred while saving history data.", e);
            }
            if (dataUrl == null || !URLFileSystem.exists((URL)dataUrl)) continue;
            URLFileSystem.setLastModified((URL)dataUrl, (long)timestamp.getTime());
            this.saveState(newState);
            if (node == null) continue;
            node.attach((Observer)this);
        }
    }

    public void persist(URL[] urls, String description) throws HistoryPersistenceException {
        if (!this.areSupported(urls)) {
            return;
        }
        if (!this.sanityCheck()) {
            return;
        }
        if (urls == null || urls.length == 0) {
            return;
        }
        Date timestamp = null;
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            Historian historian = null;
            Node node = null;
            if (!URLFileSystem.isDirectory((URL)url)) {
                try {
                    node = NodeFactory.findOrCreate((URL)url);
                }
                catch (Exception e) {
                    throw new HistoryPersistenceException((Throwable)e);
                }
                Historian historian2 = historian = node != null ? HistoryManagerImpl2.getHistorian(node.getClass()) : null;
            }
            if (historian == null) continue;
            NodeInfo nodeInfo = this.findNode(url, true);
            timestamp = timestamp == null ? new Date(System.currentTimeMillis()) : timestamp;
            LocalStateImpl2 newState = new LocalStateImpl2(nodeInfo.getNodeId(), timestamp, url, url, description);
            URL dataUrl = newState.createDataURL();
            try {
                historian.recordContents(url, dataUrl);
                URLFileSystem.setLastModified((URL)dataUrl, (long)timestamp.getTime());
                this.saveState(newState);
                if (node == null) continue;
                node.attach((Observer)this);
                continue;
            }
            catch (Exception e) {
                throw new HistoryPersistenceException((Throwable)e);
            }
        }
    }

    public void restore(LocalState[] states, Context context) throws HistoryPersistenceException {
        if (!this.sanityCheck()) {
            return;
        }
        for (int i = 0; i < states.length; ++i) {
            LocalState state = states[i];
            URL nodeURL = state.getNodeURL();
            URL stateURL = state.getStateURL();
            NodeInfo nodeInfo = this.findNode(stateURL);
            try {
                Command cmd;
                Context ctx;
                Node node = NodeFactory.find((URL)stateURL);
                if (nodeInfo.isDeleted()) {
                    if (node != null) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)IdeImplArb.format(75, URLFileSystem.getPlatformPathName((URL)stateURL)), (String)IdeImplArb.getString(76), null);
                        continue;
                    }
                    if (URLFileSystem.exists((URL)stateURL) && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)IdeImplArb.format(78, URLFileSystem.getPlatformPathName((URL)stateURL)), (String)IdeImplArb.getString(76), null)) continue;
                    URLFileSystem.copy((URL)state.getDataURL(), (URL)stateURL);
                    NodeInfo activeNode = this.findActiveNode(nodeInfo.getNodeId());
                    if (activeNode != null && activeNode.equals(nodeInfo)) {
                        activeNode.setDeleted(true);
                        this.saveNode(activeNode);
                    }
                    nodeInfo.setDeleted(false);
                    this.saveNode(nodeInfo);
                    node = NodeFactory.findOrCreate((URL)stateURL);
                    continue;
                }
                if (!URLFileSystem.equals((URL)nodeURL, (URL)stateURL)) {
                    ctx = new Context(context);
                    node = NodeFactory.findOrCreate((URL)nodeURL);
                    ctx.setNode(node);
                    HistoryContext.setLocalState((Context)ctx, (LocalState)state);
                    cmd = CommandProcessor.createCommand((String)"oracle.ide.cmd.RestoreHistoryRenameCommand", (Context)ctx);
                    if (cmd == null) continue;
                    CommandProcessor.getInstance().invoke(cmd);
                    continue;
                }
                ctx = new Context(context);
                node = node != null ? node : NodeFactory.findOrCreate((URL)stateURL);
                ctx.setNode(node);
                HistoryContext.setLocalState((Context)ctx, (LocalState)state);
                cmd = CommandProcessor.createCommand((String)"oracle.ide.cmd.RestoreHistoryCommand", (Context)ctx);
                if (cmd == null) continue;
                CommandProcessor.getInstance().invoke(cmd);
                continue;
            }
            catch (Exception e) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)IdeImplArb.format(77, new String[]{URLFileSystem.getPlatformPathName((URL)stateURL)}), (String)IdeImplArb.getString(76), null);
            }
        }
    }

    public void clear(URL[] urls) {
        if (!this.sanityCheck()) {
            return;
        }
        HashSet<Integer> nodesToDelete = new HashSet<Integer>();
        for (URL url : urls) {
            NodeInfo nodeInfo = this.findNode(url);
            if (nodeInfo == null) continue;
            this.deleteNode(nodeInfo);
            List<LocalState> states = this.findStatesByNodeIdAndStateUrl(nodeInfo.getNodeId(), url);
            for (LocalState state : states) {
                URL dataUrl = state.getDataURL();
                if (URLFileSystem.exists((URL)dataUrl) && !URLFileSystem.delete((URL)dataUrl)) {
                    Exception e = new Exception("ERROR: History Manager couldn't successfully delete " + dataUrl.getPath());
                    e.printStackTrace();
                }
                this.deleteState((LocalStateImpl2)state);
            }
            if (nodesToDelete.contains(nodeInfo.getNodeId())) continue;
            nodesToDelete.add(nodeInfo.getNodeId());
        }
        for (Integer nodeId : nodesToDelete) {
            URL historyUrl = URLFactory.newDirURL((String)(HISTORY_DIR + nodeId));
            if (URLFileSystem.exists((URL)historyUrl) && URLFileSystem.list((URL)historyUrl).length == 0) {
                URLFileSystem.delete((URL)historyUrl);
            }
            IdManager.freeId(nodeId);
        }
    }

    public void registerHistorian(Class historianCls, Class objCls) {
        if (historianCls == null) {
            throw new IllegalArgumentException("Historian class cannot be null");
        }
        if (objCls == null) {
            throw new IllegalArgumentException("Node class cannot be null");
        }
        if (!Historian.class.isAssignableFrom(historianCls)) {
            throw new IllegalArgumentException("Historian [" + historianCls + "] is not of type " + Historian.class.getName());
        }
        if (!Node.class.isAssignableFrom(objCls)) {
            throw new IllegalArgumentException("Node [" + objCls + "] is not of type " + Node.class.getName());
        }
        if (LOCTYPE_TO_HISTORIANTYPE.put(objCls, historianCls) == null) {
            NodeFactory.attach((Observer)this, (Class)objCls);
        }
    }

    public Class getRegisteredHistorian(Class objCls) {
        if (objCls == null) {
            throw new IllegalArgumentException("Node class cannot be null");
        }
        if (!Node.class.isAssignableFrom(objCls)) {
            throw new IllegalArgumentException("Node [" + objCls + "] is not of type " + Node.class.getName());
        }
        return (Class)LOCTYPE_TO_HISTORIANTYPE.get(objCls);
    }

    public void update(Object observed, UpdateMessage msg) {
        int id;
        int n = id = msg != null ? msg.getMessageID() : -1;
        if (id == NodeFactory.NODE_CACHED) {
            Node node = (Node)observed;
            if (this.findNode(node.getURL(), false) != null) {
                node.attach((Observer)this);
            }
        } else if (id == NodeFactory.NODE_UNCACHED) {
            Node node = (Node)observed;
            URL oldUrl = node.getURL();
            node.detach((Observer)this);
            this.updateNode(oldUrl, null);
        } else if (id == UpdateMessage.OBJECT_RENAMED) {
            Object obj;
            URL observedUrl = ((Node)observed).getURL();
            URL addedUrl = null;
            URL modifiedUrl = null;
            if (!msg.getAddObjects().isEmpty()) {
                obj = msg.getAddObjects().get(0);
                if (obj instanceof Node) {
                    addedUrl = ((Node)obj).getURL();
                } else if (obj instanceof URL) {
                    addedUrl = (URL)obj;
                }
            }
            if (!msg.getModifyObjects().isEmpty()) {
                obj = msg.getModifyObjects().get(0);
                if (obj instanceof Node) {
                    modifiedUrl = ((Node)obj).getURL();
                } else if (obj instanceof URL) {
                    modifiedUrl = (URL)obj;
                }
            }
            if (modifiedUrl != null && !URLFileSystem.equals(modifiedUrl, (URL)observedUrl)) {
                this.updateNode(modifiedUrl, observedUrl);
            } else if (modifiedUrl != null && !URLFileSystem.equals(modifiedUrl, addedUrl)) {
                this.updateNode(modifiedUrl, addedUrl);
            } else if (addedUrl != null && !URLFileSystem.equals((URL)observedUrl, (URL)addedUrl)) {
                this.updateNode(observedUrl, addedUrl);
            }
        }
    }

    synchronized void optionsChanged(HistoryOptions options) {
        this._active = options != null ? options.isEnabled() : this._active;
        Date timestamp = this._timestamp();
        int revisions = this._maxRevisions();
        if (revisions < this._lastPrunedRevisions || this._lastPrunedTimestamp == null || this._lastPrunedTimestamp.after(timestamp)) {
            this._alreadyPruned = false;
        }
    }

    public synchronized void enableTesting() {
        this._active = true;
        this._testingEnabled = true;
    }

    public synchronized void disableTesting() {
        this._active = false;
        this._testingEnabled = false;
    }

    void setHistoryMigrator(HistoryMigrator migrator) {
        this._historyMigrator = migrator;
    }

    private final boolean sanityCheck() {
        if (!this._active) {
            return false;
        }
        this.migrateHistoryIfNeeded();
        this.pruneHistory();
        return true;
    }

    private synchronized void pruneHistory() {
        if (this._alreadyPruned) {
            return;
        }
        Iterator states = this._stateNameSpace.getReverseKeyIterator();
        if (states == null || !states.hasNext()) {
            this._alreadyPruned = true;
            return;
        }
        HashMap<Integer, Integer> nodes = new HashMap<Integer, Integer>();
        HashMap<String, LocalStateImpl2> nodesToDelete = new HashMap<String, LocalStateImpl2>();
        Date timestamp = this._timestamp();
        int maxRevisions = this._maxRevisions();
        while (states.hasNext()) {
            String key = (String)states.next();
            int count = 0;
            boolean delete = false;
            try {
                LocalStateImpl2 state = LocalStateImpl2.assemble(this._stateNameSpace.getRecord(key));
                if (timestamp.after(state.getDate())) {
                    delete = true;
                } else {
                    Integer value = (Integer)nodes.get(state.getNodeId());
                    int n = count = value != null ? value : 0;
                    if (++count > maxRevisions) {
                        delete = true;
                    }
                }
                if (delete) {
                    this._stateNameSpace.delRecord(key);
                    URL url = state.getDataURL();
                    if (!URLFileSystem.delete((URL)url)) {
                        Exception e = new Exception("ERROR: History Manager couldn't successfully delete " + url.getPath());
                        e.printStackTrace();
                    }
                    nodesToDelete.put(state.getStateURL().toString(), state);
                    continue;
                }
                nodes.put((Integer)state.getNodeId(), count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (LocalState state : nodesToDelete.values()) {
            URL historyUrl = URLFactory.newDirURL((String)(HISTORY_DIR + state.getNodeId()));
            if (!URLFileSystem.exists((URL)historyUrl) || URLFileSystem.list((URL)historyUrl).length != 0) continue;
            if (!URLFileSystem.delete((URL)historyUrl)) {
                Exception e = new Exception("ERROR: History Manager couldn't successfully delete " + historyUrl);
                e.printStackTrace();
            }
            try {
                this._nodeNameSpace.delRecord(NodeInfo.asKey(state.getStateURL()));
                IdManager.freeId((Integer)state.getNodeId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._lastPrunedTimestamp = timestamp;
        this._lastPrunedRevisions = maxRevisions;
        this._alreadyPruned = true;
    }

    private synchronized void migrateHistoryIfNeeded() {
        if (this._alreadyMigrated) {
            return;
        }
        if (this._historyMigrator != null && !this._historyMigrator.hasRun()) {
            this._historyMigrator.migrateHistory(this._nodeNameSpace, this._stateNameSpace, IdManager.getInstance()._idsNameSpace);
        }
        this._alreadyMigrated = true;
    }

    private boolean areSupported(URL[] urls) {
        for (URL url : urls) {
            if (!this.isSupported(url)) continue;
            return true;
        }
        return false;
    }

    private boolean isSupported(URL url) {
        if (this._testingEnabled) {
            return true;
        }
        return _tmpDir == null || !URLFileSystem.isBaseURLFor((URL)_tmpDir, (URL)url);
    }

    private static Historian getHistorian(Class nodeCls) {
        Class historianCls;
        Historian historian = null;
        if (nodeCls != null && (historianCls = (Class)LOCTYPE_TO_HISTORIANTYPE.get(nodeCls)) != null && (historian = (Historian)HISTORIANTYPE_TO_HISTORIAN.get(historianCls)) == null) {
            try {
                historian = (Historian)historianCls.newInstance();
                HISTORIANTYPE_TO_HISTORIAN.put(historianCls, historian);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "An error occurred while fetching a Historian.", e);
            }
        }
        return historian;
    }

    private Date _timestamp() {
        IdeSettings settings = Ide.getSettings();
        HistoryOptions options = (HistoryOptions)((Object)settings.getData("HistoryOptions"));
        long time = System.currentTimeMillis();
        if (options != null) {
            int days = options.getLifespan();
            if (days >= 0) {
                long milliseconds = (long)days * 24L * 60L * 60L * 1000L;
                time -= milliseconds;
            } else {
                time = Long.MIN_VALUE;
            }
        } else {
            time = Long.MIN_VALUE;
        }
        return new Date(time);
    }

    private int _maxRevisions() {
        IdeSettings settings = Ide.getSettings();
        HistoryOptions options = (HistoryOptions)((Object)settings.getData("HistoryOptions"));
        int maxRevisions = Integer.MAX_VALUE;
        if (options != null) {
            maxRevisions = options.getRevisions();
        }
        return maxRevisions;
    }

    private void updateNode(URL oldUrl, URL newUrl) {
        NodeInfo node = this.findNode(oldUrl);
        if (newUrl == null) {
            if (node != null) {
                node.setDeleted(true);
                this.saveNode(node);
            }
        } else {
            NodeInfo conflict = this.findNode(newUrl);
            if (conflict != null) {
                this.updateNode(newUrl, null);
            } else if (node != null) {
                node.setDeleted(true);
                this.saveNode(node);
                node = new NodeInfo(node.getNodeId(), newUrl);
                this.saveNode(node);
            }
        }
    }

    private NodeInfo findNode(URL url) {
        return this.findNode(url, false);
    }

    private NodeInfo findNode(URL nodeUrl, boolean create) {
        NodeInfo nodeInfo = null;
        byte[] data = this._nodeNameSpace.getRecord(NodeInfo.asKey(nodeUrl));
        if (data != null && data.length > 0) {
            nodeInfo = NodeInfo.assemble(data);
        } else if (create) {
            nodeInfo = new NodeInfo(IdManager.getNextId(), nodeUrl);
            this.saveNode(nodeInfo);
        }
        return nodeInfo;
    }

    private NodeInfo findActiveNode(Integer nodeId) {
        Collection nodes = this._nodeNameSpace.getRecords("nodeId", String.valueOf(nodeId));
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        NodeInfo node = null;
        Iterator it = nodes.iterator();
        while (it.hasNext() && (node = NodeInfo.assemble((byte[])it.next())).isDeleted()) {
        }
        return node;
    }

    private LocalState findState(String key) {
        return LocalStateImpl2.assemble(this._stateNameSpace.getRecord(key));
    }

    private LinkedList<LocalState> findStatesByNodeId(Integer nodeId) {
        NodeInfo activeNode = this.findActiveNode(nodeId);
        LinkedList<LocalState> states = new LinkedList<LocalState>();
        Iterator keys = this._stateNameSpace.getKeyIterator(LocalStateImpl2.asKey(nodeId));
        while (keys.hasNext()) {
            LocalStateImpl2 state = LocalStateImpl2.assemble(this._stateNameSpace.getRecord((String)keys.next()));
            if (activeNode != null) {
                state.setNodeUrl(activeNode.getNodeURL());
            }
            states.add(state);
        }
        return states;
    }

    private List<LocalState> findStatesByNodeIdAndStateUrl(Integer nodeId, URL stateUrl) {
        NodeInfo activeNode = this.findActiveNode(nodeId);
        LinkedList<LocalState> states = new LinkedList<LocalState>();
        Iterator keys = this._stateNameSpace.getKeyIterator(LocalStateImpl2.asKey(nodeId, stateUrl));
        while (keys.hasNext()) {
            LocalStateImpl2 state = LocalStateImpl2.assemble(this._stateNameSpace.getRecord((String)keys.next()));
            if (activeNode != null) {
                state.setNodeUrl(activeNode.getNodeURL());
            }
            states.add(state);
        }
        return states;
    }

    private List<NodeInfo> findDeletedNodes() {
        ArrayList<NodeInfo> nodes = new ArrayList<NodeInfo>();
        Collection data = this._nodeNameSpace.getRecords("deleted", String.valueOf(true));
        if (data != null && !data.isEmpty()) {
            for (byte[] chunk : data) {
                nodes.add(NodeInfo.assemble(chunk));
            }
        }
        return nodes;
    }

    private void saveState(LocalStateImpl2 state) {
        this._stateNameSpace.putRecord(state.getKey(), LocalStateImpl2.disassemble(state));
    }

    private void saveNode(NodeInfo nodeInfo) {
        this._nodeNameSpace.putRecord(nodeInfo.getKey(), NodeInfo.disassemble(nodeInfo));
    }

    private void deleteState(LocalStateImpl2 state) {
        this._stateNameSpace.delRecord(state.getKey());
    }

    private void deleteNode(NodeInfo nodeInfo) {
        this._nodeNameSpace.delRecord(nodeInfo.getKey());
    }

    static {
        LOCTYPE_TO_HISTORIANTYPE = new HashMap();
        HISTORIANTYPE_TO_HISTORIAN = new HashMap();
        EMPTY_STATE_ARRAY = new LocalState[0];
        EMPTY_DELETIONS_ARRAY = new LocalState[0];
        _tmpDir = null;
        logger = Logger.getLogger(HistoryManagerImpl2.class.getName());
        String tmpdir = System.getProperty("java.io.tmpdir");
        _tmpDir = tmpdir != null ? URLFileSystem.canonicalize((URL)URLFactory.newFileURL((String)tmpdir)) : null;
        String dir = Ide.getSystemDirectory();
        if (dir == null) {
            dir = tmpdir;
        }
        HISTORY_DIR = dir + File.separator + HISTORY_DIRNAME + File.separator;
        INSTANCE = new HistoryManagerImpl2();
    }

    public static interface HistoryMigrator {
        public void migrateHistory(NameSpace var1, NameSpace var2, NameSpace var3);

        public boolean hasRun();
    }

    public static class IdManager {
        private static IdManager ID_MANAGER_INSTANCE = new IdManager();
        static final String FREE_IDS_KEY = "LocalHistory2:IdManager:FREE_IDS";
        static final String MAX_ID_KEY = "LocalHistory2:IdManager:MAX_ID";
        private static final String NS_IDS = "LocalHistory2:IdManager:Ids";
        private NameSpace _idsNameSpace;
        private final Map _idMap = new HashMap();

        private IdManager() {
            this._idsNameSpace = NameSpace.getNameSpace((String)NS_IDS);
            this._idsNameSpace.setAutoFlush(1500L);
        }

        static IdManager getInstance() {
            return ID_MANAGER_INSTANCE;
        }

        public static Integer getNextId() {
            return IdManager.getInstance()._getNextId();
        }

        public static void freeId(Integer id) {
            IdManager.getInstance()._freeId(id);
        }

        private synchronized Integer _getNextId() {
            this.loadIdMap();
            Integer id = null;
            LinkedList freeIds = (LinkedList)this._idMap.get(FREE_IDS_KEY);
            if (freeIds.size() > 0) {
                id = (Integer)freeIds.removeFirst();
                this.storeFreeIds();
            } else {
                Integer max = (Integer)this._idMap.get(MAX_ID_KEY);
                id = max + 1;
                this._idMap.put(MAX_ID_KEY, id);
                this._idsNameSpace.putRecord(MAX_ID_KEY, IdManager.intToBytes(id, null, 0));
            }
            return id;
        }

        private synchronized void _freeId(Integer id) {
            this.loadIdMap();
            LinkedList freeIds = (LinkedList)this._idMap.get(FREE_IDS_KEY);
            if (freeIds.contains(id)) {
                return;
            }
            freeIds.add(id);
            Collections.sort(freeIds);
            this.storeFreeIds();
        }

        private synchronized void loadIdMap() {
            if (!this._idMap.isEmpty()) {
                return;
            }
            LinkedList<Integer> freeIds = new LinkedList<Integer>();
            this._idMap.put(FREE_IDS_KEY, freeIds);
            this._idMap.put(MAX_ID_KEY, 0);
            byte[] data = this._idsNameSpace.getRecord(FREE_IDS_KEY);
            if (data != null && data.length > 0) {
                try {
                    int[] intArray = (int[])IntArrayFactory.INT_ARRAY_FACTORY.assemble(data);
                    for (int i = 0; i < intArray.length; ++i) {
                        freeIds.add(intArray[i]);
                    }
                }
                catch (AssemblyException e) {
                    logger.log(Level.SEVERE, "An error occurred while reading from the local history database.", e);
                }
            }
            if ((data = this._idsNameSpace.getRecord(MAX_ID_KEY)) != null && data.length > 0) {
                this._idMap.put(MAX_ID_KEY, IdManager.bytesToInt(data, 0));
            }
        }

        private synchronized void storeFreeIds() {
            this.loadIdMap();
            List freeIds = (List)this._idMap.get(FREE_IDS_KEY);
            int[] ids = new int[freeIds.size()];
            int size = freeIds.size();
            for (int i = 0; i < size; ++i) {
                ids[i] = (Integer)freeIds.get(i);
            }
            try {
                this._idsNameSpace.putRecord(FREE_IDS_KEY, IntArrayFactory.INT_ARRAY_FACTORY.disassemble((Object)ids));
            }
            catch (AssemblyException e) {
                logger.log(Level.SEVERE, "An error occurred while reading from the local history database.", e);
            }
        }

        static final int bytesToInt(byte[] b, int offset) {
            return b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
        }

        public static final byte[] intToBytes(int val, byte[] b, int offset) {
            if (b == null) {
                b = new byte[4];
            }
            b[offset] = (byte)(val >> 24);
            b[offset + 1] = (byte)(val >> 16);
            b[offset + 2] = (byte)(val >> 8);
            b[offset + 3] = (byte)val;
            return b;
        }
    }
}

