/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.Feature;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.preference.CachedExtensionInfo;
import oracle.ideimpl.extension.preference.ExtensionFilter;
import oracle.ideimpl.extension.preference.ExtensionListPanel;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.resource.ExtensionManagerOptionsArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public abstract class ConfigureExtensionCommand
extends Command {
    private boolean _disabled;
    private Set<String> _disabledIds = null;

    protected ConfigureExtensionCommand(int cmdId) {
        super(cmdId);
        Set<Object> keySet = System.getProperties().keySet();
        if (keySet.contains("ide.extensions") || keySet.contains("ide.noextensions")) {
            this._disabled = true;
        }
    }

    public int doit() {
        ExtensionPreferences options = ExtensionPreferences.getInstance();
        this._disabledIds = options != null ? new HashSet<String>(options.getDisabledIds()) : new HashSet<String>();
        Addin addin = AddinManager.getAddinManager().getAddin(this.getConfigureAddin());
        if (addin == null) {
            return -1;
        }
        this.showConfigureDialog(AddinManager.getAddinManager().getExtensionForAddin(addin));
        if (this.disabledIdsHaveChanged()) {
            this.applyExtensionPreferences();
            try {
                Preferences.getPreferences().save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!Ide.canRestart()) {
                if (ConfigureExtensionCommand.confirmExit()) {
                    Ide.quit();
                }
            } else if (ConfigureExtensionCommand.confirmRestart()) {
                try {
                    Ide.restart();
                }
                catch (UnsupportedOperationException uoe) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)IdeArb.getString((int)451), (String)IdeArb.getString((int)450), null);
                }
            }
        }
        return 0;
    }

    protected abstract String getConfigureAddin();

    protected String getDialogTitle() {
        return ExtensionManagerOptionsArb.getString(3);
    }

    private static boolean confirmExit() {
        return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)IdeArb.getString((int)447), (String)IdeArb.getString((int)446), null);
    }

    private static boolean confirmRestart() {
        return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)IdeArb.getString((int)449), (String)IdeArb.getString((int)448), null);
    }

    private void showConfigureDialog(final Extension owningExtension) {
        Window window = IdeUtil.findActiveModalWindow();
        JEWTDialog jd = JEWTDialog.createDialog((Component)(window != null ? window : IdeUtil.getMainWindow()), (String)this.getDialogTitle(), (int)7);
        ExtensionListPanel p = new ExtensionListPanel();
        HelpUtils.setHelpID((JComponent)p, (String)"f1_idedidesetextensionversion_html");
        jd.setContent((Component)p);
        jd.setResizable(true);
        DialogHeader header = new DialogHeader();
        header.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/person.png")));
        header.setHeaderDescription(ExtensionManagerOptionsArb.format(4, owningExtension.getName()));
        jd.setDialogHeader((Component)header);
        HashSet<String> copy = new HashSet<String>(this._disabledIds);
        p.setDisabledIds(copy);
        p.setCachedExtensionInfo(new CachedExtensionInfo());
        p.populate(new ExtensionFilter(){

            @Override
            public boolean accept(Extension extension) {
                Feature feature = ((ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry()).getFeature(extension);
                return feature != null && feature.isOptional() && owningExtension.getID().equals(feature.getPartOf());
            }
        });
        if (jd.runDialog()) {
            this._disabledIds.clear();
            this._disabledIds.addAll(copy);
        }
        jd.dispose();
    }

    private void applyExtensionPreferences() {
        if (this._disabled) {
            return;
        }
        if (!this.disabledIdsHaveChanged()) {
            return;
        }
        ExtensionPreferences p = ExtensionPreferences.getInstance();
        p.setDisabledIds(this._disabledIds);
        try {
            p.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean disabledIdsHaveChanged() {
        return !((Object)this._disabledIds).equals(ExtensionPreferences.getInstance().getDisabledIds());
    }
}

