/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.RoleManager;
import oracle.ideimpl.extension.DisabledReason;
import oracle.ideimpl.extension.ExtensionManagerImpl;

final class WarnAboutDisabledExtensionsAddin
implements Addin {
    WarnAboutDisabledExtensionsAddin() {
    }

    public void initialize() {
        RoleManager roleManager = ExtensionRegistry.getExtensionRegistry().getRoleManager();
        if (!roleManager.isDefaultRoleActive()) {
            return;
        }
        this.logDisabledExtensions();
    }

    private void logDisabledExtensions() {
        ExtensionManagerImpl reg = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
        Collection<String> disabledIds = reg.getDisabledExtensions();
        for (String id : disabledIds) {
            Extension extension;
            DisabledReason reason = reg.getDisabledReason(id);
            if (reason != DisabledReason.MISSING_DEPENDENCIES || this.anyDependencyIsDisabledByUser(extension = reg.findExtensionEvenIfNotLoaded(id))) continue;
            reg.createExtensionLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Not loaded: " + reg.getNotLoadedReason(id), reg.findExtensionEvenIfNotLoaded(id), 0));
        }
    }

    private boolean anyDependencyIsDisabledByUser(Extension extension) {
        ExtensionManagerImpl reg = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
        DisabledReason reason = reg.getDisabledReason(extension.getID());
        if (reason == DisabledReason.USER_DISABLED) {
            return true;
        }
        for (ExtensionDependency dep : extension.getDependencies()) {
            Extension depExt = reg.findExtensionEvenIfNotLoaded(dep.getID());
            if (depExt == null || !this.anyDependencyIsDisabledByUser(depExt)) continue;
            return true;
        }
        return false;
    }
}

