/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.spi.MacroExpander;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.extension.RolePreferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.InputSource;

final class RoleManagerImpl
extends RoleManager {
    private static final Logger LOG = Logger.getLogger(RoleManagerImpl.class.getName());
    private final List<RoleDefinition> _roles = new ArrayList<RoleDefinition>();
    private boolean _rolesLoaded = false;
    private static final String XMLNS = "http://xmlns.oracle.com/ide/roles";
    private RolePreferences _rolePreferences;
    private Role _activeRole = RoleManager.NO_ROLE;

    RoleManagerImpl() {
    }

    void setActiveRole(Role role) {
        this._activeRole = role;
        if (this._rolePreferences != null) {
            this._rolePreferences.setSelectedRoleId(role.getId());
        }
        System.setProperty("ide.role", role.getId());
        PerformanceLogger.get().logConfigurationProperty("Role", role.getId());
    }

    private URL getRolePreferencesURL() {
        File rolePrefsFile = new File(Ide.getSystemDirectory() + "/_oracle.ide.rolemgr." + Version.VER_FULL + "/", "roleprefs.xml");
        return URLFactory.newURL((String)rolePrefsFile.getPath());
    }

    RolePreferences getRolePreferences() {
        if (this._rolePreferences == null) {
            URL rolePrefs = this.getRolePreferencesURL();
            if (URLFileSystem.exists((URL)rolePrefs)) {
                try {
                    HashStructure hs = (HashStructure)new HashStructureIO(XMLNS, "role-preferences").load(rolePrefs);
                    this._rolePreferences = RolePreferences.getInstance(hs);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                this._rolePreferences = RolePreferences.getInstance();
            }
        }
        return this._rolePreferences;
    }

    void saveRolePreferences() {
        try {
            new HashStructureIO(XMLNS, "role-preferences").save(this.getRolePreferencesURL(), (Object)this._rolePreferences.getHash());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void loadRoles(Collection<File> rolesPath) {
        if (rolesPath == null) {
            throw new NullPointerException("rolesDirectory is null");
        }
        if (this._rolesLoaded) {
            throw new IllegalStateException("Roles already loaded");
        }
        this._rolesLoaded = true;
        for (File rolesDirectory : rolesPath) {
            File[] files;
            for (File file : files = rolesDirectory.listFiles()) {
                if (!file.getName().toLowerCase().endsWith(".xml")) continue;
                try {
                    RoleDefinition def = RoleManagerImpl.loadRole(file);
                    this._roles.add(def);
                }
                catch (IOException ioe) {
                    LOG.log(Level.SEVERE, "Failed to load role file " + file);
                }
            }
        }
    }

    List<Role> getRoles() {
        if (!this._rolesLoaded) {
            throw new IllegalStateException("Must load roles first.");
        }
        ArrayList<Role> roles = new ArrayList<Role>(this._roles.size());
        for (RoleDefinition rd : this._roles) {
            roles.add(rd.getRole());
        }
        return Collections.unmodifiableList(roles);
    }

    List<String> getDisabledExtensions(Role role) {
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        for (RoleDefinition rd : this._roles) {
            if (rd.getRole() != role) continue;
            return rd.getDisabledExtensions();
        }
        throw new IllegalArgumentException("Unknown role; " + role);
    }

    File getRoleFile(Role role) {
        for (RoleDefinition rd : this._roles) {
            if (rd.getRole() != role) continue;
            return rd.getFile();
        }
        return null;
    }

    public Role getActiveRole() {
        return this._activeRole;
    }

    static RoleDefinition loadRole(final File roleFile) throws IOException {
        try {
            ExtensibleSAXParser parser = new ExtensibleSAXParser();
            RoleVisitor rv = new RoleVisitor();
            parser.getContext().registerChildHandler(XMLNS, "role", (ElementHandler)rv);
            parser.parse(new XMLLocator(null){

                public InputSource createInputSource() throws IOException {
                    return new InputSource(new FileInputStream(roleFile));
                }
            });
            if (rv.getRole() == null) {
                throw new IOException(roleFile + ": role does not specify an id");
            }
            if (!"1.0".equals(rv.getVersion())) {
                throw new IOException(roleFile + ": role version '" + rv.getVersion() + "' not recognized.");
            }
            return new RoleDefinition(rv.getRole(), roleFile, rv.getExtensions());
        }
        catch (Exception e) {
            IOException ioe = new IOException("Failed to parse role " + roleFile);
            ioe.initCause(e);
            throw ioe;
        }
    }

    static final class RoleDefinition {
        private final Role _role;
        private final File _roleFile;
        private final List<String> _disabledExtensions;

        private RoleDefinition(Role role, File file, List<String> disabledExtensions) {
            this._role = role;
            this._roleFile = file;
            this._disabledExtensions = disabledExtensions;
        }

        public Role getRole() {
            return this._role;
        }

        public File getFile() {
            return this._roleFile;
        }

        public List<String> getDisabledExtensions() {
            return this._disabledExtensions;
        }
    }

    private static final class RoleVisitor
    extends ElementHandler {
        private String _id;
        private String _name;
        private String _description;
        private String _version;
        private final List<String> _extensions = new ArrayList<String>();
        private Role _role = null;
        private String _rsBundleClass;

        private RoleVisitor() {
        }

        private String expandMacros(String text) {
            if (text == null) {
                return null;
            }
            return new MacroExpander(){

                protected String getMacroValue(String macroText) {
                    if (RoleVisitor.this._rsBundleClass != null) {
                        try {
                            ResourceBundle rb = ResourceBundle.getBundle(RoleVisitor.this._rsBundleClass);
                            return rb.getString(macroText);
                        }
                        catch (MissingResourceException me) {
                            return null;
                        }
                    }
                    return null;
                }
            }.substituteMacros(text);
        }

        public void handleStart(ElementStartContext context) {
            this._id = context.getAttributeValue("id");
            this._version = context.getAttributeValue("version");
            this._rsBundleClass = context.getAttributeValue("rsbundle-class");
            context.registerChildHandler(RoleManagerImpl.XMLNS, "name", new ElementHandler(){

                public void handleEnd(ElementEndContext context) {
                    RoleVisitor.this._name = RoleVisitor.this.expandMacros(context.getText().trim());
                }
            });
            context.registerChildHandler(RoleManagerImpl.XMLNS, "description", new ElementHandler(){

                public void handleEnd(ElementEndContext context) {
                    RoleVisitor.this._description = RoleVisitor.this.expandMacros(context.getText().trim());
                }
            });
            final ElementHandler extensionHandler = new ElementHandler(){

                public void handleStart(ElementStartContext context) {
                    String extensionId = context.getAttributeValue("refid");
                    if (extensionId != null) {
                        RoleVisitor.this._extensions.add(extensionId);
                    }
                }
            };
            context.registerChildHandler(RoleManagerImpl.XMLNS, "disabled-extensions", new ElementHandler(){

                public void handleStart(ElementStartContext context) {
                    context.registerChildHandler(RoleManagerImpl.XMLNS, "extension", extensionHandler);
                }
            });
        }

        public void handleEnd(ElementEndContext context) {
            if (this._id != null) {
                String name = this._name == null ? this._id : this._name;
                String description = this._description == null ? "" : this._description;
                this._role = new Role(this._id, name, description);
            }
        }

        public String getVersion() {
            return this._version;
        }

        public Role getRole() {
            return this._role;
        }

        public List<String> getExtensions() {
            return this._extensions;
        }
    }
}

