/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.controller.MenuFilter;
import oracle.ideimpl.extension.MenuCustomizationHook;

final class MenuShapingAddin
implements Addin {
    MenuShapingAddin() {
    }

    public void initialize() {
        MenuCustomizationHook customizationHook = (MenuCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(MenuCustomizationHook.NAME);
        final List hiddenItems = customizationHook.getHiddenMenuComponents();
        MenuFilter filter = new MenuFilter(){

            public boolean accept(Component component) {
                String componentId = MenuShapingAddin.this.getId(component);
                return !hiddenItems.contains(componentId);
            }
        };
        Ide.getMenubar().addMenuFilter(filter);
        if (!hiddenItems.isEmpty()) {
            JMenuBar mb = Ide.getMainWindow().getJMenuBar();
            for (int i = 0; i < mb.getMenuCount(); ++i) {
                JMenu menu = mb.getMenu(i);
                if (!filter.accept((Component)menu)) {
                    Ide.getMenubar().remove((Component)menu);
                    --i;
                    continue;
                }
                this.filterMenuItems(filter, menu);
            }
        }
    }

    private void filterMenuItems(MenuFilter filter, JMenu menu) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component item = menu.getMenuComponent(i);
            if (!filter.accept(item)) {
                menu.remove(item);
                --i;
                continue;
            }
            if (!(item instanceof JMenu)) continue;
            this.filterMenuItems(filter, (JMenu)item);
        }
    }

    private String getId(Component component) {
        if (component == null) {
            return "";
        }
        return Ide.getMenubar().getId(component);
    }
}

