/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.RecentFilesDockableWindow;

final class RecentFilesLRU {
    private final int LRU_FILES_SIZE;
    private AtomicInteger explicitCount = new AtomicInteger();
    private final ArrayList _windows = new ArrayList();

    RecentFilesLRU() {
        String property = Ide.getProperty((String)"Editors.RecentFilesSize", (String)"20");
        this.LRU_FILES_SIZE = Integer.parseInt(property);
    }

    public void setExplicit(Context context, boolean explicit) {
        Node node = context.getNode();
        if (node != null && !URLFileSystem.isLocal((URL)node.getURL())) {
            return;
        }
        RecentFile recentFile = this.getRecentFile(context);
        if (recentFile != null) {
            boolean wasExplicit = recentFile.isExplicit();
            if (wasExplicit) {
                this.explicitCount.decrementAndGet();
            }
            recentFile.setExplicit(explicit);
            if (explicit) {
                this.explicitCount.incrementAndGet();
            }
            this.adjustSize();
        }
    }

    private void adjustSize() {
        int expCount = this.explicitCount.get();
        if (expCount > this.LRU_FILES_SIZE) {
            this.removeOldest(true);
        } else {
            int lruSize = this.getLRUList().size();
            int implicitCount = lruSize - expCount;
            if (implicitCount > this.LRU_FILES_SIZE) {
                this.removeOldest(false);
            }
        }
    }

    private void removeOldest(boolean removeExplicit) {
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorPathImpl editorPath = new EditorPathImpl();
        ArrayList lruFiles = this.getLRUList();
        for (int i = 0; i < lruFiles.size(); ++i) {
            EditorCriteriaImpl editorCriteria;
            boolean canRemove;
            RecentFile recentFile = (RecentFile)lruFiles.get(i);
            boolean isExplicit = recentFile.isExplicit();
            Context context = recentFile.getContext();
            if (isExplicit != removeExplicit || !(canRemove = context != null ? false == editorManager.searchEditor(editorPath, editorCriteria = new EditorCriteriaImpl(context)) : true)) continue;
            RecentFile rf = (RecentFile)lruFiles.remove(i);
            RemovedFileTracker.removeListener(recentFile.getNodeURL());
            if (!isExplicit) break;
            this.explicitCount.decrementAndGet();
            break;
        }
        this.setLRUList(lruFiles);
    }

    RecentFile[] getRecentFiles() {
        ArrayList lruFiles = this.getLRUList();
        int lruSize = lruFiles.size();
        RecentFile[] recentFiles = new RecentFile[lruSize];
        for (int i = 0; i < lruSize; ++i) {
            RecentFile recentFile;
            recentFiles[lruSize - i - 1] = recentFile = (RecentFile)lruFiles.get(i);
        }
        return recentFiles;
    }

    void raiseContextInLRUList(Context context, String editorAddinClassName) {
        Node node;
        if (context != null && (node = context.getNode()) != null) {
            if (!URLFileSystem.isLocal((URL)node.getURL())) {
                return;
            }
            RecentFile recentFile = this.remove(context);
            if (recentFile == null) {
                recentFile = new RecentFile(context);
            }
            if (editorAddinClassName != null) {
                recentFile.setEditor(editorAddinClassName);
            }
            ArrayList lruFiles = this.getLRUList();
            lruFiles.add(recentFile);
            RemovedFileTracker.addListener(recentFile.getNodeURL(), this);
            this.setLRUList(lruFiles);
            if (recentFile.isExplicit()) {
                this.explicitCount.incrementAndGet();
            }
            this.adjustSize();
        }
    }

    private ArrayList getLRUList() {
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorsOptions editorsOptions = editorManager.getEditorsOptions();
        ArrayList lruFiles = editorsOptions.getLruFiles();
        RemovedFileTracker.addListeners(lruFiles, this);
        this.explicitCount.set(0);
        for (int i = 0; i < lruFiles.size(); ++i) {
            RecentFile recentFile = (RecentFile)lruFiles.get(i);
            if (!recentFile.isExplicit()) continue;
            this.explicitCount.incrementAndGet();
        }
        return lruFiles;
    }

    final void addWindow(RecentFilesDockableWindow window) {
        this._windows.add(window);
    }

    private void setLRUList(ArrayList lruList) {
        RemovedFileTracker.addListeners(lruList, this);
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorsOptions editorsOptions = editorManager.getEditorsOptions();
        editorsOptions.setLruFiles(lruList);
        for (RecentFilesDockableWindow window : this._windows) {
            window.updateGUI();
        }
    }

    private int getPositionInLRUList(Context context, ArrayList lruList) {
        if (context != null) {
            for (int i = 0; i < lruList.size(); ++i) {
                RecentFile recentFile = (RecentFile)lruList.get(i);
                if (!recentFile.isSameNode(context)) continue;
                return i;
            }
        }
        return -1;
    }

    RecentFile getRecentFile(Context context) {
        if (context != null) {
            ArrayList lruList = this.getLRUList();
            for (RecentFile recentFile : lruList) {
                if (!recentFile.isSameNode(context)) continue;
                return recentFile;
            }
        }
        return null;
    }

    RecentFile remove(Context context) {
        Node node = context.getNode();
        if (node != null && !URLFileSystem.isLocal((URL)node.getURL())) {
            return null;
        }
        RecentFile ret = null;
        ArrayList lruList = this.getLRUList();
        int index = this.getPositionInLRUList(context, lruList);
        if (index >= 0) {
            ret = (RecentFile)lruList.remove(index);
            RemovedFileTracker.removeListener(ret.getNodeURL());
            this.setLRUList(lruList);
            if (ret.isExplicit()) {
                this.explicitCount.decrementAndGet();
            }
        }
        return ret;
    }

    private static class RemovedFileTracker
    implements URLFileSystemListener {
        private static Map<String, RemovedFileTracker> trackerMap = new HashMap<String, RemovedFileTracker>();
        private URL url;
        private URL parent;
        private boolean attached;
        private RecentFilesLRU lru;

        public static void addListeners(List recentFiles, RecentFilesLRU lru) {
            if (trackerMap.isEmpty()) {
                for (Object recentFile : recentFiles) {
                    RemovedFileTracker.addListener(((RecentFile)recentFile).getNodeURL(), lru);
                }
            }
        }

        public static void addListener(URL url, RecentFilesLRU lru) {
            String key;
            if (url != null && trackerMap.get(key = url.toString()) == null) {
                trackerMap.put(key, new RemovedFileTracker(url, lru).attach());
            }
        }

        public static void removeListener(URL url) {
            String key = url.toString();
            RemovedFileTracker tracker = trackerMap.get(key);
            if (tracker != null) {
                tracker.dettach();
                trackerMap.remove(key);
            }
        }

        RemovedFileTracker(URL url, RecentFilesLRU lru) {
            this.lru = lru;
            this.url = url;
            this.parent = URLFileSystem.getParent((URL)url);
        }

        public RemovedFileTracker attach() {
            if (!this.attached) {
                URLFileSystem.addURLFileSystemListener((URL)this.parent, (URLFileSystemListener)this);
                this.attached = true;
            }
            return this;
        }

        public RemovedFileTracker attachTo(URL url) {
            if (!URLFileSystem.equals((URL)this.url, (URL)url)) {
                this.dettach();
                this.url = url;
                this.parent = URLFileSystem.getParent((URL)url);
                return this.attach();
            }
            return this;
        }

        public RemovedFileTracker dettach() {
            if (this.attached) {
                URLFileSystem.removeURLFileSystemListener((URL)this.parent, (URLFileSystemListener)this);
                this.attached = false;
            }
            return this;
        }

        public void notifyEvent(URLFileSystemEvent event) {
            switch (event.getEventType()) {
                case 3: {
                    if (!URLFileSystem.equals((URL)this.url, (URL)event.getURL())) break;
                    this.removeFileFromList(event.getURL());
                    this.dettach();
                    break;
                }
                case 4: {
                    if (!URLFileSystem.equals((URL)this.url, (URL)event.getOldURL())) break;
                    this.renameFileInList(event.getOldURL(), event.getNewURL());
                    this.attachTo(event.getNewURL());
                }
            }
        }

        private void removeFileFromList(URL url) {
            ArrayList lruList = this.lru.getLRUList();
            int size = lruList.size();
            for (int i = 0; i < size; ++i) {
                RecentFile recentFile = (RecentFile)lruList.get(i);
                if (recentFile == null || !URLFileSystem.equals((URL)recentFile.getNodeURL(), (URL)url)) continue;
                lruList.remove(i);
                this.lru.setLRUList(lruList);
                break;
            }
        }

        private void renameFileInList(URL oldurl, URL newurl) {
            ArrayList lruList = this.lru.getLRUList();
            int size = lruList.size();
            for (int i = 0; i < size; ++i) {
                RecentFile recentFile = (RecentFile)lruList.get(i);
                if (recentFile == null || !URLFileSystem.equals((URL)recentFile.getNodeURL(), (URL)oldurl)) continue;
                recentFile.setNodeURL(newurl);
                this.lru.setLRUList(lruList);
                break;
            }
        }
    }
}

